/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Highlighter;
import pact.CommWidgets.InputMethodFramework.ActiveClient;
import pact.CommWidgets.JCommDocument;
import pact.CommWidgets.JCommWidget;

public class JCommTextField
extends JCommWidget
implements FocusListener,
MouseListener,
KeyListener {
    protected JTextField textField = new JTextField();
    protected String previousValue;
    protected String resetValue = "";
    protected static int textFieldsCreated;
    protected JPanel container;
    protected Font startFont;
    protected Font previousFont;
    protected Color previousColor;
    protected Highlighter defaultHighlighter;
    protected boolean keyUsed = false;
    private boolean showBorder = true;
    private Border correctBorder;
    private Border inCorrectBorder;
    private Border LISPCheckBorder;
    private Border highlightedBorder;
    protected boolean selected = false;
    static Vector selectedCellsList;
    static Vector selectedValues;
    static JFrame selectedCellsFrame;
    static JList nameList;
    static JList valuesList;
    static DefaultListModel nameModel;
    static DefaultListModel valuesModel;

    public JCommTextField() {
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.textField);
        this.textField.setDocument(new JCommDocument());
        this.add(this.textField);
        GridLayout g = new GridLayout(1, 1);
        this.setLayout(g);
        try {
            this.textField.addFocusListener(this);
            this.textField.addKeyListener(this);
            this.initialized = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.actionName = "UpdateTextField";
        this.defaultHighlighter = this.textField.getHighlighter();
        this.originalBorder = this.textField.getBorder();
        this.correctBorder = BorderFactory.createLineBorder(this.correctColor, 2);
        this.inCorrectBorder = BorderFactory.createLineBorder(this.incorrectColor, 2);
        this.LISPCheckBorder = BorderFactory.createLineBorder(this.LISPCheckColor, 2);
        this.highlightedBorder = BorderFactory.createLineBorder(Color.blue, 2);
        this.constructSelectedCellsFrame();
        this.textField.addMouseListener(new MouseListenerClass());
        this.textField.add(new ActiveClient(this.textField.getHeight(), this.textField.getWidth()));
    }

    private void constructSelectedCellsFrame() {
        selectedCellsFrame = new JFrame();
        nameModel = new DefaultListModel();
        valuesModel = new DefaultListModel();
        nameList = new JList(nameModel);
        valuesList = new JList(valuesModel);
        selectedCellsFrame.getContentPane().setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.add((Component)new JLabel("Name"), "North");
        namePanel.add((Component)nameList, "Center");
        namePanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel valuesPanel = new JPanel();
        valuesPanel.setLayout(new BorderLayout());
        valuesPanel.add((Component)new JLabel("Value"), "North");
        valuesPanel.add((Component)valuesList, "Center");
        valuesPanel.setBorder(BorderFactory.createEtchedBorder());
        JButton okBtn = new JButton("Send");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JCommTextField.this.sendSelectedCells();
                selectedCellsFrame.hide();
            }
        });
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selectedCellsFrame.hide();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        centerPanel.setLayout(new GridLayout(1, 1));
        centerPanel.add(namePanel);
        centerPanel.add(valuesPanel);
        selectedCellsFrame.getContentPane().add((Component)centerPanel, "Center");
        selectedCellsFrame.getContentPane().add((Component)btnPanel, "South");
    }

    private void sendSelectedCells() {
        if (this.getUniversalToolProxy() == null) {
            JOptionPane.showMessageDialog(null, "Warning: The Connection to the Production System should be made before sending the selection elements. \n Open the Behavior Recorder to establish a connection.", "Warning", 2);
        } else {
            MessageObject mo = MessageObject.create("SendSelectedElements");
            mo.setVerb("SendSelectedElements");
            mo.setProperty("SelectedElements", selectedCellsList);
            mo.setProperty("SelectedElementsValues", selectedValues);
            this.getUniversalToolProxy().sendMessage(mo);
        }
    }

    @Override
    public boolean getLock(String selection) {
        return ((JCommDocument)this.textField.getDocument()).locked;
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        this.changeBorder(null);
        if (action.equalsIgnoreCase("UpdateTextField")) {
            this.setText(input);
            if (this.getController().isStartStateInterface()) {
                ((JCommDocument)this.textField.getDocument()).locked = true;
                this.textField.setHighlighter(null);
                this.setFocusable(false);
            }
            return;
        }
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else if ("UpdateBackgroundColor".equalsIgnoreCase(action)) {
            trace.out("inter", "UPDATE_BACKGROUNDCOLOR: " + input);
            this.setBackground(JCommWidget.C.get(input));
        }
        trace.out(5, this, "**Error**: don't know interface action " + action);
    }

    @Override
    public MessageObject getDescriptionMessage() {
        MessageObject mo = MessageObject.create("InterfaceDescription");
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "JCommTextField");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr = "(deftemplate textField (slot name) (slot value))";
        deftemplates.add(deftemplateStr);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instanceStr = "(assert (textField (name " + this.commName + ")))";
        instances.add(instanceStr);
        return instances;
    }

    @Override
    public void highlight(String commComponentName, Border highlightBorder) {
        this.textField.setBorder(highlightBorder);
        this.setHighlighted(true);
    }

    @Override
    public void highlight() {
        this.textField.setBorder(this.highlightedBorder);
        this.setHighlighted(true);
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
        if ("SetVisible".equalsIgnoreCase(action)) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "SetVisible: " + input);
            }
            this.setVisible(input);
        } else if ("UpdateBackgroundColor".equalsIgnoreCase(action)) {
            trace.out("inter", "UPDATE_BACKGROUNDCOLOR: " + input);
            this.setBackground(JCommWidget.C.get(input));
        } else {
            this.changeBorder(this.correctBorder);
            this.textField.setForeground(this.correctColor);
            ((JCommDocument)this.textField.getDocument()).locked = false;
            this.textField.setText(input);
            if (this.getController().getUniversalToolProxy().lockWidget()) {
                ((JCommDocument)this.textField.getDocument()).locked = true;
                this.textField.setHighlighter(null);
                this.removeHighlight("");
                this.setFocusable(false);
            }
            if (this.correctFont != null) {
                this.textField.setFont(this.correctFont);
            }
        }
    }

    @Override
    public void removeHighlight() {
        this.textField.setBorder(this.originalBorder);
        this.setHighlighted(false);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.textField.setBorder(this.originalBorder);
        this.setHighlighted(false);
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
        this.changeBorder(this.LISPCheckBorder);
        this.textField.setForeground(this.LISPCheckColor);
        this.textField.setText(input);
        if (this.getController().getUniversalToolProxy().lockWidget()) {
            ((JCommDocument)this.textField.getDocument()).locked = true;
            this.textField.setHighlighter(null);
            this.removeHighlight("");
            this.setFocusable(false);
        }
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
        this.changeBorder(this.inCorrectBorder);
        this.textField.setForeground(this.incorrectColor);
        this.textField.setText(input);
        ((JCommDocument)this.textField.getDocument()).locked = false;
        if (this.incorrectFont != null) {
            this.textField.setFont(this.incorrectFont);
        }
        this.textField.setHighlighter(this.defaultHighlighter);
        this.setFocusable(true);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.textField != null) {
            this.textField.setOpaque(true);
            this.textField.setBackground(c);
        }
    }

    public void setProperty(MessageObject o) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        trace.out("inter", "text field " + this.commName + " gained focus");
        if (!((JCommDocument)this.textField.getDocument()).locked) {
            this.previousValue = this.textField.getText();
            this.previousFont = this.textField.getFont();
            this.previousColor = this.textField.getForeground();
        }
        super.focusGained(e);
    }

    @Override
    public void setFocus(String subWidgetName) {
        this.textField.requestFocus();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!((JCommDocument)this.textField.getDocument()).locked) {
            if (e.isTemporary() || !this.keyUsed) {
                return;
            }
            Component oppComponent = e.getOppositeComponent();
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "JCommTextField: focusLost oppComponent " + (oppComponent instanceof JCommWidget ? ((JCommWidget)oppComponent).getCommName() : oppComponent));
            }
            if (!this.focusTriggersBackGrading(oppComponent)) {
                return;
            }
            if (this.getController().getUniversalToolProxy().getAutoCapitalize() || this.getAutoCapitalize()) {
                this.textField.setText(this.textField.getText().toUpperCase());
            }
            this.dirty = true;
            if (!this.textField.getText().equals(this.previousValue)) {
                if (this.getController().isDefiningStartState()) {
                    this.getController().setStartStateModified(true);
                }
            } else if (this.textField.getText().equals("")) {
                this.dirty = false;
            }
            if (this.dirty) {
                this.sendValue();
            }
            this.previousValue = this.textField.getText();
        }
        super.focusLost(e);
        this.keyUsed = false;
        this.dirty = false;
    }

    @Override
    public Object getValue() {
        this.changeBorder(null);
        this.textField.setForeground(this.startColor);
        return this.textField.getText().trim();
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
        this.previousValue = text;
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f;
        if (this.textField != null) {
            this.textField.setFont(f);
        }
        super.setFont(f);
    }

    @Override
    public void setCorrectColor(Color correctColor) {
        this.correctColor = correctColor;
        this.correctBorder = BorderFactory.createLineBorder(correctColor, 2);
    }

    @Override
    public void setIncorrectColor(Color incorrectColor) {
        this.incorrectColor = incorrectColor;
        this.inCorrectBorder = BorderFactory.createLineBorder(incorrectColor, 2);
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    @Override
    public boolean isChangedFromResetState() {
        if (!this.textField.getText().equals(this.resetValue)) {
            ((JCommDocument)this.textField.getDocument()).locked = true;
            this.textField.setHighlighter(null);
            this.setFocusable(false);
            return true;
        }
        return false;
    }

    public boolean resetStartStateLock(boolean startStateLock) {
        if (!this.textField.getText().equals(this.resetValue)) {
            System.out.println("Reset TextField [" + this.commName + "] - " + this.textField.getText() + startStateLock);
            ((JCommDocument)this.textField.getDocument()).locked = startStateLock;
            this.textField.setHighlighter(null);
            this.setFocusable(!startStateLock);
            return true;
        }
        return false;
    }

    @Override
    public void reset(TutorController controller) {
        this.initialize(controller);
        ((JCommDocument)this.textField.getDocument()).locked = false;
        this.setFocusable(true);
        this.textField.setText(this.resetValue);
        this.textField.setForeground(this.startColor);
        this.textField.setEditable(true);
        this.textField.setHighlighter(this.defaultHighlighter);
        this.changeBorder(null);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyUsed = true;
        if (e.getKeyCode() == 10) {
            this.getRootPane().requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.keyUsed = true;
        if (!((JCommDocument)this.textField.getDocument()).locked) {
            this.textField.setForeground(this.startColor);
            this.changeBorder(null);
            if (this.startFont != null) {
                this.textField.setFont(this.startFont);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyUsed = true;
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirty = true;
    }

    @Override
    public void setToolTipText(String text) {
        this.textField.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        return this.textField.getToolTipText();
    }

    @Override
    public void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        if (this.textField != null) {
            this.textField.addFocusListener(l);
        }
    }

    @Override
    public void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        if (this.textField != null) {
            this.textField.addMouseListener(l);
        }
    }

    public void changeBorder(Border border) {
        if (this.isShowBorder()) {
            this.setBorder(border);
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.removeHighlight("");
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public String toString() {
        return "JCommTextField: " + this.textField.getText();
    }

    static {
        selectedCellsList = new Vector();
        selectedValues = new Vector();
    }

    private class MouseListenerClass
    implements MouseListener {
        private MouseListenerClass() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isControlDown()) {
                JCommTextField dt = (JCommTextField)me.getComponent().getParent();
                if (dt.selected) {
                    dt.setBackground(Color.WHITE);
                    dt.selected = false;
                    selectedCellsList.remove(JCommTextField.this.getCommNameToSend());
                    selectedValues.remove(JCommTextField.this.getValue());
                    nameModel.removeElement(JCommTextField.this.getCommNameToSend());
                    valuesModel.removeElement(JCommTextField.this.getValue());
                } else {
                    dt.setBackground(Color.PINK);
                    dt.selected = true;
                    this.addToSelectedList(JCommTextField.this.getCommNameToSend());
                    this.addToSelectedValues(JCommTextField.this.getValue());
                }
                selectedCellsFrame.validate();
                selectedCellsFrame.pack();
                selectedCellsFrame.show();
            }
        }

        private void clearSelectedValues() {
            selectedValues.removeAll(selectedValues);
        }

        private void addToSelectedValues(Object o) {
            selectedValues.add(o);
            valuesModel.addElement(o);
        }

        private void clearSelectedList() {
            selectedCellsList.removeAll(selectedCellsList);
        }

        private void addToSelectedList(String cellName) {
            selectedCellsList.add(cellName);
            nameModel.addElement(cellName);
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

