/*
 * Decompiled with CFR 0.152.
 */
package org.tiling.scheduling.examples.test;

import junit.framework.TestCase;
import org.tiling.scheduling.ScheduleIterator;
import org.tiling.scheduling.examples.iterators.CompositeIterator;
import org.tiling.scheduling.examples.test.ArithmeticProgressionScheduleIterator;

public class CompositeIteratorTest
extends TestCase {
    public CompositeIteratorTest(String name) {
        super(name);
    }

    public void testZero() {
        CompositeIterator compositeIterator = new CompositeIterator(new ScheduleIterator[0]);
        CompositeIteratorTest.assertEquals(null, (Object)compositeIterator.next());
        CompositeIteratorTest.assertEquals(null, (Object)compositeIterator.next());
    }

    public void testOne() {
        ArithmeticProgressionScheduleIterator t1 = new ArithmeticProgressionScheduleIterator(0, 3);
        CompositeIterator compositeIterator = new CompositeIterator(new ScheduleIterator[]{t1});
        CompositeIteratorTest.assertEquals((long)0L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)3L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)6L, (long)compositeIterator.next().getTime());
    }

    public void testTwo() {
        ArithmeticProgressionScheduleIterator t1 = new ArithmeticProgressionScheduleIterator(0, 3);
        ArithmeticProgressionScheduleIterator t2 = new ArithmeticProgressionScheduleIterator(1, 2);
        CompositeIterator compositeIterator = new CompositeIterator(new ScheduleIterator[]{t1, t2});
        CompositeIteratorTest.assertEquals((long)0L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)1L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)3L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)5L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)6L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)7L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)9L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)11L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)12L, (long)compositeIterator.next().getTime());
    }

    public void testTwoWithNull() {
        ArithmeticProgressionScheduleIterator t1 = new ArithmeticProgressionScheduleIterator(0, 3, 3);
        ArithmeticProgressionScheduleIterator t2 = new ArithmeticProgressionScheduleIterator(1, 2, 7);
        CompositeIterator compositeIterator = new CompositeIterator(new ScheduleIterator[]{t1, t2});
        CompositeIteratorTest.assertEquals((long)0L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)1L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)3L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)5L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertEquals((long)7L, (long)compositeIterator.next().getTime());
        CompositeIteratorTest.assertNull((Object)compositeIterator.next());
        CompositeIteratorTest.assertNull((Object)compositeIterator.next());
    }
}

