/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.miss.AskHintInBuiltClAlgebraTutor;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;
import javax.swing.JButton;

public class ContestMultiProdRules
extends SimStInteractiveLearning {
    BR_Controller controller;
    SimSt simSt;
    Vector<File> prodRules;
    Hashtable<String, Integer> scores;
    String[] studentName;

    public ContestMultiProdRules(SimSt ss, String[] prodRules) {
        super(ss);
        this.simSt = ss;
        this.controller = this.simSt.getBrController();
        this.scores = new Hashtable();
        this.loadProdRules(prodRules);
    }

    public void loadProdRules(String[] prodRuleFiles) {
        this.prodRules = new Vector();
        this.studentName = new String[prodRuleFiles.length];
        for (int i = 0; i < prodRuleFiles.length; ++i) {
            File prFile = new File(prodRuleFiles[i] + ".pr");
            this.prodRules.add(prFile);
            this.studentName[i] = prodRuleFiles[i];
            this.scores.put(prodRuleFiles[i], 0);
        }
    }

    public void contestOnProblem(String problemName) {
        this.createStartStateOnProblem(problemName);
        this.runContest();
    }

    public void contestOnWholeProblem(String problemName) {
        String solutions = "";
        for (int student = 0; student < this.prodRules.size(); ++student) {
            this.createStartStateOnProblem(problemName);
            boolean result = true;
            try {
                this.controller.getModelTracer().getRete().removeAllRules();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            result = this.controller.getModelTracer().getRete().reloadProductionRulesFile(this.prodRules.get(student), false);
            solutions = solutions + "Student" + student + ": " + this.solveWholeProblem((int)student).solutionPath + "\n";
        }
        trace.out("ss", solutions);
    }

    @Override
    public void createStartStateOnProblem(String problemName) {
        this.controller.startNewProblem();
        try {
            if (this.controller.getProblemModel().getStartNode() == null) {
                String[] sp = problemName.split("=");
                String c1r1Value = sp[0].trim();
                String c2r1Value = sp[1].trim();
                SimStInteractiveLearning.simulateCellTextEntry("commTable1_C1R1", c1r1Value);
                SimStInteractiveLearning.simulateCellTextEntry("commTable2_C1R1", c2r1Value);
                String normalProblemName = problemName.replaceAll("=", "_").replaceAll(" ", "");
                normalProblemName = normalProblemName.replaceAll("/", "I");
                normalProblemName = normalProblemName.replaceAll("\\(", "C");
                normalProblemName = normalProblemName.replaceAll("\\)", "D");
                normalProblemName = normalProblemName.replaceAll("\\.", "P");
                trace.out("ss", "Problem Name created: " + normalProblemName);
                this.controller.createStartState(normalProblemName);
            } else {
                ProblemNode node = this.controller.getProblemModel().getStartNode();
                trace.out("miss", "ssContest: startNode = " + node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runContest() {
        ProblemNode currentNode = this.controller.getProblemModel().getStartNode();
        boolean killMessageReceived = false;
        while (!killMessageReceived) {
            String step = this.simSt.getProblemAssessor().calcProblemStepString(currentNode.getProblemModel().getStartNode(), currentNode, this.simSt.getLastSkillOperand());
            this.simSt.setProblemStepString(step);
            trace.out("ss", "----------------" + step);
            ProblemNode nextCurrentNode = null;
            nextCurrentNode = this.contest(currentNode);
            if (nextCurrentNode != null) {
                currentNode = nextCurrentNode;
                try {
                    Vector<Instruction> instnVector = new Vector<Instruction>();
                    this.controller.setCurrentNode2(currentNode);
                    trace.out("miss", "setCurrentNode2 to " + currentNode + " suceeded");
                    Instruction instn = this.simSt.lookupInstructionWithNode(this.controller.getCurrentNode());
                    instnVector.clear();
                    instnVector.add(instn);
                    trace.out("ss", "opSequenceFound is: " + this.simSt.searchRhsOpsFor(instnVector));
                }
                catch (Exception e) {
                    trace.out("miss", "setCurrentNode2 to " + currentNode + " failed");
                }
                if (currentNode.getIncomingEdges().size() > 0) {
                    ProblemEdge edge = currentNode.getIncomingEdges().get(0);
                    String input = edge.getInput();
                    if (EqFeaturePredicate.isValidSimpleSkill(input.split(" ")[0])) {
                        this.simSt.setLastSkillOperand(input);
                    }
                    if (this.controller.getMissController().isPLEon()) {
                        JButton undoButton = this.controller.getMissController().getSimStPLE().getSimStPeerTutoringPlatform().getUndoButton();
                        if (edge.getSelection().equalsIgnoreCase("DONE")) {
                            undoButton.setText(this.controller.getMissController().getSimStPLE().getUndoButtonTitleString("done"));
                        } else {
                            undoButton.setText(this.controller.getMissController().getSimStPLE().getUndoButtonTitleString(input));
                        }
                    }
                }
            } else {
                killMessageReceived = true;
                this.simSt.setIsInteractiveLearning(false);
                trace.out("ss", "killMessageReceived is true.");
                if (this.controller.getMissController().isPLEon() && !this.controller.getMissController().getSimStPLE().isStartStatus()) {
                    this.controller.getMissController().getSimStPLE().blockInput(true);
                }
            }
            trace.out("ss", "Current Node at end of loop: " + currentNode + ":" + this.controller.getCurrentNode());
            if (!currentNode.getDoneState()) continue;
            break;
        }
        for (String str : this.scores.keySet()) {
            System.out.println(str + " " + this.scores.get(str));
        }
    }

    public String getScoreString() {
        String results = "";
        for (String str : this.scores.keySet()) {
            results = results + str + ":" + this.scores.get(str) + " ";
        }
        return results;
    }

    public ProblemNode contest(ProblemNode problemNode) {
        String results = "";
        PriorityQueue<Answer> answers = this.gatherActivationList(problemNode);
        if (answers.isEmpty()) {
            trace.out("ss", "No answers");
            return null;
        }
        Answer goodAnswer = null;
        while (!answers.isEmpty()) {
            String result;
            Answer answer = (Answer)answers.remove();
            System.out.println(answer);
            results = results + answer.toString() + "\n";
            if (goodAnswer != null || !(result = this.simSt.builtInInquiryClTutor(answer.step.getActualSelection(), answer.step.getActualAction(), answer.step.getActualInput(), problemNode, problemNode.getProblemModel().getProblemName().replace("_", "="))).startsWith("Correct")) continue;
            goodAnswer = answer;
        }
        System.out.println(results);
        if (goodAnswer == null) {
            AskHintInBuiltClAlgebraTutor hint = new AskHintInBuiltClAlgebraTutor(brController, problemNode);
            return this.advanceNode(problemNode, hint.getSai(), hint.getSkillName());
        }
        this.scores.put(goodAnswer.student, this.scores.get(goodAnswer.student) + 1);
        return this.advanceNode(problemNode, goodAnswer.step);
    }

    private ProblemNode advanceNode(ProblemNode currentNode, RuleActivationNode ran) {
        ProblemNode nextCurrentNode = null;
        this.secureCurrentNode(currentNode);
        Sai sai = this.getSai(ran);
        ProblemNode successiveNode = this.simulatePerformingStep(currentNode, sai);
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        String step = startNode.getName();
        if (this.simSt.getProblemAssessor() != null) {
            step = this.simSt.getProblemAssessor().findLastStep(startNode, currentNode);
        }
        this.simSt.setProblemStep(step);
        if (successiveNode != null) {
            String skillName = this.removeAmpersand(ran.getName()) + " simStIL";
            ProblemEdge edge = this.updateEdgeSkillName(currentNode, successiveNode, skillName);
            nextCurrentNode = successiveNode;
        }
        return nextCurrentNode;
    }

    private ProblemNode advanceNode(ProblemNode currentNode, Sai sai, String skillName) {
        ProblemNode nextCurrentNode = null;
        this.secureCurrentNode(currentNode);
        ProblemNode successiveNode = this.simulatePerformingStep(currentNode, sai);
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        String step = startNode.getName();
        if (this.simSt.getProblemAssessor() != null) {
            step = this.simSt.getProblemAssessor().findLastStep(startNode, currentNode);
        }
        this.simSt.setProblemStep(step);
        if (successiveNode != null) {
            ProblemEdge edge = this.updateEdgeSkillName(currentNode, successiveNode, skillName);
            nextCurrentNode = successiveNode;
        }
        return nextCurrentNode;
    }

    public PriorityQueue<Answer> gatherActivationList(ProblemNode problemNode) {
        return this.gatherActivationList(problemNode, 0, this.prodRules.size());
    }

    public PriorityQueue<Answer> gatherActivationList(ProblemNode problemNode, int firstStudent, int nMaxStudents) {
        PriorityQueue<Answer> results = new PriorityQueue<Answer>();
        Vector<RuleActivationNode> activationList = new Vector<RuleActivationNode>();
        this.showActivationList();
        try {
            if (problemNode != this.controller.getSolutionState().getCurrentNode()) {
                trace.out("miss", "gatherActivationList: problemNode ==>> " + problemNode);
                trace.out("miss", "gatherActivationList: currentNode ==>> " + this.controller.getSolutionState().getCurrentNode());
                this.controller.setCurrentNode2(problemNode);
            }
            ProblemNode currentNode = this.controller.getSolutionState().getCurrentNode();
            trace.out("miss", "gatherActivationList: currentNode ==>> " + currentNode);
            if (problemNode.getParents().isEmpty()) {
                trace.out("ss", "Entered problemNode.getParents().isEmpty()");
                this.controller.goToStartStateForRuleTutors();
            } else {
                trace.out("ss", "In the else part as getParents.isEmpty()is false");
                boolean useInterfaceTemplate = MTRete.getUseInterfaceTemplates();
                MTRete.setUseInterfaceTemplates(false);
                boolean loadJessFilesSucceeded = false;
                while (!loadJessFilesSucceeded) {
                    this.controller.checkProductionRulesChainNew(currentNode);
                    if (!MTRete.loadInterfacetemplatesFailed()) {
                        loadJessFilesSucceeded = true;
                        continue;
                    }
                    trace.out("miss", "gatherActivationList: RETRYING checkProductionRulesChainNew...");
                }
                MTRete.setUseInterfaceTemplates(useInterfaceTemplate);
            }
            for (int student = firstStudent; student < this.prodRules.size() && student < nMaxStudents; ++student) {
                int i;
                activationList.clear();
                boolean result = true;
                try {
                    this.controller.getModelTracer().getRete().removeAllRules();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                result = this.controller.getModelTracer().getRete().reloadProductionRulesFile(this.prodRules.get(student), false);
                this.showActivationList();
                RuleActivationTree tree = this.controller.getRuleActivationTree();
                RuleActivationTree.TreeTableModel ttm = tree.getActivationModel();
                RuleActivationNode root = (RuleActivationNode)ttm.getRoot();
                MTRete mtRete = this.controller.getModelTracer().getRete();
                root.saveState(mtRete);
                this.showActivationList();
                List wholeAgenda = mtRete.getAgendaAsList(null);
                boolean omitBuggyRules = false;
                root.createChildren(wholeAgenda, omitBuggyRules);
                List children = root.getChildren();
                JessModelTracing jmt = mtRete.getJmt();
                for (i = 0; i < children.size(); ++i) {
                    RuleActivationNode child = (RuleActivationNode)children.get(i);
                    root.setUpState(mtRete, i);
                    jmt.fireNode(child);
                    activationList.add(child);
                }
                for (i = 0; i < activationList.size(); ++i) {
                    int rand = (int)(Math.random() * (double)this.prodRules.size());
                    if (((RuleActivationNode)activationList.get(i)).getActualInput().equals("FALSE")) continue;
                    results.add(new Answer(this.studentName[student], i * this.prodRules.size() + rand, (RuleActivationNode)activationList.get(i)));
                }
                System.out.println("Student " + student + " finished");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private void showActivationList() {
        MTRete rete = this.controller.getModelTracer().getRete();
        RuleActivationTree rat = this.controller.getRuleActivationTree();
        RuleActivationTree.TreeTableModel ttm = rat.getActivationModel();
        RuleActivationNode ran = (RuleActivationNode)ttm.getRoot();
        List wholeAgenda = rete.getAgendaAsList(null);
        ran.createChildren(wholeAgenda, false);
        List children = ran.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            RuleActivationNode child = (RuleActivationNode)children.get(i);
            trace.out("miss", "Child #" + i + " = " + child.getName());
        }
    }

    private Solution solveWholeProblem(int student) {
        ProblemNode currentNode = this.controller.getProblemModel().getStartNode();
        boolean killMessageReceived = false;
        Solution solution = new Solution();
        while (!killMessageReceived) {
            String step = this.simSt.getProblemAssessor().calcProblemStepString(currentNode.getProblemModel().getStartNode(), currentNode, this.simSt.getLastSkillOperand());
            this.simSt.setProblemStepString(step);
            ProblemNode nextCurrentNode = null;
            PriorityQueue<Answer> activationList = this.gatherActivationList(currentNode, student, 1);
            nextCurrentNode = this.inspectAgendaRuleActivations(currentNode, activationList, solution);
            if (nextCurrentNode != null) {
                ++solution.steps;
                currentNode = nextCurrentNode;
                try {
                    Vector<Instruction> instnVector = new Vector<Instruction>();
                    brController.setCurrentNode2(currentNode);
                    trace.out("miss", "setCurrentNode2 to " + currentNode + " suceeded");
                    Instruction instn = this.simSt.lookupInstructionWithNode(brController.getCurrentNode());
                    instnVector.clear();
                    instnVector.add(instn);
                    trace.out("ss", instn.toString());
                }
                catch (Exception e) {
                    trace.out("miss", "setCurrentNode2 to " + currentNode + " failed");
                }
                if (currentNode.getIncomingEdges().size() > 0) {
                    ProblemEdge edge = currentNode.getIncomingEdges().get(0);
                    String input = edge.getInput();
                    if (EqFeaturePredicate.isValidSimpleSkill(input.split(" ")[0])) {
                        this.simSt.setLastSkillOperand(input);
                    }
                    if (brController.getMissController().isPLEon()) {
                        JButton undoButton = brController.getMissController().getSimStPLE().getSimStPeerTutoringPlatform().getUndoButton();
                        if (edge.getSelection().equalsIgnoreCase("DONE")) {
                            undoButton.setText(brController.getMissController().getSimStPLE().getUndoButtonTitleString("done"));
                        } else {
                            undoButton.setText(brController.getMissController().getSimStPLE().getUndoButtonTitleString(input));
                        }
                    }
                }
            } else {
                killMessageReceived = true;
                this.simSt.setIsInteractiveLearning(false);
                trace.out("ss", "killMessageReceived is true.");
            }
            trace.out("ss", "Current Node at end of loop: " + currentNode + ":" + brController.getCurrentNode());
            if (!currentNode.getDoneState()) continue;
            this.simSt.setIsInteractiveLearning(false);
            return solution;
        }
        solution.correctness = false;
        return solution;
    }

    private ProblemNode inspectAgendaRuleActivations(ProblemNode currentNode, PriorityQueue<Answer> activationList, Solution solution) {
        ProblemNode nextCurrentNode = null;
        RuleActivationNode backupRan = null;
        String listAssessment = "";
        for (Answer ans : activationList) {
            RuleActivationNode ran = ans.step;
            if (ran.getActualInput().equalsIgnoreCase("FALSE")) continue;
            if (nextCurrentNode != null) break;
            String result = this.simSt.builtInInquiryClTutor(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput(), currentNode, currentNode.getProblemModel().getProblemName().replace("_", "="));
            if (result.startsWith("Correct")) {
                nextCurrentNode = this.advanceNode(currentNode, ran);
                solution.solutionPath = solution.solutionPath + " " + ran.getActualInput();
                continue;
            }
            String lastSkill = "";
            if (this.simSt.getLastSkillOperand() != null && this.simSt.getLastSkillOperand().indexOf(32) >= 0) {
                lastSkill = this.simSt.getLastSkillOperand().substring(0, this.simSt.getLastSkillOperand().indexOf(32));
            }
            if ((ran.getActualInput().contains("FALSE") || this.simSt.getLastSkillOperand() != null && ran.getName().contains(lastSkill)) && !ran.getName().contains("typein")) continue;
            listAssessment = listAssessment + "Backup: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
            backupRan = ran;
        }
        if (nextCurrentNode == null && backupRan != null) {
            listAssessment = listAssessment + "Backup used: " + backupRan.getName() + " " + backupRan.getActualInput() + "\n";
            solution.solutionPath = solution.solutionPath + " " + backupRan.getActualInput();
            solution.correctness = false;
            nextCurrentNode = this.advanceNode(currentNode, backupRan);
        } else {
            listAssessment = listAssessment + "Not backup used\n";
        }
        return nextCurrentNode;
    }

    class Solution {
        String solutionPath = "";
        String answer = "";
        int steps = 0;
        boolean correctness = true;

        Solution() {
        }
    }

    class Answer
    implements Comparable<Object> {
        RuleActivationNode step;
        int ranking;
        String student;

        Answer(String stud, int rank, RuleActivationNode ran) {
            this.step = ran;
            this.ranking = rank;
            this.student = stud;
        }

        public String toString() {
            return this.student + "-" + this.ranking + "-" + this.step.getActualInput();
        }

        @Override
        public int compareTo(Object arg0) {
            Integer otherRank = ((Answer)arg0).ranking;
            return new Integer(this.ranking).compareTo(otherRank);
        }
    }
}

