/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.MetaTutor;

import edu.cmu.pact.ctat.view.AvoidsBackGrading;
import edu.cmu.pact.miss.MetaTutor.APlusHintDialogInterface;
import edu.cmu.pact.miss.MetaTutor.APlusHintMessagesManager;
import edu.cmu.pact.miss.MetaTutor.MetaTutorAvatarComponent;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public class APlusHintDialog
extends JDialog
implements ActionListener,
StudentActionListener,
APlusHintDialogInterface {
    private static final String NEXT_HINT = " Tell me more >> ";
    private static final String PREVIOUS_HINT = " << Go back ";
    private static final String OK = " OK ";
    private static final String DIALOG_TITLE = " Mr. Williams says    \t";
    String message;
    private JPanel okCancelPanel = new JPanel();
    private JEditorPane hintsJEditorPane;
    protected JScrollPane hintsJEditorScrollPane;
    private HintJButton previousJButton = new HintJButton(" << Go back ");
    private HintJButton nextJButton = new HintJButton(" Tell me more >> ");
    private HintJButton okJButton = new HintJButton(" OK ");
    String fontFamily = JCommWidget.getDefaultFont().getFamily();
    int fontSize = JCommWidget.getDefaultFont().getSize();
    APlusHintMessagesManager aPlusHintMessagesManger;
    Container contentPane = this.getContentPane();
    SimStLogger logger;
    int depth = 1;
    long openTime = -1L;
    long hintStartTime = -1L;
    private MetaTutorAvatarComponent mtAvatar;
    private boolean visibleFlag;

    public APlusHintDialog(Frame parent, APlusHintMessagesManager hintMessagesManager, SimStLogger log, JComponent comp) {
        super(parent, true);
        this.logger = log;
        this.mtAvatar = (MetaTutorAvatarComponent)comp;
        this.init(hintMessagesManager);
    }

    private void init(APlusHintMessagesManager hintMessagesManager) {
        this.setTitle(DIALOG_TITLE);
        this.aPlusHintMessagesManger = hintMessagesManager;
        this.setLocation(new Point(400, 200));
        this.setSize(400, 260);
        this.setResizable(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setAlwaysOnTop(true);
        this.contentPane.setLayout(new BorderLayout());
        this.hintsJEditorPane = new JEditorPane();
        this.hintsJEditorPane.setName("hintsJEditorPane");
        this.hintsJEditorPane.setContentType("text/html");
        this.hintsJEditorPane.setText("<html><br><br><br><br></html>");
        this.hintsJEditorPane.setAutoscrolls(true);
        this.hintsJEditorPane.setEditable(false);
        this.hintsJEditorPane.setFocusable(false);
        this.hintsJEditorPane.setMargin(new Insets(5, 5, 5, 2));
        this.hintsJEditorScrollPane = new JScrollPane(this.hintsJEditorPane);
        this.contentPane.add((Component)this.hintsJEditorPane, "Center");
        this.okCancelPanel.setLayout(new FlowLayout(1));
        this.okCancelPanel.add(this.previousJButton);
        this.okCancelPanel.add(this.nextJButton);
        this.okCancelPanel.add(this.okJButton);
        this.contentPane.add((Component)this.okCancelPanel, "South");
        this.previousJButton.addActionListener(this);
        this.nextJButton.addActionListener(this);
        this.okJButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                long endTime = new Date().getTime();
                int duration = (int)(endTime - APlusHintDialog.this.openTime);
                String leavingMessage = APlusHintDialog.this.hintsJEditorPane.getText();
                leavingMessage = leavingMessage.replaceAll("\\<.*?>", "");
                int durationHint = (int)(endTime - APlusHintDialog.this.hintStartTime);
                if (APlusHintDialog.this.mtAvatar != null) {
                    APlusHintDialog.this.mtAvatar.changeMetaTutorImage("img/metatutor.png");
                }
                APlusHintDialog.this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Metatutor Hint Left", "", "" + APlusHintDialog.this.depth, (Object)"", durationHint, leavingMessage);
                APlusHintDialog.this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Metatutor Hint Closed", "", "" + APlusHintDialog.this.depth, (Object)"", duration);
                APlusHintDialog.this.aPlusHintMessagesManger.dialogCloseCleanUp();
                APlusHintDialog.this.reset();
                APlusHintDialog.this.visibleFlag = false;
                APlusHintDialog.this.setVisible(false);
            }
        });
    }

    @Override
    public void displayBuggyMessage(String buggyMessage) {
    }

    @Override
    public void displaySuccessMessage() {
    }

    @Override
    public Component getDoneButton() {
        return null;
    }

    @Override
    public Component getHintButton() {
        return null;
    }

    @Override
    public JButton getNextHintButton() {
        return this.nextJButton;
    }

    @Override
    public JButton getPrevHintButton() {
        return this.previousJButton;
    }

    @Override
    public boolean getSuppressFeedback() {
        return false;
    }

    @Override
    public boolean isHintButton(Component c) {
        return c == this.okJButton || c == this.previousJButton || c == this.nextJButton;
    }

    @Override
    public void reset() {
        this.depth = 1;
        this.openTime = -1L;
        this.hintStartTime = -1L;
        if (!this.visibleFlag) {
            return;
        }
        this.hintsJEditorPane.setText("");
        this.previousJButton.setEnabled(false);
        this.nextJButton.setEnabled(false);
        this.aPlusHintMessagesManger.reset();
        this.repaint();
    }

    @Override
    public void setDisplayHint(boolean displayHint) {
    }

    @Override
    public void setSuppressFeedback(boolean suppressFeedback) {
    }

    @Override
    public void showMessage(String message) {
        this.hintsJEditorPane.setText("");
        if (message == null) {
            this.reset();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    APlusHintDialog.this.setVisible(false);
                }
            });
            return;
        }
        if (this.openTime == -1L) {
            this.openTime = new Date().getTime();
        }
        this.hintStartTime = new Date().getTime();
        this.hintsJEditorPane.setFont(JCommWidget.getDefaultFont());
        this.hintsJEditorPane.setText(message);
        this.resetButtonEnables();
        if (message.trim().equals("")) {
            this.visibleFlag = false;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    APlusHintDialog.this.setVisible(APlusHintDialog.this.visibleFlag);
                }
            });
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    APlusHintDialog.this.setVisible(true);
                    APlusHintDialog.this.validate();
                }
            });
        }
    }

    private void resetButtonEnables() {
        this.previousJButton.setEnabled(this.aPlusHintMessagesManger.hasPreviousMessage());
        this.nextJButton.setEnabled(this.aPlusHintMessagesManger.hasNextMessage());
        if (this.visibleFlag) {
            this.repaint();
            this.validate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JButton selectedButton = (JButton)ae.getSource();
        String leavingMessage = this.hintsJEditorPane.getText();
        leavingMessage = leavingMessage.replaceAll("\\<.*?>", "");
        long endTime = new Date().getTime();
        int durationHint = (int)(endTime - this.hintStartTime);
        if (selectedButton == this.okJButton) {
            int duration = (int)(endTime - this.openTime);
            this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Metatutor Hint Left", "", "" + this.depth, (Object)"", durationHint, leavingMessage);
            this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Metatutor Hint Closed", "", "" + this.depth, (Object)"", duration);
            this.aPlusHintMessagesManger.dialogCloseCleanUp();
            if (this.mtAvatar != null) {
                this.mtAvatar.changeMetaTutorImage("img/metatutor.png");
            }
            this.reset();
            this.visibleFlag = false;
            this.setVisible(false);
            return;
        }
        if (selectedButton == this.nextJButton) {
            this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Metatutor Hint Left", "", "" + this.depth, (Object)"", durationHint, leavingMessage);
            this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Next Metatutor Hint Selected", "" + this.depth);
            this.message = this.aPlusHintMessagesManger.getNextMessage();
            ++this.depth;
        } else if (selectedButton == this.previousJButton) {
            this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Metatutor Hint Left", "", "" + this.depth, (Object)"", durationHint, leavingMessage);
            this.logger.simStLog("SIM_STUDENT_METATUTOR_ACTION_LISTENER", "Previous Metatutor Hint Selected", "" + this.depth);
            this.message = this.aPlusHintMessagesManger.getPreviousMessage();
            --this.depth;
        }
        this.showMessage(this.message);
    }

    protected ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = this.getClass().getResource(file);
        return new ImageIcon(url);
    }

    @Override
    public void studentActionPerformed(StudentActionEvent sae) {
    }

    public static class HintJButton
    extends JButton
    implements AvoidsBackGrading {
        private static final long serialVersionUID = 1L;

        public HintJButton() {
        }

        public HintJButton(String text) {
            super(text);
        }
    }
}

