/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.hcii.ctat.wizard.CTATWorkspaceConfigureDialog;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorLauncherServer;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.BehaviorRecorder.Dialogs.LoadFileDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTabManager;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.Monitor;
import edu.cmu.pact.TutoringService.TransactionInfo;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.MarathonUtil;
import edu.cmu.pact.Utilities.NtpClient;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.CtatLMSClient;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import edu.cmu.pact.ctat.view.CtatFrame;
import edu.cmu.pact.ctatview.CtatFrameController;
import edu.cmu.pact.ctatview.CtatMenuBar;
import edu.cmu.pact.ctatview.DockManager;
import edu.cmu.pact.miss.MissControllerExternal;
import edu.cmu.pact.miss.MissControllerStub;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.console.controller.MissController;
import java.io.File;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import pact.CommWidgets.UniversalToolProxy;

public class CTAT_Launcher {
    public static final String SKIP_MONITOR_ARG = "skipmonitor";
    private DockManager dockManager;
    private CTATTabManager tabManager;
    private CtatMenuBar ctatMenuBar;
    private CtatFrameController ctatFrameController;
    private RuleProduction.Catalog ruleProductionCatalog;
    private CtatLMSClient ctat_lms;
    private MissControllerExternal missController;
    private boolean needAuthoringFeatures;
    private boolean inReducedMode;
    private boolean inAppletMode;
    private boolean initialized;
    private Monitor monitor;
    private AuthorLauncherServer authorLauncherServer;
    private static final Pattern htmlExt = Pattern.compile(".*[.]html?$", 2);

    public CTAT_Launcher() {
        this(null, true, false, false);
    }

    public CTAT_Launcher(String[] argv) {
        this(argv, true, false, false);
    }

    public CTAT_Launcher(String[] argv, boolean showCtatWindow, boolean inAppletMode, boolean inReducedMode) {
        if (LoadFileDialog.passFileNameToOtherInstance("spServerPort", argv)) {
            System.exit(0);
        }
        if (CTAT_Launcher.hasSimStArgs(argv)) {
            CTATTabManager.setMaxNumTabs(1);
        }
        VersionInformation.setRunningSimSt(CTAT_Launcher.hasSimStArgs(argv));
        this.initialized = false;
        this.needAuthoringFeatures = showCtatWindow;
        this.inAppletMode = inAppletMode;
        this.inReducedMode = inReducedMode;
        this.dockManager = new DockManager(this);
        this.tabManager = new CTATTabManager(this, argv);
        this.authorLauncherServer = new AuthorLauncherServer(this.tabManager, argv);
        String noTutorInterface = System.getProperty("noCtatWindow");
        if (noTutorInterface != null) {
            trace.out("No CTAT Window");
            this.needAuthoringFeatures = false;
        }
        int tabNumber = this.tabManager.getNextTabNumber();
        CTATTab firstTab = new CTATTab(tabNumber);
        this.tabManager.setFocusedTab(firstTab, true);
        SingleSessionLauncher launcher = new SingleSessionLauncher(argv, this.tabManager, this, firstTab);
        this.initCtatFrameController();
        this.tabManager.getNewTab(firstTab, launcher);
        this.tabManager.setTabVisibility(tabNumber, true);
        this.tabManager.setFocusedTab(this.tabManager.getTabByNumber(tabNumber), true);
        ProblemModel pm = this.tabManager.getTabByNumber(tabNumber).getProblemModel();
        pm.addProblemModelListener(this.getCtatFrameController().getDockedFrame().getCtatMenuBar());
        pm.addProblemModelListener(pm.getController().getPseudoTutorMessageHandler());
        pm.getController().addChangeListener(this.getCtatFrameController().getDockedFrame().getCtatModePanel());
        this.dockWindowsNow(this.needAuthoringFeatures());
        this.getCtatMenuBar();
        if (!this.isInAppletMode()) {
            this.initializeSimSt(argv);
        }
        this.startMonitor(argv);
        int firstTabNumber = 1;
        BR_Controller controller = this.getTabManager().getTabByNumber(firstTabNumber).getController();
        this.getDockManager().updateGraphConnectionStatus(firstTabNumber, controller.getUniversalToolProxy().getStudentInterfaceConnectionStatus());
        this.getDockManager().markAsFocused(1, -1);
        this.initialized = true;
        this.authorLauncherServer.startListeners();
    }

    private void startMonitor(String[] argv) {
        for (String arg : argv) {
            if (!arg.toLowerCase().contains(SKIP_MONITOR_ARG)) continue;
            return;
        }
        this.monitor = new Monitor(1503);
        this.monitor.addRequestHandler("loadFileDialog", new LoadFileDialog(this));
        this.monitor.start();
    }

    public AuthorLauncherServer getAuthorLauncherServer() {
        return this.authorLauncherServer;
    }

    public void initCtatFrameController() {
        if (this.ctatFrameController == null) {
            this.ctatFrameController = new CtatFrameController(this);
        }
    }

    public void initOnlineData(Boolean isOnline) {
        if (isOnline != null) {
            this.getAuthorLauncherServer().getProperties().setProperty("isOnline", isOnline.toString());
            this.getAuthorLauncherServer().getPreferencesModel().setPreventSaves(isOnline);
        }
    }

    public static void main(final String[] argv) {
        Locale.setDefault(new Locale("en", "US"));
        if (argv.length == 1 && "-version".equalsIgnoreCase(argv[0])) {
            VersionInformation.main(argv);
            System.out.printf("includes %-5s: %b\n", "Jess", VersionInformation.includesJess());
            System.out.printf("includes %-5s: %b\n", "SimSt", VersionInformation.includesSimSt());
            System.out.printf("includes %-5s: %b\n", "CL", VersionInformation.includesCL());
            System.exit(2);
        }
        VersionInformation.setRunningSimSt(CTAT_Launcher.hasSimStArgs(argv));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CTAT_Launcher cl;
                String siName = System.getProperty("student_interface");
                JComponent studentInterface = TutorController.createStudentInterface(siName);
                MarathonUtil.cl = cl = new CTAT_Launcher(argv);
                SingleSessionLauncher launcher = cl.getTabManager().getTabByNumber(1).getLauncher();
                if (studentInterface != null) {
                    launcher.launch(studentInterface);
                } else {
                    launcher.launch();
                    if (siName != null && htmlExt.matcher(siName).matches()) {
                        launcher.launchHTMLPage(siName);
                    }
                }
            }
        });
    }

    private static boolean hasSimStArgs(String[] argv) {
        if (argv == null) {
            return false;
        }
        for (String arg : argv) {
            if (!arg.toLowerCase().startsWith("-ss")) continue;
            return true;
        }
        return false;
    }

    public void restoreDefaultView() {
        CtatFrameController cfController = this.getCtatFrameController();
        if (cfController != null) {
            cfController.restoreDefaultView();
        }
    }

    public void dockWindowsNow(boolean showCtatWindow) {
        String isWorkspaceDefined;
        CtatFrameController cfController = this.getCtatFrameController();
        if (cfController != null) {
            cfController.dockWindowsNow(showCtatWindow);
        }
        if ((isWorkspaceDefined = this.getAuthorLauncherServer().getPreferencesModel().getStringValue("workspace")) == null) {
            CTATWorkspaceConfigureDialog configureDialog = new CTATWorkspaceConfigureDialog(this.getAuthorLauncherServer().getPreferencesModel(), true);
            configureDialog.show();
        }
    }

    public void updateStatusPanel(String toolTipText, GroupModel gm, ProblemNode currentState, ProblemModel pm, String interpStatusLabel) {
        CTATTab fTab;
        String problemFile;
        CtatFrame cf;
        if (trace.getDebugCode("status")) {
            trace.out("status", "CTAT_Launcher.updateStatusPanel(" + toolTipText + ", " + gm + ", " + currentState + ", " + pm + ", " + interpStatusLabel + ")");
        }
        if (Utils.isRuntime()) {
            return;
        }
        CtatFrame ctatFrame = cf = this.getCtatFrameController() == null ? null : this.getCtatFrameController().getDockedFrame();
        if (cf == null) {
            return;
        }
        if (toolTipText != null) {
            cf.setProblemStatusToolTip(toolTipText);
        }
        if (gm != null) {
            cf.setOrderStatusLabel(gm.isGroupOrdered(gm.getTopLevelGroup()) ? "Ordered" : "Unordered");
        }
        cf.setCurrentStateLabel(currentState == null ? null : currentState.getName());
        cf.updateUnmatchedSelections(this.graphHasObsoleteComponents(this.getFocusedController()));
        String problemFullName = pm.getProblemFullName();
        if (problemFullName != null && problemFullName.length() > 0) {
            if (toolTipText == null) {
                cf.setProblemStatusToolTip(problemFullName);
            }
            problemFile = new File(problemFullName).getName();
        } else {
            problemFile = pm.getProblemName();
        }
        if (problemFile != null && problemFile.length() > 0) {
            cf.setProblemNameLabel(problemFile);
        } else {
            cf.setProblemNameLabel("No graph has been opened yet");
            if (toolTipText == null) {
                cf.setProblemStatusToolTip("Select File->'Open Graph' to load the problem");
            }
            cf.setTutorTypeLabel("No graph has been opened yet");
        }
        if (interpStatusLabel != null) {
            cf.setInterpStatusLabel(interpStatusLabel);
        }
        CTATTab cTATTab = fTab = this.getTabManager() == null ? null : this.getTabManager().getFocusedTab();
        if (trace.getDebugCode("status")) {
            trace.printStack("status", "CTAT_Launcher.updateStatusPanel() tabMgr " + this.getTabManager() + ", fTab " + fTab + ",studentInterfaceName " + (fTab == null ? "[none]" : fTab.getStudentInterfaceName()));
        }
        cf.setStudentInterface(fTab == null ? "" : fTab.getStudentInterfaceName());
    }

    private boolean graphHasObsoleteComponents(BR_Controller controller) {
        UniversalToolProxy utp = controller.getUniversalToolProxy();
        if (utp == null) {
            return false;
        }
        return utp.enableObsoleteSeletionDialog();
    }

    public void saveDockedLayout(String layout) {
        CtatFrameController cfController = this.getCtatFrameController();
        if (cfController != null) {
            cfController.saveLayout(layout);
        }
    }

    public void closeApplication(BR_Controller controller, boolean saveBrdFile) {
        if (trace.getDebugCode("close")) {
            trace.out("close", "saveBrdFile " + saveBrdFile + ", getAuthorToolsVisible() " + controller.getAuthorToolsVisible());
        }
        this.saveDockedLayout(controller.getCtatModeModel().getCurrentMode());
        try {
            if (!controller.getAuthorToolsVisible()) {
                this.exit(controller, false);
            }
        }
        catch (NullPointerException e) {
            this.exit(controller, false);
        }
        if (this.getCTAT_LMS().isStudentLoggedIn() || controller.getProblemModel().isProblemLoadedFromLispTutor() || !saveBrdFile) {
            this.exit(controller, saveBrdFile);
            return;
        }
        this.exit(controller, saveBrdFile);
    }

    private void exit(BR_Controller controller, boolean saveBrdFile) {
        if (trace.getDebugCode("mg")) {
            trace.printStack("mg", "CTAT_Launcher (exit): start");
        }
        if (!Utils.isRuntime()) {
            this.getAuthorLauncherServer().getPreferencesModel().saveToDisk();
        }
        if (this.getCTAT_LMS().isStudentLoggedIn()) {
            this.getCTAT_LMS().logout();
        }
        int currentTab = controller.getTabNumber();
        trace.out("mg", "CTAT_Launcher (exit): on tab " + currentTab);
        if (controller.getAuthorToolsVisible() && controller.getProblemModel().getProblemGraph().getNodeCount() > 0 && !this.getCTAT_LMS().isStudentLoggedIn() && !controller.getProblemModel().isProblemLoadedFromLispTutor() && saveBrdFile) {
            trace.out("mg", "CTAT_Launcher (exit): saving problem " + currentTab);
            if (controller.saveCurrentProblemWithUserPrompt(true) == 2) {
                return;
            }
        }
        for (int i = 0; i < CTATTabManager.getNumTabs(); ++i) {
            int tabNumber = i + 1;
            if (tabNumber == currentTab) continue;
            BR_Controller control = this.getTabManager().getTabByNumber(tabNumber).getController();
            trace.out("mg", "CTAT_Launcher (exit): saving problem " + tabNumber + " if needed");
            if (control.getProblemModel().isEmpty() || control.saveCurrentProblemWithUserPrompt(true) != 2) continue;
            return;
        }
        this.getDockManager().clearGraphViews(controller.getCtatModeModel().getCurrentMode());
        MissControllerExternal missController = this.getMissController();
        if (missController != null) {
            SimStPLE ple;
            SimSt simSt = missController.getSimSt();
            if (simSt != null && simSt.inquiryClAlgebraTutor != null) {
                simSt.inquiryClAlgebraTutor.shutdown();
            }
            if ((ple = missController.getSimStPLE()) != null) {
                ple.shutdown();
            }
        }
        System.exit(0);
    }

    public PreferencesModel getPreferencesModel() {
        return this.getAuthorLauncherServer().getPreferencesModel();
    }

    public LoggingSupport getLoggingSupport() {
        return this.getAuthorLauncherServer().getLoggingSupport();
    }

    public void setCTAT_LMS(CtatLMSClient lms) {
        this.ctat_lms = lms;
    }

    public CtatLMSClient getCTAT_LMS() {
        return this.ctat_lms;
    }

    public void setMissController(MissControllerExternal mc) {
        this.missController = mc;
    }

    public MissControllerExternal getMissController() {
        return this.missController;
    }

    public void initializeSimSt() {
        this.initializeSimSt(null);
    }

    public void initializeSimSt(String[] argv) {
        if (this.getMissController() == null || argv != null) {
            CtatFrameController cfController;
            MissControllerExternal missController = null;
            missController = VersionInformation.isRunningSimSt() && !Utils.isRuntime() ? new MissController(this, "") : new MissControllerStub(this);
            this.setMissController(missController);
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "===>miss instanceof " + (this.getMissController() == null ? "null" : this.getMissController().getClass().getSimpleName()));
            }
            if (!Utils.isRuntime() && (cfController = this.getCtatFrameController()) != null) {
                cfController.getDockManager().addSimStConsole();
            }
            missController.parseArgv(argv);
        }
    }

    public AbstractCtatWindow getActiveWindow() {
        return this.getDockedFrame();
    }

    public void setAppletMode(boolean inMode) {
        this.inAppletMode = inMode;
    }

    public boolean isInAppletMode() {
        return this.inAppletMode;
    }

    public CtatFrameController getCtatFrameController() {
        return this.ctatFrameController;
    }

    public DockManager getDockManager() {
        return this.dockManager;
    }

    public CtatMenuBar getCtatMenuBar() {
        if (this.ctatMenuBar == null) {
            this.ctatMenuBar = new CtatMenuBar(this);
        }
        return this.ctatMenuBar;
    }

    public AbstractCtatWindow getDockedFrame() {
        CtatFrame result = null;
        CtatFrameController cfController = this.getCtatFrameController();
        if (cfController != null) {
            result = cfController.getDockedFrame();
        }
        if (trace.getDebugCode("frame")) {
            trace.outNT("frame", "getDockedFrame() returns " + (result == null ? null : result.getClass().getSimpleName()));
        }
        return result;
    }

    public BR_Controller getFocusedController() {
        return this.getTabManager().getFocusedTab().getController();
    }

    public BR_Controller getController() {
        return this.getFocusedController();
    }

    public void setReducedMode(boolean b) {
        this.inReducedMode = b;
    }

    public boolean isReducedMode() {
        return this.inReducedMode;
    }

    public void setNeedAuthoringFeatures(boolean flag) {
        this.needAuthoringFeatures = flag;
    }

    public boolean needAuthoringFeatures() {
        return this.needAuthoringFeatures;
    }

    public CTATTabManager getTabManager() {
        return this.tabManager;
    }

    public boolean removeSession(String guid) {
        return false;
    }

    public void updateTimeStamp(String guid) {
    }

    public TransactionInfo.Single createTransactionInfo(String sessionId) {
        return null;
    }

    public void updateTransactionInfo(String sessionId, Object info) {
    }

    public NtpClient getNtpClient() {
        return null;
    }

    public int enqueueToCollaborators(String guid, MessageObject mo) {
        return 0;
    }

    public Collaborators checkForCollaborators(String sessionId, MessageObject setPrefs) throws Collaborators.NotReadyException {
        return null;
    }

    public Collaborators.Collaborator findCollaborator(String sessionId) {
        return null;
    }

    public void endCollaboration(String sessionId) {
    }

    public boolean isDoneIntializing() {
        return this.initialized;
    }

    public void launch(JComponent component) {
        this.getTabManager().getTabByNumber(1).getLauncher().launch(component);
    }

    public RuleProduction.Catalog getRuleProductionCatalog() {
        if (this.ruleProductionCatalog == null) {
            this.ruleProductionCatalog = new RuleProduction.Catalog();
        }
        return this.ruleProductionCatalog;
    }

    public void loadLayout(String mode) {
        if (this.getDockManager() != null) {
            this.getDockManager().loadLayout(mode);
        }
    }
}

