/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATCryptoUtils;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATDirectoryTXT;
import edu.cmu.hcii.ctat.CTATFileManager;
import edu.cmu.hcii.ctat.CTATLogSnoopInterface;
import edu.cmu.hcii.ctat.ProblemEndHandler;
import edu.cmu.hcii.ctat.ProblemSetEndHandler;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import edu.cmu.pact.Utilities.trace;
import javax.swing.JOptionPane;

public class CTATLink
extends CTATBase {
    public static final String SO_LONG = "<html>\n  <head>\n    <title>TutorShop Exiting</title>\n    <style>body { background-color: #DDDDDD; font-family: Verdana, sans-serif; }</style>\n  </head>\n  <body>\n    <table width=\"100%\" height=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n      <tr>\n        <td valign=\"middle\" align=\"center\">\n          <h2>This session has ended. Local TutorShop exiting...</h2>\n        </td>\n      </tr>\n    </table>\n  </body>\n</html>\n";
    public static String handlerConfig = "BASIC";
    public static int dialogFontSize = 10;
    public static int DEPLOYFLASH = 0;
    public static int DEPLOYHTML5 = 1;
    public static int deployType = DEPLOYFLASH;
    public static int MOBILEAPIDISABLED = 0;
    public static int MOBILEAPION = 1;
    public static int MOBILEAPIAUTO = 2;
    public static int deployMobileAPI = MOBILEAPIDISABLED;
    public static Boolean reuseSWF = false;
    public static String lastError = "";
    public static boolean initialized = false;
    public static boolean noNetwork = false;
    public static String mountedFileSystem = "DISK";
    public static int debugLine = 0;
    public static String etc = "./etc/";
    public static String logdir = "./logs/";
    public static String htdocs = "./htdocs/";
    public static String configFilePath = "./etc/config.data";
    public static String profileDir = "./";
    public static String adminPasswordFilename = "./etc/password.txt";
    public static String urlPassThrough = "";
    public static boolean adminLogin = false;
    public static String remoteHost = "";
    public static String hostName = "localhost";
    public static int wwwPort = 8080;
    public static int tsPort = 4000;
    public static int tsMonitorPort = 4001;
    public static int remoteTutoringService = 0;
    public static String appMode = "normal";
    public static String appState = "normal";
    public static String keyString = "824C64D824A9CA38E09767FDA395240C";
    public static String datashopURL = "http://pslc-qa.andrew.cmu.edu/log/server";
    public static String datashopFile = "./logs/datashop.log";
    public static String datasetName = "CTAT Dataset";
    public static String updateURL = "http://ctat.pact.cs.cmu.edu/updates";
    public static boolean requirePredefinedUserid = false;
    public static boolean dlContent = false;
    public static boolean skipGlobalAssets = false;
    public static String FIREClass = "";
    public static String crossDomainPolicy = "<?xml version=\"1.0\"?>\n<!DOCTYPE cross-domain-policy SYSTEM \"http://www.macromedia.com/xml/dtds/cross-domain-policy.dtd\">\n<cross-domain-policy>\n<allow-access-from domain=\"*\" to-ports=\"*\" />\n</cross-domain-policy>\u0000";
    public static boolean problemSetXMLsAreEncrypted = false;
    public static boolean BRDsAreEncrypted = false;
    public static boolean allowWriting = true;
    public static boolean inMemoryOnly = false;
    public static boolean useLocalTutoringService = true;
    public static boolean printDebugMessages = trace.getDebugCode("ll");
    public static boolean showNavButtons = true;
    public static CTATCryptoUtils crypto = null;
    public static CTATFileManager fManager = null;
    public static CTATLogSnoopInterface logSnooper = null;
    public static long pushPollingInterval = 2000L;
    public static int maxCachedFiles = 1000;
    public static CTATContentCache cache = null;
    public static ProblemSetEndHandler problemSetEndHandler = null;
    public static ProblemEndHandler problemEndHandler = null;
    public static UserProgressDatabase userProgress = null;
    public static String userID = "offline_user";
    public static CTATDirectoryTXT fDirectoryTXT = null;
    public static Boolean generateHTMLIndex = false;
    public static String workspaceLocation = "ctatworkspace";

    public CTATLink() {
        this(new CTATDesktopFileManager());
    }

    public CTATLink(CTATFileManager aManager) {
        this.setClassName("CTATLink");
        CTATLink.debug("CTATLink", "CTATLink ()");
        crypto = new CTATCryptoUtils();
        fManager = aManager;
        if (fManager == null) {
            fManager = new CTATDesktopFileManager();
        }
        CTATLink.debug("CTATLink", "CTATLink () Done");
    }

    public static String getCacheDir() {
        return CTATLink.getPathPrefix() + "htdocs/cache";
    }

    private static String getPathPrefix() {
        if ("DISK".equalsIgnoreCase(mountedFileSystem)) {
            return "./";
        }
        if (mountedFileSystem == null) {
            return "./";
        }
        if (mountedFileSystem.toLowerCase().endsWith(".jar")) {
            return mountedFileSystem + "?";
        }
        return mountedFileSystem + "/";
    }

    public static void mountJar(String aJarFile) {
        CTATLink.debug("CTATLink", "mountJar (" + aJarFile + ")");
        mountedFileSystem = aJarFile;
        CTATLink.processMount();
        CTATDesktopFileManager checker = new CTATDesktopFileManager();
        checker.jarListContents(mountedFileSystem);
        CTATLink.debug("CTATLink", "mountJar (" + aJarFile + ") Done");
    }

    public static void processMount() {
        CTATLink.debug("CTATLink", "processMount ()");
        if (!mountedFileSystem.equalsIgnoreCase("DISK")) {
            String sep;
            CTATLink.debug("CTATLink", "File system mount point is now " + mountedFileSystem + ", remapping ...");
            String string = sep = mountedFileSystem.toLowerCase().endsWith(".jar") ? "?" : "/";
            if (etc.indexOf("./") != -1) {
                etc = etc.replaceFirst("./", mountedFileSystem + sep);
            } else {
                CTATLink.debug("CTATLink", "Error: etc does not contain ./, instead:" + etc);
            }
            if (logdir.indexOf("./") != -1) {
                logdir = logdir.replaceFirst("./", mountedFileSystem + sep);
            } else {
                CTATLink.debug("CTATLink", "Error: logdir does not contain ./, instead:" + logdir);
            }
            if (htdocs.indexOf("./") != -1) {
                htdocs = htdocs.replaceFirst("./", mountedFileSystem + sep);
            } else {
                CTATLink.debug("CTATLink", "Error: htdocs does not contain ./, instead:" + htdocs);
            }
            if (configFilePath.indexOf("./") != -1) {
                configFilePath = configFilePath.replaceFirst("./", mountedFileSystem + sep);
            } else {
                CTATLink.debug("CTATLink", "Error: configFilePath does not contain ./, instead:" + configFilePath);
            }
            if (profileDir.indexOf("./") != -1) {
                profileDir = profileDir.replaceFirst("./", mountedFileSystem + sep);
            } else {
                CTATLink.debug("CTATLink", "Error: profileDir does not contain ./, instead:" + profileDir);
            }
            if (adminPasswordFilename.indexOf("./") != -1) {
                adminPasswordFilename = adminPasswordFilename.replaceFirst("./", mountedFileSystem + sep);
            } else {
                CTATLink.debug("CTATLink", "Error: adminPasswordFilename does not contain ./, instead:" + adminPasswordFilename);
            }
        }
    }

    public static boolean getAdminPassword() {
        String input;
        String password = new CTATDesktopFileManager().getContentsEncrypted(adminPasswordFilename);
        if (password == null) {
            JOptionPane.showMessageDialog(null, "Error reading password file.");
            return false;
        }
        while ((input = JOptionPane.showInputDialog(null, (Object)"Please enter the administator password.")) != null && !input.equals(password)) {
        }
        return input != null;
    }

    public static boolean parse(String decrypted) {
        CTATLink.debug("CTATLink", "parse ()");
        if (initialized) {
            CTATLink.debug("CTATLink", "We've already been called, aborting");
            return false;
        }
        if (decrypted == null) {
            CTATLink.debug("CTATLink", "decrypted==null (default values are to be used)");
            initialized = true;
            return false;
        }
        String[] fields = decrypted.split("\t");
        CTATLink.showStringArray(fields);
        if (fields.length < 11) {
            initialized = true;
            return false;
        }
        fields[fields.length - 1] = fields[fields.length - 1].trim();
        htdocs = fields[0];
        hostName = fields[1];
        try {
            wwwPort = Integer.valueOf(fields[2]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            tsPort = Integer.valueOf(fields[3]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            tsMonitorPort = Integer.valueOf(fields[4]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        remoteHost = fields[5];
        etc = fields[6];
        datashopURL = fields[7];
        datashopFile = fields[8];
        crossDomainPolicy = fields[9];
        adminPasswordFilename = fields[10];
        CTATLink.processMount();
        CTATLink.debug("CTATLink", "Allow writing: " + fields[11]);
        allowWriting = !fields[11].equalsIgnoreCase("false");
        useLocalTutoringService = fields.length < 13 || !fields[12].equals("false");
        if (fields.length >= 14) {
            try {
                maxCachedFiles = Integer.valueOf(fields[13]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        printDebugMessages = fields.length < 15 || !fields[14].equals("false");
        if (fields.length >= 16) {
            datasetName = fields[15];
        }
        noNetwork = fields.length < 17 || !fields[16].equals("false");
        if (fields.length >= 18) {
            logdir = fields[17];
        }
        showNavButtons = fields.length < 19 || !fields[18].equals("false");
        if (fields.length > 20) {
            CTATLink.debug("CTATLink", "fields[20]:" + fields[20]);
            if (fields[20].equals("flash")) {
                CTATLink.debug("CTATLink", "Configuring local tutorshop for Flash tutors");
                deployType = DEPLOYFLASH;
            }
            if (fields[20].equals("html5")) {
                CTATLink.debug("CTATLink", "Configuring local tutorshop for HTML5 tutors");
                deployType = DEPLOYHTML5;
            }
        }
        if (fields.length > 21) {
            handlerConfig = fields[21];
            CTATLink.debug("CTATLink", "Installing handler config: " + handlerConfig);
        }
        if (fields.length > 22) {
            CTATLink.debug("CTATLink", "fields[23]:" + fields[23]);
            if (fields[23].equals("disabled")) {
                deployMobileAPI = MOBILEAPIDISABLED;
            }
            if (fields[23].equals("on")) {
                deployMobileAPI = MOBILEAPION;
            }
            if (fields[23].equals("auto")) {
                deployMobileAPI = MOBILEAPIAUTO;
            }
        }
        initialized = true;
        return true;
    }

    public static void showStringArray(String[] stringList) {
        CTATLink.debug("CTATLink", "showStringArray (" + stringList.length + ")");
        for (int i = 0; i < stringList.length; ++i) {
            CTATLink.debug("CTATLink", "field [" + i + "]:" + stringList[i]);
        }
    }
}

