/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.OpenInterfaceDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.UnmatchedSelectionsDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.BRDClosedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.BRDLoadedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NewProblemEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.CommManager.CommMessageHandler;
import edu.cmu.pact.CommManager.CommMessageReceiver;
import edu.cmu.pact.Utilities.DelayedAction;
import edu.cmu.pact.Utilities.LoggingSupport;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.UserLogin;
import edu.cmu.pact.ctat.CommTimer;
import edu.cmu.pact.ctat.MessageListener;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MsgType;
import edu.cmu.pact.ctat.model.CtatListModel;
import edu.cmu.pact.ctat.model.StartStateModel;
import edu.cmu.pact.jess.MT;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jdom.Element;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.JCommWidgetsToolProxy;
import pact.CommWidgets.RemoteProxy;
import pact.CommWidgets.StudentInterfaceConnectionStatus;
import pact.CommWidgets.StudentInterfaceWrapper;
import pact.CommWidgets.TutorWrapper;

public class UniversalToolProxy
implements CommMessageReceiver,
CommMessageHandler,
PropertyChangeListener,
ProblemModelListener {
    public String applicationName = "AuthoringTool";
    protected boolean initialized;
    protected boolean useBehaviorRecorder = true;
    protected boolean showLoginWindow;
    boolean showWidgetInfo;
    private boolean hideWarnings;
    private boolean commutative = false;
    private boolean showDebugInfo = true;
    private boolean autoCapitalize;
    public String lastHintSelection = "";
    private boolean caseInsensitive = true;
    public boolean connectedToProductionSystem;
    protected BR_Controller controller;
    private Set<MessageListener> messageListeners;
    protected StudentInterfaceConnectionStatus studentInterfaceConnectionStatus = null;
    protected List<StartStateModel.Listener> startStateListeners = new LinkedList<StartStateModel.Listener>();
    protected StartStateModel startStateModel = null;
    protected CommTimer commTimer = null;
    private UnmatchedSelectionsDialog unmatchedSelectionsDialog = null;
    public static final String HTML5 = "HTML5";
    private static final String[] movedFromWidgetMessages = new String[]{"InterfaceAction", "InterfaceDescription", "StartProblem", "StartStateEnd", "StartNewProblem", "CorrectAction", "ResetAction", "LISPCheckAction", "InCorrectAction", "UnlockComposer", "HintList", "WrongUserMessage", "ConfirmDone", "StateGraph", "InterfaceReboot", "GetAllInterfaceDescriptions", "SendWidgetLock"};
    private static final Pattern DelayedActionPattern = Pattern.compile("\\w+");
    public static final String JAVA = "Java";
    public static final String HTML_FLASH = "HTML & Flash";

    public UniversalToolProxy() {
        this.studentInterfaceConnectionStatus = StudentInterfaceConnectionStatus.Disconnected;
    }

    @Override
    public boolean lockWidget() {
        ProblemModel pm = this.controller.getProblemModel();
        if (pm != null) {
            return pm.getLockWidget();
        }
        return true;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void init(BR_Controller controller) {
        if (controller == null) {
            throw new InvalidParameterException("Controller cannot be null.");
        }
        this.setController(controller);
        controller.getPreferencesModel().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (name.equalsIgnoreCase("OLI Logging URL")) {
            this.getController().getLoggingSupport().changeOLILoggingURL((String)newValue);
        } else if (name.equalsIgnoreCase("Use OLI Logging")) {
            Boolean nv = (Boolean)newValue;
            if (trace.getDebugCode("log")) {
                trace.out("log", "USE_OLI_LOGGING now " + (nv != null && nv != false));
            }
        } else if (name.equalsIgnoreCase("Disk Logging Directory")) {
            this.getController().getLoggingSupport().changeDiskLoggingDir((String)newValue);
        } else if (name.equalsIgnoreCase("Use Disk Logging")) {
            Boolean nv = (Boolean)newValue;
            if (trace.getDebugCode("log")) {
                trace.out("log", "USE_DISK_LOGGING now " + (nv != null && nv != false));
            }
        } else {
            return;
        }
        if (trace.getDebugCode("in")) {
            trace.out("in", "Changed " + name + " from " + evt.getOldValue() + " to " + newValue);
        }
    }

    @Override
    public void receiveMessage(MessageObject o) {
    }

    @Override
    public void handleMessage(MessageObject messageObject) {
        if (this.suppressFeedback(messageObject).tutorSuppresses()) {
            return;
        }
        this.handleMessageByPlatform(messageObject, false);
    }

    public void handleMessageByPlatform(MessageObject messageObject, boolean pssOverride) {
        if (trace.getDebugCode("utp")) {
            trace.out("utp", "inside UniversalToolProxy.handleMessage():\n" + messageObject);
        }
        if (this.checkMessage(messageObject)) {
            return;
        }
        this.fireMessageSent(messageObject);
        if (trace.getDebugCode("log")) {
            trace.out("log", "UTP handleMessage after fireMessageSent for message:" + messageObject.toString());
        }
        this.transmitMessage(messageObject, pssOverride);
        if (trace.getDebugCode("utp")) {
            trace.out("utp", "UTP: don't know message type" + messageObject.getMessageType());
        }
    }

    protected synchronized boolean checkMessage(MessageObject messageObject) {
        boolean suppressInterface = false;
        boolean delayed = false;
        suppressInterface = this.suppressMsgFromInterface(messageObject);
        if (!suppressInterface) {
            delayed = this.processUpdateAfterDelay(messageObject);
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "UTP.checkMessage() suppress " + suppressInterface + " || delayed " + delayed);
        }
        return suppressInterface || delayed;
    }

    private synchronized void fireMessageSent(MessageObject messageObject) {
        if (this.messageListeners == null) {
            return;
        }
        Iterator<MessageListener> it = this.messageListeners.iterator();
        while (it.hasNext()) {
            it.next().messageSent(messageObject);
            if (!trace.getDebugCode("log")) continue;
            trace.out("log", "UTP fireMessageSent iterator sending: " + messageObject.toString());
        }
    }

    private synchronized void transmitMessage(MessageObject messageObject, boolean pssOverride) {
        if (this.controller != null && this.controller.getHintMessagesManager() != null && messageObject.isMessageType(StudentInterfaceWrapper.cleanUpMessages)) {
            this.controller.getHintMessagesManager().cleanUpHintOnChange();
        }
        if (messageObject.isMessageType(movedFromWidgetMessages)) {
            this.controller.handleCommMessage_movedFromCommWidget(messageObject);
            return;
        }
        if (messageObject.isMessageType("LoadProblem")) {
            trace.out("utp", "load problem: not used in UTP");
            return;
        }
        if (MsgType.hasTextFeedback(messageObject) && this.controller.getHintMode()) {
            this.controller.getHintMessagesManager().setMessageObject(messageObject);
            String message = this.controller.getHintMessagesManager().getFirstMessage();
            if (this.controller.getStudentInterface() != null) {
                this.controller.getStudentInterface().getHintInterface().showMessage(message);
            }
            return;
        }
        if (messageObject.isMessageType("ShowLoginWindow")) {
            trace.out("utp", "login message received");
            this.showLogin();
            return;
        }
        if (messageObject.isMessageType("IsTutorVisible")) {
            Boolean visible = (Boolean)messageObject.getProperty("IsVisible");
            if (this.controller.getStudentInterface() == null) {
                if (trace.getDebugCode("utp")) {
                    trace.out("utp", "cannot set tutor visible: tutor frame == null");
                }
                return;
            }
            this.controller.getStudentInterface().setVisible(visible);
            return;
        }
    }

    public synchronized void addMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        if (this.messageListeners == null) {
            this.messageListeners = new HashSet<MessageListener>();
        }
        this.messageListeners.add(listener);
        if (trace.getDebugCode("log")) {
            trace.out("log", "UTP addMessageListener: " + listener.toString());
        }
    }

    public synchronized void removeMessageListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        if (this.messageListeners == null) {
            return;
        }
        this.messageListeners.remove(listener);
    }

    protected FeedbackEnum suppressFeedback(MessageObject messageObject) {
        return MsgType.suppressFeedback(messageObject, this.getController().getProblemModel().getSuppressStudentFeedback());
    }

    public boolean getHideWarnings() {
        return this.hideWarnings;
    }

    public void setHideWarnings(boolean hideWarnings) {
        this.hideWarnings = hideWarnings;
    }

    public boolean getShowDebugInfo() {
        return this.showDebugInfo;
    }

    public void setShowDebugInfo(boolean showDebugInfo) {
        this.showDebugInfo = showDebugInfo;
    }

    public void setCommutativity(boolean commutative) {
        this.commutative = commutative;
    }

    public boolean getCommutativity() {
        return this.commutative;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setAutoCapitalize(boolean autoCapitalize) {
        this.autoCapitalize = autoCapitalize;
    }

    public boolean getAutoCapitalize() {
        return this.autoCapitalize;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void sendProperty(MessageObject msg) {
        BR_Controller ctlr = this.getController();
        if (ctlr == null || !ctlr.getCtatModeModel().isRuleEngineTracing()) {
            return;
        }
        if (ctlr != null && ctlr.getCtatModeModel().isJessTracing()) {
            MT mt = ctlr.getModelTracer();
            if (mt != null) {
                MessageObject mo = mt.handleCommMessage(msg);
                if (mo != null) {
                    ctlr.handleCommMessage(mo);
                }
            } else {
                trace.err("UTP.sendProperty(): controller has null model tracer");
            }
            return;
        }
        try {
            throw new IllegalStateException("UTP.sendProperty() called when not Jess tracing; message:\n  " + msg);
        }
        catch (Exception e) {
            trace.errStack("UTP.sendProperty() called when not Jess tracing; message:\n  " + msg, e);
            return;
        }
    }

    @Override
    public void sendMessage(MessageObject mo) {
        if (trace.getDebugCode("gusmiss")) {
            trace.out("gusmiss", "entered UTP.sendCommMessage()");
        }
        this.getController().handleCommMessage(mo);
    }

    public Vector<MessageObject> createCurrentStateVector(Vector<MessageObject> v, String problemName, boolean wantInterfaceDescriptions) {
        if (v == null) {
            v = new Vector();
        }
        v.addAll(this.getStartStateModel().createStartStateMessageList(this.getController().getProblemModel(), wantInterfaceDescriptions));
        return v;
    }

    public boolean connectToTutor() {
        if (this.controller.getCtatModeModel().isJessTracing()) {
            this.connectedToProductionSystem = true;
            return true;
        }
        throw new IllegalStateException("UTP.connectToTutor() called when not Jess tracing");
    }

    public String getStudentInterfacePlatform() {
        return JAVA;
    }

    public StudentInterfaceConnectionStatus getStudentInterfaceConnectionStatus() {
        return this.studentInterfaceConnectionStatus;
    }

    public void setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus sics) {
        BR_Controller ctlr;
        StudentInterfaceConnectionStatus oldSics = this.studentInterfaceConnectionStatus;
        if (sics != null) {
            this.studentInterfaceConnectionStatus = sics;
        }
        if (!this.studentInterfaceConnectionStatus.isConnected()) {
            this.unmatchedSelectionsDialog = null;
        }
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "updateStudentInterfaceConnection() " + (Object)((Object)oldSics) + " => " + (Object)((Object)sics));
        }
        if ((ctlr = this.getController()) != null) {
            ctlr.fireChangeEvent(this);
        }
    }

    protected void fireStartStateEvent(Object source) {
        EventObject evt = new EventObject(source);
        if (trace.getDebugCode("editstudentinput")) {
            trace.printStack("editstudentinput", "UTP.fireStartStateEvent(" + evt + ") n listeners " + this.startStateListeners.size());
        }
        Iterator<StartStateModel.Listener> it = this.startStateListeners.iterator();
        while (it.hasNext()) {
            it.next().startStateReceived(evt);
        }
        this.startStateListeners.clear();
    }

    public void addStartStateListener(StartStateModel.Listener listener) {
        if (trace.getDebugCode("http")) {
            trace.printStack("http", "UTP.addStartStateListener() listener " + trace.nh(listener));
        }
        this.startStateListeners.remove(listener);
        this.startStateListeners.add(listener);
    }

    public void removeStartStateListener(StartStateModel.Listener listener) {
        this.startStateListeners.remove(listener);
    }

    public void handleComponentInfoMessage(MessageObject o) {
        Object mismatchMsg = o.getProperty("ComponentMismatchMessage");
        if (mismatchMsg instanceof String) {
            trace.err("UTP.handleComponentInfoMessage(" + o.summary() + ") mismatch msg " + mismatchMsg);
        }
    }

    public void setShowWidgetInfo(boolean t) {
        this.showWidgetInfo = t;
    }

    @Override
    public boolean getShowWidgetInfo() {
        return this.showWidgetInfo;
    }

    public void setShowLoginWindow(boolean showLoginWindow) {
        this.showLoginWindow = showLoginWindow;
        if (showLoginWindow) {
            // empty if block
        }
    }

    public UserLogin showLogin() {
        JFrame frame = new JFrame();
        UserLogin uLog = this.createUserLogin(frame);
        uLog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (e.getWindow().isVisible()) {
                    e.getWindow().toFront();
                }
            }
        });
        uLog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StudentInterfaceWrapper si;
                String eName = evt.getPropertyName();
                if (trace.getDebugCode("br")) {
                    trace.out("br", "UserLogin event " + eName + ": old " + evt.getOldValue() + ", new " + evt.getNewValue());
                }
                if ("loginName".equals(eName)) {
                    LoggingSupport ls = UniversalToolProxy.this.getController().getLoggingSupport();
                    if (ls != null) {
                        ls.setStudentName((String)evt.getNewValue());
                    }
                    StudentInterfaceWrapper wrapper = UniversalToolProxy.this.controller.getStudentInterface();
                    trace.err("UTP.propertyChange(" + eName + ") controller.getWrapper() " + wrapper);
                    if (wrapper != null) {
                        wrapper.setVisible(true);
                    }
                } else if (" QUIT ".equals(eName) && (si = UniversalToolProxy.this.getController().getStudentInterface()) instanceof TutorWrapper) {
                    ((TutorWrapper)si).doLogout(false, false);
                }
            }
        });
        uLog.setVisible(true);
        uLog.toFront();
        return uLog;
    }

    protected UserLogin createUserLogin(JFrame frame) {
        return new UserLogin(frame);
    }

    public boolean getShowLoginWindow() {
        return this.showLoginWindow;
    }

    protected void setController(BR_Controller controller) {
        if (controller == null) {
            throw new InvalidParameterException("Controller cannot be null");
        }
        this.controller = controller;
    }

    public BR_Controller getController() {
        return this.controller;
    }

    public void bundleMessage(MessageObject o, String bundleName, String endMsgType) {
        this.handleMessage(o);
    }

    public static List<MessageObject> unbundle(MessageObject mo) {
        List<Object> messagesObj = mo.getProperty("messages");
        if (!(messagesObj instanceof List)) {
            if (messagesObj instanceof Element) {
                messagesObj = Collections.singletonList(messagesObj);
            } else {
                trace.err("unbundle: messages property not a List:\n  " + mo);
                return null;
            }
        }
        if (((List)messagesObj).size() < 1 || !(messagesObj.get(0) instanceof Element)) {
            trace.err("unbundle: messages property empty or not List<Element>:\n  " + mo);
            return null;
        }
        Iterator<Object> it = messagesObj.iterator();
        ArrayList<MessageObject> result = new ArrayList<MessageObject>(messagesObj.size());
        int i = 0;
        while (it.hasNext()) {
            Element msgElt = (Element)it.next();
            try {
                result.add(MessageObject.fromElement(msgElt));
            }
            catch (Exception e) {
                trace.errStack("Error unbundling msg[" + i + "]:\n    " + mo, e);
            }
            ++i;
        }
        return result;
    }

    public JCommWidgetsToolProxy getToolProxy() {
        return null;
    }

    public void setProperty(MessageObject mo) {
        this.getController().handleCommMessage(mo);
    }

    public static int isDelayedAction(String action, String[] revisedAction) {
        revisedAction[0] = action;
        if (action == null || action.length() < 1) {
            return 0;
        }
        int j = 0;
        int delayTime = 0;
        Object[] temp = new String[]{"", ""};
        Matcher m = DelayedActionPattern.matcher(action);
        while (j < temp.length && m.find()) {
            if (m.group() == null) continue;
            temp[j++] = m.group();
        }
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "UTP.isDelayedAction(" + action + ") temp[] " + Arrays.toString(temp));
        }
        if (j > 0) {
            revisedAction[0] = temp[0];
        }
        if (j > 1) {
            try {
                delayTime = Integer.parseInt(temp[1].trim());
            }
            catch (NumberFormatException nfe) {
                delayTime = 0;
            }
        }
        return delayTime;
    }

    public boolean processUpdateAfterDelay(String messageType, String selection, String action, String input) {
        String[] revisedAction = new String[1];
        int delay = UniversalToolProxy.isDelayedAction(action, revisedAction);
        if (delay == 0) {
            return false;
        }
        action = revisedAction[0];
        MessageObject mo = MessageObject.create(messageType);
        mo.setSelection(selection);
        mo.setAction(action);
        mo.setInput(input);
        this.sendMsgAfterDelay(mo, delay);
        return true;
    }

    private void sendMsgAfterDelay(final MessageObject mo, int ms) {
        if (trace.getDebugCode("msg")) {
            trace.out("msg", "sendMsgAfterDelay(" + mo.getSelection() + ", " + mo.getAction() + ", " + mo.getInput() + ") <= " + ms);
        }
        DelayedAction dA = new DelayedAction(new Runnable(){

            @Override
            public void run() {
                UniversalToolProxy.this.handleMessage(mo);
            }
        });
        dA.setDelayTime(ms);
        dA.start();
    }

    public boolean processUpdateAfterDelay(MessageObject mo) {
        String action = mo.getFirstAction();
        String[] revisedAction = new String[1];
        int delay = UniversalToolProxy.isDelayedAction(action, revisedAction);
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "UTP.processUpdateAfterDelay() action " + action + ", delay " + delay);
        }
        if (delay == 0) {
            return false;
        }
        mo.setAction(revisedAction[0]);
        this.sendMsgAfterDelay(mo, delay);
        return true;
    }

    public void handleStartStateMessageFromInterface(MessageObject mo) {
        this.getStartStateModel().addStudentInterfaceMessage(mo);
    }

    public Iterator<MessageObject> startNodeMessagesIterator(ProblemModel pm) {
        return this.getStartStateModel().startNodeMessagesIterator(pm);
    }

    protected List<String> listFixedSelectionNames() {
        return JCommWidget.listFixedSelectionNames();
    }

    protected List<String> listActionNames() {
        return JCommWidget.listActionNames();
    }

    public StartStateModel getStartStateModel() {
        if (this.startStateModel == null) {
            if (trace.getDebugCode("http")) {
                trace.printStack("http", "UTP.getStartStateModel() to create SSM");
            }
            this.startStateModel = new StartStateModel(this.listFixedSelectionNames(), this.listActionNames());
            if (!Utils.isRuntime()) {
                this.unmatchedSelectionsDialog = new UnmatchedSelectionsDialog(this);
                this.addStartStateListener(this.unmatchedSelectionsDialog);
            }
        }
        return this.startStateModel;
    }

    public String compareStartStateMessages(ProblemModel problemModel) {
        if (Utils.isRuntime()) {
            return null;
        }
        return this.getStartStateModel().compareStartStateMessages(problemModel);
    }

    public void resetStartStateModel() {
        if (trace.getDebugCode("startstate")) {
            trace.printStack("startstate", "UTP.resetCompareStartStateMessages()");
        }
        this.startStateModel = null;
        this.unmatchedSelectionsDialog = null;
    }

    public boolean setUserBeganStartStateEdit(boolean beginning) {
        return this.getStartStateModel().setUserBeganStartStateEdit(beginning);
    }

    public boolean isStartStateModified() {
        return this.getStartStateModel().isStartStateModified();
    }

    public void handleGetAllInterfaceDescriptions(MessageObject mo) {
        List<MessageObject> messages;
        if (trace.getDebugCode("ll")) {
            trace.out("ll", "handleGetAllInterfaceDescriptions ()");
        }
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", "UTP.handleGetAllInterfaceDescriptions(" + mo.summary() + ") n listeners " + this.startStateListeners.size());
        }
        if ((messages = UniversalToolProxy.unbundle(mo)) == null) {
            messages = Collections.emptyList();
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "UTP.handleGetAllInterfaceDescriptions() bundle size " + messages.size());
        }
        this.awaitInterfaceDescriptions(false);
        this.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.Connected);
        if (!this.getController().isAcceptingStartStateMessages()) {
            trace.out("ll", "Error, we're not handling start state messages in the current state");
            return;
        }
        this.resetStartStateModel();
        this.getStartStateModel().addStudentInterfaceMessageBundle(messages);
        this.fireStartStateEvent(this.getStartStateModel());
        trace.out("ll", "Number of incoming interfacedescription messages: " + messages.size());
        for (int i = 0; i < messages.size(); ++i) {
            MessageObject msg = messages.get(i);
            try {
                String msgType = msg.getMessageType();
                if ("InterfaceDescription".equalsIgnoreCase(msgType)) {
                    this.getController().handleInterfaceDescriptionMessage(msg, false);
                    continue;
                }
                if ("InterfaceAction".equalsIgnoreCase(msgType)) {
                    this.getController().handleInterfaceActionMessage(msg, false);
                    continue;
                }
                if ("UntutoredAction".equalsIgnoreCase(msgType)) {
                    this.getController().handleUntutoredActionMessage(msg, false);
                    continue;
                }
                trace.err("Unexpected message type \"" + msg.getMessageType() + "\" in bundle " + "GetAllInterfaceDescriptions" + "\n    " + msg);
                this.getController().handleCommMessage(msg);
                continue;
            }
            catch (Exception e) {
                trace.errStack("Error on bundled msg[" + i + "]:\n  " + mo, e);
            }
        }
    }

    public void chooseSISettingsInStartState(MessageObject intDescMsg, ProblemModel pm) {
        this.getStartStateModel().commitSISettings(intDescMsg, pm);
    }

    public boolean rebootInterface(RebootInterfaceDialog dialog) {
        if (this.getController() == null) {
            return false;
        }
        JComponent tutorPanel = this.getController().getTutorPanel();
        if (tutorPanel == null) {
            return false;
        }
        Class<?> tutorPanelClass = tutorPanel.getClass();
        this.getController().closeStudentInterface();
        StudentInterfaceWrapper siw = OpenInterfaceDialog.openInterface(tutorPanelClass, this.getController(), null);
        if (siw == null) {
            return false;
        }
        siw.setVisible(true);
        return true;
    }

    public boolean getAllInterfaceDescriptions() {
        if (trace.getDebugCode("startstateverbose")) {
            trace.printStack("startstateverbose", "UTP.getAllInterfaceDescriptions()");
        }
        if (!this.getStudentInterfaceConnectionStatus().isConnected()) {
            return false;
        }
        this.handleMessage(MessageObject.create("GetAllInterfaceDescriptions"));
        return true;
    }

    protected boolean suppressMsgFromInterface(MessageObject msg) {
        if (this.controller != null) {
            if (CommTimer.isTimerMessage(msg)) {
                if (this.commTimer == null || this.commTimer.isExiting()) {
                    RemoteProxy rp = this.controller.getRemoteProxy();
                    this.commTimer = rp != null && rp.getActionHandler() != null ? new CommTimer(this.controller.getSessionId(), rp.getActionHandler()) : new CommTimer(this.controller.getSessionId(), this.controller);
                }
                this.commTimer = this.commTimer.process(msg);
                return true;
            }
            if (this.controller.getCtatModeModel().isListenReplayMode()) {
                return true;
            }
        }
        return false;
    }

    public void resetTimer(MessageObject msg) {
        if (this.commTimer != null) {
            this.commTimer.reset(msg);
        }
    }

    public void listSelectionNames(CtatListModel listModel) {
        if (this.getStartStateModel().nInterfaceDescriptionsFromInterface() > 0) {
            listModel.addAll(this.getStartStateModel().getComponentNames());
        } else {
            this.handleMessage(MessageObject.create("GetAllInterfaceDescriptions"));
            listModel.addAll(this.getStartStateModel().getComponentNames());
        }
    }

    public Collection<String> getAllActionNames() {
        return this.getStartStateModel().getAllActionNames();
    }

    public boolean clientRestarts(String msgType, String commShellVersion) {
        return false;
    }

    public Boolean clientSupports(String msgType, String commShellVersion) {
        return JCommWidget.clientSupports(msgType);
    }

    public boolean hasInterfaceDescriptions() {
        if (!this.getStudentInterfaceConnectionStatus().isConnected()) {
            return false;
        }
        int n = this.getStartStateModel().nInterfaceDescriptionsFromInterface();
        return n > 0;
    }

    public boolean getStoreAllInterfaceDescriptions() {
        return true;
    }

    public void setStoreAllInterfaceDescriptions(boolean storeAllInterfaceDescriptions) {
        if (trace.getDebugCode("intdesc")) {
            trace.printStack("intdesc", "UTP *NO-OP* .setStoreAllInterfaceDescriptions(" + storeAllInterfaceDescriptions + ")");
        }
    }

    public void initUnmatchedSelectionsDialog() {
        if (this.unmatchedSelectionsDialog == null || this.startStateModel == null) {
            return;
        }
        EventObject evt = new EventObject(this.startStateModel);
        this.unmatchedSelectionsDialog.startStateReceived(evt);
    }

    public UnmatchedSelectionsDialog getUnmatchedSelectionsDialogLauncher() {
        return this.unmatchedSelectionsDialog;
    }

    public void notifyUnmatchedSelectionsDialogAvailable(boolean enable) {
        if (trace.getDebugCode("obssel")) {
            trace.out("obssel", "UTP.notifyUnmatchedSelectionsDialogAvailable(" + enable + ") this UTP " + trace.nh(this) + ", BR_C's UTP " + trace.nh(this.getController().getUniversalToolProxy()));
        }
        this.getController().getCtatFrameController().getDockedFrame().getCtatMenuBar().enableFindObsoleteComponents(enable);
        this.getController().getCtatFrameController().getDockedFrame().updateUnmatchedSelections(enable);
    }

    public boolean enableObsoleteSeletionDialog() {
        if (!this.getStudentInterfaceConnectionStatus().isConnected()) {
            return false;
        }
        ProblemModel pm = this.getController().getProblemModel();
        if (pm == null || pm.getStartNode() == null) {
            return false;
        }
        if (this.getUnmatchedSelectionsDialogLauncher() == null) {
            return false;
        }
        return this.getUnmatchedSelectionsDialogLauncher().hasDialog();
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent e) {
        if (this.unmatchedSelectionsDialog != null && (e instanceof BRDClosedEvent || e instanceof BRDLoadedEvent || e instanceof EdgeCreatedEvent || e instanceof EdgeDeletedEvent || e instanceof EdgeUpdatedEvent || e instanceof NewProblemEvent)) {
            this.unmatchedSelectionsDialog.problemModelEventOccurred(e);
        }
    }

    public void awaitSetPreferences(boolean begin) {
    }

    public void awaitInterfaceDescriptions(boolean begin) {
    }

    public void saveStudentInterfaceFile(File chosenFile) throws Exception {
        this.getStartStateModel().saveStudentInterfaceFile(chosenFile);
    }

    public String getSessionId() {
        return this.controller == null ? null : this.controller.getSessionId();
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": controller " + this.getController() + ", session " + this.getSessionId() + "]";
    }

    public void dispose() {
        if (trace.getDebugCode("timer")) {
            trace.printStack("timer", "UTP.dispose()");
        }
    }

    public static interface RebootInterfaceDialog
    extends Runnable {
        public boolean confirm();

        public void invoke();

        public void dispose();
    }
}

