/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PKLearning;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.SimSt;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;

public class PKLearner {
    private static Set<String> skills = new HashSet<String>();

    public static void main(String[] args) throws IOException {
        SimSt student = PKLearner.initStudent(args[0], args[1], args[2], args[3], args[4]);
        trace.addDebugCode("miss");
        PKLearner.learn(student, args[5]);
    }

    public static SimSt initStudent(String opFile, String fpFile, String wtFile, String wsFile, String isFile) {
        SimSt s = new SimSt();
        s.setOperatorFile(opFile);
        s.setWmeTypeFile(wtFile);
        s.setWmeStructureFile(wsFile);
        s.setInitStateFile(isFile);
        s.setStudentInterfaceClass("");
        return s;
    }

    public static void learn(SimSt student, String instructionsFile) throws IOException {
        Scanner infile = new Scanner(new FileReader(instructionsFile));
        while (infile.hasNextLine()) {
            String[] tokens = infile.nextLine().split("\t");
            if (tokens[0].charAt(0) == '#') continue;
            Vector<String> foa = PKLearner.populateFoaVector(tokens);
            Instruction i = new Instruction(tokens[0], foa);
            i.setAction("UpdateTable");
            student.initRhsSearch(i, true);
            student.addInstruction(i);
            student.generateRulesWithUnorderdFoA(tokens[0]);
            skills.add(tokens[0]);
            student.saveProductionRules(2);
        }
    }

    public static Vector<String> populateFoaVector(String[] tokens) {
        Vector<String> v = new Vector<String>();
        String head = "MAIN::cell|commTable1_C";
        String tail = "R1|";
        int lastCol = tokens.length - 1;
        v.add(head + lastCol + tail + tokens[lastCol]);
        for (int i = 1; i < lastCol; ++i) {
            v.add(head + i + tail + tokens[i]);
        }
        return v;
    }
}

