/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.WmeConstraint;
import edu.cmu.pact.miss.WmePath;
import edu.cmu.pact.miss.WmePathNode;
import java.util.Vector;

public class LhsState
implements Cloneable {
    private Vector wmePathList = new Vector();
    private static Vector targetWme;
    private Vector wmeConstraints = new Vector();

    void addWmePath(WmePath path) {
        this.wmePathList.add(path);
    }

    Vector getWmePathList() {
        return this.wmePathList;
    }

    void setWmePathList(Vector wmePathList) {
        this.wmePathList = wmePathList;
    }

    int numWmePath() {
        return this.wmePathList.size();
    }

    WmePath getWmePath(int i) {
        return (WmePath)this.wmePathList.get(i);
    }

    int numWmeProcessed() {
        return this.wmePathList.size();
    }

    private void clearTargetWme() {
        targetWme = new Vector();
    }

    private void addTargetWme(String wmeTypeName) {
        targetWme.add(wmeTypeName);
    }

    private Vector getTargetWme() {
        return targetWme;
    }

    private int targetWmeSize() {
        return targetWme.size();
    }

    String nextTargetWme() {
        if (this.numWmeProcessed() < this.targetWmeSize()) {
            return (String)targetWme.get(this.numWmeProcessed());
        }
        return null;
    }

    void addWmeConstraint(Vector constraints) {
        for (int i = 0; i < constraints.size(); ++i) {
            WmeConstraint constraint = (WmeConstraint)constraints.get(i);
            this.wmeConstraints.add(constraint);
        }
    }

    boolean isGoalState() {
        return this.numWmeProcessed() == this.targetWmeSize();
    }

    public LhsState(Instruction instruction) {
        this.clearTargetWme();
        Vector seeds = instruction.getSeeds();
        for (String seed : seeds) {
            String wmeTypeName = seed.substring(0, seed.lastIndexOf(124));
            this.addTargetWme(wmeTypeName);
        }
        String selection = instruction.getSelection();
        if (!selection.split("\\|")[1].toUpperCase().equals("DONE")) {
            this.addTargetWme(selection);
        }
    }

    Vector findFloatingWme() {
        Vector wmePathNode = new Vector();
        for (int i = 0; i < this.numWmePath(); ++i) {
            WmePath wmePath = this.getWmePath(i);
            wmePathNode.addAll(wmePath.findFloatingWme());
        }
        return wmePathNode;
    }

    int wmePathIndexOf(WmePathNode wmePathNode) {
        int index = -1;
        for (int i = 0; i < this.numWmePath(); ++i) {
            if (!this.getWmePath(i).hasNode(wmePathNode)) continue;
            index = i;
            break;
        }
        return index;
    }

    int wmePathNodeIndexof(WmePathNode wmePathNode) {
        int index = -1;
        for (int i = 0; i < this.numWmePath(); ++i) {
            WmePath wmePath = this.getWmePath(i);
            if (!wmePath.hasNode(wmePathNode)) continue;
            index = wmePath.indexOf(wmePathNode);
            break;
        }
        return index;
    }

    public Object clone() {
        LhsState cloneLhsState = null;
        try {
            cloneLhsState = (LhsState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        Vector wmePathList = this.getWmePathList();
        Vector cloneWmePathList = new Vector(wmePathList);
        cloneLhsState.setWmePathList(cloneWmePathList);
        return cloneLhsState;
    }

    public String toString() {
        String str = "<LhsState targetWme: " + this.getTargetWme().toString();
        str = str + " wmePath:\n" + this.getWmePathList().toString();
        return str;
    }
}

