/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import apple.dts.samplecode.osxadapter.OSXAdapter;
import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATFileItem;
import edu.cmu.hcii.ctat.wizard.CTATHTMLProjectWizard;
import edu.cmu.hcii.ctat.wizard.CTATLMSPackageWizard;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.CreateLMSFilesDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.CreateProblemsTableDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.BehaviorRecorder.Dialogs.EditComponentStartStateSettingsDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.LaunchInterfaceAsListenerDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.LoadFileDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.LoadProductionRulesDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.MergeMassProductionDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.OpenInterfaceDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.RuleNamesDisplayDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SaveFileDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SkillMatrixDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.SuiFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.UnmatchedSelectionsDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.HintPolicyEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.BehaviorRecorder.View.JFind;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.View.VariableViewer.VariableViewer;
import edu.cmu.pact.Log.LogConsole;
import edu.cmu.pact.Log.LogConsoleReplay;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Preferences.PreferencesWindow;
import edu.cmu.pact.Utilities.LaunchCTATWebsite;
import edu.cmu.pact.Utilities.PersonnelInfo;
import edu.cmu.pact.Utilities.PrintUtilities;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.CtatModeModel;
import edu.cmu.pact.ctat.model.StartStateModel;
import edu.cmu.pact.ctatview.DockManager;
import edu.cmu.pact.jess.WMEEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.FactoryConfigurationError;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.View;
import pact.CommWidgets.TutorWindow;
import pact.CommWidgets.UniversalToolProxy;

public class CtatMenuBar
extends CTATBase
implements ActionListener,
ProblemModelListener,
WindowListener,
ChangeListener,
StartStateModel.Listener {
    public static final int MENU_ITEM_ENABLED = 0;
    public static final int CHECK_BOX_MENU_ITEM_STATE = 1;
    public static final String RETRACT_LAST_STEP = "Retract Last Step";
    private static final String NEXT_PREFERRED_STEP = "Next Preferred Step";
    private static final String PREVIOUS_PREFERRED_STATE = "Previous Preferred State";
    public static final Font defaultFont = new Font("", 3, 14);
    private JMenu file;
    private JMenu edit;
    private JMenu viewMenu;
    private JMenu graphMenu;
    private JMenu cognitiveModelMenu;
    private JMenu simStMenu;
    private JMenu toolsMenu;
    private JMenu windowsMenu;
    private JMenu helpMenu;
    private JMenuItem openInterfaceMenu;
    private JMenuItem openInterfaceAsListenerMenu;
    private JMenuItem createProblemsTableMenu;
    private JMenuItem mergeProblemsMenu;
    private JMenuItem newGraphMenu;
    private JMenuItem newPackageMenu;
    private JMenuItem newHTMLProjectMenu;
    private JMenuItem saveGraphMenu;
    private MenuItem saveGraphAsMenu;
    private MenuItem revertGraphMenu;
    private JMenuItem openGraphMenu;
    private JMenuItem closeGraphMenu;
    private JMenu openRecentGraphMenu;
    private JMenuItem saveStudentInterfaceMenu;
    private JMenuItem saveJessFactsMenu;
    private JMenuItem saveJessTemplatesMenu;
    private JMenuItem loadRuleNamesMenu;
    private JMenuItem quitMenu;
    private JMenuItem findMenu;
    private JMenuItem undoMenu;
    private JMenuItem redoMenu;
    private JMenuItem copyLinksMenu;
    private JMenuItem pasteLinksMenu;
    private JMenuItem preferencesMenu;
    private JMenuItem collaborationMenu;
    private JMenuItem logConsoleMenu;
    private JMenuItem dsExportMenu;
    private JMenuItem nextModeMenu;
    private JMenuItem reviseStartStateFromUIMenu;
    private JMenuItem cleanupStartStateMenu;
    private JMenuItem showUnmatchedComponentsMenu;
    private JMenuItem createStartStateMenu;
    private JMenuItem goToStartStateMenu;
    private JMenuItem startStateSettingsMenu;
    private JMenuItem retractOneStepMenu;
    private JMenuItem nextPreferredStepMenu;
    private JMenuItem setWMMenu;
    private JMenuItem checkAllActionsMenu;
    private JMenuItem resetLinkColorsMenu;
    private JMenuItem activateMissMenu;
    private JMenuItem loadProdRulesMenu;
    private JMenuItem setBreakpointsMenu;
    private JMenuItem clearBreakpointsMenu;
    private JMenuItem resumeBreakpointsMenu;
    private final String SIM_ST_ACTIVATE_MENU = "Activate Sim. Student";
    private final String SIM_ST_DEACTIVATE_MENU = "Deactivate Sim. Student";
    private JMenuItem ruleNamesWindowMenu;
    private JMenuItem moodleMaker;
    private JMenuItem XBlockMaker;
    private JMenuItem OLIMaker;
    private JMenuItem showWebPageMenuItem;
    private JMenuItem showLicenseMenuItem;
    private JMenuItem skillMatrixMenu;
    private JMenuItem aboutMenu;
    private JMenuItem printGraphMenu;
    private JMenuItem newProblemMenu;
    private JMenuItem saveInstructionsMenu;
    private JMenuItem loadInstructionsMenu;
    private JMenuItem loadWmeTypesMenu;
    private JMenuItem initializeWmesMenu;
    private JMenuItem loadFeaturePredicatesMenu;
    private JMenuItem loadOperatorsMenu;
    private JMenuItem testModelMenu;
    private JMenuItem outOfOrderMessageGraphMenu;
    private JMenu hintPolicyGraphMenu;
    private JMenu suppressFeedbackGraphMenu;
    private JCheckBoxMenuItem actionLabelsMenu;
    private JCheckBoxMenuItem lastCheckLISPLabelsMenu;
    private CheckBoxMenuItem ruleLabelsMenu;
    private JCheckBoxMenuItem caseSensitiveGraphMenu;
    private JCheckBoxMenuItem lockWidgetsGraphMenu;
    private JCheckBoxMenuItem confirmDoneGraphMenu;
    private JCheckBoxMenuItem highlightRightSelectionGraphMenu;
    private int dynamicViewCount = 0;
    private boolean dynamicViewHasClosed = false;
    public static final String ECLIPSE_LISTENING_PORT = "Eclipse Plugin Listening Port";
    private JMenuBar mbar;
    private JMenu viewPanelMenu;
    private Map<JMenuItem, DockingWindow> dynamicWindowMap;
    private static final String DYNAMIC_WINDOW_COMMAND = "Dynamic Window View";
    private int maxRecentFiles = 15;
    private ArrayList<CTATFileItem> recentFiles = new ArrayList();
    private final CTAT_Launcher server;
    private DockingWindow lastRestored = null;
    private JSeparator dynamicWindowSeparator;
    private DockingWindow lastClosed = null;

    public CtatMenuBar(CTAT_Launcher server) {
        this.setClassName("CtatMenuBar");
        this.debug("CtatMenuBar ()");
        this.server = server;
        this.createMenus();
    }

    public void enableJessMenus(boolean enabled) {
        if (!VersionInformation.includesJess()) {
            return;
        }
        this.saveJessFactsMenu.setEnabled(enabled);
        this.saveJessTemplatesMenu.setEnabled(enabled);
        this.loadProdRulesMenu.setEnabled(enabled);
        if (enabled) {
            this.saveJessFactsMenu.addActionListener(this);
            this.saveJessTemplatesMenu.addActionListener(this);
            this.loadProdRulesMenu.addActionListener(this);
        } else {
            this.saveJessFactsMenu.removeActionListener(this);
            this.saveJessTemplatesMenu.removeActionListener(this);
            this.loadProdRulesMenu.removeActionListener(this);
        }
        this.file.repaint();
        this.file.updateUI();
    }

    public void enableInterfaceMenus(boolean enabled) {
        this.enableOpenInterfaceMenu(new Boolean(enabled));
        this.newGraphMenu.setEnabled(true);
        if (!this.isJavaBR(null)) {
            this.newHTMLProjectMenu.setEnabled(true);
        } else {
            this.newHTMLProjectMenu.setEnabled(false);
        }
        this.saveGraphMenu.setEnabled(enabled);
        this.saveGraphAsMenu.setEnabled(enabled);
        this.openGraphMenu.setEnabled(true);
        this.closeGraphMenu.setEnabled(enabled);
        this.loadRuleNamesMenu.setEnabled(enabled);
        this.cleanupStartStateMenu.setEnabled(this.graphHasCleanUpToDo());
        this.updateUnmatchedComponents();
        this.goToStartStateMenu.setEnabled(enabled);
        this.enableMenuIfInterfaceConnected(this.startStateSettingsMenu, this.reviseStartStateFromUIMenu);
        this.retractOneStepMenu.setEnabled(enabled);
        this.nextPreferredStepMenu.setEnabled(enabled);
        this.actionLabelsMenu.setEnabled(enabled);
        this.lastCheckLISPLabelsMenu.setEnabled(enabled);
        this.ruleLabelsMenu.setEnabled(enabled);
        this.setWMMenu.setEnabled(enabled);
        this.checkAllActionsMenu.setEnabled(enabled);
        this.resetLinkColorsMenu.setEnabled(enabled);
        this.ruleNamesWindowMenu.setEnabled(enabled);
    }

    public JMenuBar getMenuBar() {
        return this.mbar;
    }

    public void enablePrintGraphMenus(boolean enabled) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CMB.enablePrintGraphMenus(" + enabled + ")");
        }
        this.printGraphMenu.setEnabled(enabled);
    }

    public void enableSaveGraphMenus(boolean enabled) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CMB.enableSaveGraphMenus(" + enabled + ")");
        }
        this.saveGraphMenu.setEnabled(enabled);
        this.saveGraphAsMenu.setEnabled(enabled);
        this.cleanupStartStateMenu.setEnabled(this.graphHasCleanUpToDo());
        this.updateUnmatchedComponents();
        this.copyLinksMenu.setEnabled(this.hasLinks());
        this.pasteLinksMenu.setEnabled(this.getController().getProblemModelManager().nSelectedLinks() > 0);
    }

    public void enableFindObsoleteComponents(boolean enable) {
        this.showUnmatchedComponentsMenu.setEnabled(this.graphHasObsoleteComponents());
    }

    public boolean graphHasObsoleteComponents() {
        UniversalToolProxy utp = this.getController().getUniversalToolProxy();
        if (utp == null) {
            return false;
        }
        return utp.enableObsoleteSeletionDialog();
    }

    private boolean graphHasCleanUpToDo() {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "CtatMenuBar.graphHasCleanUpToDo()");
        }
        UniversalToolProxy utp = null;
        if (this.getController() == null || (utp = this.getController().getUniversalToolProxy()) == null) {
            trace.err("CtatMenuBar.graphHasCleanUpToDo(): null getController() " + this.getController() + " or .getUniversalToolProxy() " + utp);
            return false;
        }
        int nToDelete = utp.getStartStateModel().pruneInterfaceDescriptions(this.getController().getProblemModel(), false);
        return nToDelete > 0;
    }

    public void enableCreateStartStateMenus(boolean enabled) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CMB.enableCreateStartStateMenus(" + enabled + ")");
        }
        this.createStartStateMenu.setEnabled(enabled);
        this.enableMenuIfInterfaceConnected(this.startStateSettingsMenu, this.reviseStartStateFromUIMenu);
        this.updateUnmatchedComponents();
    }

    public void enableGotoStartStateMenus(boolean enabled) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CMB.enableGotoStartStateMenus(" + enabled + ")");
        }
        this.goToStartStateMenu.setEnabled(enabled);
        this.enableMenuIfInterfaceConnected(this.startStateSettingsMenu, this.reviseStartStateFromUIMenu);
        this.updateUnmatchedComponents();
        this.retractOneStepMenu.setEnabled(enabled);
        this.nextPreferredStepMenu.setEnabled(enabled);
    }

    private boolean enableMenuIfInterfaceConnected(JMenuItem ... menuItems) {
        UniversalToolProxy utp = this.getController().getUniversalToolProxy();
        boolean enable = utp != null && utp.hasInterfaceDescriptions();
        for (JMenuItem menuItem : menuItems) {
            boolean previous = menuItem.isEnabled();
            menuItem.setEnabled(enable);
            if (!trace.getDebugCode("menu")) continue;
            trace.printStack("menu", "changed state of menu item \"" + menuItem.getText() + "\" from " + (previous ? "enabled" : "disabled") + " to " + (enable ? "enabled" : "disabled"));
        }
        return enable;
    }

    public JMenuBar createMenus() {
        boolean notReducedToolMode = !this.server.isReducedMode();
        this.mbar = new JMenuBar();
        int ctrlKeyMask = System.getProperty("os.name").toUpperCase().startsWith("MAC") ? 4 : 2;
        this.file = new JMenu("File");
        this.file.setMnemonic(70);
        this.mbar.add(this.file);
        this.fillFileMenu(this.file, ctrlKeyMask, notReducedToolMode);
        this.edit = new JMenu("Edit");
        this.edit.setMnemonic(69);
        this.mbar.add(this.edit);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic(86);
        this.mbar.add(this.viewMenu);
        this.fillViewMenu(this.viewMenu);
        this.graphMenu = new JMenu("Graph");
        if (notReducedToolMode) {
            this.graphMenu.setMnemonic(71);
            this.mbar.add(this.graphMenu);
        }
        this.cognitiveModelMenu = new JMenu("Cognitive Model");
        if (notReducedToolMode && VersionInformation.includesJess()) {
            this.cognitiveModelMenu.setMnemonic(67);
            this.mbar.add(this.cognitiveModelMenu);
        }
        this.simStMenu = new JMenu("Sim. Student");
        if (notReducedToolMode && VersionInformation.isRunningSimSt()) {
            this.simStMenu.setMnemonic(83);
            this.mbar.add(this.simStMenu);
        }
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(84);
        this.mbar.add(this.toolsMenu);
        this.windowsMenu = new JMenu("Window");
        this.windowsMenu.setMnemonic(87);
        this.mbar.add(this.windowsMenu);
        this.helpMenu = new JMenu("Help");
        if (notReducedToolMode) {
            this.helpMenu.setMnemonic(72);
            this.mbar.add(this.helpMenu);
            trace.out("br", "Create help menu");
        }
        final BR_Controller controller = this.getController();
        final ProblemModel model = controller.getProblemModel();
        JUndo.JAbstractUndoPacket undoPacket = controller.getUndoPacket();
        this.findMenu = new MenuItem("Find");
        this.findMenu.setName("CtatMenuBar:Edit:Find");
        this.findMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.doFindMenuDialog();
            }
        });
        this.edit.add(this.findMenu);
        this.findMenu.setAccelerator(KeyStroke.getKeyStroke(70, ctrlKeyMask));
        this.undoMenu = new MenuItem(undoPacket.getUndoAction(), new ImageIcon(this.getClass().getClassLoader().getResource("pact/undo.gif")));
        this.undoMenu.setName("CtatMenuBar:Edit:Undo");
        this.edit.add(this.undoMenu);
        this.redoMenu = new MenuItem(undoPacket.getRedoAction(), new ImageIcon(this.getClass().getClassLoader().getResource("pact/redo.gif")));
        this.redoMenu.setName("CtatMenuBar:Edit:Redo");
        this.edit.add(this.redoMenu);
        this.copyLinksMenu = new MenuItem("Copy Links", new ImageIcon(this.getClass().getClassLoader().getResource("pact/copy.gif")));
        this.copyLinksMenu.setName("CtatMenuBar:Edit:CopyLinks");
        this.copyLinksMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("mg")) {
                    trace.out("mg", "CtatMenuBar (copyLinksMenu.actionPerformed): HERE");
                }
                if (controller.copySelectedLinks() > 0) {
                    CtatMenuBar.this.pasteLinksMenu.setEnabled(true);
                }
            }
        });
        this.copyLinksMenu.setAccelerator(KeyStroke.getKeyStroke(67, ctrlKeyMask));
        this.edit.add(this.copyLinksMenu);
        this.copyLinksMenu.setEnabled(false);
        this.pasteLinksMenu = new MenuItem("Paste Links", new ImageIcon(this.getClass().getClassLoader().getResource("pact/paste.gif")));
        this.pasteLinksMenu.setName("CtatMenuBar:Edit:PasteLinks");
        this.pasteLinksMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("mg")) {
                    trace.out("mg", "CtatMenuBar (pasteLinksMenu.actionPerformed): HERE");
                }
                controller.pasteLinks();
                CtatMenuBar.this.copyLinksMenu.setEnabled(CtatMenuBar.this.hasLinks());
                ActionEvent ae = new ActionEvent(this, 0, "Paste Links");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.pasteLinksMenu.setAccelerator(KeyStroke.getKeyStroke(86, ctrlKeyMask));
        this.edit.add(this.pasteLinksMenu);
        this.pasteLinksMenu.setEnabled(false);
        boolean onMacOS = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (onMacOS) {
            try {
                OSXAdapter.setQuitHandler(this, this.getClass().getDeclaredMethod("quitHandlerForMac", new Class[0]));
            }
            catch (Exception e) {
                trace.err("Error setting quit handler; os.name " + System.getProperty("os.name") + ", onMacOS " + onMacOS);
                e.printStackTrace();
            }
        }
        this.createStartStateMenu = new MenuItem("Create Start State");
        this.createStartStateMenu.setMnemonic(67);
        this.createStartStateMenu.setAccelerator(KeyStroke.getKeyStroke(66, ctrlKeyMask));
        this.graphMenu.add(this.createStartStateMenu);
        this.createStartStateMenu.addActionListener(this);
        this.goToStartStateMenu = new MenuItem("Jump to Start State");
        this.goToStartStateMenu.setMnemonic(74);
        this.graphMenu.add(this.goToStartStateMenu);
        this.goToStartStateMenu.addActionListener(this);
        this.goToStartStateMenu.setEnabled(false);
        this.goToStartStateMenu.setAccelerator(KeyStroke.getKeyStroke(49, ctrlKeyMask));
        this.retractOneStepMenu = new MenuItem(RETRACT_LAST_STEP);
        this.retractOneStepMenu.setMnemonic(82);
        this.graphMenu.add(this.retractOneStepMenu);
        this.retractOneStepMenu.addActionListener(this);
        this.retractOneStepMenu.setEnabled(false);
        this.retractOneStepMenu.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        this.nextPreferredStepMenu = new MenuItem(NEXT_PREFERRED_STEP);
        this.nextPreferredStepMenu.setMnemonic(78);
        this.graphMenu.add(this.nextPreferredStepMenu);
        this.nextPreferredStepMenu.addActionListener(this);
        this.nextPreferredStepMenu.setEnabled(false);
        this.nextPreferredStepMenu.setAccelerator(KeyStroke.getKeyStroke(40, 8));
        this.graphMenu.addSeparator();
        this.caseSensitiveGraphMenu = new CheckBoxMenuItem("Case Sensitive Exact Matching", this.currentCaseSensitivityProperty());
        this.caseSensitiveGraphMenu.setMnemonic(77);
        this.graphMenu.add(this.caseSensitiveGraphMenu);
        this.caseSensitiveGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setCaseInsensitive(!model.isCaseInsensitive());
                ActionEvent ae = new ActionEvent(this, 0, "Set Case " + (model.isCaseInsensitive() ? "Ins" : "S") + "ensitive Matching");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.lockWidgetsGraphMenu = new CheckBoxMenuItem("Lock Widgets on Correct Action", this.currentLockWidgetProperty());
        this.lockWidgetsGraphMenu.setMnemonic(87);
        this.graphMenu.add(this.lockWidgetsGraphMenu);
        this.lockWidgetsGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setLockWidget(!model.isLockWidget());
                ActionEvent ae = new ActionEvent(this, 0, (model.isLockWidget() ? "Lock" : "Unlock") + " Widgets on Correct Action");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.suppressFeedbackGraphMenu = new JMenu("Feedback Policy");
        FeedbackEnum currentFe = this.currentSuppressFeedbackProperty();
        for (FeedbackEnum fe : FeedbackEnum.values()) {
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(fe.toString(), fe.equals((Object)currentFe));
            cbmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (trace.getDebugCode("pr")) {
                        trace.out("pr", "suppressFeedback actionPerformed(" + e + ")");
                    }
                    FeedbackEnum oldSetting = model.getSuppressStudentFeedback();
                    FeedbackEnum choice = FeedbackEnum.fromString(e.getActionCommand());
                    model.setSuppressStudentFeedback(choice);
                    for (Component c : CtatMenuBar.this.suppressFeedbackGraphMenu.getMenuComponents()) {
                        JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)c;
                        cbmi.setSelected(cbmi.getText().equals(e.getActionCommand()));
                    }
                    if (oldSetting == null || !oldSetting.equals((Object)choice)) {
                        ActionEvent ae = new ActionEvent(this, 0, "Set Feedback Policy " + choice.toString());
                        controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                    }
                }
            });
            this.suppressFeedbackGraphMenu.add(cbmi);
        }
        this.suppressFeedbackGraphMenu.setMnemonic(70);
        this.graphMenu.add(this.suppressFeedbackGraphMenu);
        this.hintPolicyGraphMenu = new JMenu("Hint Policy");
        HintPolicyEnum currentHbe = this.currentHintBiasProperty();
        for (HintPolicyEnum hbe : HintPolicyEnum.values()) {
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(hbe.toString(), hbe.equals((Object)currentHbe));
            cbmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (trace.getDebugCode("pr")) {
                        trace.out("pr", "changeHintBiasPolicy actionPerformed(" + e + ")");
                    }
                    HintPolicyEnum oldSetting = model.getHintPolicy();
                    HintPolicyEnum choice = HintPolicyEnum.fromString(e.getActionCommand());
                    model.setHintPolicy(choice);
                    for (Component c : CtatMenuBar.this.hintPolicyGraphMenu.getMenuComponents()) {
                        JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)c;
                        cbmi.setSelected(cbmi.getText().equals(e.getActionCommand()));
                    }
                    if (oldSetting == null || !oldSetting.equals((Object)choice)) {
                        ActionEvent ae = new ActionEvent(this, 0, "Set Hint Policy " + choice.toString());
                        controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                    }
                }
            });
            this.hintPolicyGraphMenu.add(cbmi);
        }
        this.hintPolicyGraphMenu.setMnemonic(80);
        this.graphMenu.add(this.hintPolicyGraphMenu);
        this.confirmDoneGraphMenu = new CheckBoxMenuItem("Confirm Done", this.getController().getProblemModel().getEffectiveConfirmDone());
        this.confirmDoneGraphMenu.setMnemonic(68);
        this.graphMenu.add(this.confirmDoneGraphMenu);
        this.confirmDoneGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean oldSetting = model.getConfirmDone();
                Boolean newSetting = new Boolean(CtatMenuBar.this.confirmDoneGraphMenu.isSelected());
                model.setConfirmDone(newSetting);
                if (oldSetting == null || !oldSetting.equals(newSetting)) {
                    ActionEvent ae = new ActionEvent(this, 0, "Set Confirm Done " + model.getConfirmDone());
                    controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                }
            }
        });
        this.highlightRightSelectionGraphMenu = new CheckBoxMenuItem("Highlight Right Selection", this.currentHighlightRightSelectionProperty());
        this.highlightRightSelectionGraphMenu.setMnemonic(72);
        this.graphMenu.add(this.highlightRightSelectionGraphMenu);
        this.highlightRightSelectionGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setHighlightRightSelection(!model.getHighlightRightSelection());
                ActionEvent ae = new ActionEvent(this, 0, "Set Highlight Right Selection " + model.getHighlightRightSelection());
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.outOfOrderMessageGraphMenu = new MenuItem("Edit Out of Order Message...");
        this.outOfOrderMessageGraphMenu.setMnemonic(79);
        this.graphMenu.add(this.outOfOrderMessageGraphMenu);
        this.outOfOrderMessageGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.doOutOfOrderMessageDialog();
            }
        });
        this.graphMenu.addSeparator();
        this.reviseStartStateFromUIMenu = new MenuItem("Revise Start State with UI");
        this.reviseStartStateFromUIMenu.setMnemonic(83);
        this.graphMenu.add(this.reviseStartStateFromUIMenu);
        this.reviseStartStateFromUIMenu.setToolTipText("Revise Start State with initial settings from the user interface");
        this.reviseStartStateFromUIMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CtatMenuBar.this.reviseStartStateWithSettingsFromUIActionPerformed();
                }
                catch (Exception err) {
                    trace.errStack("error on reviseStartStateFromUIMenu", err);
                }
            }
        });
        this.enableMenuIfInterfaceConnected(this.reviseStartStateFromUIMenu);
        this.cleanupStartStateMenu = new MenuItem("Clean Up Graph...");
        this.cleanupStartStateMenu.setMnemonic(83);
        this.graphMenu.add(this.cleanupStartStateMenu);
        this.cleanupStartStateMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CtatMenuBar.this.cleanupStartStateMenuActionPerformed();
                }
                catch (Exception err) {
                    trace.errStack("error on cleanupStartStateMenu", err);
                }
            }
        });
        this.cleanupStartStateMenu.setEnabled(false);
        this.showUnmatchedComponentsMenu = new MenuItem("Show Unmatched Component References...");
        this.showUnmatchedComponentsMenu.setMnemonic(83);
        this.graphMenu.add(this.showUnmatchedComponentsMenu);
        this.showUnmatchedComponentsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CtatMenuBar.this.showUnmatchedComponentsMenuActionPerformed();
                }
                catch (Exception err) {
                    trace.errStack("error on showUnmatchedComponentsMenu", err);
                }
            }
        });
        this.showUnmatchedComponentsMenu.setEnabled(false);
        this.setWMMenu = new MenuItem("Set WM to Current State");
        this.setWMMenu.addActionListener(this);
        this.checkAllActionsMenu = new MenuItem("Test Cognitive Model on All Steps");
        this.checkAllActionsMenu.setMnemonic(84);
        this.checkAllActionsMenu.setAccelerator(KeyStroke.getKeyStroke(84, ctrlKeyMask));
        this.cognitiveModelMenu.add(this.checkAllActionsMenu);
        this.checkAllActionsMenu.addActionListener(this);
        this.resetLinkColorsMenu = new MenuItem("Reset Link Colors");
        this.resetLinkColorsMenu.setMnemonic(82);
        this.cognitiveModelMenu.add(this.resetLinkColorsMenu);
        this.resetLinkColorsMenu.addActionListener(this);
        this.loadProdRulesMenu = new MenuItem("Load Production Rules");
        this.loadProdRulesMenu.setMnemonic(76);
        this.loadProdRulesMenu.setAccelerator(KeyStroke.getKeyStroke(76, ctrlKeyMask));
        this.cognitiveModelMenu.add(this.loadProdRulesMenu);
        this.cognitiveModelMenu.addSeparator();
        this.setBreakpointsMenu = new MenuItem("Set Breakpoints...");
        this.setBreakpointsMenu.setMnemonic(66);
        this.cognitiveModelMenu.add(this.setBreakpointsMenu);
        this.setBreakpointsMenu.addActionListener(this);
        this.clearBreakpointsMenu = new MenuItem("Clear Breakpoints");
        this.clearBreakpointsMenu.setMnemonic(67);
        this.cognitiveModelMenu.add(this.clearBreakpointsMenu);
        this.clearBreakpointsMenu.addActionListener(this);
        this.resumeBreakpointsMenu = new MenuItem("Resume");
        this.resumeBreakpointsMenu.setMnemonic(83);
        this.cognitiveModelMenu.add(this.resumeBreakpointsMenu);
        this.resumeBreakpointsMenu.addActionListener(this);
        this.saveInstructionsMenu = new MenuItem("Save Instructions");
        this.saveInstructionsMenu.addActionListener(this);
        this.saveInstructionsMenu.setMnemonic(83);
        this.simStMenu.add(this.saveInstructionsMenu);
        this.saveInstructionsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.saveInstructionsMenuActionPerformed();
            }
        });
        this.loadInstructionsMenu = new MenuItem("Load Instructions");
        this.loadInstructionsMenu.addActionListener(this);
        this.loadInstructionsMenu.setMnemonic(76);
        this.simStMenu.add(this.loadInstructionsMenu);
        this.loadInstructionsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.loadInstructionsMenuActionPerformed();
            }
        });
        this.simStMenu.addSeparator();
        this.loadWmeTypesMenu = new MenuItem("Load WME Types");
        this.loadWmeTypesMenu.addActionListener(this);
        this.loadWmeTypesMenu.setMnemonic(87);
        this.simStMenu.add(this.loadWmeTypesMenu);
        this.loadWmeTypesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.loadWmeTypesMenuActionPerformed();
            }
        });
        this.initializeWmesMenu = new MenuItem("Initialize WMEs");
        this.initializeWmesMenu.addActionListener(this);
        this.initializeWmesMenu.setMnemonic(73);
        this.simStMenu.add(this.initializeWmesMenu);
        this.initializeWmesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.initializeWmesMenuActionPerformed();
            }
        });
        this.loadFeaturePredicatesMenu = new MenuItem("Load Feature Predicates");
        this.loadFeaturePredicatesMenu.addActionListener(this);
        this.loadFeaturePredicatesMenu.setMnemonic(70);
        this.simStMenu.add(this.loadFeaturePredicatesMenu);
        this.loadFeaturePredicatesMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.loadFeaturePredicatesMenuActionPerformed();
            }
        });
        this.loadOperatorsMenu = new MenuItem("Load Operators");
        this.loadOperatorsMenu.addActionListener(this);
        this.loadOperatorsMenu.setMnemonic(79);
        this.simStMenu.add(this.loadOperatorsMenu);
        this.loadOperatorsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.loadOperatorsMenuActionPerformed();
            }
        });
        this.simStMenu.addSeparator();
        this.testModelMenu = new MenuItem("Test Current Model on...");
        this.testModelMenu.addActionListener(this);
        this.testModelMenu.setMnemonic(84);
        this.simStMenu.add(this.testModelMenu);
        this.testModelMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.testModelMenuActionPerformed();
            }
        });
        this.preferencesMenu = new MenuItem("Preferences...");
        this.preferencesMenu.setMnemonic(80);
        this.toolsMenu.add(this.preferencesMenu);
        this.preferencesMenu.addActionListener(this);
        JMenu massProduction = new JMenu("Mass Production");
        this.toolsMenu.add(massProduction);
        this.fillMassProduction(massProduction, notReducedToolMode);
        this.newHTMLProjectMenu = new MenuItem("New HTML5 Project ...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/html5icon.png")));
        this.toolsMenu.add(this.newHTMLProjectMenu);
        this.newHTMLProjectMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CTATHTMLProjectWizard wizard = new CTATHTMLProjectWizard(CtatMenuBar.this.getServer().getPreferencesModel(), CtatMenuBar.this.getController(), new String[0]);
                wizard.init();
                wizard.show();
            }
        });
        if (this.isJavaBR(null)) {
            this.newHTMLProjectMenu.setEnabled(false);
        }
        JMenu advancedMenu = new JMenu("Advanced");
        this.collaborationMenu = new MenuItem("Start Collaboration...");
        this.collaborationMenu.setMnemonic(67);
        this.collaborationMenu.addActionListener(this);
        advancedMenu.add(this.collaborationMenu);
        this.collaborationMenu.setEnabled(true);
        this.logConsoleMenu = new MenuItem("Replay from log...");
        this.logConsoleMenu.setMnemonic(82);
        advancedMenu.add(this.logConsoleMenu);
        this.logConsoleMenu.addActionListener(this);
        this.dsExportMenu = new MenuItem("Replay from DataShop export...");
        this.dsExportMenu.setMnemonic(68);
        advancedMenu.add(this.dsExportMenu);
        this.dsExportMenu.addActionListener(this);
        this.startStateSettingsMenu = new MenuItem("Edit Start State Component Settings...");
        this.startStateSettingsMenu.setMnemonic(83);
        advancedMenu.add(this.startStateSettingsMenu);
        this.startStateSettingsMenu.addActionListener(this);
        this.startStateSettingsMenu.setToolTipText("This operation is enabled when a student interface is connected.");
        this.enableMenuIfInterfaceConnected(this.startStateSettingsMenu, this.reviseStartStateFromUIMenu);
        this.toolsMenu.add(advancedMenu);
        this.skillMatrixMenu = new MenuItem("Skill Matrix");
        this.skillMatrixMenu.setMnemonic(83);
        this.windowsMenu.add(this.skillMatrixMenu);
        this.skillMatrixMenu.addActionListener(this);
        this.ruleNamesWindowMenu = new MenuItem("Skill Names");
        this.ruleNamesWindowMenu.setMnemonic(78);
        this.windowsMenu.add(this.ruleNamesWindowMenu);
        this.ruleNamesWindowMenu.addActionListener(this);
        this.windowsMenu.addSeparator();
        JMenuItem defaultView = new JMenuItem("Restore Default View");
        defaultView.setMnemonic(82);
        this.windowsMenu.add(defaultView);
        defaultView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.getServer().restoreDefaultView();
            }
        });
        this.viewPanelMenu = new JMenu("Show Window");
        this.viewPanelMenu.setMnemonic(86);
        this.windowsMenu.add(this.viewPanelMenu);
        this.showWebPageMenuItem = new MenuItem("CTAT Home Page", new ImageIcon(this.getClass().getClassLoader().getResource("pact/help_icon.png")));
        this.showWebPageMenuItem.setMnemonic(72);
        this.helpMenu.add(this.showWebPageMenuItem);
        this.showWebPageMenuItem.addActionListener(this);
        this.showLicenseMenuItem = VersionInformation.getMenuItem();
        if (this.showLicenseMenuItem != null) {
            this.helpMenu.add(this.showLicenseMenuItem);
            this.showLicenseMenuItem.addActionListener(this);
        }
        this.aboutMenu = new MenuItem("About...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/ctat-icon.gif")));
        this.aboutMenu.setMnemonic(65);
        this.helpMenu.add(this.aboutMenu);
        this.aboutMenu.addActionListener(this);
        if (VersionInformation.includesJess()) {
            this.enableJessMenus(true);
        } else {
            this.enableJessMenus(false);
        }
        return this.mbar;
    }

    private void fillFileMenu(JMenu fileMenu, int keyMask, boolean notReducedToolMode) {
        this.debug("fillFileMenu ()");
        this.openInterfaceMenu = new MenuItem("Open Student Interface...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/launch-browser.png")));
        fileMenu.add(this.openInterfaceMenu);
        this.openInterfaceMenu.setAccelerator(KeyStroke.getKeyStroke(73, keyMask));
        this.openInterfaceMenu.setMnemonic(73);
        this.openInterfaceMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CtatMenuBar.this.isJavaBR(null)) {
                    OpenInterfaceDialog.openInterface(CtatMenuBar.this.getServer());
                } else {
                    CtatMenuBar.this.launchHTMLFile();
                }
            }
        });
        this.openInterfaceAsListenerMenu = new MenuItem("Open Student Interface as Listener...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/launch-browser.png")));
        fileMenu.add(this.openInterfaceAsListenerMenu);
        this.openInterfaceAsListenerMenu.setAccelerator(KeyStroke.getKeyStroke(76, keyMask));
        this.openInterfaceAsListenerMenu.setMnemonic(76);
        this.openInterfaceAsListenerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.launchHTMLFileAsListener();
            }
        });
        this.enableOpenInterfaceMenu(null);
        fileMenu.addSeparator();
        JMenu newSubMenu = new JMenu("New");
        fileMenu.add(newSubMenu);
        this.newGraphMenu = new MenuItem("New Graph", new ImageIcon(this.getClass().getClassLoader().getResource("pact/brd.gif")));
        this.newGraphMenu.setAccelerator(KeyStroke.getKeyStroke(78, keyMask));
        this.newGraphMenu.setMnemonic(78);
        newSubMenu.add(this.newGraphMenu);
        this.newGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.newGraphMenuActionPerformed();
            }
        });
        this.newPackageMenu = new MenuItem("New Package...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/file-open.png")));
        this.newPackageMenu.setAccelerator(KeyStroke.getKeyStroke(75, keyMask));
        this.newPackageMenu.setMnemonic(75);
        newSubMenu.add(this.newPackageMenu);
        this.newPackageMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.newPackageMenuActionPerformed();
            }
        });
        this.openGraphMenu = new MenuItem("Open Graph...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/brd.gif")));
        this.openGraphMenu.setAccelerator(KeyStroke.getKeyStroke(79, keyMask));
        this.openGraphMenu.setMnemonic(79);
        fileMenu.add(this.openGraphMenu);
        this.openGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.openGraphMenuActionPerformed();
            }
        });
        this.openRecentGraphMenu = new JMenu("Open Recent");
        fileMenu.add(this.openRecentGraphMenu);
        this.openRecentGraphMenu.setEnabled(false);
        this.fillRecentMenu();
        fileMenu.addSeparator();
        this.closeGraphMenu = new MenuItem("Close Graph");
        this.closeGraphMenu.setAccelerator(KeyStroke.getKeyStroke(87, keyMask));
        this.closeGraphMenu.setMnemonic(87);
        fileMenu.add(this.closeGraphMenu);
        this.closeGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.closeGraphMenuActionPerformed();
            }
        });
        fileMenu.addSeparator();
        this.saveGraphMenu = new MenuItem("Save Graph", new ImageIcon(this.getClass().getClassLoader().getResource("pact/save.png")));
        this.saveGraphMenu.setAccelerator(KeyStroke.getKeyStroke(83, keyMask));
        this.saveGraphMenu.setMnemonic(83);
        this.saveGraphMenu.setEnabled(false);
        fileMenu.add(this.saveGraphMenu);
        this.saveGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CtatMenuBar.this.saveGraphMenuActionPerformed();
                }
                catch (Exception err) {
                    trace.errStack("error on save-graph", err);
                }
            }
        });
        this.saveGraphAsMenu = new MenuItem("Save Graph As...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/save-as.png")));
        this.saveGraphAsMenu.setAccelerator(KeyStroke.getKeyStroke(83, keyMask | 0x40));
        this.saveGraphAsMenu.setMnemonic(83);
        this.saveGraphAsMenu.setEnabled(false);
        fileMenu.add(this.saveGraphAsMenu);
        this.saveGraphAsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CtatMenuBar.this.saveGraphAsMenuActionPerformed();
            }
        });
        if (!this.isJavaBR(null)) {
            this.moodleMaker = new MenuItem("Export ...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/export.png")));
            fileMenu.add(this.moodleMaker);
            this.moodleMaker.addActionListener(this);
        }
        fileMenu.addSeparator();
        this.saveStudentInterfaceMenu = new MenuItem("Save Student Interface...");
        this.saveStudentInterfaceMenu.setMnemonic(85);
        fileMenu.add(this.saveStudentInterfaceMenu);
        this.saveStudentInterfaceMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CtatMenuBar.this.saveStudentInterfaceMenuActionPerformed();
            }
        });
        this.saveStudentInterfaceMenu.setEnabled(false);
        if (notReducedToolMode) {
            fileMenu.addSeparator();
        }
        this.saveJessFactsMenu = new MenuItem("Save Jess Facts");
        if (notReducedToolMode && VersionInformation.includesJess()) {
            this.saveJessFactsMenu.setMnemonic(70);
            this.saveJessFactsMenu.setVisible(true);
            fileMenu.add(this.saveJessFactsMenu);
        }
        this.saveJessTemplatesMenu = new MenuItem("Save Jess Templates");
        if (notReducedToolMode && VersionInformation.includesJess()) {
            this.saveJessTemplatesMenu.setMnemonic(74);
            this.saveJessTemplatesMenu.setVisible(true);
            fileMenu.add(this.saveJessTemplatesMenu);
            fileMenu.addSeparator();
        }
        this.loadRuleNamesMenu = new MenuItem("Load Skill Names/Hints...");
        if (notReducedToolMode) {
            this.loadRuleNamesMenu.setMnemonic(76);
            fileMenu.add(this.loadRuleNamesMenu);
        }
        this.loadRuleNamesMenu.addActionListener(this);
        this.printGraphMenu = new MenuItem("Print Graph...", new ImageIcon(this.getClass().getClassLoader().getResource("pact/print.gif")));
        this.printGraphMenu.setMnemonic(80);
        this.printGraphMenu.addActionListener(this);
        if (notReducedToolMode) {
            this.printGraphMenu.setMnemonic(80);
            fileMenu.add(this.printGraphMenu);
            this.printGraphMenu.setEnabled(false);
            fileMenu.addSeparator();
        }
        this.quitMenu = new MenuItem("Quit");
        this.quitMenu.setMnemonic(81);
        this.quitMenu.setAccelerator(KeyStroke.getKeyStroke(81, keyMask));
        fileMenu.add(this.quitMenu);
        this.quitMenu.addActionListener(this);
    }

    private void fillViewMenu(JMenu viewMenu) {
        this.debug("fillViewMenu ()");
        this.actionLabelsMenu = this.getServer().getPreferencesModel().getBooleanValue("Show Action Labels") != null ? new CheckBoxMenuItem("Show Action Labels", (boolean)this.getServer().getPreferencesModel().getBooleanValue("Show Action Labels")) : new CheckBoxMenuItem("Show Action Labels", this.getController().getShowActionLabels());
        this.actionLabelsMenu.setMnemonic(65);
        viewMenu.add(this.actionLabelsMenu);
        this.actionLabelsMenu.addActionListener(this);
        this.ruleLabelsMenu = this.getServer().getPreferencesModel().getBooleanValue("Show Rule Labels") != null ? new CheckBoxMenuItem("Show Skill Labels", (boolean)this.getServer().getPreferencesModel().getBooleanValue("Show Rule Labels")) : new CheckBoxMenuItem("Show Skill Labels", this.getController().getShowRuleLabels());
        this.ruleLabelsMenu.setMnemonic(83);
        viewMenu.add(this.ruleLabelsMenu);
        this.ruleLabelsMenu.addActionListener(this);
        this.lastCheckLISPLabelsMenu = this.getServer().getPreferencesModel().getBooleanValue("Show Last Cog. Model Check Labels") != null ? new CheckBoxMenuItem("Show Last Cog. Model Check Labels", (boolean)this.getServer().getPreferencesModel().getBooleanValue("Show Last Cog. Model Check Labels")) : new CheckBoxMenuItem("Show Last Cog. Model Check Labels", this.getController().isPreCheckLISPLabelsFlag());
        this.lastCheckLISPLabelsMenu.setMnemonic(76);
        viewMenu.add(this.lastCheckLISPLabelsMenu);
        this.lastCheckLISPLabelsMenu.addActionListener(this);
    }

    private void fillMassProduction(JMenu aMassProduction, Boolean notReducedToolMode) {
        this.debug("fillMassProduction ()");
        this.createProblemsTableMenu = new MenuItem("Create Problems Table...");
        if (notReducedToolMode.booleanValue()) {
            this.createProblemsTableMenu.setMnemonic(67);
            aMassProduction.add(this.createProblemsTableMenu);
        }
        this.createProblemsTableMenu.addActionListener(this);
        this.mergeProblemsMenu = new MenuItem("Merge Problems...");
        if (notReducedToolMode.booleanValue()) {
            this.mergeProblemsMenu.setMnemonic(77);
            aMassProduction.add(this.mergeProblemsMenu);
        }
        this.mergeProblemsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CtatMenuBar.this.mergeProblemsMenuItemActionPerformed();
            }
        });
    }

    public void saveAsBRDTemplateMenuActionPerformed() {
        String targetDir;
        File selectedFile;
        ProblemModel pm = this.getController().getProblemModel();
        if (pm == null) {
            return;
        }
        if (pm.getNodeCount() < 1) {
            JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "There is currently no graph in the Behavior Recorder.", "Warning", 1);
            return;
        }
        if (pm.getProblemName() == null || pm.getProblemName().length() < 1) {
            NodeView vertex = pm.getStartNode().getNodeView();
            pm.setProblemName(vertex.getText());
        }
        if ((selectedFile = DialogUtilities.chooseFile(targetDir = SaveFileDialog.getBrdFileOtherLocation(this.getController()), pm.getProblemName(), (FileFilter)new BrdFilter(), "Save Mass Production Template File", "Save", this.getController())) != null) {
            int ans;
            File chosenFile;
            String problemName = selectedFile.getName();
            String problemFullName = selectedFile.getPath();
            if (trace.getDebugCode("massproduction")) {
                trace.out("massproduction", "problemName " + problemName + ", problemFullName " + problemFullName);
            }
            if (!problemName.endsWith(".brd")) {
                problemName = problemName + ".brd";
                problemFullName = problemFullName + ".brd";
            }
            if ((chosenFile = new File(problemFullName)).exists() && (ans = JOptionPane.showConfirmDialog(this.getServer().getActiveWindow(), "The file already exists. Overwrite?", "File exists", 2)) != 0) {
                return;
            }
            pm.setProblemName(problemName);
            pm.setProblemFullName(problemFullName);
            this.getController().getProblemStateWriter().saveBRDFile(pm.getProblemFullName());
        }
    }

    public void openBRDTemplateActionPerformed() throws FactoryConfigurationError {
        File tempFile;
        int result;
        ProblemModel pm = this.getController().getProblemModel();
        if (pm.getProblemGraph().getNodeCount() > 0 && (result = this.getController().saveCurrentProblemWithUserPrompt(true)) == 2) {
            return;
        }
        BR_Controller controller = this.getController();
        String targetDir = SaveFileDialog.getBrdFileOtherLocation(controller);
        File selectedFile = DialogUtilities.chooseFile(targetDir, new BrdFilter(), "Open Mass Production Template File", "Open", controller);
        if (selectedFile == null) {
            return;
        }
        String problemName = selectedFile.getName();
        if (!problemName.endsWith(".brd")) {
            problemName = problemName + ".brd";
        }
        if (!selectedFile.exists() && !(tempFile = new File(selectedFile.getPath() + ".brd")).exists()) {
            String message = "The file \"" + selectedFile.getName() + "\" does not exist.";
            JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), message, "Warning", 1);
            return;
        }
        this.getController().reset();
        String problemFullName = selectedFile.getPath();
        if (!problemFullName.endsWith(".brd")) {
            problemFullName = problemFullName + ".brd";
        }
        pm.setCourseName("");
        pm.setUnitName("");
        pm.setSectionName("");
        pm.setProblemName(problemName);
        pm.setProblemFullName(problemFullName);
        try {
            this.getController().openBRDFileAndSendStartState(problemFullName, null, null);
            ActionEvent ae = new ActionEvent(this, 0, "Loaded template " + problemFullName);
            this.getController().getUndoPacket().getInitializeAction().actionPerformed(ae);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String parent = selectedFile.getParent();
        if (trace.getDebugCode("massproduction")) {
            trace.out("massproduction", "openBRDTemplateActionPerformed() new BRD File other location = " + parent);
        }
        this.getServer().getPreferencesModel().setStringValue("BRD File other location", parent);
    }

    protected void doFindMenuDialog() {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "doFindMenuDialog()");
        }
        FindMenuDialog findDialog = new FindMenuDialog();
    }

    protected void doOutOfOrderMessageDialog() {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "doOutOfOrderMessageDialog()");
        }
        OutOfOrderMessageDialog ooomDialog = new OutOfOrderMessageDialog();
    }

    private void openGraphMenuActionPerformed() {
        boolean check;
        CTATFileItem aFileItem = LoadFileDialog.doDialog(this.server, true, true);
        if (aFileItem == null) {
            return;
        }
        this.getController().updateStatusPanel(null);
        ArrayList<String> fList = aFileItem.getFileNames();
        for (int i = 0; i < fList.size(); ++i) {
            this.addRecentfile(aFileItem.getDirectory(), fList.get(i));
        }
        ProblemModel openedPM = this.getController().getProblemModel();
        ProblemModel mainPM = this.getController().getProblemModel();
        boolean bl = check = openedPM != null && openedPM.getStartNode() != null && openedPM == mainPM;
        if (check) {
            this.enableCreateStartStateMenus(false);
            this.enableGotoStartStateMenus(true);
            this.enablePrintGraphMenus(true);
            this.enableSaveGraphMenus(true);
        }
    }

    public void switchSimStActivationMenu(CtatModeEvent.SetSimStudentActivationMenuEvent event) {
        boolean b = event.newStatus;
        this.activateMissMenu.setText(b ? "Deactivate Sim. Student" : "Activate Sim. Student");
    }

    public void enableSimStActivationMenu(boolean status) {
        if (VersionInformation.isRunningSimSt()) {
            this.activateMissMenu.setEnabled(status);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        WMEEditor wme;
        String arg = ae.getActionCommand();
        Object source = ae.getSource();
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "MenuBar.actionPerformed() \"" + arg + "\" from " + source.getClass().getSimpleName());
        }
        this.getServer().getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", arg, "", "", (Object)"");
        if (trace.getDebugCode("undo")) {
            trace.out("undo", "CtatMenuBar.actionPerformed(" + arg + ")");
        }
        if ("AuthorModeComboBox changed".equals(arg)) {
            this.enableMenuIfInterfaceConnected(this.startStateSettingsMenu, this.reviseStartStateFromUIMenu);
            return;
        }
        if (source == this.printGraphMenu) {
            this.printGraphActionPerformed();
        }
        if (source == this.newProblemMenu) {
            // empty if block
        }
        if (source == this.loadProdRulesMenu) {
            this.loadProdRulesMenuActionPerformed();
        }
        if (source == this.setBreakpointsMenu) {
            this.setBreakpointMenuActionPerformed();
        }
        if (source == this.clearBreakpointsMenu) {
            this.clearBreakpointMenuActionPerformed();
        }
        if (source == this.resumeBreakpointsMenu) {
            this.resumeBreakpointMenuActionPerformed();
        }
        if (source == this.saveInstructionsMenu) {
            // empty if block
        }
        if (source == this.loadInstructionsMenu) {
            // empty if block
        }
        if (source == this.quitMenu) {
            this.quitMenuActionPerformed();
        }
        if (source == this.loadRuleNamesMenu) {
            this.loadRulesMenuActionPerformed();
        }
        if (source == this.createProblemsTableMenu) {
            this.createEmptyExcelConfigurationMenuItemActionPerformed();
        }
        if (source == this.saveJessFactsMenu) {
            if (this.getController().getCtatModeModel().isExampleTracingMode()) {
                JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "You are in Example Tracing Mode. There are no Jess facts to save.");
            } else {
                wme = this.getController().getModelTracer().getWmeEditor();
                wme.saveFacts();
            }
        }
        if (source == this.saveJessTemplatesMenu) {
            if (this.getController().getCtatModeModel().isExampleTracingMode()) {
                JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "You are in Example Tracing Mode. There are no Jess templates to save.");
            } else {
                wme = this.getController().getModelTracer().getWmeEditor();
                wme.saveTemplates(true);
            }
        }
        if (source == this.ruleNamesWindowMenu) {
            this.ruleNamesWindowMenuActionPerformed();
        }
        if (source == this.actionLabelsMenu) {
            this.actionLabelsMenuActionPerformed();
        }
        if (source == this.lastCheckLISPLabelsMenu) {
            this.lastLISPCheckLabelsMenuActionPerformed();
        }
        if (source == this.ruleLabelsMenu) {
            this.ruleLabelsMenuActionPerformed();
        }
        if (source == this.setWMMenu) {
            this.setWMMenuActionPerformed();
        }
        if (source == this.checkAllActionsMenu) {
            this.checkAllActionsMenuActionPerformed();
        }
        if (source == this.resetLinkColorsMenu) {
            this.resetLinkColorsMenuActionPerformed();
        }
        if (source == this.activateMissMenu) {
            this.activateMissMenuActionPerformed();
        }
        if (source == this.reviseStartStateFromUIMenu) {
            this.reviseStartStateWithSettingsFromUIActionPerformed();
        }
        if (source == this.cleanupStartStateMenu) {
            this.cleanupStartStateMenuActionPerformed();
        }
        if (source == this.showUnmatchedComponentsMenu) {
            this.showUnmatchedComponentsMenuActionPerformed();
        }
        if (source == this.createStartStateMenu) {
            this.createStartStateMenuActionPerformed();
        }
        if (source == this.preferencesMenu) {
            this.preferencesMenuActionPerformed();
        }
        if (source == this.collaborationMenu) {
            this.collaborationMenuActionPerformed();
        }
        if (source == this.logConsoleMenu) {
            this.logConsoleMenuActionPerformed();
        }
        if (source == this.dsExportMenu) {
            this.dsExportMenuActionPerformed();
        }
        if (source == this.moodleMaker) {
            CTATLMSPackageWizard wizard = new CTATLMSPackageWizard(this.getController());
            wizard.init();
            wizard.show();
        }
        if (source == this.showWebPageMenuItem) {
            this.invokeBrowserForWebPage(ae);
        }
        if (source == this.showLicenseMenuItem) {
            this.invokeBrowserForWebPage(ae);
        }
        if (source == this.nextModeMenu) {
            this.nextModeMenuActionPerformed();
        }
        if (source == this.skillMatrixMenu) {
            this.skillMatrixMenuActionPerformed();
        }
        if (source == this.goToStartStateMenu) {
            this.goToStartStateMenuActionPerformed();
        }
        if (source == this.startStateSettingsMenu) {
            this.compareComponentSettingsMenuActionPerformed();
        }
        if (source == this.retractOneStepMenu) {
            this.retractOneStepMenuActionPerformed();
        }
        if (source == this.nextPreferredStepMenu) {
            this.nextPreferredStepMenuActionPerformed();
        }
        if (source == this.aboutMenu) {
            this.aboutMenuActionPerformed();
        }
    }

    private void showUnmatchedComponentsMenuActionPerformed() {
        UniversalToolProxy utp = this.getController().getUniversalToolProxy();
        UnmatchedSelectionsDialog launcher = null;
        boolean hasDialog = false;
        if (utp == null || (launcher = utp.getUnmatchedSelectionsDialogLauncher()) == null || !(hasDialog = utp.getUnmatchedSelectionsDialogLauncher().hasDialog())) {
            trace.err("CtatMenuBar.findObsoleteComponentsMenuActionPerformed() cannot invoke dialog utp " + trace.nh(utp) + ", launcher " + trace.nh(launcher) + ", hasDialog " + hasDialog);
            return;
        }
        launcher.launch();
    }

    private void reviseStartStateWithSettingsFromUIActionPerformed() {
        UniversalToolProxy utp = null;
        if (this.getController() == null || (utp = this.getController().getUniversalToolProxy()) == null) {
            trace.err("CtatMenuBar.reviseStartStateMsgsWithUIActionPerformed(): null getController() " + this.getController() + " or .getUniversalToolProxy() " + utp);
            return;
        }
        int okCancel = JOptionPane.showConfirmDialog(this.getController().getCtatFrameController().getDockedFrame(), "Replace start state settings saved in the graph with settings from the user interface?", "Revise start state from interface", 2);
        if (okCancel != 0) {
            return;
        }
        utp.getStartStateModel().reviseWithSettingsFromUI(this.getController().getProblemModel(), "Revised start state from interface");
        this.getController().goToStartState(true, true);
        JOptionPane.showMessageDialog(this.getController().getCtatFrameController().getDockedFrame(), "Revised start state in graph with initial settings from user interface.", "Revised start state", 1);
    }

    private void cleanupStartStateMenuActionPerformed() {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "CtatMenuBar.cleanupStartStateMenuActionPerformed()");
        }
        UniversalToolProxy utp = null;
        if (this.getController() == null || (utp = this.getController().getUniversalToolProxy()) == null) {
            trace.err("CtatMenuBar.cleanupStartStateMenuActionPerformed(): null getController() " + this.getController() + " or .getUniversalToolProxy() " + utp);
            return;
        }
        int nToDelete = utp.getStartStateModel().pruneInterfaceDescriptions(this.getController().getProblemModel(), false);
        if (nToDelete < 1) {
            JOptionPane.showMessageDialog(this.getController().getCtatFrameController().getDockedFrame(), "Found no unneeded items in the graph to delete.", "Clean Up Already Complete", 1);
            return;
        }
        int okCancel = JOptionPane.showConfirmDialog(this.getController().getCtatFrameController().getDockedFrame(), "This graph contains information that is not editable but may no longer be useful; \r\nthe extra information can make the tutor slow to start up. Clean up will remove this \r\nunneeded information from the graph and then jump to the start state.  Continue?", "Clean Up Graph", 2);
        if (okCancel != 0) {
            return;
        }
        int nDeleted = utp.getStartStateModel().pruneInterfaceDescriptions(this.getController().getProblemModel(), true);
        if (nDeleted > 0) {
            ActionEvent ae = new ActionEvent(this, 0, "Clean up start state");
            this.getController().getUndoPacket().getCheckpointAction().actionPerformed(ae);
        }
        if (nDeleted != nToDelete) {
            trace.err("CtatMenuBar.cleanupStartStateMenuActionPerformed() nToDelete " + nToDelete + " != nDeleted " + nDeleted);
        }
        this.getController().goToStartState(true, true);
        JOptionPane.showMessageDialog(this.getController().getCtatFrameController().getDockedFrame(), "Clean up removed " + nDeleted + " unneeded items from the graph.", "Clean Up Completed", 1);
    }

    private void collaborationMenuActionPerformed() {
        if (this.collaborationMenu.getText().toLowerCase().startsWith("start")) {
            int teamSize = -1;
            String prompt0 = "Please enter the total number of\nstudents on the collaborating team:";
            String prompt = "Please enter the total number of\nstudents on the collaborating team:";
            Object entry = "2";
            do {
                if ((entry = JOptionPane.showInputDialog(this.getController().getCtatFrameController().getDockedFrame(), prompt, "Enter collaboration team size", 3, null, null, entry)) == null) {
                    return;
                }
                try {
                    teamSize = Integer.parseInt(entry.toString().trim());
                    if (teamSize < 2) {
                        throw new IllegalArgumentException("teamSize " + teamSize + " must be > 1");
                    }
                    if (!trace.getDebugCode("collab")) continue;
                    trace.out("collab", "teamSize " + teamSize);
                }
                catch (Exception e) {
                    trace.err("CtatMenuBar.collaborationMenuActionPerformed(): invalid teamSize " + entry + ": " + e + "; cause " + e.getCause());
                    prompt = "The team size must be an integer\ngreater than 1. Click Cancel to quit.";
                }
            } while (teamSize < 2);
            this.getController().getLauncher().getLauncherServer().startAuthorTimeCollaboration(teamSize);
            this.collaborationMenu.setText("Stop Collaboration");
        } else {
            this.getController().getLauncher().getLauncherServer().stopAuthorTimeCollaboration();
            this.collaborationMenu.setText("Start Collaboration...");
        }
    }

    private void compareComponentSettingsMenuActionPerformed() {
        CtatModeModel cmm = this.getController().getCtatModeModel();
        if (cmm != null && !"Set Start State".equalsIgnoreCase(cmm.getCurrentAuthorMode())) {
            cmm.setAuthorMode("Set Start State");
        }
        EditComponentStartStateSettingsDialog.create(this.getController(), this.getServer().getActiveWindow());
    }

    private void logConsoleMenuActionPerformed() {
        LogConsole.createConsole(this.getController());
    }

    private void dsExportMenuActionPerformed() {
        trace.out("replay", "Menu Action Performed");
        LogConsoleReplay.createConsole(this.getController() == null ? new BR_Controller() : this.getController());
    }

    private void aboutMenuActionPerformed() {
        PersonnelInfo.showAboutBox(this.getServer().getActiveWindow());
    }

    private void goToStartStateMenuActionPerformed() {
        this.getServer().getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "GO_TO_START_STATE", "", "", (Object)"");
        this.getController().goToStartState(true, true);
    }

    private void retractOneStepMenuActionPerformed() {
        BR_Controller controller = this.getController();
        controller.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", RETRACT_LAST_STEP, "", "", (Object)"");
        controller.getProcessTraversedLinks().retractLinksFromTail(1);
    }

    private void previousPreferredStateActionPerformed() {
        this.getServer().getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", PREVIOUS_PREFERRED_STATE, "", "", (Object)"");
        BR_Controller controller = this.getController();
        if (controller == null || controller.getCurrentNode() == null) {
            return;
        }
        controller.MoveToPrevStepOnPreferredPath(this.getController().getCurrentNode());
    }

    private void nextPreferredStepMenuActionPerformed() {
        BR_Controller controller = this.getController();
        ProblemNode currentNode = controller.getCurrentNode();
        controller.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", NEXT_PREFERRED_STEP, currentNode == null ? "null" : currentNode.toString(), "", (Object)"");
        if (currentNode == null) {
            return;
        }
        controller.MoveToNextStepOnPreferredPath();
    }

    private void skillMatrixMenuActionPerformed() {
        SkillMatrixDialog.doDialog(this.getController());
    }

    private void nextModeMenuActionPerformed() {
        this.getController().nextMode();
    }

    private void createLMSFiles(ActionEvent ae) {
        CreateLMSFilesDialog c = new CreateLMSFilesDialog();
    }

    private void invokeBrowserForWebPage(ActionEvent evt) {
        String licenseWebPage = VersionInformation.getWebPage();
        if (evt.getSource() == this.showLicenseMenuItem && licenseWebPage != null) {
            LaunchCTATWebsite.showWebPage(licenseWebPage);
        } else {
            LaunchCTATWebsite.showWebPage("https://github.com/CMUCTAT/CTAT/wiki");
        }
    }

    private void preferencesMenuActionPerformed() {
        try {
            PreferencesModel model = this.getServer().getPreferencesModel();
            PreferencesWindow.create(model, this.getServer()).setVisible(true);
        }
        catch (Exception eSetPreferences) {
            eSetPreferences.printStackTrace();
        }
    }

    void createStartStateMenuActionPerformed() {
        this.getController().getCtatFrameController().getDockedFrame().getCtatModePanel().createStartState();
    }

    private void activateMissMenuActionPerformed() {
        this.getController().activateMissController(this.getController().getCtatModeModel().isSimStudentMode());
    }

    private void resetLinkColorsMenuActionPerformed() {
        Enumeration<ProblemEdge> iter = this.getController().getProblemModel().getProblemGraph().edges();
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            tempMyEdge.setCheckedStatus("Never Checked");
            tempMyEdge.getPreLispCheckLabel().resetAll(tempMyEdge.getUniqueID(), "Never Checked");
            this.getController().setFirstCheckAllStatesFlag(true);
        }
    }

    private void checkAllActionsMenuActionPerformed() {
        if (!this.checkValidGraph()) {
            return;
        }
        Vector ESEGraph = new Vector();
        BR_Controller controller = this.getController();
        trace.out("mg", "CtatMenuBar (checkAllActionsMenuActionPerformed): on tab " + controller.getTabNumber());
        ProblemModel model = controller.getProblemModel();
        model.setCheckAllNodes(new Vector());
        controller.setSendESEGraphFlag(false);
        controller.sendBehaviorRecorderGraphToLisp(ESEGraph, model.getStartNode(), 0);
        model.setCheckAllNodes(new Vector());
    }

    private void setWMMenuActionPerformed() {
        if (this.getController().getSolutionState().getCurrentNode() != this.getController().getProblemModel().getStartNode()) {
            this.getController().checkProductionRulesChainNew(this.getController().getSolutionState().getCurrentNode());
        }
    }

    private void ruleLabelsMenuActionPerformed() {
        this.getController().setShowRuleLabels(!this.getController().getShowRuleLabels());
        this.getServer().getPreferencesModel().setBooleanValue("Show Rule Labels", new Boolean(this.getController().getShowRuleLabels()));
        this.getServer().getPreferencesModel().saveToDisk();
        this.getController().getJGraphWindow().getJGraph().repaint();
    }

    private void lastLISPCheckLabelsMenuActionPerformed() {
        this.getController().setPreCheckLISPLabelsFlag(!this.getController().isPreCheckLISPLabelsFlag());
        Enumeration<ProblemEdge> iter = this.getController().getProblemModel().getProblemGraph().edges();
        while (iter.hasMoreElements()) {
            ProblemEdge tempEdge = iter.nextElement();
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            tempMyEdge.getPreLispCheckLabel().setVisible(this.getController().isPreCheckLISPLabelsFlag());
        }
        this.getServer().getPreferencesModel().setBooleanValue("Show Last Cog. Model Check Labels", new Boolean(this.getController().isPreCheckLISPLabelsFlag()));
        this.getServer().getPreferencesModel().saveToDisk();
        this.getController().getJGraphWindow().getJGraph().repaint();
    }

    private void actionLabelsMenuActionPerformed() {
        BR_Controller controller;
        controller.setShowActionLabels(!(controller = this.getController()).getShowActionLabels());
        this.getServer().getPreferencesModel().setBooleanValue("Show Action Labels", new Boolean(controller.getShowActionLabels()));
        this.getServer().getPreferencesModel().saveToDisk();
        controller.getJGraphWindow().getJGraph().repaint();
    }

    private void ruleNamesWindowMenuActionPerformed() {
        RuleNamesDisplayDialog ruleDisplayDialog = this.getController().getRuleDisplayDialog();
        ruleDisplayDialog.setVisible(true);
        ruleDisplayDialog.resetRuleProductionList(true);
    }

    private void mergeProblemsMenuItemActionPerformed() {
        new MergeMassProductionDialog(this.getController());
    }

    private void createEmptyExcelConfigurationMenuItemActionPerformed() {
        new CreateProblemsTableDialog(this.getController());
    }

    private void quitMenuActionPerformed() {
        this.getController().closeApplication(true);
    }

    public boolean quitHandlerForMac() {
        this.quitMenuActionPerformed();
        return false;
    }

    private void newGraphMenuActionPerformed() {
        DockManager docker = this.getServer().getCtatFrameController().getDockManager();
        if (docker != null) {
            VariableViewer varViewer;
            View testView;
            int tabNumber = docker.newGraphTab();
            if (tabNumber > 0) {
                docker.showGraphWindow(tabNumber);
            }
            if ((testView = docker.getCoreView("Variable Viewer")) != null && (varViewer = (VariableViewer)testView.getComponent()) != null) {
                varViewer.reset();
            }
        }
        this.enableCreateStartStateMenus(true);
        this.enableGotoStartStateMenus(false);
        this.enablePrintGraphMenus(false);
        this.enableSaveGraphMenus(false);
        this.getController().updateStatusPanel(null);
    }

    private void newPackageMenuActionPerformed() {
        CTATHTMLProjectWizard t = new CTATHTMLProjectWizard(this.getServer().getPreferencesModel(), this.getController(), "New Package");
        t.init();
        t.show();
    }

    private void closeGraphMenuActionPerformed() {
        if (2 == this.getController().cancelOrSaveCurrentProblemWithUserPrompt()) {
            return;
        }
        try {
            this.getServer().getTabManager().getFocusedTab().closeTab();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getController().startNewProblem(null);
        this.enableCreateStartStateMenus(true);
        this.enableGotoStartStateMenus(false);
        this.enablePrintGraphMenus(false);
        this.enableSaveGraphMenus(false);
        this.getController().updateStatusPanel(null);
        DockManager docker = this.getServer().getCtatFrameController().getDockManager();
        if (docker != null) {
            VariableViewer varViewer;
            try {
                int tabNumber = this.getServer().getTabManager().getFocusedTab().getTabNumber();
                this.getServer().getTabManager().getTabByNumber(tabNumber).getView().closeWithAbort();
            }
            catch (OperationAbortedException e) {
                e.printStackTrace();
            }
            View testView = docker.getCoreView("Variable Viewer");
            if (testView != null && (varViewer = (VariableViewer)testView.getComponent()) != null) {
                varViewer.reset();
            }
        }
    }

    public void launchHTMLFile(String aFile) {
        trace.out("launchHTMLFile (String)");
        CTATTab htmlTargetTab = this.getServer().getTabManager().getFocusedTab();
        if (htmlTargetTab != null) {
            if (htmlTargetTab.getController() != null) {
                htmlTargetTab.getController().disconnect(false);
            }
            htmlTargetTab.setTargetHTMLFile(new File(aFile));
            htmlTargetTab.launchHTMLPage();
        }
    }

    private void launchHTMLFileAsListener() {
        CTATTab htmlTargetTab = this.getServer().getTabManager().getFocusedTab();
        if (htmlTargetTab == null) {
            this.newGraphMenuActionPerformed();
            htmlTargetTab = this.getServer().getTabManager().getFocusedTab();
        } else if (htmlTargetTab.getController() != null) {
            htmlTargetTab.getController().disconnect(false);
        }
        new LaunchInterfaceAsListenerDialog(htmlTargetTab);
    }

    private void launchHTMLFile() {
        trace.out("launchHTMLFile ()");
        String targetDir = this.getServer().getPreferencesModel().getStringValue("Interface Directory");
        if (targetDir == null) {
            trace.out("No previous interface directory available, let's try the workspace directory");
            targetDir = this.getServer().getPreferencesModel().getStringValue("workspace");
            if (targetDir == null) {
                trace.out("no workspace defined yet, use user's home directory");
                targetDir = System.getProperty("user.home");
            }
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("HTML (.html, .htm)", "html", "htm");
        File myFilename = null;
        do {
            if (myFilename != null) {
                JOptionPane.showMessageDialog(this.getController().getActiveWindow(), "File not found or not readable:\n" + myFilename, "File not found", 2);
            }
            if (null == (myFilename = DialogUtilities.chooseFile(targetDir, myFilename == null ? null : myFilename.toString(), (FileFilter)filter, "Open HTML Student Interface", "Open", this.getController()))) {
                return;
            }
            File parent = myFilename.getParentFile();
            if (parent == null || !parent.isDirectory()) continue;
            targetDir = parent.getPath();
        } while (!myFilename.isFile() || !myFilename.canRead());
        CTATTab htmlTargetTab = this.getServer().getTabManager().getFocusedTab();
        if (htmlTargetTab != null) {
            if (htmlTargetTab.getController() != null) {
                htmlTargetTab.getController().disconnect(false);
            }
            htmlTargetTab.setTargetHTMLFile(myFilename);
            this.getServer().getPreferencesModel().setStringValue("Interface Directory", targetDir);
            htmlTargetTab.launchHTMLPage();
        }
    }

    private void printGraphActionPerformed() {
        PrintUtilities.printComponent(this.getController().getJGraphWindow());
    }

    private void newProblemMenuActionPerformed() {
        trace.out("New Problem...");
    }

    private void loadProdRulesMenuActionPerformed() {
        this.getController().getModelTracer().reloadProductionRulesFile();
    }

    private void setBreakpointMenuActionPerformed() {
        this.getController().getRuleActivationTree().displayBreakPointsPanel();
    }

    private void clearBreakpointMenuActionPerformed() {
        this.getController().getRuleActivationTree().getBreakPointRules().clear();
    }

    private void resumeBreakpointMenuActionPerformed() {
        this.getController().getModelTracer().setResume(true);
    }

    private void saveInstructionsMenuActionPerformed() {
        this.getController().getMissController().saveInstructions();
    }

    private void loadInstructionsMenuActionPerformed() {
        this.getController().getMissController().loadInstructions();
    }

    private void loadWmeTypesMenuActionPerformed() {
        this.getController().getMissController().setSimStWmeTypeFile();
    }

    private void initializeWmesMenuActionPerformed() {
        this.getController().getMissController().setSimStInitStateFile();
    }

    private void loadFeaturePredicatesMenuActionPerformed() {
        this.getController().getMissController().readSimStPredicateSymbols();
    }

    private void loadOperatorsMenuActionPerformed() {
        this.getController().getMissController().readSimStOperators();
    }

    private void testModelMenuActionPerformed() {
        this.getController().getMissController().testProductionModelOn();
    }

    private void saveGraphAsMenuActionPerformed() {
        BR_Controller controller = this.getController();
        ProblemModel probMod = controller.getProblemModel();
        if (probMod.getProblemName().length() == 0) {
            if (probMod.getStartNode() == null) {
                JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "There is currently no graph in the Behavior Recorder.", "Warning", 1);
                return;
            }
            NodeView Vertex = probMod.getStartNode().getNodeView();
            probMod.setProblemName(Vertex.getText());
        }
        SaveFileDialog.doDialog(controller, probMod.getProblemName());
        this.getController().updateStatusPanel(probMod.getProblemFullName());
        File converter = new File(controller.getProblemModel().getProblemFullName());
        this.addRecentfile(converter.getParent(), converter.getName());
    }

    private void saveStudentInterfaceMenuActionPerformed() {
        File chosenFile;
        int overwrite;
        String fileName = this.getController().getLauncher().getSessionId();
        if (fileName.endsWith(".swf")) {
            fileName = fileName.substring(0, fileName.length() - 4) + ".sui";
        }
        String dirName = SaveFileDialog.getBrdDirectoryToSuggest(this.getController());
        do {
            if ((chosenFile = DialogUtilities.chooseFile(dirName, fileName, (FileFilter)new SuiFilter(), "Please set the file name", "Save", this.getController())) == null) {
                return;
            }
            if (!chosenFile.exists()) break;
            overwrite = JOptionPane.showConfirmDialog(this.getController().getCtatFrameController().getDockedFrame(), "File " + chosenFile.getPath() + " already exists. Overwrite?", "Overwrite student interface", 1, 2);
            if (overwrite == 2) {
                return;
            }
            dirName = chosenFile.getParent();
        } while (overwrite == 1);
        try {
            UniversalToolProxy utp = this.getController().getUniversalToolProxy();
            utp.saveStudentInterfaceFile(chosenFile);
        }
        catch (Exception e) {
            String errMsg = "Error saving student interface to " + chosenFile.getPath();
            trace.errStack(errMsg, e);
            Utils.showExceptionOccuredDialog(e, errMsg, "Error saving student interface");
        }
    }

    private void loadRulesMenuActionPerformed() {
        BR_Controller controller = this.getController();
        File fi = new File(SaveFileDialog.getProjectsDirectory(controller));
        if (!fi.exists()) {
            JOptionPane.showMessageDialog(this.getController().getActiveWindow(), "No problem is defined.", "Notice", 1);
        } else {
            new LoadProductionRulesDialog(controller);
        }
    }

    private void saveGraphMenuActionPerformed() {
        this.debug("saveGraphMenuActionPerformed()");
        BR_Controller controller = this.getController();
        ProblemModel probMod = controller.getProblemModel();
        System.out.println("probMod is named " + probMod.getProblemName() + ", " + probMod.getProblemFullName());
        if (probMod.getProblemFullName().length() == 0) {
            this.debug("if A");
            if (probMod.getStartNode() == null) {
                JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "There is currently no graph in the Behavior Recorder.", "Warning", 1);
                return;
            }
            NodeView Vertex = probMod.getStartNode().getNodeView();
            SaveFileDialog.doDialog(controller, Vertex.getText());
            controller.updateStatusPanel(probMod.getProblemFullName());
            File converter = new File(controller.getProblemModel().getProblemFullName());
            this.addRecentfile(converter.getParent(), converter.getName());
            return;
        }
        if (controller.isShowTTSave() && !controller.getCtatFrameController().getDockedFrame().getTutorTypeLabel().equals(controller.getCtatModeModel().getCurrentMode())) {
            this.debug("if B");
            JCheckBox checkbox = new JCheckBox("Do not show this message again.");
            Object[] params = new Object[]{"If you save you will change the tutor type of this brd. Are you sure you want to save?", checkbox};
            int value = JOptionPane.showConfirmDialog(null, params, "Save Confirmation", 0);
            boolean dontShow = checkbox.isSelected();
            if (trace.getDebugCode("eep")) {
                trace.out("eep", "saveBRDandNotifyTT:checkbox=" + dontShow + ",resp=" + value);
            }
            if (dontShow) {
                this.getController().setShowTTSave(false);
            }
            if (value != 0) {
                return;
            }
        }
        if (probMod.getProblemFullName() != null && !probMod.getProblemFullName().equals("")) {
            this.debug("if C");
            controller.saveBRDSilently();
            File converter = new File(controller.getProblemModel().getProblemFullName());
            this.addRecentfile(converter.getParent(), converter.getName());
            return;
        }
        trace.out(5, this, "No file is saved.");
    }

    public void applyPreferences() {
        Boolean showLastCogModelCheckLabels;
        Boolean showRuleLabels;
        Boolean showActionLabels = this.getServer().getPreferencesModel().getBooleanValue("Action Labels");
        if (showActionLabels != null) {
            this.getController().setShowActionLabels(showActionLabels);
            trace.out("action label menu = " + this.actionLabelsMenu);
            this.actionLabelsMenu.setSelected(showActionLabels);
        }
        if ((showRuleLabels = this.getServer().getPreferencesModel().getBooleanValue("Rule Labels")) != null) {
            this.getController().setShowRuleLabels(showRuleLabels);
            this.ruleLabelsMenu.setSelected(showRuleLabels);
        }
        if ((showLastCogModelCheckLabels = this.getServer().getPreferencesModel().getBooleanValue("Last Cog. Model Check Labels")) != null) {
            this.getController().setPreCheckLISPLabelsFlag(showLastCogModelCheckLabels);
            this.lastCheckLISPLabelsMenu.setSelected(showLastCogModelCheckLabels);
        }
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        trace.out(5, this, "window closed");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this.getController().getStudentInterface()) {
            if (!(e.getSource() instanceof TutorWindow) || this.getController().getAuthorToolsVisible()) {
                this.getController().closeStudentInterface();
                this.enableInterfaceMenus(true);
            }
            this.enableOpenInterfaceMenu(Boolean.TRUE);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public boolean checkValidGraph() {
        if (this.getController().getProblemModel().getStartNode() == null) {
            JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "Please first create or load your graph.", "Warning", 2);
            return false;
        }
        if (this.getController().getProblemModel().getProblemGraph().degree(this.getController().getProblemModel().getStartNode()) <= 0) {
            JOptionPane.showMessageDialog(this.getServer().getActiveWindow(), "Please create links to the graph.", "Warning", 2);
            return false;
        }
        return true;
    }

    public JMenu getViewPanelMenu() {
        return this.viewPanelMenu;
    }

    private boolean currentCaseSensitivityProperty() {
        ProblemModel model = this.getController().getProblemModel();
        boolean property = model != null ? !model.isCaseInsensitive() : this.getServer().getPreferencesModel().getBooleanValue("Case Sensitive");
        return property;
    }

    private boolean currentLockWidgetProperty() {
        ProblemModel model = this.getController().getProblemModel();
        boolean property = model != null ? model.isLockWidget() : this.getServer().getPreferencesModel().getBooleanValue("Lock Widgets").booleanValue();
        return property;
    }

    private FeedbackEnum currentSuppressFeedbackProperty() {
        ProblemModel model = this.getController().getProblemModel();
        FeedbackEnum property = model != null ? model.getSuppressStudentFeedback() : (FeedbackEnum)this.getServer().getPreferencesModel().getEnumValue("suppressStudentFeedback");
        return property;
    }

    private HintPolicyEnum currentHintBiasProperty() {
        return this.getController().getProblemModel().getHintPolicy();
    }

    private boolean currentHighlightRightSelectionProperty() {
        ProblemModel model = this.getController().getProblemModel();
        boolean property = model != null ? model.getHighlightRightSelection() : this.getServer().getPreferencesModel().getBooleanValue("Highlight Right Widget").booleanValue();
        return property;
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent event) {
        ProblemModel pm = this.getController().getProblemModel();
        this.problemModelEventOccurred(pm, event);
    }

    public void problemModelEventOccurred(ProblemModel pm, ProblemModelEvent event) {
        this.caseSensitiveGraphMenu.setSelected(!pm.isCaseInsensitive());
        this.lockWidgetsGraphMenu.setSelected(pm.isLockWidget());
        this.highlightRightSelectionGraphMenu.setSelected(pm.getHighlightRightSelection());
        FeedbackEnum currentFe = this.currentSuppressFeedbackProperty();
        for (Component c : this.suppressFeedbackGraphMenu.getMenuComponents()) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)c;
            cbmi.setSelected(cbmi.getText().equals(currentFe.toString()));
        }
        HintPolicyEnum currentHbe = this.currentHintBiasProperty();
        for (Component c : this.hintPolicyGraphMenu.getMenuComponents()) {
            JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)c;
            cbmi.setSelected(cbmi.getText().equals(currentHbe.toString()));
        }
        this.confirmDoneGraphMenu.setSelected(pm.getEffectiveConfirmDone());
    }

    public boolean isJavaBR(Boolean b) {
        boolean enable = b != null ? b : true;
        return enable &= this.getServer().getTabManager() != null && this.getController() != null && this.getController().isStudentInterfaceLocal();
    }

    public boolean enableOpenInterfaceMenu(Boolean b) {
        boolean enable = this.isJavaBR(b);
        if (trace.getDebugCode("menu")) {
            trace.printStack("menu", String.format("enableOpenInterfaceMenu b %s, tabMgr %s, ctlr %s, SUI local %b, enable %b", b, this.getServer().getTabManager(), this.getController(), this.getController().isStudentInterfaceLocal(), enable));
        }
        if (enable) {
            this.openInterfaceMenu.setText("Open Student Interface...");
        } else {
            this.openInterfaceMenu.setText("Launch HTML Interface ...");
            this.openInterfaceAsListenerMenu.setText("Launch HTML Interface as Listener ...");
        }
        return enable;
    }

    public void windowRestored(DockingWindow window) {
        if (window == this.lastRestored) {
            return;
        }
        String title = window.getTitle();
        JMenu vm = this.getViewPanelMenu();
        if (this.dynamicViewCount <= 0 && !this.dynamicViewHasClosed) {
            this.dynamicWindowSeparator = new JSeparator();
            vm.add(this.dynamicWindowSeparator);
            this.dynamicWindowMap = new HashMap<JMenuItem, DockingWindow>();
        }
        JMenuItem mitem = new JMenuItem(title);
        mitem.setActionCommand(DYNAMIC_WINDOW_COMMAND);
        this.dynamicWindowMap.put(mitem, window);
        mitem.addActionListener(this);
        vm.add(mitem);
        ++this.dynamicViewCount;
        this.lastRestored = window;
    }

    public void windowClosed(DockingWindow window) {
        if (window == this.lastClosed) {
            return;
        }
        if (!this.dynamicViewHasClosed) {
            this.dynamicViewHasClosed = true;
        }
        if (this.dynamicWindowMap != null) {
            JMenuItem closedMenuItem = null;
            for (Map.Entry<JMenuItem, DockingWindow> ent : this.dynamicWindowMap.entrySet()) {
                if (ent.getValue() != window) continue;
                closedMenuItem = ent.getKey();
                break;
            }
            if (closedMenuItem != null) {
                this.dynamicWindowMap.remove(closedMenuItem);
                this.getViewPanelMenu().remove(closedMenuItem);
                this.lastClosed = window;
                --this.dynamicViewCount;
                if (this.dynamicViewCount <= 0) {
                    this.getViewPanelMenu().remove(this.dynamicWindowSeparator);
                }
            }
        }
    }

    private void fillRecentMenu() {
        this.debug("fillRecentMenu ()");
        String data = this.getServer().getPreferencesModel().getStringValue("RecentFiles");
        if (data == null) {
            this.debug("We don't have any recent file structure on disk yet");
            return;
        }
        this.debug("Recent files: " + data);
        this.openRecentGraphMenu.removeAll();
        String[] lines = data.split("!");
        if (lines.length > 0) {
            this.openRecentGraphMenu.setEnabled(true);
        }
        for (int i = 0; i < lines.length; ++i) {
            this.debug("Processing recent file item: " + lines[i]);
            String[] splitter = lines[i].split("\\|");
            if (splitter.length > 1) {
                this.debug("Path: " + splitter[0] + ", file: " + splitter[1]);
                CTATFileItem aFileItem = new CTATFileItem();
                aFileItem.setDirectory(splitter[0]);
                aFileItem.setFileName(splitter[1]);
                JMenuItem menuItem = new JMenuItem(i + 1 + " " + aFileItem.getFileName());
                aFileItem.setVisual(menuItem);
                menuItem.setToolTipText(aFileItem.getDirectory() + aFileItem.getFileName());
                this.openRecentGraphMenu.add(menuItem);
                this.recentFiles.add(aFileItem);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem targetItem = (JMenuItem)e.getSource();
                        CtatMenuBar.this.loadRecent(targetItem);
                    }
                });
                continue;
            }
            this.debug("Error: entry in recent file list is corrupted!");
        }
    }

    public void addRecentfile(String aPath, String aFile) {
        this.debug("addRecentfile (" + aPath + "," + aFile + ")");
        if (aFile.isEmpty()) {
            this.debug("Info: the provided file name is empty");
            return;
        }
        CTATFileItem aFileItem = new CTATFileItem();
        aFileItem.setDirectory(aPath + File.separator);
        aFileItem.setFileName(aFile);
        if (this.hasDuplicate(aFileItem).booleanValue()) {
            return;
        }
        this.storeRecentFile(aFileItem);
        this.recentFiles.add(0, aFileItem);
        if (this.recentFiles.size() > this.maxRecentFiles) {
            this.recentFiles.remove(this.recentFiles.size() - 1);
        }
        this.populateRecentFilesMenu();
    }

    private Boolean hasDuplicate(CTATFileItem anItem) {
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            CTATFileItem testItem = this.recentFiles.get(i);
            if (!testItem.getDirectory().equals(anItem.getDirectory()) || !testItem.getFileName().equals(anItem.getFileName())) continue;
            return true;
        }
        return false;
    }

    public void loadGraph(File testItem) {
        this.debug("loadGraph (" + testItem.getAbsolutePath() + ")");
        ProblemModel pm = this.getController().getProblemModel();
        this.debug("Opening: " + testItem.getPath() + testItem.getName());
        LoadFileDialog.doLoadBRDFile(this.getServer(), testItem.getName(), testItem.getParent() + File.separator, false);
        if (pm != null && pm.getStartNode() != null) {
            this.enableCreateStartStateMenus(false);
            this.enableGotoStartStateMenus(true);
            this.enablePrintGraphMenus(true);
            this.enableSaveGraphMenus(true);
        }
    }

    private void loadRecent(JMenuItem anItem) {
        this.debug("loadRecent (" + this.recentFiles.size() + ")");
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            CTATFileItem testItem = this.recentFiles.get(i);
            if (testItem.getVisual() == null) {
                this.debug("Internal error: recent file item doesn't have a corresponding menu item!");
                continue;
            }
            if (testItem.getVisual() != anItem) continue;
            ProblemModel pm = this.getController().getProblemModel();
            File formatter = new File(testItem.getDirectory() + File.separator + testItem.getFileName());
            this.debug("Opening: " + formatter.getAbsolutePath() + " ...");
            LoadFileDialog.doLoadBRDFile(this.getServer(), testItem.getFileName(), testItem.getDirectory() + File.separator, false);
            this.recentFiles.remove(testItem);
            this.recentFiles.add(0, testItem);
            this.storeRecentFiles();
            this.populateRecentFilesMenu();
            pm = this.getController().getProblemModel();
            if (pm != null && pm.getStartNode() != null) {
                this.enableCreateStartStateMenus(false);
                this.enableGotoStartStateMenus(true);
                this.enablePrintGraphMenus(true);
                this.enableSaveGraphMenus(true);
            }
            return;
        }
    }

    private void storeRecentFile(CTATFileItem aFileItem) {
        StringBuffer recentFileBuffer = new StringBuffer();
        recentFileBuffer.append(aFileItem.getDirectory() + "|" + aFileItem.getFileName());
        for (int j = 0; j < this.recentFiles.size(); ++j) {
            recentFileBuffer.append("!");
            CTATFileItem testFileItem = this.recentFiles.get(j);
            recentFileBuffer.append(testFileItem.getDirectory() + "|" + testFileItem.getFileName());
        }
        this.getServer().getPreferencesModel().setStringValue("RecentFiles", recentFileBuffer.toString());
        this.getServer().getPreferencesModel().saveToDisk();
    }

    private void storeRecentFiles() {
        StringBuffer recentFileBuffer = new StringBuffer();
        for (int j = 0; j < this.recentFiles.size(); ++j) {
            if (j > 0) {
                recentFileBuffer.append("!");
            }
            CTATFileItem testFileItem = this.recentFiles.get(j);
            recentFileBuffer.append(testFileItem.getDirectory() + "|" + testFileItem.getFileName());
        }
        this.getServer().getPreferencesModel().setStringValue("RecentFiles", recentFileBuffer.toString());
        this.getServer().getPreferencesModel().saveToDisk();
    }

    private void populateRecentFilesMenu() {
        this.debug("populateRecentFilesMenu ()");
        this.openRecentGraphMenu.removeAll();
        if (this.recentFiles.size() > 0) {
            this.openRecentGraphMenu.setEnabled(true);
        }
        for (int j = 0; j < this.recentFiles.size(); ++j) {
            CTATFileItem aFileItem = this.recentFiles.get(j);
            JMenuItem menuItem = new JMenuItem(j + 1 + " " + aFileItem.getFileName());
            aFileItem.setVisual(menuItem);
            menuItem.setToolTipText(aFileItem.getDirectory() + aFileItem.getFileName());
            this.openRecentGraphMenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem targetItem = (JMenuItem)e.getSource();
                    CtatMenuBar.this.loadRecent(targetItem);
                }
            });
        }
    }

    private CTAT_Launcher getServer() {
        return this.server;
    }

    private BR_Controller getController() {
        return this.getServer().getFocusedController();
    }

    public void refreshGraphDependentItems() {
        final BR_Controller controller = this.getController();
        final ProblemModel model = controller.getProblemModel();
        JUndo.JAbstractUndoPacket undoPacket = controller.getUndoPacket();
        this.undoMenu.setAction(undoPacket.getUndoAction());
        this.redoMenu.setAction(undoPacket.getRedoAction());
        this.actionLabelsMenu.setEnabled(true);
        this.actionLabelsMenu.setSelected(controller.getShowActionLabels());
        this.ruleLabelsMenu.setEnabled(true);
        this.ruleLabelsMenu.setSelected(controller.getShowRuleLabels());
        this.lastCheckLISPLabelsMenu.setEnabled(true);
        this.lastCheckLISPLabelsMenu.setSelected(controller.isPreCheckLISPLabelsFlag());
        this.copyLinksMenu.setEnabled(this.hasLinks());
        this.pasteLinksMenu.setEnabled(controller.getProblemModelManager().nSelectedLinks() > 0);
        for (ActionListener actionListener : this.copyLinksMenu.getActionListeners()) {
            this.copyLinksMenu.removeActionListener(actionListener);
        }
        this.copyLinksMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                trace.out("mg", "CtatMenuBar (copyLinksMenu.actionPerformed): HERE");
                if (controller.copySelectedLinks() > 0) {
                    CtatMenuBar.this.pasteLinksMenu.setEnabled(true);
                }
            }
        });
        for (ActionListener actionListener : this.pasteLinksMenu.getActionListeners()) {
            this.pasteLinksMenu.removeActionListener(actionListener);
        }
        this.pasteLinksMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                trace.out("mg", "CtatMenuBar (pasteLinksMenu.actionPerformed): HERE");
                controller.pasteLinks();
                CtatMenuBar.this.copyLinksMenu.setEnabled(CtatMenuBar.this.hasLinks());
                ActionEvent ae = new ActionEvent(this, 0, "Paste Links");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.caseSensitiveGraphMenu.setSelected(model.isCaseInsensitive());
        for (ActionListener actionListener : this.caseSensitiveGraphMenu.getActionListeners()) {
            this.caseSensitiveGraphMenu.removeActionListener(actionListener);
        }
        this.caseSensitiveGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setCaseInsensitive(!model.isCaseInsensitive());
                ActionEvent ae = new ActionEvent(this, 0, "Set Case " + (model.isCaseInsensitive() ? "Ins" : "S") + "ensitive Matching");
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.lockWidgetsGraphMenu.setSelected(controller.getProblemModel().getLockWidget());
        for (ActionListener actionListener : this.lockWidgetsGraphMenu.getActionListeners()) {
            this.lockWidgetsGraphMenu.removeActionListener(actionListener);
        }
        this.lockWidgetsGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setLockWidget(!model.isLockWidget());
                ActionEvent ae = new ActionEvent(this, 0, (model.isLockWidget() ? "Lock" : "Unlock") + " Widgets on Correct Action");
                CtatMenuBar.this.getController().getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        int numFeedbackOptions = this.suppressFeedbackGraphMenu.getItemCount();
        for (int i = 0; i < numFeedbackOptions; ++i) {
            JCheckBoxMenuItem cb = (JCheckBoxMenuItem)this.suppressFeedbackGraphMenu.getItem(i);
            cb.setSelected(cb.getText().equals(this.currentSuppressFeedbackProperty().toString()));
            for (ActionListener al : cb.getActionListeners()) {
                cb.removeActionListener(al);
            }
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackEnum oldSetting = model.getSuppressStudentFeedback();
                    FeedbackEnum choice = FeedbackEnum.fromString(e.getActionCommand());
                    model.setSuppressStudentFeedback(choice);
                    for (Component c : CtatMenuBar.this.suppressFeedbackGraphMenu.getMenuComponents()) {
                        JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)c;
                        cbmi.setSelected(cbmi.getText().equals(e.getActionCommand()));
                    }
                    if (oldSetting == null || !oldSetting.equals((Object)choice)) {
                        ActionEvent ae = new ActionEvent(this, 0, "Set Feedback Policy " + choice.toString());
                        controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                    }
                }
            });
        }
        int numHintPolicies = this.hintPolicyGraphMenu.getItemCount();
        for (int i = 0; i < numHintPolicies; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.hintPolicyGraphMenu.getItem(i);
            jCheckBoxMenuItem.setSelected(jCheckBoxMenuItem.getText().equals(this.currentHintBiasProperty().toString()));
            for (ActionListener al : jCheckBoxMenuItem.getActionListeners()) {
                jCheckBoxMenuItem.removeActionListener(al);
            }
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HintPolicyEnum oldSetting = model.getHintPolicy();
                    HintPolicyEnum choice = HintPolicyEnum.fromString(e.getActionCommand());
                    model.setHintPolicy(choice);
                    for (Component c : CtatMenuBar.this.hintPolicyGraphMenu.getMenuComponents()) {
                        JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)c;
                        cbmi.setSelected(cbmi.getText().equals(e.getActionCommand()));
                    }
                    if (oldSetting == null || !oldSetting.equals((Object)choice)) {
                        ActionEvent ae = new ActionEvent(this, 0, "Set Hint Policy " + choice.toString());
                        controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                    }
                }
            });
        }
        this.confirmDoneGraphMenu.setSelected(model.getEffectiveConfirmDone());
        for (ActionListener al : this.confirmDoneGraphMenu.getActionListeners()) {
            this.confirmDoneGraphMenu.removeActionListener(al);
        }
        this.confirmDoneGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean oldSetting = model.getConfirmDone();
                Boolean newSetting = new Boolean(CtatMenuBar.this.confirmDoneGraphMenu.isSelected());
                model.setConfirmDone(newSetting);
                if (oldSetting == null || !oldSetting.equals(newSetting)) {
                    ActionEvent ae = new ActionEvent(this, 0, "Set Confirm Done " + model.getConfirmDone());
                    controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
                }
            }
        });
        this.highlightRightSelectionGraphMenu.setSelected(model.getHighlightRightSelection());
        for (ActionListener al : this.highlightRightSelectionGraphMenu.getActionListeners()) {
            this.highlightRightSelectionGraphMenu.removeActionListener(al);
        }
        this.highlightRightSelectionGraphMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setHighlightRightSelection(!model.getHighlightRightSelection());
                ActionEvent ae = new ActionEvent(this, 0, "Set Highlight Right Selection " + model.getHighlightRightSelection());
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        });
        this.cleanupStartStateMenu.setEnabled(this.graphHasCleanUpToDo());
        this.updateUnmatchedComponents();
    }

    private boolean hasLinks() {
        ProblemModel pm;
        BR_Controller ctlr = this.getController();
        ProblemModel problemModel = pm = ctlr == null ? null : ctlr.getProblemModel();
        if (pm != null && pm.getProblemGraph() != null) {
            return pm.getProblemGraph().hasEdges();
        }
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableMenuIfInterfaceConnected(this.startStateSettingsMenu, this.reviseStartStateFromUIMenu);
        this.updateUnmatchedComponents();
        if (!(e.getSource() instanceof UniversalToolProxy)) {
            return;
        }
        UniversalToolProxy utp = (UniversalToolProxy)e.getSource();
        if (utp.getStudentInterfaceConnectionStatus().isConnected() && "HTML & Flash".equals(utp.getStudentInterfacePlatform())) {
            utp.removeStartStateListener(this);
            utp.addStartStateListener(this);
        } else {
            this.saveStudentInterfaceMenu.setEnabled(false);
        }
    }

    private boolean updateUnmatchedComponents() {
        UniversalToolProxy utp = this.getController().getUniversalToolProxy();
        if (utp == null) {
            return false;
        }
        boolean enable = utp.enableObsoleteSeletionDialog();
        this.showUnmatchedComponentsMenu.setEnabled(enable);
        this.getServer().getCtatFrameController().getDockedFrame().updateUnmatchedSelections(enable);
        return enable;
    }

    @Override
    public void startStateReceived(EventObject evt) {
        this.saveStudentInterfaceMenu.setEnabled(true);
    }

    private void revertCurrentGraph() {
        trace.out("mg", "revertCurrentGraph ()");
        CTATTab focusedTab = this.server.getTabManager().getFocusedTab();
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to discard your changes and reload the file from disk?", "Revert File Confirm", 0);
        if (n == 0) {
            trace.out("mg", "Reverting ... " + n);
            this.getServer().getTabManager().getFocusedTab().closeTab();
        }
    }

    private class OutOfOrderMessageDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 770478628430255130L;
        ProblemModel pm;
        JTextArea entry;
        JButton ok;
        JButton cancel;

        OutOfOrderMessageDialog() {
            super((Frame)CtatMenuBar.this.getServer().getActiveWindow(), true);
            this.pm = CtatMenuBar.this.getController().getProblemModel();
            this.setName("OutOfOrderMessageDialog");
            this.setTitle("Edit \"Out Of Order\" Message");
            this.setLayout(new BorderLayout());
            this.setDefaultCloseOperation(2);
            JLabel prompt = new JLabel("Enter the feedback message to display when a step is correct but out of order.");
            prompt.setBorder(new EmptyBorder(4, 4, 2, 4));
            prompt.setMaximumSize(prompt.getPreferredSize());
            prompt.setMinimumSize(prompt.getPreferredSize());
            this.add((Component)prompt, "North");
            this.entry = new JTextArea(2, 40);
            this.entry.setName("OutOfOrderMessage");
            this.entry.setFont(new Font("Monospaced", 0, 12));
            this.entry.setWrapStyleWord(true);
            this.entry.setText(this.pm.getOutOfOrderMessage());
            JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.entry);
            this.entry.setMinimumSize(this.entry.getPreferredSize());
            JScrollPane entryPane = new JScrollPane(this.entry);
            entryPane.setHorizontalScrollBarPolicy(32);
            entryPane.setVerticalScrollBarPolicy(22);
            entryPane.setBorder(new EmptyBorder(2, 4, 2, 4));
            this.add((Component)entryPane, "Center");
            this.ok = new JButton("OK");
            this.ok.setName("OutOfOrderMessageDialogOK");
            this.ok.addActionListener(this);
            this.cancel = new JButton("Cancel");
            this.ok.setName("OutOfOrderMessageDialogCancel");
            this.cancel.addActionListener(this);
            Box btnPanel = new Box(0);
            btnPanel.add(this.ok);
            btnPanel.add(this.cancel);
            btnPanel.setBorder(new EmptyBorder(2, 4, 4, 4));
            btnPanel.setMaximumSize(btnPanel.getPreferredSize());
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "prefSize: ok " + this.ok.getPreferredSize() + ", cancel " + this.cancel.getPreferredSize() + ", btnPanel" + btnPanel.getPreferredSize());
            }
            this.add((Component)btnPanel, "South");
            this.getContentPane().validate();
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "PrefSize: contentPane " + this.getContentPane().getPreferredSize() + ", entryPane " + entryPane.getPreferredSize() + ", entry " + this.entry.getPreferredSize() + ", prompt " + prompt.getPreferredSize());
            }
            Dimension initSize = this.getContentPane().getPreferredSize();
            this.setSize(new Dimension(initSize.width + 36, initSize.height + 54));
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == this.ok) {
                String oldText = this.pm.getOutOfOrderMessage();
                String newText = this.entry.getText();
                this.pm.setOutOfOrderMessage(newText);
                if (oldText == null || !oldText.equals(newText)) {
                    ActionEvent ae = new ActionEvent(this, 0, "Edit Out of Order Message");
                    CtatMenuBar.this.getController().getUndoPacket().getCheckpointAction().actionPerformed(ae);
                }
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private class FindResultsDialog
    extends JDialog
    implements ActionListener {
        JButton ok;

        public void centerOn(Point p) {
            int halfOfScreen = 383;
            double left = p.getX() - 383.0 > 0.0 ? p.getX() - 383.0 : 0.0;
            double right = p.getX() + 383.0;
            double top = p.getY() - 383.0 > 0.0 ? p.getY() - 383.0 : 0.0;
            double bottom = p.getY() + 383.0;
            if (trace.getDebugCode("find")) {
                trace.out("find", "FindResultDialog.centerOn(" + p + ") left " + left + ", right " + right + ", top " + top + ", bottom " + bottom);
            }
            Point topLeft = new Point();
            topLeft.setLocation(left, top);
            Point topRight = new Point();
            topRight.setLocation(right, top);
            Point bottomLeft = new Point();
            bottomLeft.setLocation(left, bottom);
            Point bottomRight = new Point();
            bottomRight.setLocation(right, bottom);
            CtatMenuBar.this.getController().getJGraphWindow().getJGraph().scrollPointToVisible(topLeft);
            CtatMenuBar.this.getController().getJGraphWindow().getJGraph().scrollPointToVisible(topRight);
            CtatMenuBar.this.getController().getJGraphWindow().getJGraph().scrollPointToVisible(bottomLeft);
            CtatMenuBar.this.getController().getJGraphWindow().getJGraph().scrollPointToVisible(bottomRight);
        }

        FindResultsDialog(HashMap<String, ProblemNode> nodeResults, HashMap<String, ProblemEdge> edgeResults) {
            Serializable result;
            super((Frame)CtatMenuBar.this.getServer().getActiveWindow(), false);
            this.setName("FindResultsDialog");
            this.setLayout(new BorderLayout());
            this.setDefaultCloseOperation(2);
            int count = 0;
            Box resultsPanel = new Box(1);
            resultsPanel.setBorder(new EmptyBorder(2, 4, 4, 4));
            String[] keys = nodeResults.keySet().toArray(new String[0]);
            Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
            if (keys.length > 0) {
                JLabel jLabel = new JLabel("States");
                resultsPanel.add(jLabel);
            }
            for (String key : keys) {
                ++count;
                result = nodeResults.get(key);
                final Point finalLoc = ((ProblemNode)result).getNodeView().getCenterPoint();
                JButton button = new JButton(key);
                button.setMinimumSize(button.getPreferredSize());
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindResultsDialog.this.centerOn(finalLoc);
                    }
                });
                resultsPanel.add(button);
            }
            keys = edgeResults.keySet().toArray(new String[0]);
            Arrays.sort(keys, String.CASE_INSENSITIVE_ORDER);
            if (keys.length > 0) {
                if (count > 0) {
                    JSeparator jSeparator = new JSeparator();
                    resultsPanel.add(jSeparator);
                }
                JLabel jLabel = new JLabel("Links");
                resultsPanel.add(jLabel);
            }
            for (String key : keys) {
                ++count;
                result = edgeResults.get(key);
                ProblemNode[] connections = ((ProblemEdge)result).getNodes();
                Point parent = connections[0].getNodeView().getCenterPoint();
                Point child = connections[1].getNodeView().getCenterPoint();
                final Point finalLoc = new Point();
                finalLoc.setLocation((parent.getX() + child.getX()) / 2.0, (parent.getY() + child.getY()) / 2.0);
                JButton button = new JButton(key);
                button.setMinimumSize(button.getPreferredSize());
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FindResultsDialog.this.centerOn(finalLoc);
                    }
                });
                resultsPanel.add(button);
            }
            JScrollPane jScrollPane = new JScrollPane(resultsPanel);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setBorder(new EmptyBorder(2, 4, 2, 4));
            this.add((Component)jScrollPane, "Center");
            this.ok = new JButton("OK");
            this.ok.setName("FindResultsDialogOK");
            this.ok.addActionListener(this);
            this.getRootPane().setDefaultButton(this.ok);
            this.add((Component)this.ok, "South");
            this.setTitle("Find Results (" + Integer.toString(count) + " matches found)");
            Dimension initSize = this.getContentPane().getPreferredSize();
            this.setSize(new Dimension(initSize.width + 200, initSize.height + 25));
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private class FindChangeSearched
    extends JDialog
    implements ActionListener {
        Box list;
        final HashSet<JCheckBox> boxes;
        JButton cancel;
        JButton ok;

        FindChangeSearched(final HashSet<String> searchSet) {
            super((Frame)CtatMenuBar.this.getServer().getActiveWindow(), true);
            this.setName("FindChangeSearched");
            this.setTitle("Change searched fields");
            this.setLayout(new BorderLayout());
            this.setDefaultCloseOperation(2);
            this.boxes = new HashSet();
            this.list = new Box(1);
            this.list.setBorder(new EmptyBorder(10, 4, 4, 0));
            final JCheckBox selectAll = new JCheckBox("Select all", true);
            this.list.add(selectAll);
            for (final String field : JFind.searchableFields) {
                final JCheckBox check = new JCheckBox(field, true);
                this.boxes.add(check);
                check.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (check.isSelected()) {
                            searchSet.add(field);
                        } else {
                            searchSet.remove(field);
                        }
                    }
                });
                this.list.add(check);
            }
            selectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean selected = selectAll.isSelected();
                    if (selected) {
                        searchSet.addAll(JFind.searchableFields);
                    } else {
                        searchSet.clear();
                    }
                    for (JCheckBox check : FindChangeSearched.this.boxes) {
                        check.setSelected(selected);
                    }
                }
            });
            JScrollPane listScroller = new JScrollPane(this.list);
            this.add((Component)listScroller, "Center");
            this.ok = new JButton("OK");
            this.ok.setName("FindChangeSearchOK");
            this.ok.addActionListener(this);
            this.getRootPane().setDefaultButton(this.ok);
            this.cancel = new JButton("Cancel");
            this.cancel.setName("FindChangeSearchCancel");
            this.cancel.addActionListener(this);
            Box btnPanel = new Box(0);
            btnPanel.add(this.cancel);
            btnPanel.add(this.ok);
            btnPanel.setBorder(new EmptyBorder(2, 4, 4, 4));
            this.add((Component)btnPanel, "South");
            this.getContentPane().validate();
            Dimension initSize = this.getContentPane().getPreferredSize();
            this.setSize(new Dimension(initSize.width + 36, initSize.height + 54));
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private class FindMenuDialog
    extends JDialog
    implements ActionListener {
        ProblemGraph pg;
        JTextField entry;
        Box entryPanel;
        Box optionPanel;
        final JButton find;
        final JButton cancel;
        final JButton search;
        final HashSet<String> searchSet;
        JCheckBox regex;
        JCheckBox caseInsensitive;

        FindMenuDialog() {
            super((Frame)CtatMenuBar.this.getServer().getActiveWindow(), true);
            this.pg = CtatMenuBar.this.getController().getProblemModel().getProblemGraph();
            this.setName("FindMenuDialog");
            this.setTitle("Find");
            this.setLayout(new BorderLayout());
            this.setDefaultCloseOperation(2);
            this.entry = new JTextField(30);
            this.entry.setAlignmentX(0.0f);
            this.entry.setName("findString");
            this.entry.setFont(new Font("Monospaced", 0, 12));
            this.entry.setMinimumSize(this.entry.getPreferredSize());
            this.entry.setMaximumSize(this.entry.getPreferredSize());
            this.entryPanel = new Box(1);
            this.entryPanel.setBorder(new EmptyBorder(10, 4, 4, 0));
            this.entryPanel.add(this.entry);
            this.add((Component)this.entryPanel, "North");
            this.searchSet = new HashSet<String>(JFind.searchableFields);
            this.search = new JButton("Change searched fields");
            this.search.setName("FindMenuDialogChange");
            this.search.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindChangeSearched findChangeSearched = new FindChangeSearched(FindMenuDialog.this.searchSet);
                }
            });
            this.search.setMinimumSize(this.search.getPreferredSize());
            this.search.setMaximumSize(this.search.getPreferredSize());
            this.regex = new JCheckBox("Search using regular expression?");
            this.caseInsensitive = new JCheckBox("Search using case insensitivity?");
            this.optionPanel = new Box(1);
            this.optionPanel.setBorder(new EmptyBorder(10, 4, 4, 0));
            this.optionPanel.add(this.search);
            this.optionPanel.add(this.regex);
            this.optionPanel.add(this.caseInsensitive);
            this.add((Component)this.optionPanel, "Center");
            this.find = new JButton("Find");
            this.find.setName("FindMenuDialogFind");
            this.find.addActionListener(this);
            this.getRootPane().setDefaultButton(this.find);
            this.cancel = new JButton("Cancel");
            this.cancel.setName("FindMenuDialogCancel");
            this.cancel.addActionListener(this);
            Box btnPanel = new Box(0);
            btnPanel.add(this.cancel);
            btnPanel.add(this.find);
            btnPanel.setBorder(new EmptyBorder(0, 4, 4, 4));
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "prefSize: find " + this.find.getPreferredSize() + ", cancel " + this.cancel.getPreferredSize() + ", btnPanel" + btnPanel.getPreferredSize());
            }
            this.add((Component)btnPanel, "South");
            this.getContentPane().validate();
            Dimension initSize = this.getContentPane().getPreferredSize();
            this.setSize(new Dimension(initSize.width, initSize.height + 54));
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.find) {
                int flags = this.caseInsensitive.isSelected() ? 2 : 0;
                Pattern findStr = this.regex.isSelected() ? Pattern.compile(".*" + this.entry.getText() + ".*", flags) : Pattern.compile(".*" + Pattern.quote(this.entry.getText()) + ".*", flags);
                if (this.entry.getText().length() > 0) {
                    HashMap<String, ProblemNode> nodeResults = JFind.nodeMatches(this.pg, findStr, this.searchSet);
                    HashMap<String, ProblemEdge> edgeResults = JFind.edgeMatches(this.pg, findStr, this.searchSet);
                    this.setVisible(false);
                    FindResultsDialog findResultsDialog = new FindResultsDialog(nodeResults, edgeResults);
                } else {
                    return;
                }
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public class CheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 201405152100L;

        CheckBoxMenuItem(String text, boolean state) {
            super(text, state);
            this.storeInTabs();
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "new CheckBoxMenuItem after stored in tab: " + this);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getText());
            sb.append('@').append(this.hashCode());
            sb.append(", ").append(super.isEnabled() ? "enabled" : "disabled");
            sb.append(", ").append(super.isSelected() ? "checked" : "unchecked");
            return sb.append("]").toString();
        }

        public String toString(boolean[] values) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getText());
            sb.append('@').append(this.hashCode());
            sb.append(", ").append(values[0] ? "enabled" : "disabled");
            sb.append(", ").append(values[1] ? "checked" : "unchecked");
            return sb.append("]").toString();
        }

        private void storeInTabs() {
            boolean[] values = this.makeValues();
            CtatMenuBar.this.server.getTabManager().addCtatMenuItem(this, values);
        }

        private boolean[] makeValues() {
            return new boolean[]{super.isEnabled(), super.getState()};
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean[] values = this.getValues();
            values[0] = enabled;
            super.setEnabled(enabled);
            this.saveValues(values);
        }

        @Override
        public void setSelected(boolean state) {
            boolean[] values = this.getValues();
            values[1] = state;
            super.setSelected(state);
            this.saveValues(values);
        }

        private boolean[] getValues() {
            boolean[] values = CtatMenuBar.this.server.getTabManager().getFocusedTab().getCtatMenuItemValues(this);
            if (values == null) {
                values = this.makeValues();
                if (trace.getDebugCode("menu")) {
                    trace.out("menu", "CtatMenuBar.CheckBoxMenuItem.getValues() no entry for menu item " + this + "; creating one with values " + values[0] + "," + values[1]);
                }
                this.saveValues(values);
            }
            return values;
        }

        private void saveValues(boolean[] values) {
            CtatMenuBar.this.server.getTabManager().getFocusedTab().setCtatMenuItemValues(this, values);
        }

        public void setValues(boolean[] values) {
            super.setEnabled(values[0]);
            super.setSelected(values[1]);
            if (trace.getDebugCode("menu")) {
                trace.printStack("menu", "CheckBoxMenuItem.setValues(" + this.toString(values) + ") state now " + this);
            }
        }
    }

    public class MenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 201405152100L;

        MenuItem(Action action) {
            super(action);
            this.storeInTabs();
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "new MenuItem after stored in tab: " + this);
            }
        }

        MenuItem(Action action, ImageIcon icon) {
            super(action);
            this.setIcon(icon);
            this.storeInTabs();
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "new MenuItem after stored in tab: " + this);
            }
        }

        MenuItem(String name) {
            super(name);
            this.storeInTabs();
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "new MenuItem after stored in tab: " + this);
            }
        }

        MenuItem(String name, ImageIcon icon) {
            super(name, icon);
            this.storeInTabs();
            if (trace.getDebugCode("menu")) {
                trace.out("menu", "new MenuItem after stored in tab: " + this);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getText());
            sb.append('@').append(this.hashCode());
            sb.append(", ").append(super.isEnabled() ? "enabled" : "disabled");
            return sb.append("]").toString();
        }

        public String toString(boolean[] values) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getText());
            sb.append('@').append(this.hashCode());
            sb.append(", ").append(values[0] ? "enabled" : "disabled");
            return sb.append("]").toString();
        }

        private void storeInTabs() {
            boolean[] values = this.makeValues();
            CtatMenuBar.this.server.getTabManager().addCtatMenuItem(this, values);
        }

        private boolean[] makeValues() {
            return new boolean[]{super.isEnabled(), false};
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean[] values = this.getValues();
            super.setEnabled(enabled);
            if (trace.getDebugCode("menu")) {
                trace.printStack("menu", "CMB.MenuItem[tab #" + CtatMenuBar.this.server.getTabManager().getFocusedTab().getTabNumber() + "].setEnabled(" + enabled + ") saved values were " + this.toString(values) + ", state now " + this);
            }
            values[0] = enabled;
            this.saveValues(values);
        }

        private boolean[] getValues() {
            boolean[] values = CtatMenuBar.this.server.getTabManager().getFocusedTab().getCtatMenuItemValues(this);
            if (values == null) {
                values = this.makeValues();
                if (trace.getDebugCode("menu")) {
                    trace.out("menu", "CtatMenuBar.MenuItem.getValues() no entry for menu item " + this + "; creating one with value " + values[0]);
                }
                this.saveValues(values);
            }
            return values;
        }

        private void saveValues(boolean[] values) {
            CtatMenuBar.this.server.getTabManager().getFocusedTab().setCtatMenuItemValues(this, values);
        }

        public void setValues(boolean[] values) {
            super.setEnabled(values[0]);
            if (trace.getDebugCode("menu")) {
                trace.printStack("menu", "MenuItem[tab #" + CtatMenuBar.this.server.getTabManager().getFocusedTab().getTabNumber() + "].setValues(" + this.toString(values) + ") state now " + this);
            }
        }
    }
}

