/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Utilities.VersionInfoGenerator;
import java.io.File;
import javax.swing.JMenuItem;

public class VersionInformation {
    public static String RELEASE_NAME = "CTAT 4.4.0";
    public static String VERSION_NUMBER = "20170914-1757";
    public static String BUILD_DATE = "14 September 2017";
    private static VersionInfoGenerator.LicenseType licenseType = VersionInfoGenerator.LicenseType.academic;
    private static Boolean lastJessResult = null;
    private static boolean runningSimSt = false;

    public static String getReleaseString() {
        return RELEASE_NAME + ", " + VERSION_NUMBER + ", " + BUILD_DATE;
    }

    public static void main(String[] args) {
        System.out.println(VersionInformation.getReleaseString());
    }

    public static boolean includesCL() {
        return licenseType == VersionInfoGenerator.LicenseType.internal;
    }

    public static boolean includesSimSt() {
        return licenseType == VersionInfoGenerator.LicenseType.internal;
    }

    public static boolean includesJess() {
        boolean result;
        if (lastJessResult != null) {
            return lastJessResult;
        }
        try {
            Class<?> cls = Class.forName("jess.Rete");
            result = cls.newInstance() != null;
        }
        catch (NoClassDefFoundError ncdfe) {
            result = false;
        }
        catch (ClassNotFoundException cnfe) {
            result = false;
        }
        catch (Throwable t) {
            result = licenseType != VersionInfoGenerator.LicenseType.commercial;
        }
        lastJessResult = new Boolean(result);
        return result;
    }

    public static boolean isRunningSimSt() {
        return runningSimSt && VersionInformation.includesSimSt();
    }

    public static void setRunningSimSt(boolean b) {
        runningSimSt = b;
    }

    public static String getWebPage() {
        return "file:///" + VersionInformation.currentDir() + "CTAT academic license.html";
    }

    public static JMenuItem getMenuItem() {
        return new JMenuItem("CTAT License");
    }

    public static String getFileReferenceString() {
        return "License: " + VersionInformation.currentDir() + "CTAT academic license.html.<br><br>";
    }

    private static String currentDir() {
        String result = System.getProperty("user.dir");
        if (result == null || result.length() < 1) {
            return "";
        }
        return result + File.separator;
    }
}

