/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class StringTokenizerItemValues {
    private StringTokenizer stringTokenizer;
    private char delim;
    private char predelim;
    private String str;

    public StringTokenizerItemValues(String str, char delim, char predelim) {
        this(str, delim, predelim, false);
    }

    public StringTokenizerItemValues(String str, char delim, char predelim, boolean returnDelims) {
        this.stringTokenizer = new StringTokenizer(str, "" + delim, returnDelims);
        this.delim = delim;
        this.predelim = predelim;
        this.str = str;
    }

    public boolean hasMoreTokens() {
        return this.stringTokenizer.hasMoreTokens();
    }

    public String nextToken() throws NoSuchElementException {
        String currentToken = this.stringTokenizer.nextToken();
        StringBuffer nextTokenBuffer = new StringBuffer(currentToken);
        boolean flag = this.isDelimInToken(currentToken);
        while (flag && this.stringTokenizer.hasMoreTokens()) {
            nextTokenBuffer.deleteCharAt(nextTokenBuffer.length() - 1);
            nextTokenBuffer.append(this.delim);
            currentToken = this.stringTokenizer.nextToken();
            nextTokenBuffer.append(currentToken);
            flag = this.isDelimInToken(currentToken);
        }
        if (flag) {
            nextTokenBuffer.deleteCharAt(nextTokenBuffer.length() - 1);
            nextTokenBuffer.append(this.delim);
        }
        return nextTokenBuffer.toString();
    }

    private boolean isDelimInToken(String currentToken) {
        int tokenLength = currentToken.length();
        if (tokenLength == 0) {
            return false;
        }
        if (currentToken.lastIndexOf(this.predelim) == tokenLength - 1) {
            if (this.stringTokenizer.hasMoreTokens()) {
                return true;
            }
            if (this.str.lastIndexOf(this.delim) == this.str.length() - 1) {
                return true;
            }
        }
        return false;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }
}

