/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Tab;

import edu.cmu.hcii.ctat.CTATHTTPHandlerBase;
import edu.cmu.hcii.ctat.CTATHTTPServer;
import edu.cmu.pact.BehaviorRecorder.Controller.AuthorHTTPSession;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphPanel;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.CtatMenuBar;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import javax.swing.JMenuItem;
import net.infonode.docking.View;

public class CTATTab {
    public static final String INIT_TITLE_PREFIX = "Graph ";
    private final int tabNumber;
    private SingleSessionLauncher launcher;
    private String name;
    private View view;
    private boolean visible;
    private String javaClass = null;
    private String swfName = null;
    private File targetHTMLFile = null;
    private CTATHTTPServer localWebServer = null;
    public static int localHTMLPort = 11000;
    private String localSessionID = UUID.randomUUID().toString();
    private HashMap<JMenuItem, boolean[]> menuItems = new HashMap();

    public CTATTab(int tabNumber) {
        this.tabNumber = tabNumber;
        this.setName(INIT_TITLE_PREFIX + String.valueOf(tabNumber));
        this.view = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHTMLInterfaceTab() {
        return this.targetHTMLFile != null;
    }

    public void setLauncher(SingleSessionLauncher launcher) {
        this.launcher = launcher;
    }

    public int getTabNumber() {
        return this.tabNumber;
    }

    public BR_Controller getController() {
        return this.launcher.getController();
    }

    public ProblemModel getProblemModel() {
        return this.getController().getProblemModel();
    }

    public JGraphPanel getJGraphPanel() {
        return this.getController().getJGraphWindow();
    }

    public SingleSessionLauncher getLauncher() {
        return this.launcher;
    }

    public View getView() {
        if (this.view == null) {
            String problemName = this.getProblemModel().getProblemName();
            JGraphPanel panel = this.getController().getJGraphWindow();
            String viewName = problemName.isEmpty() ? panel.getName() : problemName;
            this.view = new View(viewName, null, (Component)panel);
            this.view.setName(viewName);
        }
        return this.view;
    }

    protected boolean isVisible() {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "Tab " + this.getTabNumber() + " visible? " + this.visible);
        }
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "Setting tab " + this.getTabNumber() + " visible: " + visible);
        }
        this.visible = visible;
    }

    public void addListeners() {
    }

    public void addCtatMenuItem(JMenuItem menuItem, boolean[] values) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CTATTab.addCtatMenuItems(" + menuItem + ") nInField " + this.menuItems.size());
        }
        this.menuItems.put(menuItem, values);
    }

    public boolean[] getCtatMenuItemValues(JMenuItem menuItem) {
        return this.menuItems.get(menuItem);
    }

    public void setCtatMenuItemValues(JMenuItem menuItem, boolean[] values) {
        this.menuItems.put(menuItem, values);
    }

    void initializeCtatMenuItems(HashMap<JMenuItem, boolean[]> menuItems) {
        if (trace.getDebugCode("menu")) {
            trace.out("menu", "CTATTab.initializeCtatMenuItems() nInField " + this.menuItems.size() + ", nInArg " + menuItems.size());
        }
        for (JMenuItem menuItem : menuItems.keySet()) {
            if (this.menuItems.containsKey(menuItem)) continue;
            boolean[] values = menuItems.get(menuItem);
            this.menuItems.put(menuItem, Arrays.copyOf(values, values.length));
        }
    }

    void updateCtatMenuItems() {
        for (JMenuItem menuItem : this.menuItems.keySet()) {
            boolean[] values = this.menuItems.get(menuItem);
            if (menuItem instanceof CtatMenuBar.MenuItem) {
                ((CtatMenuBar.MenuItem)menuItem).setValues(values);
                continue;
            }
            if (menuItem instanceof CtatMenuBar.CheckBoxMenuItem) {
                ((CtatMenuBar.CheckBoxMenuItem)menuItem).setValues(values);
                continue;
            }
            trace.err("CTATTab.updateCtatMenuItems[tab #" + this.tabNumber + "] key " + menuItem + " in menuItems has unexpected class " + trace.nh(menuItem));
        }
    }

    public String getHTMLFile() {
        if (this.targetHTMLFile != null) {
            return this.targetHTMLFile.getName();
        }
        return ".";
    }

    public void closeTab() {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "Tab " + this.getTabNumber() + " closing; localWebServer " + trace.nh(this.localWebServer));
        }
        this.disconnectHTTP();
        if (this.localWebServer != null) {
            this.localWebServer.startExiting();
        }
        this.localWebServer = null;
    }

    public void launchHTMLPage() {
        URI generatedURL;
        if (trace.getDebugCode("html")) {
            trace.out("html", "Launching: " + this.getHTMLFile());
        }
        if ((generatedURL = this.initializationForHTMLPage(null, null)) == null) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            if (trace.getDebugCode("html")) {
                trace.out("html", "Opening: " + generatedURL);
            }
            try {
                Desktop.getDesktop().browse(generatedURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            trace.out("mg", "Error: desktop operations not supported");
        }
    }

    public void launchHTMLPageAsListener(File problemFile) {
        URI generatedURL;
        if (trace.getDebugCode("html")) {
            trace.out("html", "Launching as listener: " + this.getHTMLFile() + ", " + problemFile);
        }
        if ((generatedURL = this.initializationForHTMLPage("ctatAsListener", problemFile)) == null) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            if (trace.getDebugCode("html")) {
                trace.out("html", "Opening: " + generatedURL);
            }
            try {
                Desktop.getDesktop().browse(generatedURL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            trace.err("Error: desktop operations not supported");
        }
    }

    protected URI initializationForHTMLPage(String mode, File question_file) {
        if (this.localWebServer != null) {
            this.localWebServer.startExiting();
        }
        URI generatedURL = null;
        if (mode == null) {
            mode = "auth";
        }
        this.localWebServer = new CTATHTTPServer(localHTMLPort, "/", "dt.txt", null);
        this.localWebServer.startWebServer();
        ((CTATHTTPHandlerBase)this.localWebServer.getHandler()).setGoToStateMessageSource(this.getController());
        if (trace.getDebugCode("html")) {
            trace.out("html", "Server started with webRoot /");
        }
        try {
            int wsPort = this.getLauncher().getLauncherServer().getWSPort();
            generatedURL = new URI("http", "localhost:" + localHTMLPort, this.getURI(this.targetHTMLFile), "mode=" + mode + "&port=" + wsPort + "&session=" + this.localSessionID + (question_file != null ? "&question_file=" + this.getURI(question_file) : "") + ("ctatAsListener".equals(mode) ? "&restore_problem_url=/goToState.cgi&problem_state_status=incomplete" : "") + (trace.getDebugCode("html") ? "&show_debug_traces=true" : ""), null);
        }
        catch (Exception e) {
            trace.errStack("Error creating URI for HTML file " + this.getHTMLFile() + ", sessionID " + this.localSessionID, e);
            return null;
        }
        ++localHTMLPort;
        return generatedURL;
    }

    private String getURI(File f) {
        String result = "";
        if (f != null) {
            result = f.toURI().toASCIIString().substring("file:".length());
        }
        if (trace.getDebugCode("html")) {
            trace.out("html", "getURI() rtns " + result);
        }
        return result;
    }

    public String simulateHTMLPageLaunch(File targetHTMLFile) {
        this.setTargetHTMLFile(targetHTMLFile);
        URI generatedURL = this.initializationForHTMLPage(null, null);
        return generatedURL.toString();
    }

    synchronized String getSessionID() {
        return this.localSessionID;
    }

    private void disconnectHTTP() {
        TSLauncherServer.Session sess = this.getLauncher().getLauncherServer().getSession(this.localSessionID);
        if (sess == null) {
            trace.err("CTATTab.connectHTTP() localSessionID " + this.localSessionID + " not found among LauncherServer sessions");
            return;
        }
        if (!this.localSessionID.equals(sess.getGuid())) {
            trace.err("CTATTab.connectHTTP() localSessionID " + this.localSessionID + " != session guid " + sess.getGuid());
        }
        if (!(sess instanceof AuthorHTTPSession)) {
            trace.err("CTATTab.connectHTTP() session for localSessionID " + this.localSessionID + " not AuthorHTTPSession: " + sess);
        } else {
            this.disconnectHTTP((AuthorHTTPSession)sess);
        }
    }

    void disconnectHTTP(AuthorHTTPSession hSess) {
        hSess.close();
        BR_Controller controller = this.getLauncher().getController();
        controller.getLauncher().removeSession(hSess);
        if (trace.getDebugCode("http")) {
            trace.out("http", "TabManager.connectHTTP() just called removeSession for guid " + hSess.getGuid());
        }
        controller.setRemoteProxy(null);
    }

    CTATTab connectHTTP(AuthorHTTPSession hSess) {
        if (!this.localSessionID.equals(hSess.getGuid())) {
            trace.err("CTATTab.connectHTTP() localSessionID " + this.localSessionID + " != session guid " + hSess.getGuid());
            return null;
        }
        BR_Controller controller = this.getLauncher().getController();
        String guid = controller.getLauncher().getLauncherServer().editGuidForCollaboration(hSess.getGuid());
        if (!hSess.getGuid().equals(guid)) {
            hSess.reviseGuid(guid);
            this.localSessionID = guid;
        }
        return this;
    }

    String editGuidForTab(String guid) {
        if (guid == null) {
            return null;
        }
        if (!this.isVisible()) {
            return guid;
        }
        return String.format("%s-%02d", guid, this.getTabNumber());
    }

    synchronized void setSessionID(String guid) {
        this.localSessionID = guid;
    }

    public String getStudentInterfaceName() {
        if (this.targetHTMLFile != null) {
            return this.targetHTMLFile.getPath();
        }
        if (this.swfName != null) {
            return this.swfName;
        }
        if (this.javaClass != null) {
            return this.javaClass;
        }
        return "";
    }

    public void setSwfName(String guid) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTab.setSwfName(" + guid + ")");
        }
        this.swfName = guid;
        if (this.swfName != null) {
            this.targetHTMLFile = null;
            this.javaClass = null;
        }
    }

    public void setJavaClass(Object tutorPanel) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTab.setJavaClass(" + tutorPanel + ")");
        }
        if (tutorPanel != null) {
            this.swfName = null;
            this.targetHTMLFile = null;
            this.javaClass = tutorPanel.getClass().getName().replace('.', '/');
        } else {
            this.javaClass = null;
        }
    }

    public void setTargetHTMLFile(File targetHTMLFile) {
        if (trace.getDebugCode("mg")) {
            trace.out("mg", "CTATTab.setTargetHTMLFile(" + targetHTMLFile + ")");
        }
        this.targetHTMLFile = targetHTMLFile;
        if (targetHTMLFile != null) {
            this.swfName = null;
            this.javaClass = null;
        }
    }

    public void clearStudentInterface() {
        this.swfName = null;
        this.targetHTMLFile = null;
        this.javaClass = null;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "[" + this.getTabNumber() + "]: name " + this.getName() + ", sess " + this.localSessionID + "]";
    }
}

