/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class RuleProduction {
    private Integer opportunityCount;
    private String ruleName;
    private String productionSet;
    private String productionRule;
    private Vector<String> hints;
    private String label;
    private String description;
    public static final String UNNAMED = "unnamed";

    public String toString() {
        return "[" + this.getDisplayName() + " " + this.getOpportunityCount() + "]";
    }

    public RuleProduction clone() {
        RuleProduction result = new RuleProduction();
        result.opportunityCount = this.opportunityCount;
        result.ruleName = this.ruleName;
        result.productionSet = this.productionSet;
        result.productionRule = this.productionRule;
        result.label = this.label;
        result.description = this.description;
        result.hints = (Vector)this.hints.clone();
        return result;
    }

    public RuleProduction() {
        this("", "");
    }

    public RuleProduction(String displayName) {
        this(displayName, null);
    }

    public RuleProduction(String ruleName, String productionSet) {
        this.ruleName = ruleName == null || ruleName.length() < 1 ? UNNAMED : ruleName;
        this.productionSet = "";
        if (productionSet != null) {
            this.productionSet = productionSet;
        } else {
            int p = ruleName.indexOf(" ");
            if (p >= 0) {
                this.ruleName = ruleName.substring(0, p);
                this.productionSet = ruleName.substring(p + 1);
            }
        }
        this.productionRule = "";
        this.hints = new Vector();
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getProductionSet() {
        return this.productionSet;
    }

    public void setHints(Vector<String> hints) {
        this.hints = (Vector)hints.clone();
        if (trace.getDebugCode("br")) {
            trace.out("br", "RuleProduction.setHints()\n" + this.dumpHints());
        }
    }

    public String dumpHints() {
        if (this.hints == null || this.hints.size() < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.hints.size(); ++i) {
            sb.append(i + 1 < 10 ? " " : "").append(i + 1).append(". ").append(this.hints.get(i));
            if (i + 1 >= this.hints.size()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public Vector<String> getHints() {
        return this.hints;
    }

    public void addHintItem(String hintItem) {
        this.hints.addElement(hintItem);
    }

    public Integer getOpportunityCount() {
        return this.opportunityCount;
    }

    void setOpportunityCount(Integer opportunityCount) {
        this.opportunityCount = opportunityCount;
    }

    public String getKey() {
        return this.getDisplayName().toLowerCase();
    }

    public String getDisplayName() {
        if (this.productionSet != null && this.productionSet.length() > 0) {
            return this.getRuleName() + " " + this.productionSet;
        }
        return this.getRuleName();
    }

    public String getProductionRule() {
        return this.productionRule;
    }

    public void setProductionRule(String productionRule) {
        this.productionRule = productionRule;
    }

    public int incrementOpportunityCount(int delta) {
        this.opportunityCount = this.opportunityCount == null ? new Integer(delta) : new Integer(this.opportunityCount + delta);
        return this.opportunityCount;
    }

    public boolean isUnnamed() {
        return UNNAMED.equalsIgnoreCase(this.getDisplayName());
    }

    public static boolean isRealRuleName(String displayName) {
        if (UNNAMED.equalsIgnoreCase(displayName)) {
            return false;
        }
        return displayName.indexOf(" ") > 0;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static class Catalog
    extends LinkedHashMap<String, RuleProduction> {
        public RuleProduction getRuleProduction(String ruleName, String productionSetText) {
            return this.getRuleProduction(ruleName + " " + productionSetText);
        }

        public RuleProduction getRuleProduction(String ruleNameProdutionSetText) {
            if (ruleNameProdutionSetText.indexOf(" ") <= 0) {
                return null;
            }
            return (RuleProduction)this.get(ruleNameProdutionSetText.toLowerCase());
        }

        public RuleProduction checkAddRuleProduction(RuleProduction targetRuleProduction) {
            String key = targetRuleProduction.getKey();
            RuleProduction existing = (RuleProduction)this.get(key);
            if (existing != null) {
                return existing;
            }
            this.put(key, targetRuleProduction);
            return targetRuleProduction;
        }

        public RuleProduction checkAddRuleName(String newRuleNameText, String newProductionSet) {
            RuleProduction result = new RuleProduction(newRuleNameText, newProductionSet);
            return this.checkAddRuleProduction(result);
        }

        public void checkAddRuleProblem(String ruleNameProdutionSetText, Map<String, RuleProduction> problemRuleProductionList) {
            int temp = ruleNameProdutionSetText.indexOf(" ");
            if (temp <= 0) {
                return;
            }
            if (problemRuleProductionList.get(ruleNameProdutionSetText.toLowerCase()) != null) {
                return;
            }
            problemRuleProductionList.put(ruleNameProdutionSetText, new RuleProduction(ruleNameProdutionSetText));
        }

        public void updateOpportunityCounts(List<ProblemEdge> preferredPathEdges) {
            if (trace.getDebugCode("oppcount")) {
                trace.printStack("oppcount", "updateOpportunityCounts() preferredPath " + preferredPathEdges);
            }
            this.clearOpportunityCounts();
            for (ProblemEdge edge : preferredPathEdges) {
                EdgeData edgeData = edge.getEdgeData();
                Vector<String> ruleNames = null;
                if (edgeData == null || (ruleNames = edgeData.getRuleNames()) == null) continue;
                if (trace.getDebugCode("pm")) {
                    trace.out("pm", "updateOpportunityCounts() link " + edge + " rules " + ruleNames);
                }
                for (String ruleName : ruleNames) {
                    if (!RuleProduction.isRealRuleName(ruleName)) continue;
                    RuleProduction rp = this.getRuleProduction(ruleName);
                    if (rp == null) {
                        rp = new RuleProduction(ruleName);
                        this.addRuleProduction(rp);
                    }
                    rp.incrementOpportunityCount(1);
                }
            }
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "updateOpportunityCounts() map result " + this);
            }
        }

        private void clearOpportunityCounts() {
            for (RuleProduction rp : this.values()) {
                rp.setOpportunityCount(0);
            }
        }

        public boolean addRuleProduction(RuleProduction ruleProduction) {
            RuleProduction oldValue = this.put(ruleProduction.getKey(), ruleProduction);
            return oldValue == null;
        }

        public List<RuleProduction> getRuleProductionList() {
            return this.getRuleProductionList(false);
        }

        public List<RuleProduction> getRuleProductionList(boolean omitUnnamed) {
            return this.getRuleProductionList(omitUnnamed, false);
        }

        public List<RuleProduction> getRuleProductionList(boolean omitUnnamed, boolean omitUncounted) {
            ArrayList<RuleProduction> result = new ArrayList<RuleProduction>();
            for (RuleProduction rp : this.values()) {
                Integer count;
                if (omitUnnamed && rp.isUnnamed() || omitUncounted && ((count = rp.getOpportunityCount()) == null || count < 1)) continue;
                result.add(rp.clone());
            }
            return result;
        }

        public List<String> getRuleDisplayNames() {
            return this.getRuleDisplayNames(false);
        }

        public List<String> getRuleDisplayNames(boolean omitUnnamed) {
            ArrayList<String> result = new ArrayList<String>();
            for (RuleProduction rp : this.values()) {
                if (omitUnnamed && rp.isUnnamed()) continue;
                result.add(rp.getDisplayName());
            }
            return result;
        }

        public Catalog removeUnusedRuleProductions(ProblemGraph problemGraph) {
            if (problemGraph == null) {
                return null;
            }
            HashSet<String> keysInUse = new HashSet<String>();
            Enumeration<ProblemEdge> en = problemGraph.edges();
            boolean foundRealEdge = false;
            while (en.hasMoreElements()) {
                ProblemEdge edge = en.nextElement();
                if (edge.getUniqueID() < 0) continue;
                foundRealEdge = true;
                for (String key : edge.getEdgeData().getRuleNames()) {
                    keysInUse.add(key.toLowerCase());
                }
            }
            if (!foundRealEdge) {
                return this;
            }
            Catalog result = new Catalog();
            for (String key : keysInUse) {
                if (!RuleProduction.isRealRuleName(key)) continue;
                RuleProduction oldRP = (RuleProduction)this.get(key);
                if (oldRP == null) {
                    result.put(key, new RuleProduction(key));
                    continue;
                }
                result.put(key, oldRP.clone());
            }
            return result;
        }
    }
}

