/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Dialogs.HelpSuccessPanel;
import edu.cmu.pact.BehaviorRecorder.Dialogs.PasteSpecialDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeColorEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeRewiredEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelException;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LinkEditFunctions
implements Serializable {
    private static final long serialVersionUID = 2394717262980666306L;
    private static final String DELETE_LINK = "Delete Link";
    public transient String jDialogResult;
    ProblemEdge problemEdge;
    EdgeData edgeData;
    ProblemNode childNode;
    ProblemNode parentNode;
    BR_Controller controller;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
    }

    public LinkEditFunctions(ProblemEdge edge, BR_Controller controller) {
        this.problemEdge = edge;
        this.controller = controller;
        this.edgeData = edge.getEdgeData();
        this.childNode = edge.getDest();
        this.parentNode = edge.getSource();
    }

    public void testProcessInsert(boolean above) {
        this.processInsertNodeAbove2(above);
    }

    public void processInsertNodeAbove2(boolean above) {
        ProblemEdge rewireEdge;
        ArrayList<ProblemModelEvent> subEvents = new ArrayList<ProblemModelEvent>();
        Vector<String> selection = new Vector<String>();
        selection.add("No_Selection");
        Vector<String> action = new Vector<String>();
        action.add("No_Action");
        Vector<String> input = new Vector<String>();
        input.add("No_Value");
        new PseudoTutorMessageBuilder();
        MessageObject mo = PseudoTutorMessageBuilder.buildInterfaceAction(selection, action, input, this.controller);
        ProblemNode newNode = this.controller.createProblemNode(this.parentNode, selection, this.parentNode.getOutDegree());
        EdgeData newEdgeData = new EdgeData(this.controller.getProblemModel());
        newEdgeData.addRuleName("unnamed");
        newEdgeData.setSelection((Vector)selection.clone());
        newEdgeData.setAction((Vector)action.clone());
        newEdgeData.setInput((Vector)input.clone());
        newEdgeData.setDemoMsgObj(mo);
        newEdgeData.setActionType("Correct Action");
        newEdgeData.updateDefaultHint();
        newEdgeData.getActionLabel().resetForeground();
        if (above) {
            newEdgeData.setPreferredEdge(this.edgeData.isPreferredEdge());
        } else {
            newEdgeData.setPreferredEdge(true);
        }
        ProblemEdge newEdge = above ? this.controller.getProblemModel().getProblemGraph().addEdge(this.parentNode, newNode, newEdgeData) : this.controller.getProblemModel().getProblemGraph().addEdge(newNode, this.childNode, newEdgeData);
        newEdgeData.getActionLabel().update();
        newEdge.addEdgeLabels();
        ExampleTracerGraph currentGraph = this.controller.getExampleTracerGraph();
        EdgeCreatedEvent edgeCreatedEvent = new EdgeCreatedEvent(this, newEdge);
        LinkGroup smallestContainingGroup = currentGraph.getSmallestContainingGroup(currentGraph.getLink(this.problemEdge));
        if (smallestContainingGroup != null) {
            edgeCreatedEvent.setGroupToAddTo(smallestContainingGroup);
        }
        subEvents.add(edgeCreatedEvent);
        this.controller.deleteSingleEdge(this.problemEdge, false);
        EdgeDeletedEvent edgeDeletedEvent = new EdgeDeletedEvent(this.problemEdge);
        edgeDeletedEvent.setEdgeBeingRewired(true);
        if (above) {
            rewireEdge = this.controller.getProblemModel().getProblemGraph().addEdge(newNode, this.childNode, this.edgeData);
            rewireEdge.getEdgeData().setPreferredEdge(true);
        } else {
            rewireEdge = this.controller.getProblemModel().getProblemGraph().addEdge(this.parentNode, newNode, this.edgeData);
        }
        rewireEdge.getEdgeData().getActionLabel().update();
        rewireEdge.addEdgeLabels();
        edgeCreatedEvent = new EdgeCreatedEvent(this, rewireEdge);
        edgeCreatedEvent.setEdgeBeingRewired(true);
        if (smallestContainingGroup != null) {
            edgeCreatedEvent.setGroupToAddTo(smallestContainingGroup);
        }
        EdgeRewiredEvent edgeRewiredEvent = new EdgeRewiredEvent(this, edgeDeletedEvent, edgeCreatedEvent);
        subEvents.add(edgeRewiredEvent);
        NodeCreatedEvent fireMe = new NodeCreatedEvent(this, newNode, subEvents);
        this.controller.getProblemModel().fireProblemModelEvent(fireMe);
    }

    public void changeActionType(String newActionType) {
        if (newActionType == null || newActionType.equalsIgnoreCase(this.edgeData.getActionType())) {
            return;
        }
        String serializedBeforeEdit = this.problemEdge.toXMLString();
        if (newActionType.equals("Correct Action")) {
            this.handleCorrectAction();
        } else if (newActionType.equals("Buggy Action")) {
            this.handleBuggyAction();
        } else if (newActionType.equals("Fireable Buggy Action")) {
            this.handleFireableBuggyAction();
        } else if (newActionType.equals("Untraceable Error")) {
            this.handleUntraceableAction();
        }
        this.checkpoint(serializedBeforeEdit, newActionType);
        this.edgeData.getActionLabel().resetForeground();
    }

    private void checkpoint(String serializedBeforeEdit, String newActionType) {
        String serializedAfterEdit = this.problemEdge.toXMLString();
        if (serializedBeforeEdit.equals(serializedAfterEdit)) {
            return;
        }
        if (trace.getDebugCode("undo")) {
            trace.out("undo", "ActionLabelHandler.actionPerformed(" + newActionType + ") XML before:\n" + serializedBeforeEdit + "\nXML after:\n" + serializedAfterEdit);
        }
        ActionEvent ae = new ActionEvent(this, 0, "Change Action Type");
        this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
    }

    private void handleUntraceableAction() {
        if (this.edgeData.getActionType().equalsIgnoreCase("Correct Action") || this.edgeData.getActionType().equalsIgnoreCase("Fireable Buggy Action")) {
            this.updateActionTypeFromCorrectToBuggy("Untraceable Error");
        } else {
            if (this.childNode == this.controller.getSolutionState().getCurrentNode()) {
                this.controller.setCurrentNode(this.parentNode);
                this.controller.sendCommMsgs(this.parentNode, this.controller.getProblemModel().getStartNode());
            }
            this.edgeData.setActionType("Untraceable Error");
            this.edgeData.setBuggyMsg("");
        }
    }

    private void handleFireableBuggyAction() {
        if (this.edgeData.getActionType().equalsIgnoreCase("Correct Action") && (this.edgeData.getSuccessMsg().trim().length() > 0 || this.edgeData.haveNoneDefaultHint())) {
            new ChangeActionTypePanel("Fireable Buggy Action");
        } else {
            EditBuggyMsgPanel editBuggyMsgPanel = new EditBuggyMsgPanel(true);
            if (editBuggyMsgPanel.getCancelled()) {
                return;
            }
            this.edgeData.setActionType("Fireable Buggy Action");
        }
    }

    private void handleCorrectAction() {
        if ((this.edgeData.getActionType().equalsIgnoreCase("Buggy Action") || this.edgeData.getActionType().equalsIgnoreCase("Fireable Buggy Action")) && this.edgeData.getBuggyMsg().trim().length() > 0) {
            new ChangeActionTypePanel("Correct Action");
        } else {
            this.edgeData.setActionType("Correct Action");
            this.edgeData.setBuggyMsg("");
        }
        this.controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this, this.problemEdge, true));
    }

    public void testProcessDeleteSingleEdge() {
        this.processDeleteSingleEdge(true);
    }

    public void processDeleteSingleEdge(boolean isJUnitTesting) {
        ProblemNode source;
        ProblemNode target;
        boolean childIsStartNode;
        int result;
        Vector childsParents;
        List<ProblemEdge> childOutEdges = this.childNode.getOutgoingEdges();
        ArrayList<ProblemNode> grandChildren = new ArrayList<ProblemNode>();
        for (int i = 0; i < childOutEdges.size(); ++i) {
            grandChildren.add(childOutEdges.get(0).getDest());
        }
        Vector<ProblemNode> children = this.parentNode.getChildren();
        String mergeNotPossibleMsg = null;
        ProblemNode conflictNode = null;
        for (ProblemNode curr : children) {
            if (!grandChildren.contains(curr)) continue;
            mergeNotPossibleMsg = "Merging the states would result in 2 links with the same source and destination";
            conflictNode = curr;
            break;
        }
        if (conflictNode == null) {
            Vector parentsParents = this.parentNode.getParents();
            childsParents = this.childNode.getParents();
            for (ProblemNode curr : parentsParents) {
                if (!childsParents.contains(curr)) continue;
                mergeNotPossibleMsg = "Merging the states would result in 2 links with the same source and destination";
                conflictNode = curr;
                break;
            }
        }
        if (conflictNode == null) {
            childsParents = this.childNode.getParents();
            for (ProblemNode curr : childsParents) {
                if (curr == this.parentNode) continue;
                Vector<ProblemNode> ancestorNodesList = new Vector<ProblemNode>();
                this.controller.getProblemModel().findAncestorNodesListIgnoringLinkX(curr, ancestorNodesList, this.problemEdge);
                if (!ancestorNodesList.contains(this.parentNode)) continue;
                mergeNotPossibleMsg = "Merging the states would create a cycle in the graph";
                conflictNode = curr;
                break;
            }
        }
        if ((result = !isJUnitTesting ? this.doDeleteLinkMergeDialogue("Merge states " + this.parentNode.getName() + " and " + this.childNode.getName() + ".", mergeNotPossibleMsg) : (conflictNode == null ? 1 : 2)) == 3) {
            return;
        }
        if (result == 2) {
            if (this.problemEdge.isPreferredEdge()) {
                this.resetPreferredPath(false);
            }
            this.controller.deleteSingleEdge(this.problemEdge, true);
            ActionEvent ae = new ActionEvent(this, 0, DELETE_LINK);
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            return;
        }
        boolean bl = childIsStartNode = this.controller.getExampleTracerGraph().getStartNode().getProblemNode() == this.childNode;
        if (childIsStartNode) {
            target = this.childNode;
            source = this.parentNode;
        } else {
            target = this.parentNode;
            source = this.childNode;
        }
        ArrayList<ProblemModelEvent> subEvents = new ArrayList();
        boolean targetHasPreferredEdge = target.hasOutGoingPreferredEdge(this.problemEdge);
        boolean sourceHasPreferredEdge = source.hasOutGoingPreferredEdge(null);
        if (!targetHasPreferredEdge && !sourceHasPreferredEdge) {
            try {
                ProblemEdge temp = this.controller.getProblemModel().updatePreferredPath(target, this.problemEdge, false);
                targetHasPreferredEdge = temp != null;
            }
            catch (Exception temp) {
                // empty catch block
            }
        }
        this.controller.deleteSingleEdge(this.problemEdge, false);
        subEvents = this.controller.mergeStates2(source, target, false, false, targetHasPreferredEdge);
        this.controller.getProblemModel().fireProblemModelEvent(new EdgeDeletedEvent(this.problemEdge, subEvents));
        ActionEvent ae = new ActionEvent(this, 0, DELETE_LINK);
        this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
    }

    private int doDeleteLinkMergeDialogue(String mergeText, String mergeNotPossibleMsg) {
        this.jDialogResult = null;
        String deleteText = "Don't merge states";
        String cancelText = "Cancel";
        JButton merge = new JButton(mergeText);
        if (mergeNotPossibleMsg != null) {
            merge.setEnabled(false);
            merge.setToolTipText(mergeNotPossibleMsg);
        }
        JButton delete = new JButton(deleteText);
        JButton cancel = new JButton(cancelText);
        Object[] buttons = new Object[]{"Delete this link and...", merge, delete};
        JOptionPane op = new JOptionPane();
        op.setMessage(buttons);
        Object[] smallButtons = new Object[]{cancel};
        op.setOptions(smallButtons);
        final JDialog d = op.createDialog(this.controller.getActiveWindow(), DELETE_LINK);
        ActionListener closeDialog = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkEditFunctions.this.jDialogResult = e.getActionCommand();
                d.dispose();
            }
        };
        merge.addActionListener(closeDialog);
        delete.addActionListener(closeDialog);
        cancel.addActionListener(closeDialog);
        d.setVisible(true);
        if (this.jDialogResult == null || this.jDialogResult.equals(cancelText)) {
            return 3;
        }
        if (this.jDialogResult.equals(deleteText)) {
            return 2;
        }
        if (this.jDialogResult.equals(mergeText)) {
            return 1;
        }
        return 3;
    }

    private boolean resetPreferredPath(boolean throwException) {
        try {
            return this.controller.getProblemModel().updatePreferredPath(this.parentNode, this.problemEdge, throwException) != null;
        }
        catch (ProblemModelException e) {
            NodeView outVertex = this.parentNode.getNodeView();
            String[] message = new String[]{"You don't have preferred path defined", "from state: " + outVertex.getText().trim(), ""};
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), message, "Warning", 2);
            e.printStackTrace();
            return false;
        }
    }

    private void checkWithProductionSystem() {
        if (this.parentNode != this.controller.getCurrentNode()) {
            this.controller.goToState(this.parentNode);
        }
        this.controller.checkWithLispSingle(this.problemEdge);
    }

    public boolean setPreferredArc(Color colorToRestoreTo) {
        if (this.edgeData.isPreferredEdge()) {
            return false;
        }
        ProblemEdge thisEdge = this.problemEdge;
        ProblemNode sourceNode = thisEdge.getNodes()[0];
        EdgeData tempMyEdge = null;
        ProblemEdge tempEdge = null;
        Enumeration<ProblemEdge> iter = this.controller.getProblemModel().getProblemGraph().getOutgoingEdges(sourceNode);
        boolean hasPreferPathSet = false;
        while (iter.hasMoreElements() && !hasPreferPathSet) {
            tempEdge = iter.nextElement();
            tempMyEdge = tempEdge.getEdgeData();
            if (!tempMyEdge.isPreferredEdge()) continue;
            hasPreferPathSet = true;
        }
        if (tempEdge != null && tempMyEdge != null && !tempEdge.equals(thisEdge)) {
            tempMyEdge.setPreferredEdge(false);
            this.edgeData.setPreferredEdge(true);
            this.controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this, tempEdge, true));
            this.controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this, thisEdge, true));
            if (colorToRestoreTo != null) {
                this.controller.getProblemModel().fireProblemModelEvent(new EdgeColorEvent(this, thisEdge, colorToRestoreTo));
            }
            ActionEvent ae = new ActionEvent(this, 0, "Set As Preferred Path");
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            return true;
        }
        return false;
    }

    public boolean processDemonstrateLink() {
        if (this.controller.getCtatModeModel().isDefiningStartState()) {
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "You are currently in 'Set Start State' mode. Please switch to another mode to use 'Demonstrate This Link'", "Warning", 2);
            return false;
        }
        int value = JOptionPane.showConfirmDialog(this.controller.getActiveWindow(), "Going into 'Demonstrate This Link' Recording. This will only work in 'Demonstrate' mode or 'Test Tutor' mode", "Demonstrate This Link", 2, 3);
        if (value == 0) {
            this.controller.getCtatModeModel().enterDemonstrateThisLinkMode(this.problemEdge.getUniqueID());
            this.controller.goToState(this.parentNode, false);
            if (trace.getDebugCode("demolink")) {
                trace.out("demolink", "LinkEdit.processDemonstrateLink() parentNode " + this.parentNode + ", problemEdge " + this.problemEdge);
            }
            return true;
        }
        this.controller.getCtatModeModel().exitDemonstrateThisLinkMode();
        return false;
    }

    public void processCancelDemonstrateLink() {
        this.controller.getCtatModeModel().exitDemonstrateThisLinkMode();
    }

    public void showEditBuggyMsgPanel() {
        new EditBuggyMsgPanel(false);
    }

    private void updateActionTypeFromCorrectToBuggy(String newAuthorIntent) {
        if (this.edgeData.getSuccessMsg().trim().length() > 0 || this.edgeData.haveNoneDefaultHint()) {
            new ChangeActionTypePanel(newAuthorIntent);
            return;
        }
        EditBuggyMsgPanel editBuggyMsgPanel = new EditBuggyMsgPanel(true);
        if (editBuggyMsgPanel.getCancelled()) {
            if (trace.getDebugCode("mps")) {
                trace.out("mps", "RETURNING");
            }
            this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
            return;
        }
        this.handleTraverseableToNonTraverseable2(newAuthorIntent);
    }

    private void handleBuggyAction() {
        if (this.edgeData.getActionType().equalsIgnoreCase("Correct Action") || this.edgeData.getActionType().equalsIgnoreCase("Fireable Buggy Action")) {
            if (trace.getDebugCode("mps")) {
                trace.out("mps", "updating it here???");
            }
            this.updateActionTypeFromCorrectToBuggy("Buggy Action");
        } else {
            if (this.childNode == this.controller.getSolutionState().getCurrentNode()) {
                this.controller.setCurrentNode(this.parentNode);
                this.controller.sendCommMsgs(this.parentNode, this.controller.getProblemModel().getStartNode());
            }
            new EditBuggyMsgPanel(true);
            this.edgeData.setActionType("Buggy Action");
        }
    }

    public void testChangeActionTypeToBuggy(String newActionType) {
        this.handleTraverseableToNonTraverseable2(newActionType);
    }

    private boolean handleTraverseableToNonTraverseable2(String newActionType) {
        this.edgeData.setActionType(newActionType);
        if (this.problemEdge.isPreferredEdge()) {
            this.resetPreferredPath(false);
            this.problemEdge.getEdgeData().setPreferredEdge(false);
        }
        if (this.childNode.getConnectingEdges().size() == 1) {
            EdgeUpdatedEvent e = new EdgeUpdatedEvent(this, this.problemEdge, true);
            if (this.controller.getCurrentNode() == this.childNode) {
                e.setTryToSetCurrentStateTo(this.parentNode.getUniqueID());
            }
            this.controller.getProblemModel().fireProblemModelEvent(e);
            return true;
        }
        ArrayList<ProblemModelEvent> subEvents = new ArrayList<ProblemModelEvent>();
        ProblemNode newDestNode = this.controller.createProblemNode(this.parentNode, this.problemEdge.getEdgeData().getSelection(), this.parentNode.getOutDegree() - 1);
        this.controller.deleteSingleEdge(this.problemEdge, false);
        ProblemEdge replacementEdge = this.controller.getProblemModel().getProblemGraph().addEdge(this.problemEdge.getSource(), newDestNode, this.problemEdge.getEdgeData());
        replacementEdge.addEdgeLabels();
        replacementEdge.getEdgeData().getActionLabel().update();
        EdgeCreatedEvent edgeCreatedEvent = new EdgeCreatedEvent(this, replacementEdge);
        edgeCreatedEvent.setEdgeBeingRewired(true);
        EdgeDeletedEvent edgeDeletedEvent = new EdgeDeletedEvent(this.problemEdge);
        edgeDeletedEvent.setEdgeBeingRewired(true);
        if (this.controller.getCurrentNode() == this.childNode) {
            edgeDeletedEvent.setTryToSetCurrentStateTo(this.parentNode.getUniqueID());
        }
        EdgeRewiredEvent ere = new EdgeRewiredEvent(this, edgeDeletedEvent, edgeCreatedEvent);
        subEvents.add(ere);
        NodeCreatedEvent fireMe = new NodeCreatedEvent(this, newDestNode, subEvents);
        this.controller.getProblemModel().fireProblemModelEvent(fireMe);
        return true;
    }

    public void processCopyLink() {
        EdgeData.setCopyData(this.edgeData);
    }

    public void processPasteLink() {
        EdgeData pasteData = EdgeData.getCopyData();
        this.edgeData.setActor(pasteData.getActor());
        this.edgeData.setSelection(pasteData.copyVector(pasteData.getSelection()));
        this.edgeData.setAction(pasteData.copyVector(pasteData.getAction()));
        this.edgeData.setInput(pasteData.copyVector(pasteData.getInput()));
        this.edgeData.setDemoMsgObj(pasteData.getDemoMsgObj().copy());
        this.edgeData.setActionType(pasteData.getActionType());
        this.edgeData.setHints(pasteData.copyVector(pasteData.getAllHints()));
        this.edgeData.setBuggyMsg(pasteData.getBuggyMsg());
        this.edgeData.setSuccessMsg(pasteData.getSuccessMsg());
        this.edgeData.setOldActionType(pasteData.getOldActionType());
        this.edgeData.setMatcher((Matcher)pasteData.getMatcher().clone());
        this.edgeData.setMinTraversalsStr(pasteData.getMinTraversalsStr());
        this.edgeData.setMaxTraversalsStr(pasteData.getMaxTraversalsStr());
        ProblemModel pm = this.controller.getProblemModel();
        this.edgeData.setPreferredEdge(!pm.hasPreferredPath(this.parentNode) || this.edgeData.isPreferredEdge());
        pm.fireProblemModelEvent(new EdgeColorEvent(this, this.edgeData.getEdge(), pasteData.getDefaultColor()));
        this.edgeData.getPreLispCheckLabel().resetCheckedStatus(pasteData.getPreLispCheckLabel() == null ? "No-Applicable" : pasteData.getPreLispCheckLabel().getCheckedStatus());
        this.edgeData.getActionLabel().update();
        this.problemEdge.getActionLabel().repaint();
    }

    public void processPasteSpecialLink() {
        EdgeData copyData = EdgeData.getCopyData();
        PasteSpecialDialog psd = new PasteSpecialDialog(this.controller);
        EnumMap<PasteSpecialDialog.EdgeAttribute, Boolean> selectMap = psd.getSelectedAttributes();
        if (selectMap == null) {
            return;
        }
        EnumMap<PasteSpecialDialog.EdgeAttribute, Object> valueMap = new EnumMap<PasteSpecialDialog.EdgeAttribute, Object>(PasteSpecialDialog.EdgeAttribute.class);
        for (PasteSpecialDialog.EdgeAttribute ea : selectMap.keySet()) {
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.HINT_MESSAGE)) {
                valueMap.put(ea, copyData.getHints());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.SUCCESS_MESSAGE)) {
                valueMap.put(ea, (Object)copyData.getSuccessMsg());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.BUG_MESSAGE)) {
                valueMap.put(ea, (Object)copyData.getBuggyMsg());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.MATCHERS)) {
                valueMap.put(ea, (Object)copyData.getMatcher());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.ACTION_TYPE)) {
                valueMap.put(ea, (Object)copyData.getActionType());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.ACTOR)) {
                valueMap.put(ea, (Object)copyData.getActor());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.MIN_TRAVERSALS)) {
                valueMap.put(ea, (Object)copyData.getMinTraversals());
                continue;
            }
            if (ea.equals((Object)PasteSpecialDialog.EdgeAttribute.SKILLS)) {
                Vector skills = (Vector)copyData.getRuleNames().clone();
                valueMap.put(ea, (Object)skills);
                continue;
            }
            if (!ea.equals((Object)PasteSpecialDialog.EdgeAttribute.MAX_TRAVERSALS)) continue;
            valueMap.put(ea, (Object)copyData.getMaxTraversals());
        }
        psd.applyDialogSelection(this.problemEdge, valueMap, false);
        this.edgeData.getActionLabel().update();
    }

    public void processClipboardCopyLink() {
        this.controller.getProblemModelManager().copySelectedLinks();
    }

    public void processClipboardPasteLink() {
        this.controller.getProblemModelManager().pasteLinks();
    }

    private class EditBuggyMsgPanel
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = -3351810150675944882L;
        JPanel buggyMsgPanel;
        JPanel OptionsPanel;
        JCheckBox checkOption1;
        JLabel copyFromJLabel;
        JComboBox edgesJComboBox;
        Vector myEdgesWithBuggy;
        JPanel okCancelPanel;
        Container contentPane;
        JLabel explainJLabel;
        JTextArea buggyArea;
        JScrollPane buggyAreaScrollPane;
        JButton okJButton;
        JButton cancelJButton;
        static final String title = "Edit your buggy message";
        private boolean cancelled;
        private final String serializedBeforeEdit;
        private boolean partOfLargerEdit;

        public boolean getCancelled() {
            return this.cancelled;
        }

        private EditBuggyMsgPanel(boolean partOfLargerEdit) {
            super(LinkEditFunctions.this.controller.getActiveWindow(), title, true);
            this.buggyMsgPanel = new JPanel();
            this.OptionsPanel = new JPanel();
            this.checkOption1 = new JCheckBox("Copy to all links with the same Selection/Action/Input.");
            this.copyFromJLabel = new JLabel(" Copy from buggy states:");
            this.edgesJComboBox = new JComboBox();
            this.myEdgesWithBuggy = new Vector();
            this.okCancelPanel = new JPanel();
            this.contentPane = this.getContentPane();
            this.explainJLabel = new JLabel("Please define your buggy message:");
            this.okJButton = new JButton("   OK  ");
            this.cancelJButton = new JButton("Cancel");
            this.partOfLargerEdit = false;
            this.serializedBeforeEdit = LinkEditFunctions.this.edgeData.getEdge().toXMLString();
            this.partOfLargerEdit = partOfLargerEdit;
            this.buggyArea = new JTextArea();
            JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.buggyArea);
            this.buggyArea.setLineWrap(true);
            this.buggyArea.setWrapStyleWord(true);
            this.buggyArea.setVisible(true);
            this.buggyArea.setText(LinkEditFunctions.this.edgeData.getBuggyMsg().trim());
            this.buggyAreaScrollPane = new JScrollPane(this.buggyArea);
            this.buggyMsgPanel.setLayout(new BorderLayout());
            this.buggyMsgPanel.add((Component)this.explainJLabel, "North");
            this.buggyMsgPanel.add((Component)this.buggyAreaScrollPane, "Center");
            Enumeration<ProblemEdge> iter = LinkEditFunctions.this.controller.getProblemModel().getProblemGraph().edges();
            this.myEdgesWithBuggy = new Vector();
            while (iter.hasMoreElements()) {
                ProblemEdge tempEdge = iter.nextElement();
                if (LinkEditFunctions.this.problemEdge == tempEdge) continue;
                EdgeData tempMyEdge = tempEdge.getEdgeData();
                String tempAuthorIntent = tempMyEdge.getActionType();
                String tempBuggyMsg = tempMyEdge.getBuggyMsg().trim();
                if (tempAuthorIntent.equalsIgnoreCase("Correct Action") || tempBuggyMsg.length() <= 0) continue;
                this.myEdgesWithBuggy.addElement(tempMyEdge);
                NodeView tempParentVertex = tempEdge.getNodes()[0].getNodeView();
                NodeView tempChildVertex = tempEdge.getNodes()[1].getNodeView();
                this.edgesJComboBox.addItem(tempParentVertex.getText() + " to " + tempChildVertex.getText());
            }
            if (((DefaultComboBoxModel)this.edgesJComboBox.getModel()).getSize() == 0) {
                this.edgesJComboBox.addItem("None");
            }
            this.OptionsPanel.setLayout(new GridLayout(3, 1));
            this.OptionsPanel.add(this.checkOption1);
            this.OptionsPanel.add(this.copyFromJLabel);
            this.OptionsPanel.add(this.edgesJComboBox);
            this.buggyMsgPanel.add((Component)this.OptionsPanel, "South");
            this.edgesJComboBox.addActionListener(this);
            this.okCancelPanel.setLayout(new FlowLayout(1));
            this.okJButton.setSize(this.cancelJButton.getSize());
            this.okCancelPanel.add(this.okJButton);
            this.okCancelPanel.add(this.cancelJButton);
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.add((Component)this.buggyMsgPanel, "Center");
            this.contentPane.add((Component)this.okCancelPanel, "South");
            this.okJButton.addActionListener(this);
            this.cancelJButton.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    EditBuggyMsgPanel.this.thisWindowClosing();
                }
            });
            this.setSize(300, 400);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        public void thisWindowClosing() {
            this.setVisible(false);
            this.dispose();
            String serializedAfterEdit = LinkEditFunctions.this.edgeData.getEdge().toXMLString();
            if (!this.serializedBeforeEdit.equals(serializedAfterEdit) && trace.getDebugCode("undo")) {
                trace.out("undo", "EditBuggyMsgPanel.windowClosing() XML before:\n" + this.serializedBeforeEdit + "\nXML after:\n" + serializedAfterEdit);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String selectedItem;
            int slectedEdgeIndex;
            if (ae.getSource() == this.okJButton) {
                String newBuggyText = this.buggyArea.getText();
                if (newBuggyText != null) {
                    newBuggyText = newBuggyText.trim();
                    LinkEditFunctions.this.edgeData.getActionLabel().resetForeground();
                    LinkEditFunctions.this.edgeData.setBuggyMsg(newBuggyText);
                    if (this.checkOption1.isSelected()) {
                        Vector sameTripleLinks = LinkEditFunctions.this.controller.getProblemModel().findSameTripleEdges(LinkEditFunctions.this.edgeData.getSelection(), LinkEditFunctions.this.edgeData.getAction(), LinkEditFunctions.this.edgeData.getInput());
                        this.copyBuggyMsgs(LinkEditFunctions.this.edgeData.getActionLabel(), sameTripleLinks);
                    }
                    if (!this.partOfLargerEdit) {
                        ActionEvent evt = new ActionEvent(this, 0, "Edit Bug Message...");
                        LinkEditFunctions.this.controller.getUndoPacket().getCheckpointAction().actionPerformed(evt);
                    }
                }
                this.setVisible(false);
                this.dispose();
            } else if (ae.getSource() == this.cancelJButton) {
                this.setVisible(false);
                this.cancelled = true;
                this.dispose();
            } else if (ae.getSource() == this.edgesJComboBox && (slectedEdgeIndex = this.edgesJComboBox.getSelectedIndex()) >= 0 && !(selectedItem = (String)this.edgesJComboBox.getSelectedItem()).equals("None")) {
                EdgeData selectedMyEdge = (EdgeData)this.myEdgesWithBuggy.elementAt(slectedEdgeIndex);
                this.buggyArea.setText(selectedMyEdge.getBuggyMsg().trim());
            }
        }

        void copyBuggyMsgs(ActionLabel fromActionLabel, Vector toLinksVector) {
            if (toLinksVector == null) {
                return;
            }
            int numberOfLinks = toLinksVector.size();
            for (int i = 0; i < numberOfLinks; ++i) {
                ProblemEdge tempEdge = (ProblemEdge)toLinksVector.elementAt(i);
                EdgeData tempMyEdge = tempEdge.getEdgeData();
                tempMyEdge.setBuggyMsg(fromActionLabel.getEdge().getBuggyMsg());
            }
        }
    }

    public class ChangeActionTypePanel
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 8808164135294824941L;
        String newIntent;
        JTextArea displayJTextArea;
        Container contentPane;
        private JPanel optionPanel;
        private JPanel okPanel;
        private ButtonGroup group;
        private JRadioButton[] buttons;
        private JButton okButton;
        private final String serializedBeforeEdit;

        public ChangeActionTypePanel(String newIntentP) {
            super(LinkEditFunctions.this.controller.getActiveWindow(), "Warning", true);
            this.contentPane = this.getContentPane();
            this.optionPanel = new JPanel();
            this.okPanel = new JPanel();
            this.group = new ButtonGroup();
            this.buttons = new JRadioButton[]{new JRadioButton("Cancel"), new JRadioButton("Change action type, but keep attached messages."), new JRadioButton("Change both action type and attached messages.")};
            this.okButton = new JButton("OK");
            this.serializedBeforeEdit = LinkEditFunctions.this.edgeData.getEdge().toXMLString();
            this.newIntent = newIntentP;
            this.setResizable(false);
            this.contentPane.setLayout(new BorderLayout());
            String displayText = newIntentP.equalsIgnoreCase("Correct Action") ? "The link you selected has a buggy message attached. When you change the action type from " + LinkEditFunctions.this.edgeData.getActionType() + " to " + this.newIntent + " the buggy message is no longer useful (since it would never be displayed by the tutor). You may want to change the message or switch it to Help/Success messages." : "The link you selected has attached Help/Success messages. When you change the action type from " + LinkEditFunctions.this.edgeData.getActionType() + " to " + this.newIntent + " help/success messages are no longer useful (since they would never be displayed by the tutor). You may want to change the messages or switch them to Buggy message.";
            this.displayJTextArea = new JTextArea(displayText);
            this.contentPane.add((Component)this.displayJTextArea, "North");
            this.displayJTextArea.setEditable(false);
            this.displayJTextArea.setLineWrap(true);
            this.displayJTextArea.setWrapStyleWord(true);
            this.optionPanel.setLayout(new GridLayout(3, 1));
            for (int i = 0; i < 3; ++i) {
                this.optionPanel.add(this.buttons[i]);
                this.group.add(this.buttons[i]);
            }
            this.buttons[0].setSelected(true);
            this.contentPane.add((Component)this.optionPanel, "Center");
            this.okPanel.setLayout(new FlowLayout(1));
            this.okPanel.add(this.okButton);
            this.contentPane.add((Component)this.okPanel, "South");
            this.okButton.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ChangeActionTypePanel.this.setVisible(false);
                    ChangeActionTypePanel.this.dispose();
                }
            });
            this.setSize(300, 400);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setVisible(false);
            this.dispose();
            if (this.buttons[0].isSelected()) {
                return;
            }
            boolean continueDeleteFlag = false;
            String oldAuthorIntent = LinkEditFunctions.this.edgeData.getActionType();
            if ((oldAuthorIntent.equalsIgnoreCase("Correct Action") || oldAuthorIntent.equalsIgnoreCase("Fireable Buggy Action")) && (this.newIntent.equalsIgnoreCase("Buggy Action") || this.newIntent.equalsIgnoreCase("Untraceable Error"))) {
                continueDeleteFlag = true;
            }
            if (continueDeleteFlag) {
                LinkEditFunctions.this.handleTraverseableToNonTraverseable2(this.newIntent);
            }
            if (this.buttons[1].isSelected()) {
                LinkEditFunctions.this.edgeData.setActionType(this.newIntent);
            } else if (this.buttons[2].isSelected()) {
                if (this.newIntent.equalsIgnoreCase("Correct Action")) {
                    new HelpSuccessPanel(LinkEditFunctions.this.controller, LinkEditFunctions.this.edgeData, true);
                    LinkEditFunctions.this.edgeData.setBuggyMsg("");
                } else {
                    new EditBuggyMsgPanel(true);
                    LinkEditFunctions.this.edgeData.setSuccessMsg("");
                    LinkEditFunctions.this.edgeData.setHints(new Vector());
                }
                LinkEditFunctions.this.edgeData.setActionType(this.newIntent);
            }
        }
    }
}

