/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Dialogs.MatchedStatesDialog;
import edu.cmu.pact.BehaviorRecorder.Dialogs.OrderSwitchDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreationFailedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Preferences.PreferencesModel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.miss.AskHintHumanOracle;
import edu.cmu.pact.miss.MissControllerExternal;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DemonstrateModeMessageHandler {
    private BR_Controller controller;

    public DemonstrateModeMessageHandler(BR_Controller controller) {
        this.controller = controller;
    }

    public void processDemonstrateInterfaceAction(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType) {
        if (trace.getDebugCode("demo")) {
            trace.out("demo", "processDemonstrateInterfaceAction(" + selection + "," + action + "," + input + "," + actionType);
        }
        String firstSelection = (String)selection.elementAt(0);
        boolean isMissActive = this.checkForMiss();
        if (isMissActive && !this.controller.getMissController().isFoaGetterDefined() && !this.controller.getMissController().isFoaSearch()) {
            return;
        }
        boolean isHint = this.checkForHint(firstSelection);
        if (isHint) {
            return;
        }
        ProblemNode currentNode = this.controller.getSolutionState().getCurrentNode();
        if (this.checkForCurrentStateChange()) {
            return;
        }
        if (this.matchesExistingEdge(selection, action, input)) {
            if (trace.getDebugCode("npe")) {
                trace.out("npe", "processDemoIA: matchesExistingEdge(" + selection + ", " + action + ", " + input + ") true,\n  controller.getMissController() " + this.controller.getMissController());
            }
            if (!this.controller.getMissController().isPLEon()) {
                return;
            }
        }
        if (currentNode.isDoneState()) {
            this.processDoneStateMessage();
            return;
        }
        if (this.handleCheckedNode(selection, action, input, actionType)) {
            return;
        }
        if (this.controller.getCtatModeModel().isJessMode() || this.controller.getCtatModeModel().isTDKMode()) {
            this.addNewNodeForRuleEngine(selection, action, input, messageObject, actionType);
            return;
        }
        Vector updatedMatchedNodesCopy = this.controller.getProblemModel().findSameStates(this.controller.getSolutionState().getCurrentNode(), selection, action, input);
        int numberOfMatchedNodes = updatedMatchedNodesCopy.size();
        Vector updatedMatchedNodes = this.getUpdatedMatchedNodes(updatedMatchedNodesCopy, numberOfMatchedNodes);
        updatedMatchedNodesCopy = (Vector)updatedMatchedNodes.clone();
        numberOfMatchedNodes = updatedMatchedNodesCopy.size();
        SimStInteractiveLearning ssIL = null;
        try {
            ssIL = this.controller.getMissController().getSimSt().getSsInteractiveLearning();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (numberOfMatchedNodes == 0 || ssIL != null && (ssIL.isRunningFromBrd() || this.controller.getMissController().isPLEon())) {
            this.doZeroMatchedNodes(selection, action, input, messageObject, actionType);
        } else if (numberOfMatchedNodes == 1) {
            this.doOneMatchedNode(selection, action, input, messageObject, actionType, updatedMatchedNodesCopy);
        } else {
            this.doMultipleMatchedNodes(selection, action, input, messageObject, actionType, updatedMatchedNodesCopy);
        }
        this.controller.getJGraphWindow().getJGraph().scrollPointToVisible(this.controller.getCurrentNode().getNodeView().getBottomCenterPoint());
        ActionEvent ae = new ActionEvent(this, 0, "Demonstrate step [" + selection.get(0) + "," + action.get(0) + "," + input.get(0) + "]");
        this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
    }

    private boolean matchesExistingEdge(Vector selection, Vector action, Vector input) {
        ExampleTracerEvent tryTraceResult = this.tryTrace(selection, action, input);
        String tryTraceAnswer = tryTraceResult.getResult();
        if (tryTraceAnswer.equals("NO-MODEL")) {
            return false;
        }
        ProblemEdge tryTraceEdge = tryTraceResult.getReportableLink().getEdge().getEdge();
        ProblemNode targetNode = tryTraceEdge.getDest();
        if (trace.getDebugCode("demo")) {
            trace.out("demo", "is same state = " + targetNode + ", tryTraceAnswer " + tryTraceAnswer);
        }
        String actionType = tryTraceEdge.getEdgeData().getActionType();
        if (tryTraceEdge.isCorrectorFireableBuggy()) {
            ProblemNode newCurrentNode = this.controller.getExampleTracer().getCurrentNode(true);
            this.controller.setCurrentNode(newCurrentNode);
        } else if (!"Buggy Action".equalsIgnoreCase(actionType) && !"Untraceable Error".equalsIgnoreCase(actionType)) {
            trace.err("edge " + tryTraceEdge + " not isTraversable() but actionType " + actionType + " not " + "Buggy Action" + " nor " + "Untraceable Error");
        } else {
            this.controller.fireCtatModeEvent(CtatModeEvent.REPAINT);
        }
        EdgeData myEdge = tryTraceEdge.getEdgeData();
        if (this.controller.getTraversalCountEnabled()) {
            myEdge.incrementTraversalCount();
        }
        if ("Correct Action".equalsIgnoreCase(actionType)) {
            this.controller.sendCorrectActionMsg(selection, input, action);
        } else {
            this.controller.sendIncorrectActionMsg(selection, input, action);
        }
        return true;
    }

    public ExampleTracerEvent tryTrace(Vector selection, Vector action, Vector input) {
        if (trace.getDebugCode("EMS")) {
            trace.out("EMS", "" + this.controller.getExampleTracer());
        }
        this.controller.getExampleTracer().evaluate(selection, action, input, "Student");
        ExampleTracerEvent result = this.controller.getExampleTracer().getLastResult();
        if (trace.getDebugCode("EMS")) {
            trace.out("EMS", "" + result);
        }
        return result;
    }

    private Vector getUpdatedMatchedNodes(Vector matchedNodes, int sizeOfMatch) {
        Vector<ProblemNode> updatedMatchedNodes = new Vector<ProblemNode>();
        for (int i = 0; i < sizeOfMatch; ++i) {
            ProblemNode nodeTemp = (ProblemNode)matchedNodes.elementAt(i);
            if (this.controller.getSolutionState().isCurrentNodeOrParent(nodeTemp)) continue;
            updatedMatchedNodes.addElement(nodeTemp);
        }
        return updatedMatchedNodes;
    }

    private void doMultipleMatchedNodes(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType, Vector findMatchedNodes) {
        this.controller.setAllowCurrentStateChange(false);
        new MatchedStatesDialog(this.controller, this, findMatchedNodes, selection, action, input, messageObject, actionType);
    }

    private void doOneMatchedNode(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType, Vector findMatchedNodes) {
        if (trace.getDebugCode("gusIL")) {
            trace.out("gusIL", "entered doOneMatchedNode");
        }
        ProblemNode checkedNode = (ProblemNode)findMatchedNodes.elementAt(0);
        PreferencesModel prefs = this.controller.getPreferencesModel();
        Boolean alwaysLinkStates = prefs.getBooleanValue("Always Link States");
        if (trace.getDebugCode("gusIL")) {
            trace.out("gusIL", "**alwaysLinkStates** " + alwaysLinkStates + ", prefsModel " + prefs);
        }
        if (alwaysLinkStates.booleanValue()) {
            this.treatAsSameState(selection, action, input, messageObject, actionType, checkedNode);
        } else {
            ProblemNode exTracerCurrentNode = this.controller.getExampleTracer().getCurrentNode(true);
            Enumeration<ProblemEdge> iter = this.controller.getProblemModel().getProblemGraph().getConnectingEdges(exTracerCurrentNode);
            while (iter.hasMoreElements()) {
                ProblemEdge tempEdge = iter.nextElement();
                if (tempEdge.getNodes()[1] != exTracerCurrentNode || (ProblemNode)findMatchedNodes.elementAt(0) != tempEdge.getNodes()[0]) continue;
                ProblemNode newNode = this.controller.addNewState(exTracerCurrentNode, selection, action, input, messageObject, actionType);
                ProblemEdge newAddedEdge = this.controller.getProblemModel().returnsEdge(exTracerCurrentNode, newNode);
                if (newAddedEdge.isCorrectorFireableBuggy() && this.tryTrace(newAddedEdge.getEdgeData())) {
                    this.controller.setCurrentNode(newNode);
                }
                if (!this.controller.getCtatModeModel().isSimStudentMode()) continue;
                MissControllerExternal mc = this.controller.getMissController();
                if (AskHintHumanOracle.isWaitingForSai) {
                    AskHintHumanOracle.hereIsTheSai(new Sai(selection, action, input));
                    continue;
                }
                if (this.controller.getMissController().getSimSt().isInteractiveLearning()) continue;
                mc.stepDemonstrated(newNode, selection, action, input, newAddedEdge);
            }
            this.controller.setAllowCurrentStateChange(false);
            new OrderSwitchDialog(this.controller, this, checkedNode, selection, action, input, messageObject, actionType);
        }
    }

    void treatAsSameState(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType, ProblemNode checkedNode) {
        EdgeData newEdge = this.controller.createNewEdge(this.controller.getExampleTracer().getCurrentNode(true), checkedNode, selection, action, input, messageObject, actionType, this.controller.getExampleTracer().getBestInterpretation().getMatchedLinks());
        this.controller.getExampleTracer().extendPaths();
        if (newEdge.getEdge().isCorrectorFireableBuggy()) {
            boolean bl = this.tryTrace(newEdge);
        }
        this.controller.setCurrentNode(this.controller.getExampleTracer().getCurrentNode(true));
    }

    boolean tryTrace(EdgeData edgeData) {
        if (this.controller == null || this.controller.getExampleTracer() == null) {
            return false;
        }
        return this.controller.getExampleTracer().evaluate(edgeData);
    }

    private void doZeroMatchedNodes(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType) {
        ProblemNode newNode = null;
        ProblemEdge newAddedEdge = null;
        if (!VersionInformation.includesJess() || !SimStInteractiveLearning.isWaitingForDemonstration) {
            EdgeData newEdge = this.controller.createNewEdge(this.controller.getSolutionState().getCurrentNode(), null, selection, action, input, messageObject, actionType, this.controller.getExampleTracer().getBestInterpretation().getMatchedLinks());
            this.controller.getExampleTracer().extendPaths();
            if (newEdge.getEdge().isCorrectorFireableBuggy()) {
                boolean bl = this.tryTrace(newEdge);
            }
            this.controller.setCurrentNode(newEdge.getEdge().getDest());
            newNode = newEdge.getEdge().getDest();
            newAddedEdge = newEdge.getEdge();
        }
        if (this.controller.getCtatModeModel().isSimStudentMode()) {
            if (SimStInteractiveLearning.isWaitingForDemonstration) {
                Sai sai = new Sai(selection, action, input);
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "delivering the SAI: " + sai);
                }
                AskHintHumanOracle.hereIsTheSai(sai);
            } else {
                if (AskHintHumanOracle.isWaitingForSai) {
                    AskHintHumanOracle.getSaiDrop().put(new Sai(selection, action, input));
                } else if (!this.controller.getMissController().getSimSt().isInteractiveLearning()) {
                    MissControllerExternal mc = this.controller.getMissController();
                    mc.stepDemonstrated(newNode, selection, action, input, newAddedEdge);
                }
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "Trying to model trace a step...");
                }
                this.controller.tutorMessageHandler.processTutorInterfaceAction(selection, action, input, "Student", messageObject);
            }
        }
    }

    protected void addNewNodeForRuleEngine(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType) {
        ProblemEdge newAddedEdge;
        if (trace.getDebugCode("demo")) {
            trace.out("demo", "addNewNodeForRuleEngine(" + selection + ", " + action + ", " + input + ", " + actionType + ") currentNode " + this.controller.getSolutionState().getCurrentNode());
        }
        ProblemNode newNode = this.controller.addNewState(this.controller.getSolutionState().getCurrentNode(), selection, action, input, messageObject, actionType);
        if (trace.getDebugCode("demo")) {
            trace.out("demo", "addNewNodeIfNeeded() newNode name " + newNode.getName() + ", " + newNode + ", currentNode " + this.controller.getSolutionState().getCurrentNode());
        }
        if ((newAddedEdge = this.controller.getProblemModel().returnsEdge(this.controller.getSolutionState().getCurrentNode(), newNode)) != null && newAddedEdge.isCorrectorFireableBuggy()) {
            this.tryTrace(selection, action, input);
            this.controller.setCurrentNode(newNode);
            if (this.controller.getProcessTraversedLinks() != null) {
                if (trace.getDebugCode("demo")) {
                    trace.out("demo", "add traversed link to DOM");
                }
                this.controller.getProcessTraversedLinks().addLinkNode(newAddedEdge.getUniqueID(), selection, action, input, actionType);
            }
        }
    }

    private boolean handleCheckedNode(Vector selection, Vector action, Vector input, String actionType) {
        ProblemEdge checkedEdge;
        ProblemNode checkedNode = this.controller.getProblemModel().findSameChildState(this.controller.getSolutionState().getCurrentNode(), selection, action, input);
        if (checkedNode == null) {
            return false;
        }
        if (trace.getDebugCode("mps")) {
            trace.out("mps", "find matched child state");
        }
        if ((checkedEdge = this.controller.getProblemModel().returnsEdge(this.controller.getSolutionState().getCurrentNode(), checkedNode)) == null) {
            return true;
        }
        EdgeData myEdge = checkedEdge.getEdgeData();
        if (this.controller.getTraversalCountEnabled()) {
            myEdge.incrementTraversalCount();
        }
        if ((actionType.equalsIgnoreCase("Correct Action") || actionType.equalsIgnoreCase("Fireable Buggy Action")) && checkedEdge.isCorrectorFireableBuggy()) {
            this.controller.setCurrentNode(checkedNode);
        }
        if (actionType.equalsIgnoreCase("Correct Action") && myEdge.getActionType().equalsIgnoreCase("Correct Action")) {
            this.controller.sendCorrectActionMsg(selection, input, action);
        } else {
            this.controller.sendIncorrectActionMsg(selection, input, action);
        }
        return false;
    }

    private boolean checkForCurrentStateChange() {
        if (!this.controller.isAllowCurrentStateChange()) {
            String[] message = new String[]{"Please FIRST handle your current Dialog."};
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), message, "Warning", 2);
            this.controller.sendCommMsgs(this.controller.getSolutionState().getCurrentNode(), this.controller.getProblemModel().getStartNode());
            return true;
        }
        return false;
    }

    private boolean checkForMiss() {
        MissControllerExternal mc;
        if (!VersionInformation.isRunningSimSt()) {
            return false;
        }
        if (Utils.isRuntime()) {
            return false;
        }
        if (this.controller.getCtatModeModel().isSimStudentMode() && !(mc = this.controller.getMissController()).isMissHibernating() && !mc.isFocusOfAttentionSpecified()) {
            if (this.controller.getProblemModel().getStartNode() != null) {
                mc.askSpecifyFocusOfAttention();
            }
            return true;
        }
        return false;
    }

    private boolean checkForHint(String firstSelection) {
        if (firstSelection.equalsIgnoreCase("Help") || firstSelection.equalsIgnoreCase("Hint")) {
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "The use of the Help button cannot be demonstrated to the Behavior Recorder.", "Information", 1);
            return true;
        }
        return false;
    }

    private void processDoneStateMessage() {
        String[] message = new String[]{"You are not allowed to add a child state to the Done state."};
        JOptionPane.showMessageDialog(this.controller.getActiveWindow(), message, "Warning", 2);
        EdgeCreationFailedEvent evt = new EdgeCreationFailedEvent(this.controller, EdgeCreationFailedEvent.Reason.LINK_AFTER_DONE_STATE, message[0]);
        this.controller.getProblemModel().fireProblemModelEvent(evt);
        this.controller.sendCommMsgs(this.controller.getSolutionState().getCurrentNode(), this.controller.getProblemModel().getStartNode());
    }
}

