/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Controller;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.ctat.model.CtatModeModel;

public class CtatModeEvent {
    public static final CtatModeEvent REPAINT = new RepaintEvent();
    public static final CtatModeEvent CLEAR_DRAWING_AREA = new ClearDrawingAreaEvent();

    public String toString() {
        return this.getClass().getName();
    }

    public static class SetCurrentNodeEvent
    extends CtatModeEvent {
        public ProblemNode previousCurrentNode;
        public ProblemNode newCurrentNode;

        public SetCurrentNodeEvent(ProblemNode currentNode, ProblemNode previousCurrentNode) {
            this.newCurrentNode = currentNode;
            this.previousCurrentNode = previousCurrentNode;
        }
    }

    public static class RepaintEvent
    extends CtatModeEvent {
    }

    public static class ClearDrawingAreaEvent
    extends CtatModeEvent {
    }

    public static class SetModeEvent
    extends CtatModeEvent {
        private String mode;
        private String previousMode;
        private String authorMode;
        private String previousAuthorMode;

        public SetModeEvent(String mode, String previousMode, String authorMode, String previousAuthorMode) {
            this.setMode(mode);
            this.previousMode = previousMode;
            this.setAuthorMode(authorMode);
            this.previousAuthorMode = previousAuthorMode;
        }

        private void setMode(String mode) {
            if (!CtatModeModel.getModeTypeList().contains(mode)) {
                throw new RuntimeException("Unknown mode type: " + mode);
            }
            this.mode = mode;
        }

        private void setAuthorMode(String authorMode) {
            if (!CtatModeModel.getAuthorModeList().contains(authorMode)) {
                throw new RuntimeException("Unknown author mode: " + authorMode);
            }
            this.authorMode = authorMode;
        }

        public String getMode() {
            return this.mode;
        }

        public String getPreviousMode() {
            return this.previousMode;
        }

        @Override
        public String toString() {
            return "Set mode from: " + this.previousMode + " to: " + this.mode + "; authorMode from: " + this.previousAuthorMode + " to: " + this.authorMode;
        }

        public String getAuthorMode() {
            return this.authorMode;
        }

        public String getPreviousAuthorMode() {
            return this.previousAuthorMode;
        }

        public boolean modeChanged() {
            return !this.getMode().equalsIgnoreCase(this.getPreviousMode());
        }

        public boolean authorModeChanged() {
            return !this.getAuthorMode().equalsIgnoreCase(this.getPreviousAuthorMode());
        }
    }

    public static class SetVisibleEvent
    extends CtatModeEvent {
        private final boolean visible;

        public SetVisibleEvent(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    public static class SetSimStudentActivationMenuEvent
    extends CtatModeEvent {
        public boolean newStatus;

        public SetSimStudentActivationMenuEvent(boolean newStatus) {
            this.newStatus = newStatus;
        }
    }
}

