/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDiagnostics;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATMilestoneManager;
import edu.cmu.hcii.ctat.CTATUserData;
import edu.cmu.hcii.ctat.PositionWithinAssignment;
import edu.cmu.hcii.ctat.UserAssignmentInfo;
import edu.cmu.hcii.ctat.UserProblemInfo;
import edu.cmu.pact.ctat.model.Skill;
import edu.cmu.pact.ctat.model.Skills;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class UserProgressDatabase
extends CTATBase {
    private Boolean memOnly = false;
    private Map<String, CTATUserData> table = null;
    private String userprogressPath = "etc/userprogress/";
    private Map<String, String> currentAssignments = new HashMap<String, String>();

    public UserProgressDatabase(Boolean aMemOnly) throws IOException {
        this.setClassName("UserProgressDatabase");
        this.debug("UserProgressDatabase (" + aMemOnly + ")");
        this.memOnly = aMemOnly;
        if (!this.memOnly.booleanValue()) {
            this.initializeUserProgress();
        } else {
            this.table = new HashMap<String, CTATUserData>();
            this.table.put(CTATLink.userID, this.castTableEntry(new CTATUserData()));
        }
    }

    public UserProgressDatabase() throws IOException {
        this.setClassName("UserProgressDatabase");
        this.debug("UserProgressDatabase ()");
        this.initializeUserProgress();
    }

    public UserProgressDatabase(String path) throws IOException {
        this.setClassName("UserProgressDatabase");
        this.debug("UserProgressDatabase ()");
        this.userprogressPath = path;
        new File(this.userprogressPath).mkdirs();
        this.initializeUserProgress();
    }

    private synchronized void initializeUserProgress() {
        this.debug("initializeUserProgress ()");
        if (this.memOnly.booleanValue()) {
            this.debug("We're in memOnly mode, aborting ...");
            return;
        }
        CTATDiagnostics diags = new CTATDiagnostics();
        if (!diags.getWritableDirectory().booleanValue()) {
            this.debug("Error: unable to obtain a list of writable directories!");
            return;
        }
        ArrayList<String> writableDirs = diags.getWritables();
        String finalUserprogressPath = writableDirs.get(0) + "/.ctat/userprogress/";
        this.debug("Set user db directory to: " + finalUserprogressPath);
        this.userprogressPath = finalUserprogressPath;
        File userprogressDir = new File(this.userprogressPath);
        if (!userprogressDir.exists()) {
            this.debug("User progress directory doesn't exist yet, creating ...");
            userprogressDir.mkdirs();
        }
        this.table = new HashMap<String, CTATUserData>();
        File[] subfiles = userprogressDir.listFiles();
        if (subfiles == null) {
            this.debug("No files found!");
            return;
        }
        for (File f : subfiles) {
            this.debug("Loading potential user data file: " + f.getName());
            String name = f.getName();
            if (name.endsWith(".data")) {
                String userID = name.substring(0, name.length() - ".data".length());
                this.debug("Determined username to be: " + userID);
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                    CTATUserData streamedObject = (CTATUserData)ois.readObject();
                    try {
                        this.table.put(userID, this.castTableEntry(streamedObject));
                    }
                    catch (ClassCastException e) {
                        this.debug("Error: the class stored in " + name + " is not what is expected to be loaded");
                    }
                    ois.close();
                    CTATMilestoneManager manager = streamedObject.getMilestoneManager();
                    if (manager != null) {
                        if (!manager.isEmpty().booleanValue()) continue;
                        manager.initialize();
                        continue;
                    }
                    this.debug("Error: user info doesn't contain a milestone manager");
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
                continue;
            }
            this.debug("File " + name + " does not end in .data");
        }
        this.debug("Loaded " + this.table.size() + " users");
    }

    public CTATUserData getUser(String anID) {
        return this.table.get(anID.toLowerCase());
    }

    public CTATUserData addUser(String anID) {
        this.debug("addUser (" + anID + ")");
        CTATUserData aUser = new CTATUserData();
        aUser.username = anID.toLowerCase();
        CTATMilestoneManager manager = aUser.getMilestoneManager();
        if (manager != null) {
            manager.initialize();
        }
        this.table.put(anID, aUser);
        return aUser;
    }

    private CTATUserData castTableEntry(Object serializedObject) {
        return (CTATUserData)serializedObject;
    }

    public Boolean getMemOnly() {
        return this.memOnly;
    }

    public void setMemOnly(Boolean memOnly) {
        this.memOnly = memOnly;
    }

    public synchronized void setCurrentProblem(String userID, String assignmentName, String problemSetName, int position, boolean writeToDisk) throws IOException {
        this.debug("setCurrentProblem ()");
        if (userID == null || assignmentName == null || problemSetName == null) {
            throw new IllegalArgumentException("UserProgressDatabase.setCurrentProblem does not accept null arguments");
        }
        this.currentAssignments.put(userID, assignmentName);
        UserAssignmentInfo uai = this.getUserAssignmentInfo(userID, assignmentName, true);
        if (uai == null) {
            throw new IllegalArgumentException("User \"" + userID + "\" does not exist.");
        }
        uai.currentProblemPosition = new PositionWithinAssignment(problemSetName, position);
        if (writeToDisk && !this.memOnly.booleanValue()) {
            this.saveUserProgress(userID);
        }
    }

    public synchronized PositionWithinAssignment getCurrentProblem(String userID, String assignmentName) {
        this.debug("getCurrentProblem ()");
        UserAssignmentInfo uai = this.getUserAssignmentInfo(userID, assignmentName, false);
        if (uai == null || uai.currentProblemPosition == null) {
            return null;
        }
        this.currentAssignments.put(userID, assignmentName);
        return new PositionWithinAssignment(uai.currentProblemPosition.problemSet, uai.currentProblemPosition.position);
    }

    public synchronized int getPositionWithinProblemSet(String userID, String problemSetName) {
        this.debug("getPositionWithinProblemSet (" + userID + "," + problemSetName + ")");
        if (userID == null || problemSetName == null) {
            return -1;
        }
        CTATUserData aUser = this.table.get(userID.toLowerCase());
        if (aUser == null) {
            return -1;
        }
        Map<String, UserAssignmentInfo> thisUsersInfo = aUser.getAssignmentInfo();
        if (thisUsersInfo == null) {
            return -1;
        }
        Set<String> keys = thisUsersInfo.keySet();
        for (String assignmentName : keys) {
            UserAssignmentInfo UAI = thisUsersInfo.get(assignmentName);
            PositionWithinAssignment currentPosition = UAI.currentProblemPosition;
            if (currentPosition == null || !problemSetName.equals(currentPosition.problemSet)) continue;
            this.currentAssignments.put(userID, assignmentName);
            return currentPosition.position;
        }
        return -1;
    }

    public synchronized void setProblemState(String userID, String assignmentName, String problemSetName, int position, String problem_state, boolean writeToDisk) throws IOException {
        this.debug("setProblemState ()");
        if (userID == null || assignmentName == null || problemSetName == null) {
            throw new IllegalArgumentException("userID, assignmentName, and problemSetName cannot be null in UserProgressDatabase.setProblemState");
        }
        this.currentAssignments.put(userID, assignmentName);
        UserAssignmentInfo uai = this.getUserAssignmentInfo(userID, assignmentName, true);
        PositionWithinAssignment pwa = new PositionWithinAssignment(problemSetName, position);
        UserProblemInfo upi = uai.problemInfoMap.get(pwa);
        if (upi == null) {
            upi = new UserProblemInfo(problem_state, null);
            uai.problemInfoMap.put(pwa, upi);
        } else {
            upi.problemState = problem_state;
        }
        if (writeToDisk && !this.memOnly.booleanValue()) {
            this.saveUserProgress(userID);
        }
    }

    public synchronized void setProblemSummary(String userID, String assignmentName, String problemSetName, int position, String summary, boolean writeToDisk) throws IOException {
        this.debug("setProblemSummary ()");
        if (userID == null) {
            this.debug("Error: userID is null");
            throw new IllegalArgumentException("userID, assignmentName, and problemSetName cannot be null in UserProgressDatabase.setProblemSummary");
        }
        if (assignmentName == null) {
            this.debug("Error: userID is assignmentName");
            throw new IllegalArgumentException("userID, assignmentName, and problemSetName cannot be null in UserProgressDatabase.setProblemSummary");
        }
        if (problemSetName == null) {
            this.debug("Error: userID is problemSetName");
            throw new IllegalArgumentException("userID, assignmentName, and problemSetName cannot be null in UserProgressDatabase.setProblemSummary");
        }
        this.currentAssignments.put(userID, assignmentName);
        UserAssignmentInfo uai = this.getUserAssignmentInfo(userID, assignmentName, true);
        PositionWithinAssignment pwa = new PositionWithinAssignment(problemSetName, position);
        UserProblemInfo upi = uai.problemInfoMap.get(pwa);
        CTATUserData aUser = this.table.get(userID.toLowerCase());
        if (aUser != null) {
            String extractedSkills = this.parseSkills(summary);
            if (extractedSkills.isEmpty()) {
                this.debug("Info: no skills in problem summary");
            } else {
                this.debug("Extracted skills: " + extractedSkills);
                aUser.skillXML = extractedSkills;
                try {
                    Skills newSkills = Skills.factory(extractedSkills);
                    this.updateSkills(newSkills, aUser);
                }
                catch (Exception e) {
                    this.debug("Error extracting skills from problem summary xml");
                    e.printStackTrace();
                }
            }
        } else {
            this.debug("Error no user object found for: " + aUser);
        }
        if (upi == null) {
            upi = new UserProblemInfo(null, summary);
            uai.problemInfoMap.put(pwa, upi);
        } else {
            upi.problemSummary = summary;
        }
        if (writeToDisk && !this.memOnly.booleanValue()) {
            this.saveUserProgress(userID);
        }
    }

    private String parseSkills(String aSummary) {
        this.debug("parseSkills ()");
        StringBuffer pref = new StringBuffer();
        pref.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try {
            pref.append(URLDecoder.decode(aSummary, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
        this.debug("Parsing: " + pref.toString());
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(pref.toString()));
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        Element skillElement = root.getChild("Skills");
        if (skillElement != null) {
            XMLOutputter outputter = new XMLOutputter();
            String result = outputter.outputString(skillElement);
            return result;
        }
        this.debug("No Skills element found in problem summary!");
        return "";
    }

    public synchronized String getProblemState(String userID, String assignmentName, String problemSetName, int position) {
        this.debug("getProblemState ()");
        UserAssignmentInfo uai = this.getUserAssignmentInfo(userID, assignmentName, false);
        if (uai == null) {
            return null;
        }
        if (problemSetName == null) {
            return null;
        }
        this.currentAssignments.put(userID, assignmentName);
        PositionWithinAssignment pwa = new PositionWithinAssignment(problemSetName, position);
        UserProblemInfo upi = uai.problemInfoMap.get(pwa);
        if (upi == null) {
            return null;
        }
        return upi.problemState;
    }

    public synchronized String getProblemSummary(String userID, String assignmentName, String problemSetName, int position) {
        this.debug("getProblemSummary ()");
        UserAssignmentInfo uai = this.getUserAssignmentInfo(userID, assignmentName, false);
        if (uai == null) {
            return null;
        }
        if (problemSetName == null) {
            return null;
        }
        this.currentAssignments.put(userID, assignmentName);
        PositionWithinAssignment pwa = new PositionWithinAssignment(problemSetName, position);
        UserProblemInfo upi = uai.problemInfoMap.get(pwa);
        if (upi == null) {
            return null;
        }
        return upi.problemSummary;
    }

    public synchronized String getProblemStateStatus(String userID, String assignmentName, String problemSetName, int position) {
        this.debug("getProblemStateStatus ()");
        this.currentAssignments.put(userID, assignmentName);
        String EMPTY = "empty";
        String INCOMPLETE = "incomplete";
        String COMPLETE = "complete";
        String summary = this.getProblemSummary(userID, assignmentName, problemSetName, position);
        if (summary == null) {
            return "empty";
        }
        try {
            summary = URLDecoder.decode(summary, "UTF-8");
            if (summary.contains("CompletionStatus=\"complete\"")) {
                return "complete";
            }
            return "incomplete";
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public synchronized String getCurrentAssignment(String userID) {
        return this.currentAssignments.get(userID);
    }

    private synchronized UserAssignmentInfo getUserAssignmentInfo(String userID, String assignmentName, boolean createIfMissing) {
        UserAssignmentInfo uai;
        this.debug("getUserAssignmentInfo (" + userID + "," + assignmentName + ")");
        if (userID == null) {
            this.debug("Error: userID is null");
            return null;
        }
        if (assignmentName == null) {
            this.debug("Error: assignmentName is null");
            return null;
        }
        CTATUserData aUser = this.table.get(userID.toLowerCase());
        if (aUser == null) {
            return null;
        }
        Map<String, UserAssignmentInfo> thisUsersInfo = aUser.getAssignmentInfo();
        if (thisUsersInfo == null) {
            this.debug("thisUsersInfo is null, see if we should create it ...");
            if (createIfMissing) {
                thisUsersInfo = new HashMap<String, UserAssignmentInfo>();
                aUser.createAssignmentInfo();
            } else {
                this.debug("Error: thisUserInfo is null but we're not allowed to create it");
                return null;
            }
        }
        if ((uai = thisUsersInfo.get(assignmentName)) == null) {
            this.debug("UserAssignmentInfo is null, see if we should create it ...");
            if (createIfMissing) {
                uai = new UserAssignmentInfo();
                thisUsersInfo.put(assignmentName, uai);
            } else {
                this.debug("Error: UserAssignmentInfo is null but we're not allowed to create it");
                return null;
            }
        }
        return uai;
    }

    public synchronized boolean saveUserProgress() {
        this.debug("saveUserProgress ()");
        Set<String> userIDs = this.table.keySet();
        boolean success = true;
        for (String id : userIDs) {
            try {
                this.saveUserProgress(id);
            }
            catch (IOException e) {
                success = false;
                this.debug("Error saving user progress database");
            }
        }
        return success;
    }

    public synchronized void saveUserProgress(String userID) throws IOException {
        this.debug("saveUserProgress (" + userID + ")");
        if (userID == null) {
            return;
        }
        CTATUserData aUser = this.table.get(userID.toLowerCase());
        if (aUser == null) {
            this.debug("Error: no user data object associated with this user!");
            return;
        }
        File f = new File(this.userprogressPath, userID + ".data");
        this.debug("Writing file: " + f.getAbsolutePath());
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        oos.writeObject(aUser);
        oos.close();
        this.debug("All done");
    }

    private void updateSkills(Skills newSkillObject, CTATUserData aUser) {
        this.debug("updateSkills ()");
        CTATMilestoneManager mManager = aUser.milestoneManager;
        List<Skill> targetSkills = newSkillObject.getAllSkills();
        for (int i = 0; i < targetSkills.size(); ++i) {
            Skill aSkill = targetSkills.get(i);
            if (!(aSkill.getPKnown().floatValue() > aSkill.getMasteryThreshold())) continue;
            mManager.checkSkillMilestone(aSkill.getName(), this.currentAssignments.get(aUser.username));
        }
    }
}

