/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATCharsetFunctions;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATWSFrameData;
import edu.cmu.hcii.ctat.CTATWSFrameProcessor;
import edu.cmu.pact.SocketProxy.HTTPToolProxy;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.BASE64Encoder;

public class CTATHTTPExchange
extends CTATBase
implements Runnable {
    private static SimpleDateFormat respDateFmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    private State state = State.HTTP;
    private CTATWSFrameProcessor wsFrameProcessor = new CTATWSFrameProcessor();
    private CTATWSFrameData currentFrame;
    private Thread wsThread = null;
    private static final String TUTORSHOP_COOKIE_DELETED = "tutorshop_cookie_deleted";
    private boolean initialized = false;
    private Socket socket = null;
    private Map<String, List<String>> requestHeaders = null;
    private Map<String, String> requestHeadersConcatenated = null;
    private Map<String, List<String>> responseHeaders = null;
    private byte[] requestBody;
    private InputStream requestBodyStream = null;
    private String requestMethod;
    private URI requestURI;
    private String requestProtocolString;
    private boolean responseHeadersSent = false;
    private InputStream requestIn;
    private int responseCode = -1;
    private boolean badRequest = false;
    private static final Charset defaultCharset = Charset.forName("ISO-8859-1");
    private Charset requestCharset = defaultCharset;
    private Map<String, String> requestParameters;
    private static final Pattern charsetPattern = Pattern.compile(".*charset=([-a-zA-Z0-9]+)");
    private SendOnCloseOutputStream responseTank = null;
    private BufferedOutputStream bufferedResponseOut = null;
    private String requestBodyAsString = null;
    private CTATHTTPHandlerInterface handler;
    private HTTPToolProxy httpToolProxy = null;

    public CTATHTTPExchange() {
        this.setClassName("CTATHTTPExchange");
        this.debug("CTATHTTPExchange()");
    }

    public CTATHTTPExchange(Socket s) throws IOException {
        this.setClassName("CTATHTTPExchange");
        this.debug("CTATHTTPExchange()");
        this.socket = s;
        this.requestIn = new BufferedInputStream(this.socket.getInputStream());
        int bodyLength = this.readRequestHeaders(this.requestIn);
        this.readRequestBody(this.requestIn, bodyLength);
        if (!this.badRequest) {
            this.initialized = true;
        } else {
            this.debug("Bad request for: " + this.socket);
        }
        this.checkWebsocketConnection();
    }

    private boolean checkWebsocketConnection() {
        this.debug("checkWebsocketConnection ()");
        String wsConnection = this.getRequestHeaderConcatenatedLazy("Connection");
        if (wsConnection != null) {
            this.debug("Potential websocket request found, checking ...");
            String wsUpgrade = this.getRequestHeaderConcatenatedLazy("Upgrade");
            if (wsUpgrade != null) {
                if (wsUpgrade.equalsIgnoreCase("websocket")) {
                    this.debug("Confirmed, we are in a web socket situation, configuring and confirming to client ...");
                    this.setWS(true);
                    return true;
                }
                this.debug("Websocket handshake failed, Upgrade field was: " + wsUpgrade);
            }
        }
        this.debug("Connection does not appear to be a websocket connection");
        return false;
    }

    public BufferedOutputStream getOutputStream() {
        if (this.socket == null) {
            this.debug("Socket is null, already closed?");
            return null;
        }
        OutputStream responseOut = null;
        if (this.bufferedResponseOut == null) {
            try {
                responseOut = this.socket.getOutputStream();
                this.bufferedResponseOut = new BufferedOutputStream(responseOut);
            }
            catch (Exception e) {
                this.debug("Error sending headers! " + e.getMessage());
                e.printStackTrace();
            }
        }
        return this.bufferedResponseOut;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void checkSocket() {
        this.debug("checkSocket ()");
        if (this.socket == null) {
            this.debug("Socket is null");
            return;
        }
        if (this.socket.isBound()) {
            this.debug("Socket is bound");
        } else {
            this.debug("Socket is unbound");
        }
        if (this.socket.isClosed()) {
            this.debug("Socket is closed");
        } else {
            this.debug("Socket is open");
        }
        if (this.socket.isConnected()) {
            this.debug("Socket is connected");
        } else {
            this.debug("Socket is not connected");
        }
    }

    public Boolean processSocket(Socket s) {
        this.debug("processSocket()");
        this.socket = s;
        try {
            this.requestIn = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (IOException e) {
            this.debug("IO Exception in getting buffered input stream from socket");
            e.printStackTrace();
            return false;
        }
        int bodyLength = 0;
        try {
            bodyLength = this.readRequestHeaders(this.requestIn);
        }
        catch (IOException e) {
            this.debug("IO Exception in getting request headers");
            e.printStackTrace();
            return false;
        }
        this.checkWebsocketConnection();
        try {
            this.readRequestBody(this.requestIn, bodyLength);
            this.debug("CTATHTTPExch.processSocket() badRequest " + this.badRequest + ",\n  requestHeaders " + this.requestHeaders + ",\n  requestParameters " + this.requestParameters + ",\n  requestBody " + this.requestBody);
        }
        catch (IOException e) {
            this.debug("IO Exception in reading request body");
            e.printStackTrace();
            return false;
        }
        if (this.badRequest) {
            this.debug("Bad request for: " + this.socket);
            return false;
        }
        this.initialized = true;
        return true;
    }

    private boolean onMessage(String stringUtf8) {
        this.debug(String.format("onMessage(String) length %d, char[0-59] %.60s", stringUtf8.length(), stringUtf8));
        if (this.isWS() && stringUtf8.indexOf("--test") == 0) {
            this.debug("Detected a ping/echo request, sending back as-is ...");
            this.WSSend(stringUtf8, 200);
            return false;
        }
        if (this.handler != null) {
            this.handler.handle(this, stringUtf8);
            return false;
        }
        trace.err("CTATHTTPExchange.onMessage(String) no handler");
        return true;
    }

    private boolean onMessage(byte[] aBlock) {
        this.debug("onMessage (byte []) length " + aBlock.length);
        trace.err("CTATHTTPExchange.onMessage(byte[]) no processing of binary data");
        return true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public InputStream getInputStream() {
        return this.requestIn;
    }

    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    public int getRemotePort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    public URI getRequestURI() {
        if (!this.initialized) {
            return null;
        }
        return this.requestURI;
    }

    public String getRequestMethod() {
        if (!this.initialized) {
            return null;
        }
        return this.requestMethod;
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort());
    }

    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort());
    }

    public String getProtocol() {
        if (!this.initialized) {
            return null;
        }
        return this.requestProtocolString;
    }

    public int getResponseCode() {
        if (!this.initialized) {
            return 0;
        }
        return this.responseCode;
    }

    public Map<String, List<String>> getRequestHeaders() {
        if (!this.initialized) {
            return null;
        }
        TreeMap<String, List<String>> mapCopy = new TreeMap<String, List<String>>(this.requestHeaders);
        Set<String> keySet = this.requestHeaders.keySet();
        for (String key : keySet) {
            List<String> oldList = this.requestHeaders.get(key);
            ArrayList<String> newList = new ArrayList<String>();
            for (String value : oldList) {
                newList.add(value);
            }
            mapCopy.put(key, newList);
        }
        return mapCopy;
    }

    public List<String> getRequestHeader(String name) {
        if (!this.initialized) {
            return null;
        }
        if (name == null || name.length() < 1) {
            return null;
        }
        List<String> value = this.requestHeaders.get(name = name.toLowerCase());
        if (value == null) {
            return null;
        }
        return new ArrayList<String>(value);
    }

    public String getRequestHeaderConcatenatedLazy(String name) {
        if (name == null || name.length() < 1) {
            return null;
        }
        name = name.toLowerCase();
        try {
            return this.requestHeadersConcatenated.get(name);
        }
        catch (Exception e) {
            trace.errStack("CTATHTTPExchange: error getting request header \"" + name + "\"", e);
            return null;
        }
    }

    public String getRequestHeaderConcatenated(String name) {
        if (!this.initialized) {
            return null;
        }
        if (name == null || name.length() < 1) {
            return null;
        }
        name = name.toLowerCase();
        return this.requestHeadersConcatenated.get(name);
    }

    public InputStream getRequestBody() {
        this.debug("getRequestBody() ");
        if (!this.initialized) {
            return null;
        }
        if (this.requestBodyStream == null) {
            this.requestBodyStream = new ByteArrayInputStream(this.requestBody);
        }
        return this.requestBodyStream;
    }

    public Map<String, List<String>> getResponseHeaders() {
        this.debug("getResponseHeaders() ");
        if (!this.initialized) {
            return null;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new TreeMap<String, List<String>>();
        }
        return this.responseHeaders;
    }

    public Map<String, List<String>> addResponseHeader(String fieldName, String fieldValue) {
        this.debug("addResponseHeader (" + fieldName + "," + fieldValue + ")");
        if (!this.initialized) {
            this.debug("Error: CTATHTTPExchange object has not been initialized");
            return null;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new TreeMap<String, List<String>>();
        }
        if (this.responseHeaders.containsKey(fieldName)) {
            this.responseHeaders.get(fieldName).add(fieldValue);
        } else {
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(fieldValue);
            this.responseHeaders.put(fieldName, valueList);
        }
        return this.responseHeaders;
    }

    public void send404(String aMessage) {
        this.debug("send404 (" + aMessage + ")");
        this.addResponseHeader("Content-Type", "text/plain");
        this.sendResponseHeaders(404, aMessage.length());
        this.writeBytesString(aMessage, false);
        this.close();
    }

    public void sendOptions() {
        this.debug("sendOptions ()");
        String aMessage = "";
        this.addResponseHeader("Content-Type", "text/plain");
        this.addResponseHeader("Allow", "GET,HEAD,POST,OPTIONS,TRACE");
        this.sendResponseHeaders(200, aMessage.length());
        this.writeBytesString(aMessage, true);
    }

    public void sendResponseHeaders(int rCode, long responseLength) {
        this.debug("sendResponseHeaders (" + rCode + "," + responseLength + ")");
        if (!this.initialized) {
            this.debug("Error: CTATHTTPExchange object has not been initialized");
            return;
        }
        if (this.responseTank != null) {
            this.debug("Can't call sendResponseHeaders if responseTank is being used");
            return;
        }
        if (this.responseHeaders == null) {
            this.debug("INFO: no response headers available, generating new ones ...");
            this.responseHeaders = new TreeMap<String, List<String>>();
        } else {
            this.debug("We have proper pre-existing response headers, re-using ...");
        }
        this.responseCode = rCode;
        String CRLF = "\r\n";
        String statusLine = "HTTP/1.1 " + rCode + " " + this.getReasonPhrase(rCode) + "\r\n";
        if (responseLength > 0L) {
            ArrayList<String> contentLengthList = new ArrayList<String>();
            contentLengthList.add("" + responseLength);
            this.responseHeaders.put("Content-Length", contentLengthList);
        }
        ArrayList<String> connectionList = new ArrayList<String>();
        if (!this.isWS()) {
            this.debug("Setting Connection header field to 'close' (we're not in a websocket condition)");
            connectionList.add("close");
            this.responseHeaders.put("Connection", connectionList);
        } else {
            this.debug("Bypassing Connection header configuration, we're in a websocket condition so the connection should not be closed");
        }
        ArrayList<String> dateList = new ArrayList<String>();
        dateList.add(respDateFmt.format(new Date()));
        this.responseHeaders.put("Date", dateList);
        this.writeBytesString(statusLine, true);
        Set<String> keySet = this.responseHeaders.keySet();
        for (String key : keySet) {
            StringBuilder thisLine = new StringBuilder(key + ": ");
            List<String> values = this.responseHeaders.get(key);
            Iterator<String> valuesIter = values.iterator();
            while (valuesIter.hasNext()) {
                thisLine.append(valuesIter.next());
                if (!valuesIter.hasNext()) continue;
                if ("Set-Cookie".equalsIgnoreCase(key)) {
                    thisLine.append("\r\n").append(key).append(": ");
                    continue;
                }
                thisLine.append(", ");
            }
            thisLine.append("\r\n");
            if (key.contains("Cookie")) {
                this.debug("Sending Cookie directive:\n  " + thisLine);
            }
            this.debug("Writing header: " + thisLine.toString());
            this.writeBytesString(thisLine.toString(), true);
        }
        this.debug("Writing bytes ...");
        this.writeBytesString("\r\n", true);
        this.debug("Flushing socket ...");
        try {
            this.bufferedResponseOut.flush();
        }
        catch (IOException e) {
            this.debug("Error flushing response output");
            e.printStackTrace();
        }
        this.responseHeadersSent = true;
        this.debug("Response headers sent");
    }

    public OutputStream getResponseTank() {
        if (this.initialized && !this.responseHeadersSent) {
            if (this.responseTank == null) {
                this.responseTank = new SendOnCloseOutputStream(this);
            }
            return this.responseTank;
        }
        return null;
    }

    private void sendReponseTank() throws IOException {
        this.debug("sendReponseTank ()");
        if (this.initialized && !this.responseHeadersSent && this.responseTank != null) {
            this.sendResponseHeaders(200, this.responseTank.size());
            this.writeBytes(this.responseTank.toByteArray());
        }
    }

    public void writeBytes(byte[] aMessage) {
        this.debug("writeBytes ()");
        if (this.isClosed()) {
            if (trace.getDebugCode("ws")) {
                trace.out("ws", "CTATHTTPExchange.writeBytes(): connection " + (Object)((Object)this.state) + "; discarding message of length " + aMessage.length);
            }
            return;
        }
        BufferedOutputStream bufferedResponseOut = this.getOutputStream();
        try {
            bufferedResponseOut.write(aMessage);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            bufferedResponseOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeBytesString(String aMessage, Boolean isHeader) {
        this.writeBytesString(aMessage, isHeader, null);
    }

    public void writeBytesString(String aMessage, Boolean isHeader, String encoding) {
        this.debug("writeBytesString ()");
        encoding = encoding == null ? "ISO-8859-1" : encoding;
        BufferedOutputStream bufferedResponseOut = this.getOutputStream();
        if (isHeader.booleanValue()) {
            try {
                bufferedResponseOut.write(aMessage.getBytes(encoding));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if (!this.isWS()) {
            try {
                bufferedResponseOut.write(aMessage.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.WSSend(aMessage);
        }
        try {
            bufferedResponseOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isClosed() {
        return !this.initialized || this.socket == null || this.state == State.WS_CLOSED || this.state == State.WS_CLOSE_SENT;
    }

    public void close() {
        this.debug("close ()");
        if (!this.initialized) {
            this.debug("initialized == false");
            return;
        }
        if (this.socket == null) {
            this.debug("Socket already closed");
            return;
        }
        if (this.responseTank != null) {
            try {
                this.responseTank.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.isWS()) {
            this.processWSClose();
        }
        if (this.bufferedResponseOut != null) {
            this.debug("Closing output buffer ...");
            try {
                this.bufferedResponseOut.flush();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                this.bufferedResponseOut.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bufferedResponseOut = null;
        }
        this.debug("Closing requestIn");
        try {
            if (this.requestIn != null) {
                this.requestIn.close();
            } else {
                this.debug("Error: requestIn is null");
            }
        }
        catch (IOException e) {
            this.debug("Error closing requestIn");
        }
        this.requestIn = null;
        this.debug("Trying to close socket ...");
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.debug("Error closing socket");
            }
        } else {
            this.debug("Socket already closed!");
        }
        this.socket = null;
    }

    private int readRequestHeaders(InputStream requestIn) throws IOException {
        int b;
        this.debug("readRequestHeaders ()");
        int contentLength = 0;
        boolean chunkedEncoding = false;
        ByteArrayOutputStream requestLine = new ByteArrayOutputStream();
        while ((b = requestIn.read()) == 10 || b == 13) {
        }
        do {
            requestLine.write(b);
        } while (b != 10 && b != -1 && (b = requestIn.read()) != -1);
        byte[] bytes = requestLine.toByteArray();
        if (trace.getDebugCode("ll")) {
            StringBuilder sb = new StringBuilder(String.format("bytes.length %d;\n ", bytes.length));
            for (int i = 0; i < bytes.length && i < 10; ++i) {
                sb.append(" 0x").append(Integer.toHexString(bytes[i]));
            }
            trace.out("ll", sb.toString());
        }
        String requestLineStr = new String(bytes, "ISO-8859-1");
        String[] requestLineComponents = requestLineStr.split(" ");
        for (int t = 0; t < requestLineComponents.length; ++t) {
            String jsTest = requestLineComponents[t];
            if (jsTest.indexOf("/http") == -1) continue;
            requestLineComponents[t] = jsTest.substring(1);
        }
        if (requestLineComponents.length != 3) {
            this.handleBadRequest();
            return 0;
        }
        this.requestMethod = requestLineComponents[0].trim();
        String fullURI = requestLineComponents[1].trim();
        this.debug("Processing request URI: " + fullURI);
        try {
            this.requestURI = new URI(fullURI);
        }
        catch (Exception e) {
            this.handleBadRequest();
            return 0;
        }
        this.requestProtocolString = requestLineComponents[2].trim();
        if (this.requestHeaders == null) {
            this.requestHeaders = new TreeMap<String, List<String>>();
            this.requestHeadersConcatenated = new HashMap<String, String>();
        }
        ByteArrayOutputStream currentLine = new ByteArrayOutputStream();
        b = requestIn.read();
        while (b != -1) {
            block25: {
                int nextByte;
                block26: {
                    block28: {
                        String[] fieldValues;
                        String fieldName;
                        block29: {
                            block27: {
                                currentLine.write(b);
                                if (b != 10) break block25;
                                String currentLineString = new String(currentLine.toByteArray(), "ISO-8859-1");
                                if (currentLineString.equals("\r\n") || currentLineString.equals("\n")) break;
                                nextByte = requestIn.read();
                                if (nextByte == 32 || nextByte == 9) break block26;
                                int colonPosition = currentLineString.indexOf(58);
                                if (colonPosition < 0) {
                                    this.handleBadRequest();
                                    return 0;
                                }
                                fieldName = currentLineString.substring(0, colonPosition).trim().toLowerCase();
                                String entireFieldValue = currentLineString.substring(colonPosition + 1).trim();
                                fieldValues = entireFieldValue.split(",");
                                ArrayList<String> fieldValueList = new ArrayList<String>();
                                for (String fieldValue : fieldValues) {
                                    fieldValueList.add(fieldValue.trim());
                                }
                                if (fieldName.equalsIgnoreCase("Connection")) {
                                    this.debug("Found Connection header: " + entireFieldValue);
                                    this.requestHeadersConcatenated.put("Connection", entireFieldValue);
                                }
                                if (fieldName.equalsIgnoreCase("Upgrade")) {
                                    this.debug("Found Upgrade header: " + entireFieldValue);
                                    this.requestHeadersConcatenated.put("Upgrade", entireFieldValue);
                                }
                                if (fieldName.equalsIgnoreCase("Sec-WebSocket-Key")) {
                                    this.debug("Found Sec-WebSocket-Key header: " + entireFieldValue);
                                    this.requestHeadersConcatenated.put("Sec-WebSocket-Key header", entireFieldValue);
                                }
                                if (fieldName.equalsIgnoreCase("Sec-WebSocket-Protocol")) {
                                    this.debug("Found Sec-WebSocket-Protocol header: " + entireFieldValue);
                                    this.requestHeadersConcatenated.put("Sec-WebSocket-Protocol", entireFieldValue);
                                }
                                if (!this.requestHeaders.containsKey(fieldName)) {
                                    this.requestHeaders.put(fieldName, fieldValueList);
                                    this.requestHeadersConcatenated.put(fieldName, entireFieldValue);
                                } else {
                                    List<String> newValueList = this.requestHeaders.get(fieldName);
                                    for (String value : fieldValueList) {
                                        newValueList.add(value);
                                    }
                                    this.requestHeaders.put(fieldName, newValueList);
                                    String newValue = this.requestHeadersConcatenated.get(fieldName);
                                    newValue = newValue + "," + entireFieldValue;
                                    this.requestHeadersConcatenated.put(fieldName, newValue);
                                }
                                if (fieldName.equalsIgnoreCase("Cookie")) {
                                    this.debug("Cookie: (raw) " + currentLineString + "\n  (table): " + this.requestHeaders.get("Cookie"));
                                }
                                if (!fieldName.equalsIgnoreCase("Content-Length")) break block27;
                                contentLength = Integer.valueOf(fieldValues[0].trim());
                                break block28;
                            }
                            if (!fieldName.equalsIgnoreCase("Transfer-Encoding")) break block29;
                            if (fieldValues[0].equalsIgnoreCase("identity")) break block28;
                            chunkedEncoding = true;
                            break block28;
                        }
                        if (fieldName.equalsIgnoreCase("Content-Type")) {
                            for (String field : fieldValues) {
                                Matcher m = charsetPattern.matcher(field);
                                if (!m.find()) continue;
                                String charsetName = m.group(1);
                                try {
                                    this.requestCharset = Charset.forName(charsetName);
                                }
                                catch (Exception e) {
                                    trace.errStack("Error interpreting charset name \"" + charsetName + "\" in HTTP header " + fieldName, e);
                                    this.requestCharset = defaultCharset;
                                }
                                break;
                            }
                        }
                    }
                    currentLine = new ByteArrayOutputStream();
                }
                b = nextByte;
                continue;
            }
            b = requestIn.read();
        }
        if (chunkedEncoding) {
            contentLength = -1;
        }
        return contentLength;
    }

    private void readRequestBody(InputStream requestIn, int contentLength) throws IOException {
        this.debug("readRequestBody (" + requestIn + ", " + contentLength + ")");
        if (contentLength >= 0) {
            int n;
            this.requestBody = new byte[contentLength];
            for (n = 0; n < contentLength; n += requestIn.read(this.requestBody, n, contentLength - n)) {
                this.debug("readRequestBody so far has read n=" + n);
            }
            this.debug("readRequestBody read total n=" + n + " bytes");
            this.requestParameters = this.extractRequestParameters(this.requestBody);
            this.debug("readRequestBody requestParameters " + this.requestParameters);
        } else {
            boolean lastChunkRead = false;
            ByteArrayOutputStream messageBody = new ByteArrayOutputStream();
            while (!lastChunkRead) {
                String firstLineString;
                int semicolonPosition;
                String chunkSizeHex;
                int chunkSize;
                int b;
                ByteArrayOutputStream firstLine = new ByteArrayOutputStream();
                while ((b = requestIn.read()) != -1) {
                    firstLine.write(b);
                    if (b != 10) continue;
                }
                if ((chunkSize = Integer.parseInt(chunkSizeHex = (semicolonPosition = (firstLineString = new String(firstLine.toByteArray(), "ISO-8859-1")).indexOf(59)) == -1 ? firstLineString.trim() : firstLineString.substring(0, semicolonPosition).trim(), 16)) == 0) {
                    lastChunkRead = true;
                    continue;
                }
                for (int i = 0; i < chunkSize && (b = requestIn.read()) != -1; ++i) {
                    messageBody.write(b);
                }
                b = requestIn.read();
                if (b != 13 && b != 10) {
                    this.handleBadRequest();
                    return;
                }
                if (b != 13 || (b = requestIn.read()) == 10) continue;
                this.handleBadRequest();
                return;
            }
            this.requestBody = messageBody.toByteArray();
            Set<String> keySet = this.requestHeaders.keySet();
            for (String fieldName : keySet) {
                if (!fieldName.equalsIgnoreCase("Transfer-Encoding")) continue;
                List<String> transferEncodingValues = this.requestHeaders.get(fieldName);
                for (String value : transferEncodingValues) {
                    if (!value.equalsIgnoreCase("chunked")) continue;
                    transferEncodingValues.remove(value);
                    if (transferEncodingValues.size() == 0) {
                        this.requestHeaders.remove(fieldName);
                    }
                    return;
                }
            }
        }
    }

    public Map<String, String> getRequestParameters() {
        if (this.requestParameters == null) {
            return new LinkedHashMap<String, String>();
        }
        return this.requestParameters;
    }

    private Map<String, String> extractRequestParameters(byte[] requestBody) {
        this.debug("extractRequestParameters ()");
        int e = 0;
        LinkedHashMap<String, String> requestParameters = null;
        while (e < requestBody.length) {
            String paramPair;
            byte c = requestBody[e];
            while (c == 38 && ++e < requestBody.length) {
                c = requestBody[e];
            }
            if (e >= requestBody.length) break;
            int s = e;
            while (c != 38 && ++e < requestBody.length) {
                c = requestBody[e];
            }
            try {
                paramPair = new String(CTATHTTPExchange.copyOfRange(requestBody, s, e), this.requestCharset.name());
            }
            catch (UnsupportedEncodingException ex) {
                paramPair = new String(CTATHTTPExchange.copyOfRange(requestBody, s, e));
            }
            int k = paramPair.indexOf(61);
            if (requestParameters == null) {
                requestParameters = new LinkedHashMap<String, String>();
            }
            if (k > 0) {
                requestParameters.put(paramPair.substring(0, k), paramPair.substring(k + 1));
                continue;
            }
            if (k >= 0) continue;
            requestParameters.put(paramPair, null);
        }
        return requestParameters;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("`from` is greater than `to`");
        }
        if (original == null) {
            throw new NullPointerException("`original` is null");
        }
        if (from < 0 || from > original.length) {
            throw new ArrayIndexOutOfBoundsException(from < 0 ? "`from` is negative" : "`from` is greater than length of `original`");
        }
        byte[] result = new byte[to - from];
        int end = to < original.length ? to : original.length;
        int i = 0;
        while (i + from < end) {
            result[i] = original[i + from];
            ++i;
        }
        return result;
    }

    private String getReasonPhrase(int rCode) {
        switch (rCode) {
            case 100: {
                return "Continue";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Found";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 307: {
                return "Temporary Redirect";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Time-out";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request-URI Too Large";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 416: {
                return "Requested range not satisfiable";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Time-out";
            }
            case 505: {
                return "HTTP Version not supported";
            }
        }
        return "Status code " + rCode;
    }

    private void handleBadRequest() throws IOException {
        this.debug("handleBadRequest ()");
        this.badRequest = true;
        String response = "HTTP/1.1 400 Bad Request\r\nConnection: close\r\n\r\n";
        BufferedOutputStream os = this.getOutputStream();
        if (os != null) {
            ((OutputStream)os).write("HTTP/1.1 400 Bad Request\r\nConnection: close\r\n\r\n".getBytes("ISO-8859-1"));
        }
        this.socket.close();
    }

    public String getRequestParameter(String name) {
        if (this.requestParameters == null) {
            return null;
        }
        return this.requestParameters.get(name);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean appendText) {
        StringBuilder sb = new StringBuilder(this.requestMethod).append(" ").append(this.requestURI).append(" ").append(this.requestProtocolString);
        if (appendText) {
            sb.append("\n  ").append(this.requestBodyAsString);
        }
        return sb.toString();
    }

    public void setResponseHeader(String hdrName, String newValue) {
        this.debug("setResponseHeader (" + hdrName + "," + newValue + ")");
        List<String> values = this.getResponseHeaders().get(hdrName);
        if (values == null) {
            this.addResponseHeader(hdrName, newValue);
        } else {
            values.clear();
            values.add(newValue);
            this.responseHeaders.put(hdrName, values);
        }
    }

    public String getRequestCookie(String name) {
        this.debug("getRequestCookie (" + name + ")");
        String result = null;
        List<String> cookies = this.getRequestHeader("Cookie");
        if (cookies != null) {
            for (String cookie : cookies) {
                if (cookie == null || !cookie.startsWith(name)) continue;
                if (cookie.length() < name.length() + 2) {
                    result = "";
                    continue;
                }
                result = cookie.substring(name.length() + 1);
            }
        }
        if (trace.getDebugCode("cookie")) {
            trace.out("cookie", "getRequestCookie(" + name + ") to return " + (TUTORSHOP_COOKIE_DELETED.equalsIgnoreCase(result) ? null : result));
        }
        if (TUTORSHOP_COOKIE_DELETED.equalsIgnoreCase(result)) {
            trace.err("getRequestCookie found tutorshop_cookie_deleted; returning null");
            result = null;
        }
        return result;
    }

    public void setResponseCookie(String name, String value) {
        List<String> cookies;
        this.debug("setResponseCookie (" + name + "," + value + ")");
        if (value == null) {
            value = "tutorshop_cookie_deleted; Expires=Thu, 01-Jan-1970 00:00:01 GMT";
        }
        if (trace.getDebugCode("cookie")) {
            trace.out("cookie", "setResponseCookie(" + name + ", " + value + ")");
        }
        if ((cookies = this.responseHeaders.get("Set-Cookie")) == null) {
            this.addResponseHeader("Set-Cookie", name + '=' + value);
        } else {
            for (int i = 0; i < cookies.size(); ++i) {
                String cookie = cookies.get(i);
                if (cookie == null || !cookie.startsWith(name)) continue;
                cookies.set(i, name + '=' + value);
                return;
            }
            cookies.add(name + '=' + value);
        }
    }

    public void addMimeType() {
        this.debug("addMimeType ()");
        if (this.getRequestURI().getRawPath().endsWith(".css")) {
            this.addResponseHeader("Content-Type", "text/css");
        }
        if (this.getRequestURI().getRawPath().endsWith(".js")) {
            this.addResponseHeader("Content-Type", "application/javascript");
        }
        if (this.getRequestURI().getRawPath().endsWith(".xml")) {
            this.addResponseHeader("Content-Type", "text/xml");
        }
        if (this.getRequestURI().getRawPath().endsWith(".png")) {
            this.addResponseHeader("Content-Type", "image/png");
        }
        if (this.getRequestURI().getRawPath().endsWith(".gif")) {
            this.addResponseHeader("Content-Type", "image/gif");
        }
        if (this.getRequestURI().getRawPath().endsWith(".jpg")) {
            this.addResponseHeader("Content-Type", "image/jpg");
        }
        if (this.getRequestURI().getRawPath().endsWith(".swf")) {
            this.addResponseHeader("Content-Type", "application/x-shockwave-flash");
        }
        if (this.getRequestURI().getRawPath().endsWith(".json")) {
            this.addResponseHeader("Content-Type", "application/json");
        }
    }

    public String getRequestBodyAsString() throws IOException {
        if (this.isWS()) {
            if (this.currentFrame != null) {
                return CTATCharsetFunctions.stingUtf8(this.currentFrame.getPayloadData());
            }
            throw new IOException("CTATHTTPExchange.getRequestBodyAsString() called with WS currentFrame null");
        }
        if (this.requestBodyAsString == null) {
            this.requestBodyAsString = CTATHTTPExchange.convertStreamToString(this.getRequestBody());
            this.debug("getRequestBodyAsString:\n" + this.requestBodyAsString);
        }
        return this.requestBodyAsString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                    if (!trace.getDebugCode("ll")) continue;
                    trace.outNT("ll", "convertStreamToString() nBytes=" + n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public String getIPAddress() {
        if (this.socket == null || this.socket.getInetAddress() == null) {
            return null;
        }
        return this.socket.getInetAddress().getHostAddress();
    }

    public static void main(String[] args) {
        CTATHTTPExchange che = new CTATHTTPExchange();
        for (String arg : args) {
            Map<String, String> requestParameters = che.extractRequestParameters(arg.getBytes());
            System.out.printf("\n%s :\n", arg);
            if (requestParameters == null) continue;
            for (String key : requestParameters.keySet()) {
                System.out.printf("  %s=%s\n", key, requestParameters.get(key));
            }
        }
        che.close();
    }

    public void setWS(boolean isWS) {
        if (isWS) {
            this.currentFrame = null;
            this.state = State.WS_OPEN;
        } else {
            this.state = State.HTTP;
        }
    }

    public boolean isWS() {
        return this.state != State.HTTP;
    }

    private String generateWsHandshakeKey() {
        String inKey = this.getRequestHeaderConcatenatedLazy("Sec-WebSocket-Key");
        BASE64Encoder encoder = new BASE64Encoder();
        String concat2 = inKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return encoder.encode(md.digest(concat2.getBytes()));
    }

    public void sendWebSocketAck() {
        this.debug("sendWebSocketAck ()");
        String aMessage = "ack";
        this.addResponseHeader("Content-Type", "text/plain");
        this.addResponseHeader("Connection", "Upgrade");
        this.addResponseHeader("Upgrade", "websocket");
        this.addResponseHeader("Sec-WebSocket-Accept", this.generateWsHandshakeKey());
        String protocolCheck = this.getRequestHeaderConcatenatedLazy("Sec-WebSocket-Protocol");
        if (protocolCheck != null && protocolCheck.indexOf("chat") != -1) {
            this.addResponseHeader("Sec-WebSocket-Protocol", "chat");
        }
        this.sendResponseHeaders(101, 0L);
    }

    public void WSSend(String text) {
        this.WSSend(text, 200);
    }

    public void WSSend(String text, int statusCode) {
        this.debug("WSSend (" + text + ", " + statusCode + ")");
        if (statusCode == 200) {
            this.WSSend(this.wsFrameProcessor.createFrames(text));
        } else {
            this.debug("statusCode != HttpURLConnection.HTTP_OK, closing WS connection ...");
            this.processWSCloseInternal(null, CTATHTTPExchange.httpToWsStatus(statusCode), text, statusCode);
        }
    }

    private static int httpToWsStatus(int httpCode) {
        switch (httpCode) {
            case 200: {
                return 1000;
            }
        }
        return 1008;
    }

    public void WSSend(byte[] bytes) {
        this.debug("WSSend (byte[] bytes)");
        this.WSSend(this.wsFrameProcessor.createFrames(bytes));
    }

    private void WSSend(Collection<CTATWSFrameData> frames) {
        this.debug("WSSend (Collection<CTATWSFrameData> frames)");
        for (CTATWSFrameData f : frames) {
            this.WSSendFrame(f);
        }
    }

    public void WSSendFrame(CTATWSFrameData framedata) {
        this.debug("WSSendFrame ()");
        ByteBuffer buf = this.wsFrameProcessor.createBinaryFrame(framedata);
        this.writeBytes(buf.array());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CTATHTTPExchange cTATHTTPExchange = this;
        synchronized (cTATHTTPExchange) {
            this.wsThread = Thread.currentThread();
        }
        this.debug("run ()");
        boolean done = false;
        while (!done) {
            BufferedInputStream inFromClient;
            done = false;
            try {
                inFromClient = new BufferedInputStream(this.socket.getInputStream());
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
            PrintStream dump = null;
            if (trace.getDebugCode("ws")) {
                dump = System.out;
                dump.printf("\nCTATHTTPExchange.run() to read socket:\n ", new Object[0]);
            }
            CTATWSFrameData frame = new CTATWSFrameData();
            try {
                frame.fromStream(inFromClient);
                done = this.processWSFrame(frame);
            }
            catch (Exception e) {
                e.printStackTrace();
                done = true;
            }
        }
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CTATHTTPExchange cTATHTTPExchange2 = this;
        synchronized (cTATHTTPExchange2) {
            this.wsThread = null;
        }
    }

    private boolean processWSFrame(CTATWSFrameData f) {
        this.debug("processWSFrame (" + f + ")");
        CTATWSFrameData resultFrame = null;
        try {
            resultFrame = this.processIncomingFrame(this.currentFrame, f);
        }
        catch (Exception e) {
            trace.errStack("Error from processIncomingFrame(" + f + "): " + e + "; cause " + e.getCause(), e);
            return true;
        }
        this.debug("processedFrame: " + resultFrame);
        CTATWSFrameData.Opcode curop = resultFrame.getOpcode();
        switch (curop) {
            case CLOSING: {
                return this.processWSClose(resultFrame);
            }
            case PING: {
                this.pong(resultFrame);
                return false;
            }
            case PONG: {
                return !this.pongOK(resultFrame);
            }
            case TEXT: {
                this.currentFrame = resultFrame;
                if (this.currentFrame.isFin()) {
                    return this.onMessage(CTATCharsetFunctions.stingUtf8(this.currentFrame.getPayloadData()));
                }
                return false;
            }
            case BINARY: {
                this.currentFrame = resultFrame;
                if (this.currentFrame.isFin()) {
                    return this.onMessage(this.currentFrame.getPayloadData());
                }
                return false;
            }
            case CONTINUATION: {
                this.currentFrame = resultFrame;
                return false;
            }
        }
        trace.err("Error from processIncomingFrame(): undefined opcode" + (Object)((Object)curop));
        return true;
    }

    public boolean processWSClose() {
        return this.processWSCloseInternal(null, CTATHTTPExchange.httpToWsStatus(200), null, -1);
    }

    private boolean processWSClose(CTATWSFrameData clientFrame) {
        this.processWSCloseInternal(clientFrame, -1, null, -1);
        if (this.handler != null) {
            this.handler.handle(this, "Q");
        }
        return true;
    }

    private synchronized boolean processWSCloseInternal(CTATWSFrameData closeFrame, int wsStatus, String text, int httpStatus) {
        if (trace.getDebugCode("ws")) {
            trace.printStack("ws", "CTATHTTPExchange.processWSClose() state " + (Object)((Object)this.state) + ", input frame " + closeFrame + ", wsStatus " + wsStatus);
        }
        if (this.state == State.WS_CLOSED) {
            return true;
        }
        CTATWSFrameData closeResponse = new CTATWSFrameData();
        closeResponse.setFin(true);
        closeResponse.setOpcode(CTATWSFrameData.Opcode.CLOSING);
        closeResponse.setMasked(false);
        if (closeFrame != null) {
            closeResponse.setPayload(closeFrame.getPayloadData());
            this.state = this.state == State.WS_CLOSE_SENT ? State.WS_CLOSED : State.WS_CLOSE_RECEIVED;
        } else {
            if (httpStatus >= 0) {
                text = "HTTP " + httpStatus + " " + text;
            }
            closeResponse.setPayload(CTATWSFrameData.formatClosePayload(wsStatus, text));
        }
        if (trace.getDebugCode("ws")) {
            trace.out("ws", "CTATHTTPExchange.processWSClose() frame " + closeResponse);
        }
        this.WSSendFrame(closeResponse);
        State state = this.state = this.state == State.WS_CLOSE_RECEIVED ? State.WS_CLOSED : State.WS_CLOSE_SENT;
        if (this.state == State.WS_CLOSED) {
            this.close();
        }
        return true;
    }

    private CTATWSFrameData processIncomingFrame(CTATWSFrameData oldFrame, CTATWSFrameData newFrame) throws IllegalArgumentException {
        switch (newFrame.getOpcode()) {
            case CONTINUATION: {
                if (oldFrame == null) {
                    throw new IllegalArgumentException("processIncomingFrame(): CONTINUATION but no old frame to append to; newFrame " + newFrame);
                }
                oldFrame.append(newFrame);
                return oldFrame;
            }
            case TEXT: 
            case BINARY: {
                return newFrame;
            }
            case CLOSING: {
                return newFrame;
            }
        }
        return newFrame;
    }

    private void pong(CTATWSFrameData pingFrame) {
        if (trace.getDebugCode("ws")) {
            trace.out("ws", "CTATHTTPExchange.pong(" + pingFrame + ")");
        }
        CTATWSFrameData pongResponse = new CTATWSFrameData();
        pongResponse.setFin(true);
        pongResponse.setOpcode(CTATWSFrameData.Opcode.PONG);
        pongResponse.setMasked(false);
        pongResponse.setPayload(pingFrame.getPayloadData());
        this.WSSendFrame(pongResponse);
    }

    private boolean pongOK(CTATWSFrameData pongFrame) {
        if (trace.getDebugCode("ws")) {
            trace.out("ws", "CTATHTTPExchange.pongOK(" + pongFrame + ")");
        }
        return true;
    }

    public synchronized Thread getWsThread() {
        return this.wsThread;
    }

    public void setHandler(CTATHTTPHandlerInterface handler) {
        this.handler = handler;
    }

    public CTATHTTPHandlerInterface getHandler() {
        return this.handler;
    }

    public HTTPToolProxy getHTTPToolProxy() {
        return this.httpToolProxy;
    }

    public void setHTTPToolProxy(HTTPToolProxy httpToolProxy) {
        this.httpToolProxy = httpToolProxy;
    }

    public synchronized boolean startWS(CTATHTTPHandlerInterface handler) {
        if (this.isWS() && (this.wsThread == null || !this.wsThread.isAlive())) {
            this.setHandler(handler);
            new Thread(this).start();
            this.sendWebSocketAck();
            return true;
        }
        return false;
    }

    private static class SendOnCloseOutputStream
    extends ByteArrayOutputStream {
        private CTATHTTPExchange parent;

        public SendOnCloseOutputStream(CTATHTTPExchange parent) {
            this.parent = parent;
        }

        @Override
        public void close() throws IOException {
            this.parent.sendReponseTank();
        }
    }

    public static enum State {
        HTTP,
        WS_OPEN,
        WS_CLOSE_SENT,
        WS_CLOSE_RECEIVED,
        WS_CLOSED;

    }
}

