/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ProblemGraph
implements Serializable {
    private static final long serialVersionUID = -8217291579641205667L;
    public static final String DONE_NODE_NAME = "Done";
    private ProblemNode firstNode = null;
    private ProblemEdge firstEdge = null;
    private int numNodes = 0;
    private Map<String, ProblemNode> doneNodeNames = new LinkedHashMap<String, ProblemNode>();

    public int getNodeCount() {
        return this.numNodes;
    }

    public ProblemNode getFirstNode() {
        return this.firstNode;
    }

    public ProblemNode getNode(int i) {
        for (ProblemNode e = this.firstNode; e != null; e = e.getNextNode()) {
            if (e.getNodeOrder() != i) continue;
            return e;
        }
        return null;
    }

    public ProblemNode getNode(String name) {
        Enumeration<ProblemNode> en = this.nodes();
        while (en.hasMoreElements()) {
            ProblemNode node = en.nextElement();
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    public int degree(ProblemNode node) {
        int numEdges = 0;
        ProblemEdge e = this.firstEdge;
        while (e != null) {
            if (e.source == node || e.dest == node) {
                ++numEdges;
            }
            e = e.nextEdge;
        }
        return numEdges;
    }

    public boolean containsEdge(ProblemNode node0, ProblemNode node1) {
        ProblemEdge e = this.firstEdge;
        while (e != null) {
            if (e.source == node0 && e.dest == node1) {
                return true;
            }
            e = e.nextEdge;
        }
        return false;
    }

    public int outDegree(ProblemNode node) {
        if (node == null) {
            return 0;
        }
        return node.getOutDegree();
    }

    public void clear() {
        this.firstNode = null;
        this.firstEdge = null;
        this.numNodes = 0;
        this.doneNodeNames.clear();
    }

    public ProblemNode addProblemNode(ProblemNode node) {
        if (node.getDoneState()) {
            this.addDoneName(node.getName(), node);
        }
        if (this.firstNode != null) {
            this.firstNode.setPrevNode(node);
        }
        node.setPrevNode(null);
        node.setNextNode(this.firstNode);
        this.firstNode = node;
        ++this.numNodes;
        node.setNodeOrder(this.numNodes);
        if (trace.getDebugCode("pm")) {
            trace.out("pm", "addProblemNode(" + node + "): size = " + this.numNodes);
        }
        return node;
    }

    public ProblemEdge addEdge(ProblemNode node0, ProblemNode node1) {
        return this.addEdge(node0, node1, null);
    }

    public boolean doesEdgeExist(ProblemNode source, ProblemNode dest) {
        ProblemEdge tempEdge = this.firstEdge;
        while (tempEdge != null) {
            if (tempEdge.source == source && tempEdge.dest == dest) {
                return true;
            }
            tempEdge = tempEdge.nextEdge;
        }
        return false;
    }

    public ProblemEdge addEdge(ProblemNode node0, ProblemNode node1, EdgeData edgeData) {
        ProblemNode source = node0;
        ProblemNode dest = node1;
        ProblemEdge edge = new ProblemEdge(source, dest, edgeData);
        if (this.firstEdge != null) {
            this.firstEdge.prevEdge = edge;
        }
        edge.prevEdge = null;
        edge.nextEdge = this.firstEdge;
        this.firstEdge = edge;
        if (trace.getDebugCode("br")) {
            trace.out("br", "addEdge(" + source.getName() + "-" + dest.getName() + "), nextedge id(" + (edge.nextEdge == null ? -1 : edge.nextEdge.getUniqueID()) + ")");
        }
        source.setOutDegree(source.getOutDegree() + 1);
        if (edge.isCorrect()) {
            source.setCorrectOutDegree(source.getCorrectOutDegree() + 1);
        }
        edgeData.setEdge(edge);
        this.dumpEdges("addEdge(" + source.getName() + "-" + dest.getName() + ")");
        return edge;
    }

    private void dumpEdges(String label) {
        if (!trace.getDebugCode("br")) {
            return;
        }
        StringBuffer sb = new StringBuffer(label);
        ProblemEdge next = this.firstEdge;
        while (next != null) {
            sb.append(" ").append(next.getUniqueID());
            next = next.nextEdge;
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "dumpEdges: " + sb);
        }
    }

    public void removeNode(ProblemNode node) {
        ProblemNode currNode = node;
        ProblemEdge e = this.firstEdge;
        while (e != null) {
            if (e.source == currNode || e.dest == currNode) {
                this.removeEdge(e);
            }
            e = e.nextEdge;
        }
        ProblemNode prevNode = currNode.getPrevNode();
        ProblemNode nextNode = currNode.getNextNode();
        if (prevNode == null) {
            this.firstNode = nextNode;
        } else {
            prevNode.setNextNode(nextNode);
        }
        if (nextNode != null) {
            nextNode.setPrevNode(prevNode);
        }
        --this.numNodes;
        this.doneNodeNames.remove(currNode.getName());
    }

    public void removeEdge(ProblemEdge edge) {
        ProblemEdge prevEdge = edge.prevEdge;
        ProblemEdge nextEdge = edge.nextEdge;
        if (trace.getDebugCode("br")) {
            trace.out("br", "removeEdge(" + edge.getUniqueID() + ") from between prev edge id(" + (prevEdge == null ? -1 : prevEdge.getUniqueID()) + ")&(" + (nextEdge == null ? -1 : nextEdge.getUniqueID()) + ")");
        }
        if (prevEdge == null) {
            this.firstEdge = nextEdge;
        } else {
            prevEdge.nextEdge = nextEdge;
        }
        if (nextEdge != null) {
            nextEdge.prevEdge = prevEdge;
        }
        edge.source.setOutDegree(edge.source.getOutDegree() - 1);
        if (edge.isCorrect()) {
            edge.source.setCorrectOutDegree(edge.source.getCorrectOutDegree() - 1);
        }
    }

    public ProblemEdge lookupProblemEdgeByID(int id) {
        ProblemEdge theEdge = null;
        Enumeration<ProblemEdge> edges = this.edges();
        while (edges.hasMoreElements()) {
            ProblemEdge edge = edges.nextElement();
            EdgeData edgeData = edge.getEdgeData();
            if (edgeData.getUniqueID() != id) continue;
            theEdge = edge;
            break;
        }
        return theEdge;
    }

    public Enumeration<ProblemNode> nodes() {
        return new AllNodeEnumeration();
    }

    public Enumeration<ProblemEdge> edges() {
        return new AllEdgeEnumeration();
    }

    public Enumeration<ProblemNode> neighbors(ProblemNode node) {
        return new NodeEnumeration(node, false);
    }

    public Enumeration<ProblemEdge> getConnectingEdges(ProblemNode node) {
        return new EdgeEnumeration(node, true, true);
    }

    public Enumeration<ProblemEdge> getIncomingEdges(ProblemNode node) {
        return new EdgeEnumeration(node, true, false);
    }

    public Enumeration<ProblemEdge> getOutgoingEdges(ProblemNode node) {
        return new EdgeEnumeration(node, false, true);
    }

    public Enumeration<ProblemNode> successors(ProblemNode node) {
        return new NodeEnumeration(node, true);
    }

    public ProblemEdge lookupProblemEdge(ProblemNode parentNode, ProblemNode targetNode) {
        Enumeration<ProblemEdge> connectingEdges = this.getConnectingEdges(parentNode);
        while (connectingEdges.hasMoreElements()) {
            ProblemEdge edge = connectingEdges.nextElement();
            if (edge.getDest() != targetNode) continue;
            return edge;
        }
        return null;
    }

    public Enumeration<ProblemNode> parents(ProblemNode node) {
        return new ParentsEnumeration(node);
    }

    public Vector<ProblemNode> siblings(ProblemNode node) {
        Enumeration<ProblemNode> parents = this.parents(node);
        Vector<ProblemNode> siblings = new Vector<ProblemNode>();
        while (parents.hasMoreElements()) {
            Enumeration<ProblemNode> successors = this.successors(parents.nextElement());
            while (successors.hasMoreElements()) {
                ProblemNode sib = successors.nextElement();
                if (sib == node || siblings.contains(sib)) continue;
                siblings.addElement(sib);
            }
        }
        return siblings;
    }

    public boolean isNodeInGraph(ProblemNode testNode) {
        Enumeration<ProblemNode> iter = this.nodes();
        while (iter.hasMoreElements()) {
            ProblemNode tempNode = iter.nextElement();
            if (tempNode != testNode) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren(ProblemNode node) {
        AllEdgeEnumeration edges = new AllEdgeEnumeration();
        while (edges.hasMoreElements()) {
            ProblemEdge currEdge = (ProblemEdge)edges.nextElement();
            if (currEdge.source != node) continue;
            return true;
        }
        return false;
    }

    public int getEdgeCount() {
        Enumeration<ProblemEdge> edges = this.edges();
        int count = 0;
        while (edges.hasMoreElements()) {
            edges.nextElement();
            ++count;
        }
        return count;
    }

    public boolean hasEdges() {
        return this.edges().hasMoreElements();
    }

    private void addDoneName(String doneNodeName, ProblemNode doneNode) {
        if (doneNodeName == null || doneNodeName.length() < 1) {
            return;
        }
        ProblemNode existingDoneNode = this.doneNodeNames.get(doneNodeName);
        if (existingDoneNode != null) {
            throw new IllegalArgumentException("Duplicate Done node name " + doneNodeName + " on nodes " + existingDoneNode.getUniqueID() + ", " + doneNode.getUniqueID());
        }
        this.doneNodeNames.put(doneNodeName, doneNode);
    }

    public String nextDoneName() {
        String result;
        int nextDoneNodeNo = this.doneNodeNames.size() + 1;
        if (nextDoneNodeNo <= 1) {
            return DONE_NODE_NAME;
        }
        String prefix = "Done_";
        while (this.doneNodeNames.containsKey(result = prefix + nextDoneNodeNo)) {
            ++nextDoneNodeNo;
        }
        return result;
    }

    public void renameNode(ProblemNode problemNode, String oldName, String newName) {
        if (problemNode.isDoneState()) {
            this.doneNodeNames.remove(oldName);
            this.addDoneName(newName, problemNode);
        }
    }

    private class EdgeEnumeration
    implements Enumeration<ProblemEdge> {
        private Enumeration<ProblemEdge> allEdges;
        ProblemEdge currEdge;
        private ProblemNode targetNode;
        private boolean incoming;
        private boolean outgoing;

        private EdgeEnumeration(ProblemNode node, boolean incoming, boolean outgoing) {
            this.allEdges = new AllEdgeEnumeration();
            this.targetNode = node;
            this.outgoing = outgoing;
            this.incoming = incoming;
            this.currEdge = this.scanNextEdge();
        }

        ProblemEdge scanNextEdge() {
            while (this.allEdges.hasMoreElements()) {
                ProblemEdge edge = this.allEdges.nextElement();
                if (this.incoming && edge.dest == this.targetNode) {
                    return edge;
                }
                if (!this.outgoing || edge.source != this.targetNode) continue;
                return edge;
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currEdge != null;
        }

        @Override
        public ProblemEdge nextElement() {
            ProblemEdge result = this.currEdge;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currEdge = this.scanNextEdge();
            return result;
        }

        public void remove() {
            if (this.currEdge == null) {
                throw new IllegalStateException();
            }
            ProblemGraph.this.removeEdge(this.currEdge);
        }
    }

    private class AllEdgeEnumeration
    implements Enumeration<ProblemEdge> {
        ProblemEdge currEdge;

        private AllEdgeEnumeration() {
            this.currEdge = ProblemGraph.this.firstEdge;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currEdge != null;
        }

        @Override
        public ProblemEdge nextElement() {
            ProblemEdge result = this.currEdge;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currEdge = this.currEdge.nextEdge;
            return result;
        }

        public void remove() {
            if (this.currEdge == null) {
                throw new IllegalStateException();
            }
            ProblemGraph.this.removeEdge(this.currEdge);
        }
    }

    private class NodeEnumeration
    implements Enumeration<ProblemNode> {
        private Enumeration<ProblemEdge> allEdges;
        private ProblemNode currNode;
        private ProblemNode targetNode;
        private boolean directed;

        private NodeEnumeration(ProblemNode node, boolean directed) {
            this.targetNode = node;
            this.directed = directed;
            this.allEdges = new AllEdgeEnumeration();
            this.currNode = this.scanNextNode();
        }

        ProblemNode scanNextNode() {
            while (this.allEdges.hasMoreElements()) {
                ProblemEdge currEdge = this.allEdges.nextElement();
                if (currEdge.source == this.targetNode) {
                    return currEdge.dest;
                }
                if (this.directed || currEdge.dest != this.targetNode) continue;
                return currEdge.source;
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currNode != null;
        }

        @Override
        public ProblemNode nextElement() {
            ProblemNode result = this.currNode;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currNode = this.scanNextNode();
            return result;
        }

        public void remove() {
            if (this.currNode == null) {
                throw new IllegalStateException();
            }
            ProblemGraph.this.removeNode(this.currNode);
        }
    }

    private class ParentsEnumeration
    implements Enumeration<ProblemNode> {
        private Enumeration<ProblemEdge> allEdges;
        private ProblemNode currNode;
        private ProblemNode targetNode;

        private ParentsEnumeration(ProblemNode node) {
            this.targetNode = node;
            this.allEdges = new AllEdgeEnumeration();
            this.currNode = this.scanNextNode();
        }

        ProblemNode scanNextNode() {
            while (this.allEdges.hasMoreElements()) {
                ProblemEdge currEdge = this.allEdges.nextElement();
                if (currEdge.dest != this.targetNode) continue;
                return currEdge.source;
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currNode != null;
        }

        @Override
        public ProblemNode nextElement() {
            ProblemNode result = this.currNode;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currNode = this.scanNextNode();
            return result;
        }

        public void remove() {
            if (this.currNode == null) {
                throw new IllegalStateException();
            }
            ProblemGraph.this.removeNode(this.currNode);
        }
    }

    private class AllNodeEnumeration
    implements Enumeration<ProblemNode> {
        private ProblemNode currNode;

        private AllNodeEnumeration() {
            this.currNode = ProblemGraph.this.firstNode;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currNode != null;
        }

        @Override
        public ProblemNode nextElement() {
            ProblemNode result = this.currNode;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currNode = this.currNode.getNextNode();
            return result;
        }

        public void remove() {
            if (this.currNode == null) {
                throw new IllegalStateException();
            }
            ProblemGraph.this.removeNode(this.currNode);
        }
    }
}

