/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.CommManager.CommManager;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.VersionInformation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.QuestionWidgetInterface;
import pact.CommWidgets.event.IncorrectActionEvent;
import pact.CommWidgets.event.IncorrectActionListener;
import pact.CommWidgets.event.StudentActionEvent;
import pact.CommWidgets.event.StudentActionListener;

public abstract class JCommQuestion
extends JCommWidget
implements QuestionWidgetInterface {
    String questionText = "Question?";
    JLabel questionLbl = new JLabel();
    String toolTipText;
    int scaffoldingOrder = 1;
    EventListenerList studentActionListeners;
    Color backColor;
    protected Font startFont;
    private boolean originalQuestion = false;

    public JCommQuestion() {
        this.questionLbl.setText(this.questionText);
        this.studentActionListeners = new EventListenerList();
        this.questionLbl.setFocusable(false);
    }

    protected boolean initialize() {
        return super.initialize(this.getController());
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void highlight(String subElement, Border highlightBorder) {
        this.setBorder(highlightBorder);
    }

    @Override
    public void removeHighlight(String subElement) {
        this.setBorder(this.originalBorder);
    }

    @Override
    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    @Override
    public synchronized String getQuestionText() {
        return this.questionText;
    }

    @Override
    public synchronized void setQuestionText(String qText) {
        this.questionText = qText;
        this.questionLbl.setText(Utils.replaceImg(qText));
        this.validate();
    }

    @Override
    public void setFont(Font f) {
        this.startFont = f != null ? f : super.getFont();
        super.setFont(this.startFont);
        if (this.questionLbl != null) {
            this.questionLbl.setFont(this.startFont);
        }
    }

    @Override
    public Font getFont() {
        if (this.questionLbl != null) {
            return this.questionLbl.getFont();
        }
        return super.getFont();
    }

    @Override
    public void addStudentActionListener(StudentActionListener l) {
        EventListener[] obj = this.studentActionListeners.getListeners(StudentActionListener.class);
        if (obj == null || obj.length == 0) {
            this.studentActionListeners.add(StudentActionListener.class, l);
            return;
        }
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].equals(l)) continue;
            return;
        }
        this.studentActionListeners.add(StudentActionListener.class, l);
    }

    @Override
    public void removeStudentActionListener(StudentActionListener l) {
        this.studentActionListeners.remove(StudentActionListener.class, l);
    }

    @Override
    public EventListener[] getStudentActionListener() {
        return this.studentActionListeners.getListeners(StudentActionListener.class);
    }

    @Override
    public void fireStudentAction(StudentActionEvent e) {
        Object[] listeners = this.studentActionListeners.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != StudentActionListener.class) continue;
            ((StudentActionListener)listeners[i + 1]).studentActionPerformed(e);
        }
    }

    @Override
    public synchronized int getScaffoldingOrder() {
        return this.scaffoldingOrder;
    }

    @Override
    public synchronized void setScaffoldingOrder(int dialogOrder) {
        this.scaffoldingOrder = dialogOrder;
    }

    @Override
    public void hideAllComponents(boolean b) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setVisible(!b);
        }
    }

    @Override
    public void addIncorrectActionListener(IncorrectActionListener l) {
        EventListener[] obj = this.studentActionListeners.getListeners(IncorrectActionListener.class);
        if (obj == null || obj.length == 0) {
            this.studentActionListeners.add(IncorrectActionListener.class, l);
            return;
        }
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].equals(l)) continue;
            return;
        }
        this.studentActionListeners.add(IncorrectActionListener.class, l);
    }

    @Override
    public void removeIncorrectActionListener(IncorrectActionListener l) {
        this.studentActionListeners.remove(IncorrectActionListener.class, l);
    }

    @Override
    public void fireIncorrectAction(IncorrectActionEvent e) {
        Object[] listeners = this.studentActionListeners.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != IncorrectActionListener.class) continue;
            ((IncorrectActionListener)listeners[i + 1]).incorrectActionPerformed(e);
        }
    }

    public abstract Vector createJessDeftemplates();

    public abstract Vector createJessInstances();

    public void addCommListener() {
        if (!VersionInformation.includesCL()) {
            return;
        }
        CommManager.instance().addMessageReceiver(this, this.commName, this.getController());
    }

    @Override
    public String getCommNameToSend() {
        return this.commName;
    }

    public synchronized boolean isOriginalQuestion() {
        return this.originalQuestion;
    }

    public synchronized void setOriginalQuestion(boolean originalQuestion) {
        this.originalQuestion = originalQuestion;
    }

    @Override
    public void setEnabled(boolean b) {
        for (int i = 0; i < this.getComponents().length; ++i) {
            this.getComponent(i).setEnabled(b);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

