/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.AmlRete;
import edu.cmu.pact.miss.BindPair;
import edu.cmu.pact.miss.FeaturePredicate;
import edu.cmu.pact.miss.FoaGetter;
import edu.cmu.pact.miss.HashMap;
import edu.cmu.pact.miss.Instruction;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import jess.JessException;
import jess.Value;

public class RhsState
implements Cloneable {
    private int numVar = 0;
    private AmlRete amlRete;
    private Vector expList = new Vector();
    private double likelihood;
    private Vector varList = new Vector();
    private static String matcher = null;
    private static Class matcherClass = null;
    private static FeaturePredicate matcherInstance = null;
    private static HashMap compairInputCache = new HashMap();
    private String lastVal = null;

    private void setAmlRete(AmlRete amlRete) {
        this.amlRete = amlRete;
    }

    AmlRete getAmlRete() {
        return this.amlRete;
    }

    private BindPair lookupBindPairByVar(String var) {
        for (int i = 0; i < this.expList.size(); ++i) {
            BindPair bindPair = (BindPair)this.expList.get(i);
            if (!var.equals(bindPair.getVar())) continue;
            return bindPair;
        }
        return null;
    }

    Vector getExpList() {
        return this.expList;
    }

    boolean pushExpList(FeaturePredicate rhsOp) {
        boolean pushExpList = false;
        boolean typeMatch = this.argTypeMatch(rhsOp);
        if (typeMatch) {
            BindPair existingBP = this.hasRepeatedBindPair(rhsOp);
            if (existingBP != null) {
                this.pushVarList(existingBP.getVar());
                pushExpList = true;
                return pushExpList;
            }
            String var = this.genVarSym();
            BindPair bp = new BindPair(var, rhsOp);
            this.expList.add(bp);
            this.pushVarList(var);
            pushExpList = true;
        }
        return pushExpList;
    }

    private BindPair hasRepeatedBindPair(FeaturePredicate rhsOp) {
        Vector expList = this.getExpList();
        for (int i = 0; i < expList.size(); ++i) {
            BindPair existingBP = (BindPair)expList.get(i);
            if (existingBP.getExp() == null || !existingBP.getExp().equals(rhsOp)) continue;
            return existingBP;
        }
        return null;
    }

    private double foaLikelihood(Vector foaWmes) {
        double product = 1.0;
        for (int i = 0; i < foaWmes.size(); ++i) {
            String wme = (String)foaWmes.get(i);
            product *= this.wmeLikelihood(wme);
        }
        return product;
    }

    private double wmeLikelihood(String wme) {
        int howManyBack = FoaGetter.howManyBack(wme);
        return 1.0 - 0.01 * (double)howManyBack;
    }

    void pushExpList(String foa) {
        String foaValue = foa.split("\\|")[2];
        String var = this.genVarSym();
        this.expList.add(new BindPair(var, FeaturePredicate.valueType(foaValue)));
        this.pushVarList(var);
    }

    void setExpList(Vector expList) {
        this.expList = expList;
    }

    private boolean argTypeMatch(FeaturePredicate rhsOp) {
        if (trace.getDebugCode("rhs-typechecking")) {
            trace.out("rhs-typechecking", "entered argTypeMatch: rhsOp = " + rhsOp);
        }
        boolean argTypeMatch = true;
        Vector args = rhsOp.getArgs();
        for (int i = 0; i < args.size(); ++i) {
            String var = (String)args.get(i);
            BindPair bindPair = this.lookupBindPairByVar(var);
            if (trace.getDebugCode("rhs-typechecking")) {
                trace.out("rhs-typechecking", "argTypeMatch: bindPair.getArgType() = " + bindPair.getArgType() + ", rhsOp.getArgValueType(i) = " + rhsOp.getArgValueType(i));
            }
            int givenType = bindPair.getArgType();
            int expectedType = rhsOp.getArgValueType(i);
            if (FeaturePredicate.isCompatibleType(givenType, expectedType)) continue;
            argTypeMatch = false;
            break;
        }
        trace.out("rhs-typechecking", "argTypeMatch: returning " + argTypeMatch);
        return argTypeMatch;
    }

    int numRhsOperators() {
        int numRhsOperators = 0;
        for (int i = 0; i < this.expList.size(); ++i) {
            BindPair bindPair = (BindPair)this.expList.get(i);
            FeaturePredicate exp = bindPair.getExp();
            if (exp == null) continue;
            ++numRhsOperators;
        }
        return numRhsOperators;
    }

    String getExpVar(FeaturePredicate rhsOp) {
        String var = null;
        for (int i = 0; i < this.expList.size(); ++i) {
            BindPair bindPair = (BindPair)this.expList.get(i);
            FeaturePredicate exp = bindPair.getExp();
            if (exp == null || !exp.equals(rhsOp)) continue;
            var = bindPair.getVar();
            break;
        }
        return var;
    }

    boolean isGivenVar(String var) {
        boolean test = true;
        for (int i = 0; i < this.expList.size(); ++i) {
            BindPair bindPair = (BindPair)this.expList.get(i);
            if (!bindPair.getVar().equals(var)) continue;
            if (bindPair.getExp() == null) break;
            test = false;
            break;
        }
        return test;
    }

    void pushVarList(String var) {
        this.varList.add(var);
    }

    Vector getVarList() {
        return this.varList;
    }

    void setVarList(Vector varList) {
        this.varList = varList;
    }

    void removeVarList(String var) {
        this.varList.remove(var);
    }

    void removeVarList(Vector vars) {
        for (int i = 0; i < vars.size(); ++i) {
            this.varList.remove((String)vars.get(i));
        }
    }

    private String getMatcher() {
        return matcher;
    }

    public void setMatcher(String theMatcher) {
        matcher = theMatcher;
    }

    private Class getMatcherClass() {
        if (matcherClass == null) {
            try {
                matcherClass = Class.forName(this.getMatcher());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return matcherClass;
    }

    private FeaturePredicate getMatcherInstance() {
        if (matcherInstance == null) {
            try {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "matcherClass = " + this.getMatcherClass());
                }
                matcherInstance = (FeaturePredicate)this.getMatcherClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return matcherInstance;
    }

    public RhsState(String wmeTypeFile, Vector seeds, String matcher) {
        this.setAmlRete(new AmlRete());
        this.setMatcher(matcher);
        try {
            this.getAmlRete().reset();
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream is = cl.getResourceAsStream(wmeTypeFile);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            try {
                Value value = this.getAmlRete().parse(br, false);
            }
            catch (JessException e) {
                e.printStackTrace();
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < seeds.size(); ++i) {
            this.pushExpList((String)seeds.get(i));
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "RhsState initialized");
        }
    }

    boolean hasValidOperations(Instruction instruction) {
        Vector seeds = instruction.getSeeds();
        int seedIndex = 0;
        HashMap unifier = new HashMap();
        Vector expList = this.getExpList();
        for (int i = 0; i < expList.size(); ++i) {
            BindPair bindPair = (BindPair)expList.get(i);
            String val = null;
            String var = bindPair.getVar();
            FeaturePredicate exp = bindPair.getExp();
            if (exp == null) {
                String seed = "";
                if (seedIndex < seeds.size()) {
                    seed = (String)seeds.elementAt(seedIndex++);
                }
                val = seed.substring(seed.lastIndexOf(124) + 1);
            } else {
                val = this.evalExp(exp, unifier);
                this.setLastVal(val);
            }
            if (val == null || val.equals("")) {
                return false;
            }
            unifier.put(var, val);
        }
        boolean isValid = this.compairInput(this.getLastVal(), instruction.getInput());
        return isValid;
    }

    private boolean compairInput(String lastVar, String stInput) {
        boolean isValid;
        boolean bl = isValid = lastVar != null;
        if (isValid) {
            if (this.getMatcher() == null) {
                isValid = lastVar.equals(stInput);
            } else {
                String cachedResult = this.cachedCompairInput(lastVar, stInput);
                if (cachedResult != null) {
                    isValid = cachedResult.equals("T");
                } else {
                    try {
                        FeaturePredicate matcherInstance = this.getMatcherInstance();
                        String result = matcherInstance.inputMatcher(lastVar, stInput);
                        this.putCachedCompairInput(lastVar, stInput, result);
                        isValid = result != null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return isValid;
    }

    private String cachedCompairInput(String lastVar, String stInput) {
        String cachedCompairInput = null;
        HashMap inputCache = (HashMap)compairInputCache.get(lastVar);
        if (inputCache != null) {
            cachedCompairInput = (String)inputCache.get(stInput);
        }
        return cachedCompairInput;
    }

    private void putCachedCompairInput(String lastVar, String stInput, String result) {
        HashMap inputCache = (HashMap)compairInputCache.get(lastVar);
        if (inputCache == null) {
            inputCache = new HashMap();
            compairInputCache.put(lastVar, inputCache);
        }
        inputCache.put(stInput, result == null ? "F" : "T");
    }

    public static void printInputCache() {
        for (String key : compairInputCache.keySet()) {
            HashMap hashMap = (HashMap)compairInputCache.get(key);
            for (String value : hashMap.keySet()) {
                String match = (String)hashMap.get(value);
                System.out.println(key + (match.equals("T") ? " == " : " != ") + value);
            }
        }
    }

    String getLastVal() {
        return this.lastVal;
    }

    void setLastVal(String lastVal) {
        this.lastVal = lastVal;
    }

    private String evalExp(FeaturePredicate exp, HashMap unifier) {
        Vector<Object> argsUnified = new Vector<Object>();
        Vector args = exp.getArgs();
        for (int i = 0; i < args.size(); ++i) {
            String argStr = (String)args.get(i);
            argsUnified.add(unifier.get(argStr));
        }
        String value = null;
        try {
            value = exp.cachedApply(argsUnified);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public Object clone() {
        RhsState state = null;
        try {
            state = (RhsState)super.clone();
            state.setExpList((Vector)this.getExpList().clone());
            state.setVarList((Vector)this.getVarList().clone());
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return state;
    }

    String genVarSym() {
        return "?val" + String.valueOf(this.numVar++);
    }

    public String toString() {
        String expList = this.expList.toString();
        String varList = this.varList.toString();
        return "<RhsState> expLlist: " + expList + " varList: " + varList;
    }
}

