/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.curriculumeditor;

import edu.cmu.pact.curriculumeditor.CurriculumConstants;
import edu.cmu.pact.curriculumeditor.CurriculumUnit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class CurriculumModel {
    ArrayList unitList = new ArrayList();
    private String title;
    private File problemDataFolder;
    private File initialStateFolder;
    private File unitFolder;
    private File problemFolder;

    public CurriculumModel(String title) {
        this.title = title;
    }

    public CurriculumUnit createUnit(String unitTitle) {
        CurriculumUnit unit = new CurriculumUnit(unitTitle, this);
        this.unitList.add(unit);
        return unit;
    }

    public void writeCurriculumFiles(File testFolder) throws IOException {
        this.makeFolders(testFolder);
        this.writeXCurFile();
        this.writeUnitFiles(testFolder);
    }

    private void writeXCurFile() throws IOException {
        File f = new File(this.title + ".xcur");
        f.createNewFile();
        File g = new File(this.title + ".interfaces");
        g.createNewFile();
    }

    private void makeFolders(File testFolder) {
        this.problemDataFolder = new File(testFolder, CurriculumConstants.PROBLEM_DATA_FOLDER_NAME);
        this.problemDataFolder.mkdirs();
        this.initialStateFolder = new File(testFolder, CurriculumConstants.INITIAL_STATE_FOLDER_NAME);
        this.initialStateFolder.mkdirs();
        this.unitFolder = new File(testFolder, CurriculumConstants.UNIT_DATA_FOLDER_NAME);
        this.unitFolder.mkdirs();
        this.problemFolder = new File(testFolder, CurriculumConstants.PROBLEM_DATA_FOLDER_NAME);
        this.problemFolder.mkdirs();
    }

    private void writeUnitFiles(File testFolder) throws IOException {
        for (CurriculumUnit unit : this.unitList) {
            unit.writeCurriculumFiles(testFolder);
        }
    }

    public File getUnitFolder() {
        return this.unitFolder;
    }

    public File getProblemsFolder() {
        return this.problemFolder;
    }
}

