/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.Controller.ActionLabelHandler;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.LinkEditFunctions;
import edu.cmu.pact.BehaviorRecorder.Controller.RuleLabelHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateWriter;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.CheckLispLabel;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdge;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.miss.Sai;
import java.io.Serializable;
import java.util.Vector;
import org.jdom.Content;
import org.jdom.Element;

public class ProblemEdge
implements Serializable {
    private static final long serialVersionUID = -4402015128879088164L;
    public static final String ELEMENT_NAME = "edge";
    public static final int SOURCE = 0;
    public static final int DEST = 1;
    EdgeData edgeData;
    LinkEditFunctions functions;
    public ProblemNode source;
    public ProblemNode dest;
    ProblemEdge nextEdge;
    ProblemEdge prevEdge;
    private BR_JGraphEdge jgraphEdge;

    public ProblemNode getSource() {
        return this.source;
    }

    public ProblemNode getDest() {
        return this.dest;
    }

    public void restoreTransients(BR_Controller controller) {
        if (this.edgeData != null) {
            this.edgeData.restoreTransients(controller);
        }
        if (this.functions != null) {
            this.functions.restoreTransients(controller);
        }
        if (this.jgraphEdge != null) {
            this.jgraphEdge.restoreTransients(controller);
        }
    }

    public ProblemEdge() {
    }

    public ProblemEdge(ProblemNode source, ProblemNode dest, EdgeData attr) {
        this.source = source;
        this.dest = dest;
        this.edgeData = attr;
        this.prevEdge = null;
        this.nextEdge = null;
        if (!Utils.isRuntime()) {
            this.functions = new LinkEditFunctions(this, attr.getController());
        }
    }

    public String toString() {
        return "ProblemEdge: [" + this.source + ", " + this.dest + "]";
    }

    public String toXMLString() {
        return ProblemStateWriter.multiLineOutputter.outputString(this.toElement());
    }

    public Element toElement() {
        Element elt = new Element(ELEMENT_NAME);
        Element child = null;
        child = this.edgeData.getActionLabelElement();
        if (child != null) {
            elt.addContent((Content)child);
        }
        if ((child = this.edgeData.getPreLispCheckLabel().toElement()) != null) {
            elt.addContent((Content)child);
        }
        for (RuleLabel rl : this.edgeData.getRuleLabels()) {
            elt.addContent((Content)rl.toElement());
        }
        ProblemNode node = this.getNodes()[0];
        if (node != null) {
            elt.addContent((Content)new Element("sourceID").setText(Integer.toString(node.getUniqueID())));
        }
        if ((node = this.getNodes()[1]) != null) {
            elt.addContent((Content)new Element("destID").setText(Integer.toString(node.getUniqueID())));
        }
        elt.addContent((Content)new Element("traversalCount").setText(Integer.toString(this.edgeData.getTraversalCount())));
        elt.addContent((Content)new Element("SimSt"));
        Vector assocElements = this.edgeData.getAssociatedElements();
        Vector assocElementsValues = this.edgeData.getAssociatedElementsValues();
        for (int i = 0; i < assocElements.size(); ++i) {
            String value;
            Element assocElt = new Element("element");
            String name = assocElements.get(i).toString();
            if (name != null) {
                assocElt.setAttribute("name", name);
            }
            if ((value = assocElementsValues.get(i).toString()) != null) {
                assocElt.setAttribute("value", value);
            }
            elt.addContent((Content)assocElt);
        }
        return elt;
    }

    public BR_Controller getController() {
        return this.edgeData.getController();
    }

    public ProblemNode[] getNodes() {
        return new ProblemNode[]{this.source, this.dest};
    }

    public EdgeData getEdgeData() {
        return this.edgeData;
    }

    public void setEdgeData(EdgeData attr) {
        this.edgeData = attr;
    }

    public LinkEditFunctions getLinkEditFunctions() {
        return this.functions;
    }

    public String getActionType() {
        return this.edgeData.getActionType();
    }

    public String getInput() {
        return (String)this.edgeData.getInput().get(0);
    }

    public String getSelection() {
        return (String)this.edgeData.getSelection().get(0);
    }

    public String getAction() {
        return (String)this.edgeData.getAction().get(0);
    }

    public boolean isPreferredEdge() {
        return this.edgeData.isPreferredEdge();
    }

    public Vector getSkills() {
        if (this.edgeData == null) {
            return new Vector();
        }
        return this.edgeData.getSkills();
    }

    public boolean isBuggy() {
        String authorintent = this.edgeData.getActionType();
        return authorintent.equalsIgnoreCase("Buggy Action") || authorintent.equalsIgnoreCase("Untraceable Error");
    }

    public boolean hasBuggyMessage() {
        String buggyMsg = this.edgeData.getBuggyMsg();
        return !buggyMsg.equals("");
    }

    public boolean isGiven() {
        String edgeActionType = this.edgeData.getActionType();
        return edgeActionType.equalsIgnoreCase("Given Action");
    }

    public boolean minGreaterThanMaxTraversals() {
        return this.edgeData.getMinTraversals() > this.edgeData.getMaxTraversals();
    }

    public boolean isSkip() {
        String edgeActionType = this.edgeData.getActionType();
        return edgeActionType.equalsIgnoreCase("Skip Action");
    }

    public boolean isCorrect() {
        String actionType = this.edgeData.getActionType();
        return actionType.equalsIgnoreCase("Correct Action");
    }

    public boolean isCltErrorAction() {
        String actionType = this.edgeData.getActionType();
        return actionType.equalsIgnoreCase("Error Action");
    }

    public boolean isDone() {
        Vector selection = this.edgeData.getSelection();
        for (int i = 0; i < selection.size(); ++i) {
            String tempSelectionString = (String)selection.elementAt(i);
            if (!tempSelectionString.equalsIgnoreCase("Done")) continue;
            return true;
        }
        return false;
    }

    public boolean isCorrectorFireableBuggy() {
        String actionType = this.edgeData.getActionType();
        return actionType.equalsIgnoreCase("Correct Action") || actionType.equalsIgnoreCase("Fireable Buggy Action");
    }

    public boolean selectionNameMatch(String widgetSelectionName) {
        if (widgetSelectionName == null) {
            return false;
        }
        if (widgetSelectionName.trim().length() == 0) {
            return false;
        }
        Vector selection = this.edgeData.getSelection();
        String firstSelection = (String)selection.elementAt(0);
        return widgetSelectionName.equalsIgnoreCase(firstSelection);
    }

    public boolean hasDialogueName() {
        String dialogueName = this.edgeData.getDialogueName().trim();
        return dialogueName.length() != 0;
    }

    public String getDialogueName() {
        String dialogueName = this.edgeData.getDialogueName().trim();
        return dialogueName;
    }

    public boolean hasHints() {
        Vector<String> hints = this.edgeData.getHints();
        return hints.size() > 0;
    }

    public ActionLabelHandler getActionHandler() {
        return this.edgeData.getActionLabel().getHandler();
    }

    public ActionLabel getActionLabel() {
        return this.edgeData.getActionLabel();
    }

    public CheckLispLabel getPreLispCheckLabel() {
        return this.edgeData.getPreLispCheckLabel();
    }

    public void setJGraphEdge(BR_JGraphEdge edge) {
        this.jgraphEdge = edge;
    }

    public BR_JGraphEdge getJGraphEdge() {
        return this.jgraphEdge;
    }

    public Sai getSai() {
        Sai sai = new Sai(this.edgeData.getSelection(), this.edgeData.getAction(), this.edgeData.getInput());
        return sai;
    }

    public int getUniqueID() {
        return this.getEdgeData().getUniqueID();
    }

    public void addEdgeLabels() {
        EdgeData myEdge = this.getEdgeData();
        myEdge.getActionLabel().addHandler(new ActionLabelHandler(myEdge.getActionLabel(), this.getController()));
        int rulesNumber = myEdge.getRuleLabels().size();
        for (int i = 0; i < rulesNumber; ++i) {
            RuleLabel tempRuleLabel = myEdge.getRuleLabels().elementAt(i);
            tempRuleLabel.addMouseListener(new RuleLabelHandler(tempRuleLabel, this, this.getController()));
        }
        this.setEdgeLabels(this);
    }

    public void setEdgeLabels(ProblemEdge Edge) {
        EdgeData myedge = Edge.getEdgeData();
        myedge.updateMovedFromEdgeView();
    }
}

