/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDB;
import edu.cmu.hcii.ctat.monitor.CTATNetworkTools;
import edu.cmu.hcii.ctat.monitor.CTATStreamedTableDiskLogger;
import edu.cmu.hcii.ctat.monitor.CTATTutorMonitorServerThread;
import edu.cmu.hcii.ctat.monitor.CTATXMLBase;
import java.util.UUID;
import org.w3c.dom.Element;

public class CTATClientEntry
extends CTATXMLBase {
    private int socketID = -1;
    private int port = -1;
    private String guid = "undefined";
    private String machineGuid = "undefined";
    private String clientType = "undefined";
    private String address = "127.0.0.1";
    private String access = "NONE";
    private String status = "START";
    private String report = "";
    private Boolean updated = false;
    private Boolean shouldLog = true;
    private Long lastPing = 0L;
    private Integer updateDelta = 1;
    private Integer lastTimestamp = 0;
    private CTATTutorMonitorServerThread aThread = null;
    protected CTATStreamedTableDiskLogger logger = null;
    private CTATBerkeleyDB dbDriver = null;

    public CTATClientEntry() {
        this.setClassName("CTATClientEntry");
        this.debug("CTATClientEntry ()");
        this.guid = UUID.randomUUID().toString();
        this.getHostname();
        this.logger = new CTATStreamedTableDiskLogger();
        this.report = new String();
    }

    public Integer getUpdateDelta() {
        return this.updateDelta;
    }

    public void setUpdateDelta(Integer updateDelta) {
        this.updateDelta = updateDelta;
    }

    public Long getLastPing() {
        return this.lastPing;
    }

    public void setLastPing(Long lastPing) {
        this.lastPing = lastPing;
    }

    public CTATBerkeleyDB getDbDriver() {
        return this.dbDriver;
    }

    public void setDbDriver(CTATBerkeleyDB dbDriver) {
        this.dbDriver = dbDriver;
    }

    public CTATStreamedTableDiskLogger getLogger() {
        return this.logger;
    }

    public CTATTutorMonitorServerThread getaThread() {
        return this.aThread;
    }

    public void setaThread(CTATTutorMonitorServerThread aThread) {
        this.aThread = aThread;
    }

    public Boolean checkService() {
        this.debug("checkService ()");
        return false;
    }

    public void resetReport() {
        this.report = "";
    }

    public void appendReport(String aMessage) {
        this.report = aMessage;
    }

    public String getReport() {
        return this.report;
    }

    public void startLogging() {
        this.debug("startLogging ()");
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.debug("setStatus (" + status + ")");
        if (status.isEmpty()) {
            this.debug("Error: status argument is empty");
            return;
        }
        String oldStatus = this.status;
        this.status = status;
        if (!oldStatus.equals(status)) {
            this.setUpdated(true);
        }
    }

    public Boolean getUpdated() {
        return this.updated;
    }

    public void setUpdated(Boolean updated) {
        this.updated = updated;
    }

    public String getMachineGuid() {
        return this.machineGuid;
    }

    public void setMachineGuid(String aMachineGuid) {
        if (aMachineGuid == null) {
            return;
        }
        if (aMachineGuid.isEmpty()) {
            return;
        }
        if (aMachineGuid.equals("")) {
            return;
        }
        this.machineGuid = aMachineGuid;
    }

    public String getAccess() {
        return this.access;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public int getID() {
        return this.socketID;
    }

    public void setID(int iD) {
        this.socketID = iD;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String uuid) {
        if (uuid.equals("-1") || uuid.isEmpty()) {
            return;
        }
        this.guid = uuid;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostname() {
        this.debug("getHostname (" + this.address + ")");
        CTATNetworkTools ntools = new CTATNetworkTools();
        String better = ntools.getHostname();
        if (this.address.equals("127.0.0.1") || this.address.equals("localhost")) {
            this.debug("Assigning better hostname: " + better);
            this.address = better;
        }
        return this.address;
    }

    public void setHostname(String aHostname) {
        this.debug("setHostname (" + aHostname + ")");
        if (aHostname == null) {
            this.debug("Null argument provided");
            return;
        }
        if (aHostname.equals("") || aHostname.isEmpty()) {
            this.debug("No valid hostname provided as argument");
            return;
        }
        if (!aHostname.equals("127.0.0.1") && !aHostname.toLowerCase().equals("localhost")) {
            this.debug("Valid hostname provided, assigning: " + aHostname);
            this.address = aHostname;
            return;
        }
        this.debug("Error unable to verify provided hostname to be valid, not assinging");
    }

    public Boolean parseHostConfig(Element root) {
        this.debug("parseHostConfig ()");
        this.setGuid(root.getAttribute("ID"));
        this.setHostname(root.getAttribute("host"));
        this.setPort(Integer.parseInt(root.getAttribute("port")));
        this.setAccess(root.getAttribute("access"));
        this.setStatus(root.getAttribute("status"));
        this.setMachineGuid(root.getAttribute("machineGUID"));
        return true;
    }

    @Override
    public Boolean fromXML(Element root) {
        this.debug("fromXML ()");
        if (!root.getNodeName().equals(this.getClientType())) {
            this.debug("Client type tag not found in node, instead got: " + root.getNodeName());
            return false;
        }
        this.parseHostConfig(root);
        return true;
    }

    public String toXMLOpen() {
        return "<" + this.clientType + " ID=\"" + this.getGuid() + "\" host=\"" + this.address + "\" port=\"" + this.getPort() + "\" access=\"" + this.getAccess() + "\" status=\"" + this.getStatus() + "\" machineGUID=\"" + this.getMachineGuid() + "\" delta=\"" + this.updateDelta.toString() + "\" >";
    }

    public String toXMLOpen(String attrName, String attrValue) {
        return "<" + this.clientType + " ID=\"" + this.getGuid() + "\" host=\"" + this.address + "\" port=\"" + this.getPort() + "\" access=\"" + this.getAccess() + "\" status=\"" + this.getStatus() + "\" machineGUID=\"" + this.getMachineGuid() + "\" delta=\"" + this.updateDelta.toString() + "\" " + attrName + "=\"" + attrValue + "\" >";
    }

    public String toXMLClose() {
        return "</" + this.clientType + ">";
    }

    @Override
    public String toXML() {
        this.debug("toXML ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toXMLOpen());
        buffer.append(this.toXMLClose());
        return buffer.toString();
    }

    public Boolean getShouldLog() {
        return this.shouldLog;
    }

    public void setShouldLog(Boolean shouldLog) {
        this.shouldLog = shouldLog;
    }

    public String toXMLUpdated() {
        this.debug("toXMLUpdated ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toXMLOpen());
        buffer.append(this.toXMLClose());
        return buffer.toString();
    }

    public void cleanup() {
        this.debug("cleanup ()");
    }

    public Integer getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(Integer timeStamp) {
        this.lastTimestamp = timeStamp;
    }
}

