/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.TutorController;
import edu.cmu.pact.miss.JTabbedPaneWithCloseIcons;
import edu.cmu.pact.miss.MetaTutor.APlusHintDialog;
import edu.cmu.pact.miss.MetaTutor.APlusHintDialogInterface;
import edu.cmu.pact.miss.MetaTutor.MetaTutorAvatarComponent;
import edu.cmu.pact.miss.PeerLearning.GameShow.ProblemBankTableModel;
import edu.cmu.pact.miss.PeerLearning.SimStExample;
import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.SimStPLEActionListener;
import edu.cmu.pact.miss.PeerLearning.StudentAvatarDisplay;
import edu.cmu.pact.miss.SimSt;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class SimStPeerTutoringPlatform
extends JComponent {
    BR_Controller brController = null;
    boolean runningAsApplication = false;
    SimStPLE simStPLE = null;
    JComponent studentInterface = null;
    JComponent metaTutorComponent = null;
    APlusHintDialogInterface aPlusHintDialogInterface;
    JTabbedPaneWithCloseIcons tabPane = null;
    Dimension platformSize = null;
    StudentAvatarDisplay layeredIcon = null;
    JLabel simStAvatorIcon = null;
    final int simStAvatorIconWidth = 200;
    final int simStAvatorIconHeight = 200;
    final int medalWidth = 37;
    final int medalHeight = 50;
    final int trophyHeight = 70;
    int medals;
    int trophies = 0;
    int totalWidth = 0;
    Dimension simStAvatorIconSize = new Dimension(200, 200);
    JPanel simStAvatorPanel = null;
    JPanel metaTutorAvatorPanel = null;
    JPanel simStAvatarSpeechPanel = null;
    JLayeredPane medalPane = null;
    JPanel speechPanel = null;
    JTextArea speechText = null;
    JScrollPane speechScroll = null;
    JPanel yesNoPanel = null;
    JButton yesResponseButton = null;
    JButton noResponseButton = null;
    JComboBox textResponse = null;
    JButton textResponseSubmitButton = null;
    JButton nextProblemButton = null;
    JButton quizButton = null;
    JButton curriculumBrowserButton = null;
    JButton exampleButton = null;
    JButton undoButton = null;
    JButton restartButton = null;
    JLabel simStNameLabel = null;
    JTabbedPane resultsPane = new JTabbedPane();
    JTabbedPane sectionResultsPane;
    int quizNumber = 1;
    JFrame quizResultFrame = new JFrame("Quiz Results");
    JProgressBar quizProgress = new JProgressBar(0, 100);
    JFrame topLevelFrame;
    Dimension windowSize = new Dimension(800, 900);
    Dimension examplePanelSize = new Dimension(500, 400);
    JDesktopPane desktop;
    public static final String WAIT_MESSAGE = "   Please Wait While Your Previous Work is Loaded";
    JProgressBar progressBar = new JProgressBar(0, 100);
    JLabel backgroundLabel;
    JLabel hairLabel;
    JLabel eyeLabel;
    JLabel noseLabel;
    JLabel shirtLabel;
    JLabel faceLabel;
    JFrame waitMsg;
    JTable problemBankTable;

    public JComponent getMetaTutorComponent() {
        return this.metaTutorComponent;
    }

    public void setMetaTutorComponent(JComponent metaTutorComponent) {
        this.metaTutorComponent = metaTutorComponent;
    }

    public MouseListener[] setMetaTutorComponentEnabled(boolean isEnabled, MouseListener[] mListener) {
        if (!isEnabled) {
            MouseListener[] ml = this.metaTutorComponent.getMouseListeners();
            for (int i = 0; i < ml.length; ++i) {
                this.metaTutorComponent.removeMouseListener(ml[i]);
            }
            this.metaTutorComponent.setEnabled(isEnabled);
            this.metaTutorComponent.validate();
            return ml;
        }
        if (isEnabled) {
            for (int i = 0; i < mListener.length; ++i) {
                this.metaTutorComponent.addMouseListener(mListener[i]);
            }
            this.metaTutorComponent.setEnabled(isEnabled);
            this.metaTutorComponent.validate();
            return null;
        }
        return null;
    }

    public APlusHintDialogInterface getAPlusHintDialogInterface() {
        return this.aPlusHintDialogInterface;
    }

    public void setAPlusHintDialogInterface(APlusHintDialogInterface aPlusHintDialogInterface) {
        this.aPlusHintDialogInterface = aPlusHintDialogInterface;
    }

    public JTabbedPaneWithCloseIcons getTabPane() {
        return this.tabPane;
    }

    public void setTabPane(JTabbedPaneWithCloseIcons tabPane) {
        this.tabPane = tabPane;
    }

    public Dimension getExamplePanelSize() {
        return this.examplePanelSize;
    }

    public SimStPeerTutoringPlatform() {
    }

    public SimStPeerTutoringPlatform(JComponent tutorPanel, TutorController brController) {
        int buttonWidth;
        int buttonHeight;
        BR_Controller temp = (BR_Controller)brController;
        this.setBrController(temp);
        SimStPLE.setComponentFont(tutorPanel, new Font("Serif", 0, 16));
        this.quizResultFrame.setLayout(new BorderLayout());
        this.quizProgress.setStringPainted(true);
        this.quizResultFrame.add((Component)this.quizProgress, "North");
        Dimension tutorPanelPreferredSize = tutorPanel.getPreferredSize();
        Dimension tutorPanelSize = tutorPanel.getSize();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "SimStPeerTutoringPlatform: tutorPanelPreferredSize = " + tutorPanelPreferredSize);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "SimStPeerTutoringPlatform: tutorPanelSize = " + tutorPanelSize);
        }
        this.setSimStPLE(new SimStPLE(temp, this));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "screenSize = " + screenSize);
        }
        int width = tutorPanelPreferredSize.width * 2 + 100;
        this.setPlatformSize(new Dimension(width, screenSize.height));
        this.setPreferredSize(this.getPlatformSize());
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "platformSize = " + this.getPlatformSize());
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setNextProblemButton(new JButton(this.getSimStPLE().getNextProblemButtonTitleString()));
        this.setQuizButton(new JButton(this.getSimStPLE().getQuizButtonTitleString()));
        this.setCurriculumBrowserButton(new JButton(this.getSimStPLE().getCurriculumBrowserButtonTitleString()));
        this.setExampleButton(new JButton(this.getSimStPLE().getShowExampleButtonTitleString()));
        this.setUndoButton(new JButton(this.getSimStPLE().getUndoButtonTitleString()));
        this.setRestartButton(new JButton(this.getSimStPLE().getRestartButtonTitleString()));
        SimStPLEActionListener actionListener = new SimStPLEActionListener(this.getBrController());
        this.getNextProblemButton().setActionCommand("next problem");
        this.getNextProblemButton().addActionListener(actionListener);
        this.getQuizButton().setActionCommand("quiz");
        this.getQuizButton().addActionListener(actionListener);
        this.getCurriculumBrowserButton().setActionCommand("curriculum browser");
        this.getCurriculumBrowserButton().addActionListener(actionListener);
        this.getExampleButton().setActionCommand("examples");
        this.getExampleButton().addActionListener(actionListener);
        this.getUndoButton().setActionCommand("undo");
        this.getUndoButton().addActionListener(actionListener);
        this.getRestartButton().setActionCommand("restart");
        this.getRestartButton().addActionListener(actionListener);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.setBackground(Color.GREEN);
        buttonPanel.add(this.getNextProblemButton());
        buttonPanel.add(this.getQuizButton());
        buttonPanel.add(this.getUndoButton());
        buttonPanel.add(this.getRestartButton());
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "buttonPanel size = " + buttonPanel.getSize());
        }
        if ((buttonHeight = this.getNextProblemButton().getHeight()) < this.getQuizButton().getHeight()) {
            buttonHeight = this.getQuizButton().getHeight();
        }
        if (buttonHeight < this.getCurriculumBrowserButton().getHeight()) {
            buttonHeight = this.getCurriculumBrowserButton().getHeight();
        }
        if (buttonHeight < this.getExampleButton().getHeight()) {
            buttonHeight = this.getExampleButton().getHeight();
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "buttonHeight = " + buttonHeight);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "buttonBounds = " + this.getNextProblemButton().getBounds());
        }
        if ((buttonWidth = this.getNextProblemButton().getWidth()) < this.getQuizButton().getWidth()) {
            buttonWidth = this.getQuizButton().getWidth();
        }
        if (buttonWidth < this.getCurriculumBrowserButton().getWidth()) {
            buttonWidth = this.getCurriculumBrowserButton().getWidth();
        }
        if (buttonWidth < this.getExampleButton().getWidth()) {
            buttonWidth = this.getExampleButton().getWidth();
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "buttonWidth= " + buttonWidth);
        }
        Dimension buttonSize = new Dimension(buttonWidth, buttonHeight);
        Dimension buttonPanelSize = new Dimension(this.getPlatformSize().width, buttonHeight + 20);
        this.setSimStAvatorIcon(new JLabel());
        this.getSimStAvatorIcon().setPreferredSize(this.getSimStAvatorIconSize());
        this.getSimStAvatorIcon().setBackground(Color.YELLOW);
        this.setSpeechPanel(new JPanel());
        this.getSpeechPanel().setBorder(BorderFactory.createEtchedBorder());
        this.getSpeechPanel().setBackground(Color.white);
        this.getSpeechPanel().setLayout(new BorderLayout());
        this.setSimStNameLabel(new JLabel(this.getSimStPLE().getSimStName(), 0));
        this.getSimStNameLabel().setFont(new Font("SansSerif", 0, 18));
        this.totalWidth = (int)this.getPlatformSize().getWidth();
        int aiWidth = this.getSimStAvatorIconSize().width;
        int aiHeight = this.getSimStAvatorIconSize().height + this.getSimStNameLabel().getHeight();
        this.simStAvatorPanel = new JPanel();
        this.simStAvatorPanel.setLayout(new BoxLayout(this.simStAvatorPanel, 1));
        this.simStAvatorPanel.setPreferredSize(new Dimension(aiWidth, aiHeight * 2));
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout());
        namePanel.setPreferredSize(new Dimension(aiWidth, 30));
        this.medalPane = new JLayeredPane();
        this.medalPane.setLayout(null);
        this.medalPane.setPreferredSize(new Dimension(aiWidth, 70));
        this.setUpLayeredIcon();
        this.setImage(SimStPLE.STUDENT_IMAGE);
        namePanel.add((Component)this.getSimStNameLabel(), "North");
        this.simStAvatorPanel.add(this.layeredIcon);
        this.simStAvatorPanel.add(namePanel);
        this.simStAvatorPanel.add(this.medalPane);
        this.simStAvatarSpeechPanel = new JPanel();
        this.simStAvatarSpeechPanel.setLayout(new BoxLayout(this.simStAvatarSpeechPanel, 0));
        this.getSpeechPanel().setPreferredSize(new Dimension((int)(2.5 * (double)aiWidth), aiHeight / 2));
        this.getSpeechPanel().setMinimumSize(new Dimension(aiWidth, aiHeight / 3));
        this.getSpeechPanel().setMaximumSize(new Dimension((int)(2.5 * (double)aiWidth), 2 * aiHeight / 3));
        this.simStAvatarSpeechPanel.setPreferredSize(new Dimension(this.totalWidth, aiHeight * 2));
        this.simStAvatarSpeechPanel.add(this.simStAvatorPanel);
        JPanel commPanel = new JPanel();
        this.yesNoPanel = new JPanel();
        this.setYesResponseButton(new JButton("Yes"));
        this.setNoResponseButton(new JButton("No"));
        this.yesNoPanel.setLayout(new BoxLayout(this.yesNoPanel, 0));
        int yesNoWidth = this.getYesResponseButton().getPreferredSize().width;
        int yesNoHeight = this.getYesResponseButton().getPreferredSize().height + this.getNoResponseButton().getPreferredSize().height;
        this.yesNoPanel.setPreferredSize(new Dimension(yesNoWidth, yesNoHeight));
        this.yesNoPanel.add(this.getYesResponseButton());
        this.yesNoPanel.add(this.getNoResponseButton());
        this.setTextResponse(new JComboBox());
        this.getTextResponse().setMaximumSize(new Dimension(500, 40));
        this.setTextResponseSubmitButton(new JButton("Submit"));
        this.getTextResponseSubmitButton().setMaximumSize(new Dimension(75, 40));
        this.setSpeechText(new JTextArea());
        this.getSpeechText().setFont(new Font("Monospace", 0, 12));
        this.getSpeechText().setLineWrap(true);
        this.getSpeechText().setEditable(false);
        this.speechScroll = new JScrollPane(this.getSpeechText());
        this.speechScroll.setHorizontalScrollBarPolicy(31);
        this.getSpeechPanel().setLayout(new BoxLayout(this.getSpeechPanel(), 1));
        this.getSpeechPanel().add((Component)this.speechScroll, "North");
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.add(this.getTextResponse());
        tmpPanel.add(this.getTextResponseSubmitButton());
        this.getSpeechPanel().add(tmpPanel);
        this.showButtons(false);
        this.showTextResponse(false);
        commPanel.setLayout(null);
        commPanel.setPreferredSize(new Dimension((int)(2.75 * (double)aiWidth), aiHeight));
        this.getSpeechPanel().setBounds(0, 5, (int)(2.5 * (double)aiWidth), 2 * aiHeight / 3);
        this.yesNoPanel.setBounds(0, 2 * aiHeight / 3 + 5, (int)(2.5 * (double)aiWidth), aiHeight / 3);
        commPanel.add((Component)this.getSpeechPanel(), "North");
        commPanel.add((Component)this.yesNoPanel, "South");
        this.simStAvatarSpeechPanel.add(commPanel);
        if (this.simStPLE.getSimSt().isSsMetaTutorMode()) {
            this.metaTutorComponent = new MetaTutorAvatarComponent("img/metatutor.png", this.getBrController().getMissController().getSimSt());
            this.metaTutorComponent.setPreferredSize(new Dimension(aiWidth, aiHeight * 2));
            this.simStAvatarSpeechPanel.add(this.metaTutorComponent);
            this.aPlusHintDialogInterface = new APlusHintDialog(new Frame(), this.simStPLE.getMissController().getAPlusHintMessagesManager(), this.simStPLE.logger, this.metaTutorComponent);
        }
        this.setStudentInterface(tutorPanel);
        int tpWidth = this.getPlatformSize().width;
        int tpHeight = this.getPlatformSize().height;
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "tpHeight = " + tpHeight);
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "tpHeight = " + tpHeight);
        }
        tpHeight -= this.simStAvatorPanel.getHeight();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "tpHeight = " + tpHeight);
        }
        tpHeight -= buttonPanel.getHeight();
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "tpHeight = " + tpHeight);
        }
        this.tabPane = new JTabbedPaneWithCloseIcons(this);
        JPanel topPanel = new JPanel();
        this.examplePanelSize = new Dimension(tpWidth, tpHeight);
        topPanel.setPreferredSize(this.getExamplePanelSize());
        topPanel.setLayout(new FlowLayout());
        topPanel.add(tutorPanel);
        this.tabPane.insertTab(this.simStPLE.getSimStName(), null, topPanel, "", 0);
        SimStPLEActionListener changeListener = new SimStPLEActionListener(this.getBrController());
        this.tabPane.addChangeListener(changeListener);
        this.add(this.tabPane);
        this.add(this.simStAvatarSpeechPanel);
        this.add(buttonPanel);
        this.getSimStPLE().generateProblemBankTab();
        this.getSimStPLE().setUpOverviewTab();
        this.getSimStPLE().showExamples();
        this.getSimStPLE().setUpVideoTab();
        this.getSimStPLE().removeComponentColor(this.getStudentInterface());
        this.requestFocus();
        this.simStAvatorPanel.setMinimumSize(new Dimension((int)((double)aiWidth * 1.1), (int)((double)aiWidth * 1.1)));
        this.simStAvatorPanel.setMaximumSize(new Dimension(aiWidth * 2, aiWidth * 2));
    }

    void initApplicationGUI(JComponent studentInterface) {
        this.setRunningAsApplication(true);
        this.setTopLevelFrame(new JFrame());
        this.getTopLevelFrame().getContentPane().add(studentInterface);
    }

    public void showMedals(boolean show) {
        if (this.medalPane != null) {
            this.medalPane.removeAll();
            int offset = 37;
            if (163 < 37 * (2 * this.trophies + this.medals - 1)) {
                offset = 163 / (2 * this.trophies + this.medals - 1);
            }
            for (int j = 1; j <= this.trophies; ++j) {
                JLabel t = new JLabel(this.createImageIcon("img/trophy" + j + ".png"));
                t.setBounds((j - 1) * offset * 2, 0, 74, 70);
                this.medalPane.add((Component)t, new Integer(j));
            }
            for (int k = 1; k <= this.medals; ++k) {
                JLabel m = new JLabel(this.createImageIcon("img/medal" + k + ".png"));
                m.setBounds((2 * this.trophies + k - 1) * offset, 20, 37, 50);
                this.medalPane.add((Component)m, new Integer(k + this.trophies));
            }
            this.medalPane.validate();
            this.medalPane.setVisible(false);
            this.medalPane.setVisible(show);
        }
    }

    public int getMedalCount() {
        return this.medals;
    }

    public void augmentMedals(int medals, boolean show) {
        this.medals += medals;
        this.showMedals(show);
    }

    public void addTrophy(boolean show) {
        ++this.trophies;
        this.augmentMedals(-1 * this.medals, show);
    }

    public void showQuizResultFrame(boolean isShowing) {
        this.quizResultFrame.setVisible(isShowing);
    }

    public void displayQuizResults(String solutions) {
        JLabel label = new JLabel(solutions);
        label.setFont(new Font("SansSerif", 0, 14));
        this.resultsPane.insertTab("Trial #" + this.quizNumber, null, label, null, 0);
        this.resultsPane.setSelectedIndex(0);
        this.quizResultFrame.add((Component)this.resultsPane, "Center");
        this.quizResultFrame.pack();
        ++this.quizNumber;
    }

    protected void setUpLayeredIcon() {
        this.layeredIcon = new StudentAvatarDisplay(50, 0);
        this.getSimStAvatorIcon().setBounds(0, 0, this.getSimStAvatorIconSize().width, this.getSimStAvatorIconSize().height);
        this.layeredIcon.add((Component)this.getSimStAvatorIcon(), new Integer(4));
        this.getSimStAvatorIcon().setVisible(false);
    }

    public ImageIcon createImageIcon(String path) {
        String file = "/edu/cmu/pact/miss/PeerLearning/" + path;
        URL url = this.getClass().getResource(file);
        return new ImageIcon(url);
    }

    public void displayQuizResults(String solutions, int sectionNumber, boolean complete, int levelNumber) {
        if (this.sectionResultsPane == null) {
            this.sectionResultsPane = new JTabbedPane();
            this.resultsPane.insertTab("Section " + levelNumber + "-" + sectionNumber, null, this.sectionResultsPane, null, 0);
            this.resultsPane.setSelectedIndex(0);
            this.quizResultFrame.add((Component)this.resultsPane, "Center");
            this.quizResultFrame.pack();
        }
        JLabel label = new JLabel(solutions);
        label.setFont(new Font("SansSerif", 0, 14));
        Dimension size = new Dimension(300, this.getHeight());
        if (complete) {
            this.sectionResultsPane.insertTab("Section " + levelNumber + "-" + sectionNumber + " Complete", null, label, null, 0);
            this.sectionResultsPane.setSelectedIndex(0);
            this.quizNumber = 1;
            this.sectionResultsPane = null;
        } else {
            this.sectionResultsPane.insertTab("Trial #" + this.quizNumber, null, label, null, 0);
            this.sectionResultsPane.setSelectedIndex(0);
            ++this.quizNumber;
        }
        this.quizResultFrame.setSize(size);
    }

    public void setQuizProgress(double percentCorrect) {
        int progress = (int)(percentCorrect * 100.0);
        this.quizProgress.setValue(progress);
    }

    public void setImageTeacher(boolean isTeacher) {
        if (isTeacher) {
            this.setImage("img/teacher.png");
            this.getSimStNameLabel().setText(this.simStPLE.getTeacherName());
            this.layeredIcon.setIsStaticGraphic(true);
        } else {
            this.getSimStAvatorIcon().setVisible(false);
            this.setImage(SimStPLE.STUDENT_IMAGE);
            this.getSimStNameLabel().setText(this.simStPLE.getSimStName());
            this.layeredIcon.setIsStaticGraphic(false);
        }
    }

    public void setImage(String img) {
        this.layeredIcon.setImage(img);
    }

    @Override
    public void setName(String name) {
        if (this.tabPane.getSelectedIndex() == 0) {
            this.simStNameLabel.setText(SimSt.getSimStName());
        }
        this.tabPane.setTitleAt(0, name);
        this.nextProblemButton.setText(this.getSimStPLE().getNextProblemButtonTitleString());
        this.quizButton.setText(this.getSimStPLE().getQuizButtonTitleString());
    }

    public void setExpression(String expression) {
        this.layeredIcon.setExpression(expression);
    }

    public void setSpeech(String text) {
        int width = 2 * this.getSimStAvatorIconSize().width - 20;
        JLabel temp = new JLabel(text);
        temp.setFont(new Font("Monospace", 0, 12));
        int textWidth = temp.getPreferredSize().width;
        if (textWidth > width && width != 0) {
            double percentFits = (double)width / (double)textWidth;
            int charsFit = (int)(percentFits * (double)text.length());
            String remaining = text;
            String formatted = "";
            while (remaining.length() > 0) {
                int newLine;
                if (remaining.length() < charsFit) {
                    int newLine2 = remaining.indexOf("\\n");
                    String tempString = "";
                    if (newLine2 != -1) {
                        tempString = remaining.substring(0, newLine2);
                        formatted = formatted + tempString + "\n";
                        remaining = remaining.substring(newLine2 + 2);
                    }
                    formatted = formatted + remaining + "\n";
                    remaining = "";
                    continue;
                }
                int firstSpace = remaining.indexOf(32);
                if (firstSpace == -1) {
                    firstSpace = remaining.length();
                }
                if ((newLine = remaining.indexOf("\\n")) == -1) {
                    newLine = remaining.length();
                }
                String tempString = "";
                if (newLine < charsFit) {
                    tempString = remaining.substring(0, newLine);
                    remaining = remaining.substring(newLine + 2);
                } else if (firstSpace > charsFit) {
                    tempString = remaining.substring(0, firstSpace);
                    remaining = remaining.substring(firstSpace + 1);
                } else {
                    tempString = remaining.substring(0, charsFit);
                    int lastSpace = tempString.lastIndexOf(32);
                    remaining = remaining.substring(lastSpace + 1);
                    tempString = tempString.substring(0, lastSpace);
                }
                formatted = formatted + tempString + "\n";
            }
            formatted = formatted + "";
            this.getSpeechText().setText(formatted);
        } else {
            this.getSpeechText().setText(text);
        }
        this.speechScroll.repaint();
    }

    public void setFormattedSpeech(String text) {
        this.getSpeechText().setText(text);
        this.scrollPaneToBottom();
    }

    public void appendSpeech(String text, String name) {
        if (this.tabPane.getSelectedComponent().getName() != null && this.tabPane.getSelectedComponent().getName().equalsIgnoreCase("Unit Overview")) {
            this.getSimStPLE().showTabText(this.tabPane.getSelectedComponent().getName());
            return;
        }
        String prevText = this.getSpeechText().getText();
        Calendar cal = Calendar.getInstance();
        String now = cal.get(12) < 10 ? "[" + cal.get(10) + ":0" + cal.get(12) + "]" : "[" + cal.get(10) + ":" + cal.get(12) + "]";
        if (now.contains("[0:")) {
            now = now.replace("[0:", "[12:");
        }
        text = now + " " + name + ": " + text;
        int width = (int)(2.5 * (double)this.getSimStAvatorIconSize().width) - 25;
        JLabel temp = new JLabel(text);
        temp.setFont(new Font("Monospace", 0, 12));
        int textWidth = temp.getPreferredSize().width;
        if (textWidth > width && width != 0) {
            double percentFits = (double)width / (double)textWidth;
            int charsFit = (int)(percentFits * (double)text.length());
            String remaining = text;
            String formatted = "";
            while (remaining.length() > 0) {
                int newLine;
                if (remaining.length() < charsFit) {
                    int newLine2 = remaining.indexOf("\\n");
                    String tempString = "";
                    if (newLine2 != -1) {
                        tempString = remaining.substring(0, newLine2);
                        formatted = formatted + tempString + "\n";
                        remaining = remaining.substring(newLine2 + 2);
                    }
                    formatted = formatted + remaining + "\n";
                    remaining = "";
                    continue;
                }
                int firstSpace = remaining.indexOf(32);
                if (firstSpace == -1) {
                    firstSpace = remaining.length();
                }
                if ((newLine = remaining.indexOf("\\n")) == -1) {
                    newLine = remaining.length();
                }
                String tempString = "";
                if (newLine < charsFit) {
                    tempString = remaining.substring(0, newLine);
                    remaining = remaining.substring(newLine + 2);
                } else if (firstSpace > charsFit) {
                    tempString = remaining.substring(0, firstSpace);
                    remaining = firstSpace + 1 >= remaining.length() ? "" : remaining.substring(firstSpace + 1);
                } else {
                    tempString = remaining.substring(0, charsFit);
                    int lastSpace = tempString.lastIndexOf(32);
                    remaining = remaining.substring(lastSpace + 1);
                    tempString = tempString.substring(0, lastSpace);
                }
                formatted = formatted + tempString + "\n";
            }
            formatted = formatted + "";
            if (prevText.endsWith(text)) {
                return;
            }
            this.getSpeechText().append(formatted);
        } else {
            if (prevText.endsWith(text.substring(7) + "\n")) {
                return;
            }
            this.getSpeechText().append(text + "\n");
        }
        this.speechScroll.repaint();
        this.scrollPaneToBottom();
    }

    public void clearSpeech() {
        this.getSpeechText().setText("");
        this.getTextResponse().setEditable(false);
        this.getTextResponse().setEnabled(false);
        this.getTextResponseSubmitButton().setEnabled(false);
        if (this.getTextResponse().getItemCount() > 0) {
            this.getTextResponse().removeAllItems();
        }
    }

    public void scrollPaneToBottom() {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimStPeerTutoringPlatform.this.speechScroll.getVerticalScrollBar().setValue(SimStPeerTutoringPlatform.this.speechScroll.getVerticalScrollBar().getMaximum());
                }
            });
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SimStPeerTutoringPlatform.this.speechScroll.getVerticalScrollBar().setValue(SimStPeerTutoringPlatform.this.speechScroll.getVerticalScrollBar().getMaximum());
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void refresh() {
    }

    public void showButtons(boolean show) {
        if (show) {
            this.getYesResponseButton().setVisible(false);
            this.getNoResponseButton().setVisible(false);
            this.setYesResponseButton(new JButton("Yes"));
            this.setNoResponseButton(new JButton("No"));
            this.getYesResponseButton().setPreferredSize(new Dimension(this.getYesResponseButton().getPreferredSize().width * 2, this.getYesResponseButton().getPreferredSize().height));
            this.getNoResponseButton().setPreferredSize(new Dimension(this.getNoResponseButton().getPreferredSize().width * 2, this.getNoResponseButton().getPreferredSize().height));
            this.yesNoPanel.add(this.getYesResponseButton());
            this.yesNoPanel.add(this.getNoResponseButton());
            this.getYesResponseButton().validate();
            this.getNoResponseButton().validate();
            this.yesNoPanel.validate();
            this.yesNoPanel.paintImmediately(this.yesNoPanel.getBounds());
        } else {
            this.getYesResponseButton().setVisible(show);
            this.getNoResponseButton().setVisible(show);
            this.getYesResponseButton().validate();
            this.getNoResponseButton().validate();
        }
        this.refresh();
    }

    public void restoreButtons() {
        this.getYesResponseButton().setVisible(true);
        this.getNoResponseButton().setVisible(true);
    }

    public void showTextResponse(boolean show) {
        if (show) {
            this.showButtons(false);
        }
        this.getTextResponse().setEditable(show);
        this.getTextResponse().setEnabled(show);
        this.getTextResponseSubmitButton().setEnabled(show);
        if (show) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimStPeerTutoringPlatform.this.getTextResponse().requestFocus();
                    SimStPeerTutoringPlatform.this.getTextResponse().validate();
                }
            });
        }
    }

    public void showTextResponseOptions(final boolean show, List<String> options) {
        if (show) {
            this.showButtons(false);
        }
        this.getTextResponse().removeAllItems();
        if (options != null) {
            for (String option : options) {
                this.getTextResponse().addItem(option);
            }
        }
        this.getTextResponse().setEditable(show);
        this.getTextResponse().setEnabled(show);
        this.getTextResponseSubmitButton().setEnabled(show);
        if (show) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimStPeerTutoringPlatform.this.getTextResponse().requestFocus();
                    SimStPeerTutoringPlatform.this.getTextResponse().validate();
                    if (show) {
                        SimStPeerTutoringPlatform.this.getTextResponse().showPopup();
                    }
                }
            });
        }
    }

    public void showWaitMessage(boolean show) {
        if (show) {
            this.waitMsg = new JFrame();
            this.waitMsg.setUndecorated(true);
            this.waitMsg.setSize(450, 100);
            this.waitMsg.setLocationRelativeTo(null);
            this.waitMsg.setAlwaysOnTop(true);
            JLabel msg = new JLabel(WAIT_MESSAGE);
            msg.setFont(new Font(msg.getFont().getFamily(), msg.getFont().getStyle(), 14));
            msg.setBorder(BorderFactory.createRaisedBevelBorder());
            this.waitMsg.getContentPane().setLayout(new BorderLayout());
            this.waitMsg.getContentPane().add((Component)msg, "Center");
            this.waitMsg.getContentPane().add((Component)this.progressBar, "South");
            this.waitMsg.setVisible(true);
        } else if (this.waitMsg != null) {
            this.waitMsg.setVisible(false);
        }
    }

    public void setWaitProgress(double percentProgress) {
        int progress = (int)(percentProgress * 100.0);
        this.progressBar.setValue(progress);
    }

    public Component createProblemBank(String[] columns, Object[][] problemBank) {
        final String[] columnToolTips = new String[]{"Generated Problems to Try Solving", "Number of Times Students Tried Problems Similar to This One", "Estimated Difficulty of the Problem"};
        this.problemBankTable = new JTable(new ProblemBankTableModel(columns, problemBank)){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return columnToolTips[realIndex];
            }
        };
        this.problemBankTable.setFillsViewportHeight(true);
        JScrollPane scroll = new JScrollPane(this.problemBankTable);
        this.problemBankTable.setSize(400, 400);
        this.problemBankTable.setAutoCreateRowSorter(true);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.problemBankTable.getModel());
        this.problemBankTable.setRowSorter(sorter);
        return scroll;
    }

    public Component createProblemBankNew(String[] columns, Object[][] problemBank) {
        final String[] columnToolTips = new String[]{"Generated Problems to Try Solving", "Number of Times Students Tried Problems Similar to This One", "Estimated Difficulty of the Problem"};
        this.problemBankTable = new JTable(new ProblemBankTableModel(columns, problemBank)){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return columnToolTips[realIndex];
            }
        };
        this.problemBankTable.setFillsViewportHeight(true);
        JScrollPane scroll = new JScrollPane(this.problemBankTable);
        this.problemBankTable.setSize(400, 400);
        this.problemBankTable.setAutoCreateRowSorter(true);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.problemBankTable.getModel());
        this.problemBankTable.setRowSorter(sorter);
        this.problemBankTable.getRowSorter().toggleSortOrder(1);
        this.problemBankTable.getRowSorter().toggleSortOrder(1);
        this.problemBankTable.getTableHeader().setBackground(new Color(202, 202, 202));
        return scroll;
    }

    public boolean isRunningAsApplication() {
        return this.runningAsApplication;
    }

    public void setRunningAsApplication(boolean runningAsApplication) {
        this.runningAsApplication = runningAsApplication;
    }

    public BR_Controller getBrController() {
        return this.brController;
    }

    public void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    public SimStPLE getSimStPLE() {
        return this.simStPLE;
    }

    public void setSimStPLE(SimStPLE simStPLE) {
        this.simStPLE = simStPLE;
    }

    public JComponent getStudentInterface() {
        return this.studentInterface;
    }

    public void setStudentInterface(JComponent studentInterface) {
        this.studentInterface = studentInterface;
    }

    public void setSpeechPanel(JPanel panel) {
        this.speechPanel = panel;
    }

    public JPanel getSpeechPanel() {
        return this.speechPanel;
    }

    private void setSpeechText(JTextArea speechText) {
        this.speechText = speechText;
    }

    private JTextArea getSpeechText() {
        return this.speechText;
    }

    private void setYesResponseButton(JButton yesButton) {
        this.yesResponseButton = yesButton;
    }

    public JButton getYesResponseButton() {
        return this.yesResponseButton;
    }

    private void setNoResponseButton(JButton noButton) {
        this.noResponseButton = noButton;
    }

    public JButton getNoResponseButton() {
        return this.noResponseButton;
    }

    private void setTextResponse(JComboBox text) {
        this.textResponse = text;
    }

    public JComboBox getTextResponse() {
        return this.textResponse;
    }

    private void setTextResponseSubmitButton(JButton text) {
        this.textResponseSubmitButton = text;
    }

    public JButton getTextResponseSubmitButton() {
        return this.textResponseSubmitButton;
    }

    public JLabel getSimStAvatorIcon() {
        return this.simStAvatorIcon;
    }

    public void setSimStAvatorIcon(JLabel simStAvatorIcon) {
        this.simStAvatorIcon = simStAvatorIcon;
    }

    public JLayeredPane getSimStAvatarLayerIcon() {
        return this.layeredIcon;
    }

    public void setSimStAvatarLayerIcon(StudentAvatarDisplay icon) {
        this.layeredIcon = icon;
    }

    public JLabel getSimStNameLabel() {
        return this.simStNameLabel;
    }

    public void setSimStNameLabel(JLabel simStNameLabel) {
        this.simStNameLabel = simStNameLabel;
    }

    public JFrame getTopLevelFrame() {
        return this.topLevelFrame;
    }

    public void setTopLevelFrame(JFrame topLevelFrame) {
        this.topLevelFrame = topLevelFrame;
    }

    public Dimension getSimStAvatorIconSize() {
        return this.simStAvatorIconSize;
    }

    public void setSimStAvatorIconSize(Dimension simStAvatorIconSize) {
        this.simStAvatorIconSize = simStAvatorIconSize;
    }

    public Dimension getPlatformSize() {
        return this.platformSize;
    }

    public void setPlatformSize(Dimension plaformSize) {
        this.platformSize = plaformSize;
    }

    public JButton getNextProblemButton() {
        return this.nextProblemButton;
    }

    public void setNextProblemButton(JButton nextProblemButton) {
        this.nextProblemButton = nextProblemButton;
    }

    public JButton getQuizButton() {
        return this.quizButton;
    }

    public void setQuizButton(JButton quizButton) {
        this.quizButton = quizButton;
    }

    public JButton getExampleButton() {
        return this.exampleButton;
    }

    public void setExampleButton(JButton cbButton) {
        this.exampleButton = cbButton;
    }

    public void setUndoButton(JButton cbButton) {
        this.undoButton = cbButton;
    }

    public JButton getUndoButton() {
        return this.undoButton;
    }

    public void setRestartButton(JButton cbButton) {
        this.restartButton = cbButton;
    }

    public JButton getRestartButton() {
        return this.restartButton;
    }

    public JButton getCurriculumBrowserButton() {
        return this.curriculumBrowserButton;
    }

    public void setCurriculumBrowserButton(JButton cbButton) {
        this.curriculumBrowserButton = cbButton;
    }

    public JTabbedPaneWithCloseIcons getExamplePane() {
        return this.tabPane;
    }

    public String getCurrentSpeechText() {
        return this.getSpeechText().getText();
    }

    public boolean getButtonsShowing() {
        return this.getYesResponseButton().isVisible();
    }

    public void setNextProblemButtonEnabled(boolean isEnabled) {
        this.nextProblemButton.setEnabled(isEnabled);
        this.nextProblemButton.repaint();
    }

    public void setRestartButtonEnabled(boolean isEnabled) {
        this.restartButton.setEnabled(isEnabled);
        this.restartButton.repaint();
    }

    public void setQuizButtonEnabled(boolean isEnabled) {
        this.quizButton.setEnabled(isEnabled);
        this.quizButton.repaint();
    }

    public void setUndoButtonEnabled(boolean isEnabled) {
        this.undoButton.setEnabled(isEnabled);
        this.undoButton.repaint();
    }

    public void setUndoButtonText(String text) {
        this.undoButton.setText(text);
    }

    public void addSection(String sectionName) {
    }

    public void addQuiz(SimStExample quiz) {
    }

    public void clearQuizzes() {
    }

    public void unlockQuiz(int index) {
    }

    public void setSpeech(String text, boolean quiz) {
        this.setSpeech(text);
    }

    public void setWait(boolean isWaiting) {
        if (isWaiting) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setUpTakingQuiz() {
        this.refresh();
        this.clearSpeech();
        this.setExpression("img/face6.png");
    }

    public void hideTakingQuiz() {
    }

    public void setQuizMessage(String message) {
        this.simStPLE.giveMessage(message);
    }

    public static void main(String[] args) {
    }
}

