/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.jess.GetCustomFieldsFact;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MessageHandler;
import edu.cmu.pact.jess.WMEEditor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import jess.Fact;
import jess.Rete;
import org.jdom.Element;

public class ProdSysCheckMessgHandler
extends MessageHandler {
    private Vector ruleNames;
    private List<String> skillNames;
    private Integer actionLabelTagId;
    private Vector messages;
    private Vector wmImages;
    private String transactionId = null;
    private String tutorSelection = null;
    private String tutorAction = null;
    private String tutorInput = null;

    static void executeSynchronously(MessageObject msg, JessModelTracing jmt, CTAT_Controller controller, WMEEditor wmeEditor) {
        ExecuteInstance ei = new ExecuteInstance(msg, jmt, controller, wmeEditor);
        ei.execute();
    }

    public ProdSysCheckMessgHandler(MessageObject o, JessModelTracing jmt, CTAT_Controller controller) {
        super(o, jmt, controller);
        this.init();
    }

    public void init() {
        this.messages = new Vector();
        this.selectionList = this.recdMessage.getSelection();
        this.inputList = this.recdMessage.getInput();
        this.actionList = this.recdMessage.getAction();
        this.ruleNames = (Vector)this.recdMessage.getProperty("RuleNames");
        this.actionLabelTagId = this.recdMessage.getPropertyAsInteger("ActionLabelTagID");
        this.transactionId = this.recdMessage.getTransactionId();
    }

    @Override
    public String processMessage() {
        block18: {
            boolean notApplicable = false;
            this.messages.removeAllElements();
            Enumeration selectionEnum = this.selectionList.elements();
            String sel = (String)selectionEnum.nextElement();
            int selectionIndex = this.selectionList.indexOf(sel);
            String act = (String)this.actionList.get(selectionIndex);
            String inp = (String)this.inputList.get(selectionIndex);
            try {
                if (JessModelTracing.isSAIToBeModelTraced(sel, act)) {
                    this.checkResult = this.jmt.runModelTrace(true, false, sel, act, inp, this.messages);
                    this.setTutorSAI(this.jmt);
                    if (this.jmt.getWMImages() != null) {
                        this.wmImages = new Vector();
                        this.wmImages.addAll(this.jmt.getWMImages());
                    }
                    if (this.ruleNames != null) {
                        this.ruleNames.clear();
                    } else {
                        this.ruleNames = new Vector();
                    }
                    this.ruleNames.addAll(this.jmt.getRuleSeq());
                    if (this.skillNames != null) {
                        this.skillNames.clear();
                    } else {
                        this.skillNames = new ArrayList<String>();
                    }
                    this.skillNames.addAll(this.jmt.getSkillSeq());
                    if (!"SUCCESS".equals(this.checkResult) && this.getController() != null && this.getController().updateModelOnTraceFailure()) {
                        this.jmt.getRete().setSAIDirectly(sel, act, inp);
                    }
                    this.returnMessage = this.messages.size() > 0 ? (!"SUCCESS".equals(this.checkResult) ? this.createLispCheckResult("BuggyMsg", this.messages) : this.createLispCheckResult("SuccessMsg", this.messages)) : this.createLispCheckResult(null, null);
                    this.sendMessage();
                    break block18;
                }
                if (JessModelTracing.isHintRequest(sel, act)) {
                    String actionString2;
                    String selectionString = "";
                    String actionString = "";
                    if (this.actionList.size() > 1 && (actionString2 = this.actionList.get(1).toString()).equalsIgnoreCase("PreviousFocus") && this.selectionList.size() > 1) {
                        selectionString = this.selectionList.get(1).toString();
                        if (this.actionList.size() > 2 && this.actionList.get(2) != null) {
                            actionString = this.actionList.get(2).toString();
                        }
                    }
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "to call HINT modelTrace( sel " + sel + ", act " + act + ") with selectionString " + selectionString);
                    }
                    this.messages.removeAllElements();
                    this.checkResult = this.jmt.runModelTrace(true, true, selectionString, actionString, "", this.messages);
                    this.setTutorSAI(this.jmt);
                    if (this.ruleNames != null) {
                        this.ruleNames.clear();
                    } else {
                        this.ruleNames = new Vector();
                    }
                    this.ruleNames.addAll(this.jmt.getRuleSeq());
                    if (this.skillNames != null) {
                        this.skillNames.clear();
                    } else {
                        this.skillNames = new ArrayList<String>();
                    }
                    this.skillNames.addAll(this.jmt.getSkillSeq());
                    if (this.messages.size() < 1) {
                        this.messages.add("I'm sorry, no hint is available at this step");
                    }
                    this.returnMessage = this.createLispCheckResult("HintMessages", this.messages);
                    this.sendMessage();
                    break block18;
                }
                throw new IllegalArgumentException("Neither an update nor a hint request: act=" + act + ", sel=" + sel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private void setTutorSAI(JessModelTracing jmt) {
        this.tutorSelection = jmt.getTutorSelection();
        this.tutorAction = jmt.getTutorAction();
        this.tutorInput = jmt.getTutorInput();
    }

    private MessageObject createLispCheckResult(String msgListName, List msgList) {
        List<Element> customFields;
        MessageObject mo = MessageObject.create("LispCheckResult", "SetProperty");
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "createLispCheckResultResult " + this.checkResult + " " + this.actionLabelTagId + " " + this.selectionList + " " + this.actionList + " " + this.inputList + " " + msgListName + "=" + msgList);
        }
        if (msgListName != null && msgList != null && msgList.size() > 0) {
            if (msgListName.toLowerCase().startsWith("hint")) {
                mo.setProperty(msgListName, msgList);
            } else {
                mo.setProperty(msgListName, msgList.get(0));
            }
        }
        mo.setProperty("Result", this.checkResult);
        mo.setSelection(this.tutorSelection);
        if (trace.getDebugCode("mo")) {
            trace.out("mo", "PSCMH.createLispCheckResult() getSelection " + mo.getSelection() + ", class " + (mo.getSelection() == null ? null : mo.getSelection().getClass()));
        }
        mo.setAction(this.tutorAction);
        mo.setInput(this.tutorInput);
        mo.setProperty("StudentSelection", this.selectionList);
        mo.setProperty("StudentAction", this.actionList);
        mo.setProperty("StudentInput", this.inputList);
        mo.setProperty("ActionLabelTagID", this.actionLabelTagId);
        if (this.skillNames != null && this.skillNames.size() > 0) {
            mo.setProperty("Skills", this.skillNames);
        }
        if (this.ruleNames != null && this.ruleNames.size() > 0) {
            mo.setProperty("ProductionList", this.ruleNames);
        }
        if (this.wmImages != null && this.wmImages.size() > 0) {
            mo.setProperty("WMImages", this.wmImages);
        }
        if (this.transactionId != null && this.transactionId.length() > 0) {
            mo.setTransactionId(this.transactionId);
        }
        if ((customFields = this.getCustomFields(this.jmt.getRete())) != null) {
            mo.setProperty("custom_fields", customFields);
        }
        return mo;
    }

    private List<Element> getCustomFields(Rete rete) {
        Fact f = GetCustomFieldsFact.get(rete);
        List<Element> result = GetCustomFieldsFact.toXML(f, rete.getGlobalContext());
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "ProdSysMsgHandler.getCustomFields() fact, xml:\n  " + f + "\n  " + result);
        }
        return result;
    }

    @Override
    public void sendMessage() {
        CTAT_Controller ctlr = this.getController();
        if (ctlr == null) {
            if (!Utils.isRuntime()) {
                JOptionPane.showMessageDialog(ctlr.getActiveWindow(), "Error in the communication  between the Interface and the Production system. \nTry again after restarting the tools.");
            }
            trace.err("null CTAT_Controller in ProdSysCheckMessgHandler.sendMessage()");
            return;
        }
        if (this.returnMessage == null) {
            trace.err("null returnMessage in ProdSysCheckMessgHandler.sendMessage()");
        } else {
            this.fireMessageEvent(this.returnMessage);
            ctlr.handleCommMessage(this.returnMessage);
        }
    }

    static class Queue
    implements Runnable {
        private static final long MAX_IDLE_TIME = 120000L;
        private java.util.Queue<ExecuteInstance> theQueue = new LinkedList<ExecuteInstance>();
        private volatile boolean isActive = false;

        Queue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ExecuteInstance ei = null;
                Queue queue = this;
                synchronized (queue) {
                    this.isActive = true;
                    long now = System.currentTimeMillis();
                    long then = now + 120000L;
                    while (this.theQueue.peek() == null) {
                        try {
                            this.wait(then - now);
                        }
                        catch (Exception e) {
                            now = System.currentTimeMillis();
                            trace.err("ProdSysCheckMessgHandler.Queue.run() exception after waiting " + (now - (then - 120000L)) + " ms on queue: " + e + "; cause: " + e.getCause());
                        }
                        if (this.theQueue.peek() != null) break;
                        now = System.currentTimeMillis();
                        if (then > now) continue;
                        this.isActive = false;
                        return;
                    }
                    ei = this.theQueue.remove();
                }
                ei.execute();
                if (!trace.getDebugCode("mt")) continue;
                trace.outNT("mt", "ProdSysCheckMessgHandler.Queue.run() length " + this.theQueue.size());
            }
        }

        int add(MessageObject msg, JessModelTracing jmt, CTAT_Controller controller, WMEEditor wmeEditor) {
            return this.add(new ExecuteInstance(msg, jmt, controller, wmeEditor));
        }

        synchronized int add(ExecuteInstance ei) {
            this.theQueue.add(ei);
            if (trace.getDebugCode("mt")) {
                trace.outNT("mt", "ProdSysCheckMessgHandler.Queue.add() length " + this.theQueue.size());
            }
            if (!this.isActive) {
                Thread t = new Thread(this);
                t.start();
            }
            this.notify();
            return this.theQueue.size();
        }
    }

    private static class ExecuteInstance {
        final MessageObject msg;
        final JessModelTracing jmt;
        final CTAT_Controller controller;
        final WMEEditor wmeEditor;

        ExecuteInstance(MessageObject msg, JessModelTracing jmt, CTAT_Controller controller, WMEEditor wmeEditor) {
            this.msg = msg;
            this.jmt = jmt;
            this.controller = controller;
            this.wmeEditor = wmeEditor;
        }

        void execute() {
            ProdSysCheckMessgHandler handler = new ProdSysCheckMessgHandler(this.msg, this.jmt, this.controller);
            if (this.wmeEditor != null) {
                handler.addMessageEventListener(this.wmeEditor);
            }
            handler.processMessage();
        }
    }
}

