/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctatview;

import edu.cmu.pact.BehaviorRecorder.Dialogs.SkillMatrixDialog;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateReaderJDom;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;

public class CTATtoLMS {
    private static final String HIERARCHY = "hierarchy.txt";
    private String curDir = null;
    private File root = null;
    private String studentInterface;
    private String platform;
    private String history = "";
    private boolean[] msgOption;
    private boolean fromMenu;
    private HashMap<String, File> brdFileMap = new HashMap();
    private HashMap<String, ArrayList<File>> skillToProblemMap = new HashMap();
    private HashMap<File, HashSet<String>> problemToSkillMap = new HashMap();
    private String date;
    private ArrayList<String> omitted;
    private ArrayList<String> unitNames;
    private static final String RANDOM = "random";
    private ArrayList<ArrayList<Section>> curriculum;
    private String curricName;

    public CTATtoLMS(File root, String platform, String studentInterface, String msgOption, boolean fromMenu) {
        this.curDir = root.getAbsolutePath() + File.separator;
        this.root = root;
        this.studentInterface = studentInterface;
        this.platform = platform;
        this.msgOption = new boolean[4];
        for (int i = 0; i < msgOption.length(); ++i) {
            if (msgOption.charAt(0) != 'y' && msgOption.charAt(0) != 'Y') continue;
            this.msgOption[i] = true;
        }
        this.fromMenu = fromMenu;
        this.date = this.getDate();
        this.curriculum = new ArrayList();
        this.unitNames = new ArrayList();
        this.omitted = new ArrayList();
    }

    public static void main(String[] args) {
        String status = CTATtoLMS.run(args, false);
        if (status != null && status != "") {
            System.out.println(status);
        }
    }

    public static String run(String[] args, boolean fromMenu) {
        String filename;
        String string = filename = args == null || args.length == 0 ? JOptionPane.showInputDialog(null, (Object)"Filepath: ") : args[0];
        if (filename == null) {
            return "Error: Cancelled by user";
        }
        File d = new File(filename);
        if (!(d.isDirectory() || d.getAbsolutePath().endsWith(".brd") || d.getName().contains(HIERARCHY))) {
            return "Error: Not a folder, .brd, or hierarchy.txt";
        }
        if (d.getName().equals(HIERARCHY)) {
            d = d.isFile() ? d.getAbsoluteFile().getParentFile() : new File(System.getProperty("user.dir"));
        }
        String platform = args == null || args.length <= 1 ? JOptionPane.showInputDialog(null, (Object)"Platform: ") : args[1];
        String studentInterface = args == null || args.length <= 2 ? JOptionPane.showInputDialog(null, (Object)"StudentInterface: ") : args[2];
        String options = "NYYY";
        if (args.length > 3) {
            options = args[3];
        }
        String msgOption = "YYN";
        if (args.length > 4) {
            msgOption = args[4];
        }
        CTATtoLMS t = new CTATtoLMS(d, platform, studentInterface, msgOption, fromMenu);
        t.setup();
        if (!t.doOptions(options)) {
            return t.history;
        }
        t.debugging("Success!");
        return t.history;
    }

    private boolean doOptions(String options) {
        if (options.length() != 4) {
            this.error("Invalid options (needs 4 y/n's), usage: java CTATtoLMS (filepath) (platformName) (stuInterfaceName) (options[xml, xcur, unit, bas])* (debugging)* [see comments for more]");
            return false;
        }
        if (!(options.charAt(0) != 'y' && options.charAt(0) != 'Y' || this.createExcelFile(this.problemToSkillMap.keySet(), this.skillToProblemMap, this.problemToSkillMap))) {
            this.error("Could not create Excel file");
        }
        if (!(options.charAt(1) != 'y' && options.charAt(1) != 'Y' || this.createXCURFile())) {
            this.error("Could not create Unit (or Xcur) file(s)");
        }
        if (!(options.charAt(2) != 'y' && options.charAt(2) != 'Y' || this.createUnitFiles())) {
            this.error("Could not create Unit (or Xcur) file(s)");
        }
        if (options.charAt(3) == 'y' || options.charAt(3) == 'Y') {
            new File(this.curDir + "bas").mkdir();
            for (File f : this.brdFileMap.values()) {
                if (this.createBAS(f, new File(this.curDir + "bas" + File.separator + f.getName().replace(".brd", ".bas")), (Set<String>)this.problemToSkillMap.get(f))) continue;
                this.error("Could not create BAS file");
            }
        }
        return true;
    }

    public void setup() {
        this.setupMaps(this.root);
        boolean hierarchyExists = false;
        File[] files = this.root.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (!files[i].getName().equals(HIERARCHY)) continue;
            hierarchyExists = true;
        }
        Parse p = (Parse)((Object)(hierarchyExists ? new FromTxt(this.root) : new FromFolders(this.root)));
        if (!hierarchyExists) {
            this.debugging("Parsing from directory");
            if (!p.setup()) {
                this.error("Could not create hierarchy from folders");
            }
        } else {
            this.debugging("Parsing from hierarchy.txt file");
            if (!p.setup()) {
                this.error("Could not create hierarchy from txt");
            }
        }
    }

    private void setupMaps(File parent) {
        if (!parent.getName().endsWith(".brd")) {
            File[] files = this.filter(parent, 0);
            for (int i = 0; i < files.length; ++i) {
                this.setupMaps(files[i]);
            }
        } else {
            this.brdFileMap.put(parent.getName(), parent);
            String brdContents = this.inputFile(parent);
            String[] prodRules = brdContents.split("<productionRule>");
            for (int j = 1; j < prodRules.length; ++j) {
                String ruleName = prodRules[j].split("<ruleName>")[1].split("</ruleName")[0];
                String prodSet = prodRules[j].split("<productionSet>")[1].split("</productionSet")[0];
                String skillName = ruleName + ' ' + prodSet;
                ArrayList<File> fileSet = this.skillToProblemMap.get(skillName);
                if (fileSet == null) {
                    fileSet = new ArrayList();
                }
                fileSet.add(parent);
                this.skillToProblemMap.put(skillName, fileSet);
                HashSet<String> skillNames = this.problemToSkillMap.get(parent);
                if (skillNames == null) {
                    skillNames = new HashSet();
                }
                skillNames.add(skillName);
                this.problemToSkillMap.put(parent, skillNames);
            }
        }
    }

    private boolean createUnitFiles() {
        boolean success = true;
        for (int i = 0; i < this.curriculum.size(); ++i) {
            ArrayList<Section> unit = this.curriculum.get(i);
            success = success && this.createUnitFile(this.unitNames.get(i), unit);
        }
        return success;
    }

    private HashMap<String, ArrayList> getMatrix(ArrayList<Section> unit) {
        Vector<String> unitRuleProductionList = new Vector<String>();
        HashMap<String, ArrayList> unitSkillsFrequency = new HashMap<String, ArrayList>();
        for (Section s : unit) {
            for (File problem : s.getProblemFiles()) {
                RuleProduction.Catalog rpc = new RuleProduction.Catalog();
                ProblemStateReaderJDom psrj = new ProblemStateReaderJDom(null);
                ProblemModel pm = psrj.loadBRDFileIntoProblemModel(problem.getAbsolutePath(), rpc);
                if (pm == null) continue;
                List<Integer> tempVector = SkillMatrixDialog.problemSkillsMatrix(pm, unitRuleProductionList, rpc);
                ArrayList<Integer> problemFrequency = new ArrayList<Integer>(tempVector);
                unitSkillsFrequency.put(problem.getName(), problemFrequency);
            }
        }
        ArrayList productionRules = new ArrayList();
        for (int i = 0; i < unitRuleProductionList.size(); ++i) {
            productionRules.add(unitRuleProductionList.get(i));
        }
        unitSkillsFrequency.put("skills", productionRules);
        return unitSkillsFrequency;
    }

    private boolean createBAS(File input, File output, Set<String> skillNames) {
        this.debugging("Parsing " + input.getName());
        String problemHeader = "<?xml version=\"1.0\" encoding=\"US-ASCII\"   ?>\n<LMS:Problem id=\"_PROBLEM_NAME_\" name=\"_PROBLEM_NAME_\" problem_type=\"PROBLEM\" description=\"filler\">\r\n";
        String skillInfo = "<LMS:ProblemSkill subskill_id=\"_SKILL_\" skill_count=\"1\"/>\r\n";
        String problemFooter = "</LMS:Problem>";
        String problemName = input.getName().replaceAll(".brd", "");
        String contents = "";
        contents = contents + "<?xml version=\"1.0\" encoding=\"US-ASCII\"   ?>\n<LMS:Problem id=\"_PROBLEM_NAME_\" name=\"_PROBLEM_NAME_\" problem_type=\"PROBLEM\" description=\"filler\">\r\n".replaceAll("_PROBLEM_NAME_", problemName);
        if (skillNames != null) {
            for (String skillName : skillNames) {
                contents = contents + "<LMS:ProblemSkill subskill_id=\"_SKILL_\" skill_count=\"1\"/>\r\n".replaceAll("_SKILL_", skillName);
            }
        }
        contents = contents + "</LMS:Problem>";
        return this.outputFile(output, contents);
    }

    private boolean createExcelFile(Set<File> files, HashMap<String, ArrayList<File>> skillToProblemMap, HashMap<File, HashSet<String>> problemToSkillMap) {
        this.debugging("Creating xml document " + this.root.getName());
        ExcelFormatter x = new ExcelFormatter(files, skillToProblemMap, problemToSkillMap);
        String xmlContents = "";
        xmlContents = xmlContents + x.xmlHeader();
        xmlContents = xmlContents + x.createProblemLibrary();
        for (int i = 0; i < this.curriculum.size(); ++i) {
            xmlContents = xmlContents + x.createUnitLibrary(this.unitNames.get(i), this.curriculum.get(i));
        }
        xmlContents = xmlContents + x.createSkillLibrary();
        xmlContents = xmlContents + x.xmlFooter();
        return this.outputFile(new File(this.curDir + this.root.getName() + ".xml"), xmlContents);
    }

    private boolean createUnitFile(String unitName, List<Section> unit) {
        this.debugging("Creating unit file " + unitName);
        String unitHeader = "<?xml version=\"1.0\" encoding=\"US-ASCII\"  ?>\r\n<!-- $Id: CTATtoLMS.java 23661 2016-06-07 16:16:21Z sewall $\r\n     $Name$ -->\r\n \r\n  <LMS:Unit  xmlns:LMS=\"http://www.carnegielearning.com/LMS\" id=\"_UNIT_NAME_\"  name=\"_UNIT_NAME_\" >\r\n";
        String sectionHeader = "    <LMS:Section id=\"_UNIT_NAME_-_SECTION_NUM_\" name=\"_SECTION_NAME_\" completion_code_freq=\"PROBLEM_COMPLETION\">\r\n";
        String skillInfo = "       <LMS:SectionSkill skill_id=\"_SKILL_\" skill_name=\"_SKILL_\" p_guess=\"0.4\" p_learn=\"0.1\" p_slip=\"0.2\" initial_p_known=\"0.66\" displayed=\"true\" remediated=\"true\">\r\n          <LMS:SectionSubSkill subskill_id=\"_SKILL_\" subskill_name=\"_SKILL_\"/>\r\n       </LMS:SectionSkill>\r\n";
        String outerProblemSetHeader = "       <LMS:ProblemSet id=\"_PROBLEM_SET_NAME_-_PROBLEM_SET_NUM_\" problem_count=\"2\" repeat_problems=\"2\">\r\n          <LMS:SelectionInfo>\r\n             <LMS:SelectionAlgo id=\"Ordered-1\" name=\"Ordered\" execution_point=\"precompile\"/>\r\n          </LMS:SelectionInfo>\r\n";
        String executableInfo = "       <LMS:Executable id=\"_PLATFORM_\" name=\"_PLATFORM_\" type=\"LISP\" platform=\"ANY\" entry_point=\"cl.tutors.tre.LMS_Session\"/>\r\n";
        String toolInfo = "          <LMS:ToolSpec id=\"_STU_INT_\" >\r\n\t\t<LMS:Tool id=\"_STU_INT_\" name=\"_STU_INT_\" type=\"_STUD_INT_PATH_\" subtype=\"\" />\r\n             <LMS:SetOptions>\r\n                <LMS:AttValue attribute=\"ToolIsRequired\" value=\"true\" />\r\n                <LMS:AttValue attribute=\"layout_template\" value=\"3\"/>\r\n                <LMS:AttValue attribute=\"layout_region\" value=\"2\"/>\r\n                <LMS:AttValue attribute=\"layout_tab\" value=\"1\"/>\r\n             </LMS:SetOptions>\r\n             <LMS:DefaultOptions>\r\n             </LMS:DefaultOptions>\r\n          </LMS:ToolSpec>\r\n";
        String outerProblemSetMemberHeader = "          <LMS:ProblemSetMember>\r\n";
        String innerProblemSetHeader = "             <LMS:ProblemSet id=\"_INNER_PROBLEM_SET_NAME_-_INNER_PROBLEM_SET_NUM_-PS-1\" problem_count=\"10\" repeat_problems=\"2\">\r\n";
        String innerProblemSetMemberHeader = "          <LMS:ProblemSetMember>\r\n";
        String randomSelectionAlgo = "                <LMS:SelectionInfo>\r\n                   <LMS:SelectionAlgo id=\"Random-1\" name=\"Random\" execution_point=\"precompile\"/>\r\n                </LMS:SelectionInfo>\r\n";
        String orderedSelectionAlgo = "                <LMS:SelectionInfo>\r\n                   <LMS:SelectionAlgo id=\"Ordered-1\" name=\"Ordered\" execution_point=\"precompile\"/>\r\n                </LMS:SelectionInfo>\r\n";
        String problemInfo = "                   <LMS:Problem id=\"_PROBLEM_ID_\" name=\"_PROBLEM_NAME_\"/>\r\n";
        String innerProblemSetMemberFooter = "                </LMS:ProblemSetMember>\r\n";
        String innerProblemSetFooter = "             </LMS:ProblemSet>\r\n";
        String outerProblemSetMemberFooter = "          </LMS:ProblemSetMember>\r\n";
        String outerProblemSetFooter = "       </LMS:ProblemSet>\r\n";
        String sectionFooter = "    </LMS:Section>\r\n";
        String unitFooter = " </LMS:Unit>\r\n";
        String date = this.getDate();
        String unitContents = "";
        unitContents = unitContents + "<?xml version=\"1.0\" encoding=\"US-ASCII\"  ?>\r\n<!-- $Id: CTATtoLMS.java 23661 2016-06-07 16:16:21Z sewall $\r\n     $Name$ -->\r\n \r\n  <LMS:Unit  xmlns:LMS=\"http://www.carnegielearning.com/LMS\" id=\"_UNIT_NAME_\"  name=\"_UNIT_NAME_\" >\r\n".replaceAll("_UNIT_NAME_", unitName).replaceAll("_DATE_", date);
        for (Section s : unit) {
            unitContents = unitContents + "    <LMS:Section id=\"_UNIT_NAME_-_SECTION_NUM_\" name=\"_SECTION_NAME_\" completion_code_freq=\"PROBLEM_COMPLETION\">\r\n".replaceAll("_UNIT_NAME_", unitName).replaceAll("_SECTION_NUM_", s.getNum()).replaceAll("_SECTION_NAME_", s.getName());
            for (String skill : s.getSkills()) {
                unitContents = unitContents + "       <LMS:SectionSkill skill_id=\"_SKILL_\" skill_name=\"_SKILL_\" p_guess=\"0.4\" p_learn=\"0.1\" p_slip=\"0.2\" initial_p_known=\"0.66\" displayed=\"true\" remediated=\"true\">\r\n          <LMS:SectionSubSkill subskill_id=\"_SKILL_\" subskill_name=\"_SKILL_\"/>\r\n       </LMS:SectionSkill>\r\n".replaceAll("_SKILL_", skill);
            }
            unitContents = unitContents + "       <LMS:Executable id=\"_PLATFORM_\" name=\"_PLATFORM_\" type=\"LISP\" platform=\"ANY\" entry_point=\"cl.tutors.tre.LMS_Session\"/>\r\n".replaceAll("_PLATFORM_", s.getPlatform());
            if (s.platformFlagged()) {
                this.warning("Null or empty platform used in " + unitName + ".UNIT file");
            }
            unitContents = unitContents + "       <LMS:ProblemSet id=\"_PROBLEM_SET_NAME_-_PROBLEM_SET_NUM_\" problem_count=\"2\" repeat_problems=\"2\">\r\n          <LMS:SelectionInfo>\r\n             <LMS:SelectionAlgo id=\"Ordered-1\" name=\"Ordered\" execution_point=\"precompile\"/>\r\n          </LMS:SelectionInfo>\r\n".replaceAll("_PROBLEM_SET_NAME_", unitName).replaceAll("_PROBLEM_SET_NUM_", s.getNum());
            unitContents = unitContents + "          <LMS:ToolSpec id=\"_STU_INT_\" >\r\n\t\t<LMS:Tool id=\"_STU_INT_\" name=\"_STU_INT_\" type=\"_STUD_INT_PATH_\" subtype=\"\" />\r\n             <LMS:SetOptions>\r\n                <LMS:AttValue attribute=\"ToolIsRequired\" value=\"true\" />\r\n                <LMS:AttValue attribute=\"layout_template\" value=\"3\"/>\r\n                <LMS:AttValue attribute=\"layout_region\" value=\"2\"/>\r\n                <LMS:AttValue attribute=\"layout_tab\" value=\"1\"/>\r\n             </LMS:SetOptions>\r\n             <LMS:DefaultOptions>\r\n             </LMS:DefaultOptions>\r\n          </LMS:ToolSpec>\r\n".replaceAll("_STU_INT_", s.getStudentInterface()).replaceAll("_STUD_INT_PATH_", s.getStudentInterface());
            if (s.stuIntFlagged()) {
                this.warning("Null or empty student interface used in " + unitName + ".UNIT file");
            }
            unitContents = unitContents + "          <LMS:ProblemSetMember>\r\n";
            unitContents = unitContents + "             <LMS:ProblemSet id=\"_INNER_PROBLEM_SET_NAME_-_INNER_PROBLEM_SET_NUM_-PS-1\" problem_count=\"10\" repeat_problems=\"2\">\r\n".replaceAll("_INNER_PROBLEM_SET_NAME_", unitName).replaceAll("_INNER_PROBLEM_SET_NUM_", s.getNum());
            unitContents = unitContents + "          <LMS:ProblemSetMember>\r\n";
            unitContents = s.randomized() ? unitContents + "                <LMS:SelectionInfo>\r\n                   <LMS:SelectionAlgo id=\"Random-1\" name=\"Random\" execution_point=\"precompile\"/>\r\n                </LMS:SelectionInfo>\r\n" : unitContents + "                <LMS:SelectionInfo>\r\n                   <LMS:SelectionAlgo id=\"Ordered-1\" name=\"Ordered\" execution_point=\"precompile\"/>\r\n                </LMS:SelectionInfo>\r\n";
            for (String problem : s.getProblems()) {
                problem = problem.replaceAll(".brd", "");
                unitContents = unitContents + "                   <LMS:Problem id=\"_PROBLEM_ID_\" name=\"_PROBLEM_NAME_\"/>\r\n".replaceAll("_PROBLEM_NAME_", problem.split(";")[0]).replaceAll("_PROBLEM_ID_", problem.split(";")[1]);
            }
            unitContents = unitContents + "                </LMS:ProblemSetMember>\r\n";
            unitContents = unitContents + "             </LMS:ProblemSet>\r\n";
            unitContents = unitContents + "          </LMS:ProblemSetMember>\r\n";
            unitContents = unitContents + "       </LMS:ProblemSet>\r\n";
            unitContents = unitContents + "    </LMS:Section>\r\n";
        }
        unitContents = unitContents + " </LMS:Unit>\r\n";
        return this.outputFile(new File(this.curDir + unitName + ".unit"), unitContents);
    }

    private boolean createXCURFile() {
        if (this.curricName == null) {
            this.curricName = JOptionPane.showInputDialog(null, (Object)"Curriculum name: ");
        }
        if (this.curricName == null) {
            return false;
        }
        this.debugging("Creating xcur file " + this.curricName + ".xcur");
        String xcurHeader = "<?xml version=\"1.0\" encoding=\"US-ASCII\"  ?>\r\n<!-- $Id: CTATtoLMS.java 23661 2016-06-07 16:16:21Z sewall $\r\n     $Name$ -->\r\n\r\n<LMS:Curriculum xmlns:LMS=\"http://www.carnegielearning.com/LMS\"\r\n                id=\"_CURRICULUM_NAME_\" name=\"_CURRICULUM_NAME_\">\r\n ";
        String unitInfo = "<LMS:Unit id=\"_UNIT_NAME_\"  unit_introduction=\"_UNIT_NAME_\" unit_summary=\"_UNIT_NAME_\" />\r\n <!-- review sections -->\r\n";
        String xcurFooter = " </LMS:Curriculum>";
        String xcurContents = "";
        xcurContents = xcurContents + "<?xml version=\"1.0\" encoding=\"US-ASCII\"  ?>\r\n<!-- $Id: CTATtoLMS.java 23661 2016-06-07 16:16:21Z sewall $\r\n     $Name$ -->\r\n\r\n<LMS:Curriculum xmlns:LMS=\"http://www.carnegielearning.com/LMS\"\r\n                id=\"_CURRICULUM_NAME_\" name=\"_CURRICULUM_NAME_\">\r\n ".replaceAll("_CURRICULUM_NAME_", this.curricName);
        for (int i = 0; i < this.unitNames.size(); ++i) {
            xcurContents = xcurContents + "<LMS:Unit id=\"_UNIT_NAME_\"  unit_introduction=\"_UNIT_NAME_\" unit_summary=\"_UNIT_NAME_\" />\r\n <!-- review sections -->\r\n".replaceAll("_UNIT_NAME_", this.unitNames.get(i));
        }
        xcurContents = xcurContents + " </LMS:Curriculum>";
        return this.outputFile(new File(this.curDir + this.curricName + ".xcur"), xcurContents);
    }

    private String getDate() {
        Calendar c = Calendar.getInstance();
        return "" + c.get(1) + '-' + c.get(2) + '-' + c.get(5) + 'T' + c.get(11) + ':' + c.get(12) + ':' + c.get(13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean outputFile(File target, String contents) {
        this.debugging("Writing to " + target.getName());
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(target);
            pw.print(contents);
        }
        catch (Throwable t) {
            t.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            pw.flush();
            pw.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String inputFile(File input) {
        if (input.isDirectory()) {
            return null;
        }
        this.debugging("Parsing: " + input.getAbsolutePath());
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(input));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
        }
        catch (IOException e) {
            this.error("IOException, could not read file: " + input.getAbsolutePath());
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                this.error("Could not close buffered reader, while reading file: " + input.getAbsolutePath());
            }
        }
        return sb.toString();
    }

    private void debugging(String message) {
        if (this.msgOption[0]) {
            if (this.fromMenu) {
                this.history = this.history + "Debug: " + message + "\r\n";
            } else {
                System.out.println(message);
            }
        }
    }

    private void error(String error) {
        if (this.msgOption[1]) {
            if (this.fromMenu) {
                this.history = this.history + "Error: " + error + "\r\n";
            } else {
                System.err.println("Error: " + error);
            }
        }
    }

    private void warning(String warning) {
        if (this.msgOption[2]) {
            if (this.fromMenu) {
                this.history = this.history + "Warning: " + warning + "\r\n";
            } else {
                System.out.println("Warning: " + warning);
            }
        }
    }

    private boolean checkBadString(String toCheck) {
        return toCheck == null || toCheck.trim().equals("");
    }

    private File[] filter(File parent, int filter) {
        File[] result = null;
        result = filter == -1 ? parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File filename) {
                return filename.getAbsolutePath().endsWith(".brd");
            }
        }) : (filter == 0 ? parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File filename) {
                return filename.getAbsolutePath().endsWith(".brd") || filename.isDirectory() && !filename.getName().equals("bas");
            }
        }) : parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File filename) {
                return !filename.getAbsolutePath().contains(".") && !filename.getName().equals("bas");
            }
        }));
        return result == null ? new File[]{} : result;
    }

    private class ExcelFormatter {
        private final int horizTextWidth = 6;
        private final int rotatedTextWidth = 3;
        private final String xmlHeader = "<?xml version=\"1.0\"?>\r\n<?mso-application progid=\"Excel.Sheet\"?>\r\n<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\r\n xmlns:o=\"urn:schemas-microsoft-com:office:office\"\r\n xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\r\n xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\r\n xmlns:html=\"http://www.w3.org/TR/REC-html40\">\r\n <DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\">\r\n  <Author>Somebody</Author>\r\n  <LastAuthor>Somebody</LastAuthor>\r\n  <Created>_DATE_</Created>\r\n  <LastSaved>_DATE_</LastSaved>\r\n  <Version>11.6360</Version>\r\n </DocumentProperties>\r\n <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n  <WindowHeight>7425</WindowHeight>\r\n  <WindowWidth>15195</WindowWidth>\r\n  <WindowTopX>0</WindowTopX>\r\n  <WindowTopY>75</WindowTopY>\r\n  <ProtectStructure>False</ProtectStructure>\r\n  <ProtectWindows>False</ProtectWindows>\r\n </ExcelWorkbook>\r\n";
        private final String cellStyleOptions = " <Styles>\r\n  <Style ss:ID=\"Default\" ss:Name=\"Normal\">\r\n   <Alignment ss:Vertical=\"Bottom\"/>\r\n  </Style>\r\n  <Style ss:ID=\"s23\">\r\n   <Alignment ss:Vertical=\"Bottom\" ss:Rotate=\"60\"/>\r\n  </Style>\r\n </Styles>\r\n";
        private final String worksheetHeader = " <Worksheet ss:Name=\"_WORKSHEET_NAME_\">\r\n  <Table>\r\n";
        private final String columnInfo = "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n";
        private final String rowHeader = "   <Row>\r\n";
        private final String regCellHeader = "    <Cell>";
        private final String rotatedCellHeader = "    <Cell ss:StyleID=\"s23\">";
        private final String specificColCellHeader = "    <Cell ss:Index=\"_COL_\"";
        private final String regCellFooter = "</Cell>\r\n";
        private final String stringData = "<Data ss:Type=\"String\">_DATA_</Data>";
        private final String integerData = "<Data ss:Type=\"Number\">_DATA_</Data>";
        private final String skillCountCellInfo = "   <Cell ss:Formula=\"=COUNTIF('Skills Library'!C[_COL_INDEX_],&quot;=&quot;&amp;RC1)\"><Data ss:Type=\"Number\"></Data></Cell>\r\n";
        private final String rowFooter = "   </Row>\r\n";
        private final String worksheetFooter = "  </Table>  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n   <Selected/>\r\n   <Panes>\r\n    <Pane>\r\n     <Number>3</Number>\r\n     <ActiveRow>7</ActiveRow>\r\n     <ActiveCol>4</ActiveCol>\r\n    </Pane>\r\n   </Panes>\r\n   <ProtectObjects>False</ProtectObjects>\r\n   <ProtectScenarios>False</ProtectScenarios>\r\n  </WorksheetOptions>\r\n </Worksheet>\r\n ";
        private final String xmlFooter = "</Workbook>";
        private Set<File> files;
        private HashMap<String, ArrayList<File>> skillToProblemMap;
        private HashMap<File, HashSet<String>> problemToSkillMap;
        private ArrayList<String> skillList;
        private ArrayList<String> problemList;

        public ExcelFormatter(Set<File> files, HashMap<String, ArrayList<File>> skillToProblemMap, HashMap<File, HashSet<String>> problemToSkillMap) {
            this.files = files;
            this.skillToProblemMap = skillToProblemMap;
            this.problemToSkillMap = problemToSkillMap;
            this.skillList = new ArrayList();
            for (String skill : skillToProblemMap.keySet()) {
                this.skillList.add(skill);
            }
            this.problemList = new ArrayList();
            for (File f : problemToSkillMap.keySet()) {
                this.problemList.add(f.getName());
            }
        }

        public String xmlHeader() {
            String xmlContents = "";
            xmlContents = xmlContents + "<?xml version=\"1.0\"?>\r\n<?mso-application progid=\"Excel.Sheet\"?>\r\n<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\r\n xmlns:o=\"urn:schemas-microsoft-com:office:office\"\r\n xmlns:x=\"urn:schemas-microsoft-com:office:excel\"\r\n xmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\r\n xmlns:html=\"http://www.w3.org/TR/REC-html40\">\r\n <DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\">\r\n  <Author>Somebody</Author>\r\n  <LastAuthor>Somebody</LastAuthor>\r\n  <Created>_DATE_</Created>\r\n  <LastSaved>_DATE_</LastSaved>\r\n  <Version>11.6360</Version>\r\n </DocumentProperties>\r\n <ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n  <WindowHeight>7425</WindowHeight>\r\n  <WindowWidth>15195</WindowWidth>\r\n  <WindowTopX>0</WindowTopX>\r\n  <WindowTopY>75</WindowTopY>\r\n  <ProtectStructure>False</ProtectStructure>\r\n  <ProtectWindows>False</ProtectWindows>\r\n </ExcelWorkbook>\r\n".replaceAll("_DATE_", CTATtoLMS.this.date);
            xmlContents = xmlContents + " <Styles>\r\n  <Style ss:ID=\"Default\" ss:Name=\"Normal\">\r\n   <Alignment ss:Vertical=\"Bottom\"/>\r\n  </Style>\r\n  <Style ss:ID=\"s23\">\r\n   <Alignment ss:Vertical=\"Bottom\" ss:Rotate=\"60\"/>\r\n  </Style>\r\n </Styles>\r\n";
            return xmlContents;
        }

        public String xmlFooter() {
            return "</Workbook>";
        }

        public String createProblemLibrary() {
            String xmlContents = "";
            xmlContents = xmlContents + " <Worksheet ss:Name=\"_WORKSHEET_NAME_\">\r\n  <Table>\r\n".replaceAll("_WORKSHEET_NAME_", "Problem Library").replaceAll("_ROW_", "" + this.files.size()).replaceAll("_COL_", "3");
            int max = 0;
            for (File f : this.files) {
                int cur = f.getName().length();
                if (max >= cur) continue;
                max = cur;
            }
            xmlContents = xmlContents + "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n".replaceAll("_INDEX_", "1").replaceAll("_HIDDEN_", "0").replaceAll("_WIDTH_", "" + 6 * max);
            xmlContents = xmlContents + "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n".replaceAll("_INDEX_", "2").replaceAll("_HIDDEN_", "0").replaceAll("_WIDTH_", "" + 6 * (CTATtoLMS.this.studentInterface.length() > 17 ? CTATtoLMS.this.studentInterface.length() : 17));
            xmlContents = xmlContents + "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n".replaceAll("_INDEX_", "3").replaceAll("_HIDDEN_", "0").replaceAll("_WIDTH_", "" + 6 * (CTATtoLMS.this.platform.length() > 8 ? CTATtoLMS.this.platform.length() : 8));
            xmlContents = xmlContents + "   <Row>\r\n";
            xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "Problem Name") + "</Cell>\r\n";
            xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "Student Interface") + "</Cell>\r\n";
            xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "Platform") + "</Cell>\r\n";
            xmlContents = xmlContents + "   </Row>\r\n";
            for (File f : this.files) {
                xmlContents = xmlContents + "   <Row>\r\n";
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", f.getName()) + "</Cell>\r\n";
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", CTATtoLMS.this.studentInterface) + "</Cell>\r\n";
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", CTATtoLMS.this.platform) + "</Cell>\r\n";
                xmlContents = xmlContents + "   </Row>\r\n";
            }
            xmlContents = xmlContents + "  </Table>  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n   <Selected/>\r\n   <Panes>\r\n    <Pane>\r\n     <Number>3</Number>\r\n     <ActiveRow>7</ActiveRow>\r\n     <ActiveCol>4</ActiveCol>\r\n    </Pane>\r\n   </Panes>\r\n   <ProtectObjects>False</ProtectObjects>\r\n   <ProtectScenarios>False</ProtectScenarios>\r\n  </WorksheetOptions>\r\n </Worksheet>\r\n ";
            return xmlContents;
        }

        public String createUnitLibrary(String unitName, ArrayList<Section> unit) {
            HashMap unitSkillsFrequency = CTATtoLMS.this.getMatrix(unit);
            ArrayList skills = (ArrayList)unitSkillsFrequency.get("skills");
            String xmlContents = "";
            xmlContents = xmlContents + " <Worksheet ss:Name=\"_WORKSHEET_NAME_\">\r\n  <Table>\r\n".replaceAll("_WORKSHEET_NAME_", unitName).replaceAll("_ROW_", "" + unitSkillsFrequency.keySet().size()).replaceAll("_COL_", "" + (skills.size() + 1));
            int max = 0;
            for (Section s : unit) {
                int cur;
                for (String problemData : s.getProblems()) {
                    cur = problemData.split(";")[0].length();
                    if (max >= cur) continue;
                    max = cur;
                }
                cur = s.getName().length();
                if (max >= cur) continue;
                max = cur;
            }
            xmlContents = xmlContents + "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n".replaceAll("_INDEX_", "1").replaceAll("_HIDDEN_", "0").replaceAll("_WIDTH_", "" + 6 * (max > 12 ? max : 12));
            int i = 2;
            for (Object skillNameObj : skills) {
                xmlContents = xmlContents + "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n".replaceAll("_INDEX_", "" + i).replaceAll("_HIDDEN_", "0").replaceAll("_WIDTH_", "" + 3 * ((String)skillNameObj).length());
                ++i;
            }
            xmlContents = xmlContents + "   <Row>\r\n";
            xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "Skill Counts") + "</Cell>\r\n";
            for (Object skillNameObj : skills) {
                xmlContents = xmlContents + "    <Cell ss:StyleID=\"s23\">" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", (String)skillNameObj) + "</Cell>\r\n";
            }
            xmlContents = xmlContents + "   </Row>\r\n";
            for (Section s : unit) {
                xmlContents = xmlContents + "   <Row>\r\n";
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", s.getName()) + "</Cell>\r\n";
                xmlContents = xmlContents + "   </Row>\r\n";
                for (String problemData : s.getProblems()) {
                    String problemName = problemData.split(";")[0];
                    if (problemName == "skills") continue;
                    xmlContents = xmlContents + "   <Row>\r\n";
                    xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "" + problemName) + "</Cell>\r\n";
                    for (Object integerVal : (ArrayList)unitSkillsFrequency.get(problemName)) {
                        if ((Integer)integerVal == 0) {
                            xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "") + "</Cell>\r\n";
                            continue;
                        }
                        xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"Number\">_DATA_</Data>".replaceAll("_DATA_", "" + (Integer)integerVal) + "</Cell>\r\n";
                    }
                    xmlContents = xmlContents + "   </Row>\r\n";
                }
            }
            xmlContents = xmlContents + "  </Table>  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n   <Selected/>\r\n   <Panes>\r\n    <Pane>\r\n     <Number>3</Number>\r\n     <ActiveRow>7</ActiveRow>\r\n     <ActiveCol>4</ActiveCol>\r\n    </Pane>\r\n   </Panes>\r\n   <ProtectObjects>False</ProtectObjects>\r\n   <ProtectScenarios>False</ProtectScenarios>\r\n  </WorksheetOptions>\r\n </Worksheet>\r\n ";
            return xmlContents;
        }

        public String createOldUnitLibrary(String unitName, ArrayList<Section> unit) {
            String xmlContents = "";
            HashSet<String> unitProblems = new HashSet<String>();
            HashMap<String, Integer> unitSkills = new HashMap<String, Integer>();
            for (Section s : unit) {
                for (String sectionProblem : s.getProblems()) {
                    unitProblems.add(sectionProblem.split(";")[0]);
                }
                for (String sectionSkill : s.getSkills()) {
                    unitSkills.put(sectionSkill, new Integer(this.skillList.indexOf(sectionSkill)));
                }
            }
            xmlContents = xmlContents + " <Worksheet ss:Name=\"_WORKSHEET_NAME_\">\r\n  <Table>\r\n".replaceAll("_WORKSHEET_NAME_", unitName).replaceAll("_ROW_", "" + (unitProblems.size() + 1)).replaceAll("_COL_", "" + (unitSkills.size() + 1));
            xmlContents = xmlContents + "   <Row>\r\n";
            xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", "Skill Counts") + "</Cell>\r\n";
            for (String skill : unitSkills.keySet()) {
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", skill) + "</Cell>\r\n";
            }
            xmlContents = xmlContents + "   </Row>\r\n";
            for (String problemName : unitProblems) {
                xmlContents = xmlContents + "   <Row>\r\n";
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", problemName) + "</Cell>\r\n";
                int i = 0;
                for (String skill : unitSkills.keySet()) {
                    xmlContents = xmlContents + "   <Cell ss:Formula=\"=COUNTIF('Skills Library'!C[_COL_INDEX_],&quot;=&quot;&amp;RC1)\"><Data ss:Type=\"Number\"></Data></Cell>\r\n".replaceAll("_COL_INDEX_", "" + ((Integer)unitSkills.get(skill) - i));
                    ++i;
                }
                xmlContents = xmlContents + "   </Row>\r\n";
            }
            xmlContents = xmlContents + "  </Table>  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n   <Selected/>\r\n   <Panes>\r\n    <Pane>\r\n     <Number>3</Number>\r\n     <ActiveRow>7</ActiveRow>\r\n     <ActiveCol>4</ActiveCol>\r\n    </Pane>\r\n   </Panes>\r\n   <ProtectObjects>False</ProtectObjects>\r\n   <ProtectScenarios>False</ProtectScenarios>\r\n  </WorksheetOptions>\r\n </Worksheet>\r\n ";
            return xmlContents;
        }

        /*
         * WARNING - void declaration
         */
        public String createSkillLibrary() {
            String xmlContents = "";
            xmlContents = xmlContents + " <Worksheet ss:Name=\"_WORKSHEET_NAME_\">\r\n  <Table>\r\n".replaceAll("_WORKSHEET_NAME_", "Skills Library").replaceAll("_ROW_", "" + (this.problemList.size() + 1)).replaceAll("_COL_", "" + (this.skillList.size() + 1));
            int i = 1;
            for (String string : this.skillList) {
                xmlContents = xmlContents + "   <Column ss:Index=\"_INDEX_\" ss:Hidden=\"_HIDDEN_\" ss:Width=\"_WIDTH_\"/>\r\n".replaceAll("_INDEX_", "" + i).replaceAll("_HIDDEN_", "0").replaceAll("_WIDTH_", "" + 6 * string.length());
                ++i;
            }
            xmlContents = xmlContents + "   <Row>\r\n";
            ArrayList<String> tempSkillList = new ArrayList<String>();
            for (String skill : this.skillList) {
                xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", skill) + "</Cell>\r\n";
                tempSkillList.add(skill);
            }
            xmlContents = xmlContents + "   </Row>\r\n";
            boolean bl = false;
            while (tempSkillList.size() > 0) {
                void var4_7;
                xmlContents = xmlContents + "   <Row>\r\n";
                for (String skillName : this.skillList) {
                    if (this.skillToProblemMap.get(skillName).size() <= var4_7) {
                        tempSkillList.remove(skillName);
                    }
                    String problemName = "";
                    if (tempSkillList.contains(skillName)) {
                        problemName = this.skillToProblemMap.get(skillName).get((int)var4_7).getName();
                    }
                    xmlContents = xmlContents + "    <Cell>" + "<Data ss:Type=\"String\">_DATA_</Data>".replaceAll("_DATA_", problemName) + "</Cell>\r\n";
                }
                xmlContents = xmlContents + "   </Row>\r\n";
                ++var4_7;
            }
            xmlContents = xmlContents + "  </Table>  <WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\r\n   <Selected/>\r\n   <Panes>\r\n    <Pane>\r\n     <Number>3</Number>\r\n     <ActiveRow>7</ActiveRow>\r\n     <ActiveCol>4</ActiveCol>\r\n    </Pane>\r\n   </Panes>\r\n   <ProtectObjects>False</ProtectObjects>\r\n   <ProtectScenarios>False</ProtectScenarios>\r\n  </WorksheetOptions>\r\n </Worksheet>\r\n ";
            return xmlContents;
        }
    }

    private class Section {
        private String sectionName;
        private ArrayList<String> problemList = new ArrayList();
        private ArrayList<File> problemFileList = new ArrayList();
        private ArrayList<String> skillList = new ArrayList();
        private String stu_int;
        private String platform_;
        private String sectionNum;
        private boolean platformFlag = false;
        private boolean stuIntFlag = false;
        private boolean randomize = false;

        public Section(String sectionName, String stu_int, String platform, boolean randomize, int sectionNum) {
            this.sectionName = sectionName;
            this.stu_int = stu_int;
            this.platform_ = platform;
            if (CTATtoLMS.this.checkBadString(platform)) {
                this.platformFlag = true;
            }
            if (CTATtoLMS.this.checkBadString(CTATtoLMS.this.studentInterface)) {
                this.stuIntFlag = true;
            }
            this.randomize = randomize;
            this.sectionNum = "" + sectionNum;
        }

        public Section(String[] sectionInfo, int sectionNum) {
            if (sectionInfo.length == 0) {
                CTATtoLMS.this.error("Section name missing");
            }
            this.sectionName = sectionInfo[0];
            this.sectionNum = "" + sectionNum;
            if (sectionInfo.length == 2) {
                this.randomize = sectionInfo[1].contains(CTATtoLMS.RANDOM);
            }
            if (sectionInfo.length >= 3) {
                this.stu_int = sectionInfo[1];
                this.platform_ = sectionInfo[2];
                if (sectionInfo.length >= 4) {
                    this.randomize = sectionInfo[3].contains(CTATtoLMS.RANDOM);
                }
            } else {
                this.stu_int = CTATtoLMS.this.studentInterface;
                this.platform_ = CTATtoLMS.this.platform;
            }
            if (CTATtoLMS.this.checkBadString(this.platform_)) {
                this.platformFlag = true;
            }
            if (CTATtoLMS.this.checkBadString(CTATtoLMS.this.studentInterface)) {
                this.stuIntFlag = true;
            }
        }

        public void addProblem(String problemID, String problemName, File problem) {
            if (problem == null) {
                problem = (File)CTATtoLMS.this.brdFileMap.get(problemID);
            }
            if (problem == null) {
                CTATtoLMS.this.error("Could not find problem: " + problemID);
            }
            this.problemFileList.add(problem);
            this.problemList.add(problemID + ";" + problemName);
        }

        public void addProblem(File problem) {
            String problemName = problem.getName();
            this.addProblem(problemName, problemName, problem);
        }

        public void addSkill(String skillName) {
            this.skillList.add(skillName);
        }

        public ArrayList<String> getProblems() {
            return this.problemList;
        }

        public ArrayList<File> getProblemFiles() {
            return this.problemFileList;
        }

        public ArrayList<String> getSkills() {
            return this.skillList;
        }

        public String getStudentInterface() {
            return this.stu_int;
        }

        public String getPlatform() {
            return this.platform_;
        }

        public String getName() {
            return this.sectionName;
        }

        public String getNum() {
            return this.sectionNum;
        }

        public boolean platformFlagged() {
            return this.platformFlag;
        }

        public boolean stuIntFlagged() {
            return this.stuIntFlag;
        }

        public boolean randomized() {
            return this.randomize;
        }
    }

    private class FromFolders
    extends ParseUtil
    implements Parse {
        private int depth;

        public FromFolders(File root) {
            this.depth = this.getDepth(root);
            this.checkFiles(root, 0, this.depth);
            if (CTATtoLMS.this.omitted.size() > 0) {
                String omit = "";
                omit = omit + "These files to be omitted:\r\n";
                for (String file : CTATtoLMS.this.omitted) {
                    omit = omit + file + "\r\n";
                }
                CTATtoLMS.this.warning(omit);
            }
        }

        @Override
        public boolean setup() {
            Section section;
            ArrayList<Section> unit;
            if (this.depth == 0) {
                unit = new ArrayList<Section>();
                section = new Section(CTATtoLMS.this.root.getName(), CTATtoLMS.this.studentInterface, CTATtoLMS.this.platform, false, 1);
                section.stuIntFlag = CTATtoLMS.this.checkBadString(CTATtoLMS.this.studentInterface);
                section.platformFlag = CTATtoLMS.this.checkBadString(CTATtoLMS.this.platform);
                section.addProblem(CTATtoLMS.this.root);
                for (String skill : CTATtoLMS.this.skillToProblemMap.keySet()) {
                    section.addSkill(skill);
                }
                unit.add(section);
                CTATtoLMS.this.curriculum.add(unit);
                CTATtoLMS.this.unitNames.add(CTATtoLMS.this.root.getName());
            }
            if (this.depth == 1) {
                unit = new ArrayList();
                section = this.getSection(CTATtoLMS.this.root, CTATtoLMS.this.studentInterface, CTATtoLMS.this.platform, 1);
                unit.add(section);
                CTATtoLMS.this.curriculum.add(unit);
                CTATtoLMS.this.unitNames.add(CTATtoLMS.this.root.getName());
            } else if (this.depth == 2) {
                unit = new ArrayList();
                File[] sections = CTATtoLMS.this.filter(CTATtoLMS.this.root, 1);
                for (int i = 1; i <= sections.length; ++i) {
                    unit.add(this.getSection(sections[i], CTATtoLMS.this.studentInterface, CTATtoLMS.this.platform, i));
                }
                CTATtoLMS.this.curriculum.add(unit);
                CTATtoLMS.this.unitNames.add(CTATtoLMS.this.root.getName());
            } else if (this.depth == 3) {
                File[] unitFiles = CTATtoLMS.this.filter(CTATtoLMS.this.root, 1);
                for (int i = 0; i < unitFiles.length; ++i) {
                    unit = new ArrayList();
                    File[] sectionFiles = CTATtoLMS.this.filter(unitFiles[i], 1);
                    for (int j = 1; j <= sectionFiles.length; ++j) {
                        unit.add(this.getSection(sectionFiles[j], CTATtoLMS.this.studentInterface, CTATtoLMS.this.platform, j));
                    }
                    CTATtoLMS.this.curriculum.add(unit);
                    CTATtoLMS.this.unitNames.add(unitFiles[i].getName());
                }
                CTATtoLMS.this.curricName = CTATtoLMS.this.root.getName();
            } else {
                CTATtoLMS.this.error("Unrecognized hierarchy");
                return false;
            }
            return true;
        }
    }

    private class FromTxt
    extends ParseUtil
    implements Parse {
        private int depth;

        public FromTxt(File root) {
            this.depth = this.getDepth(root);
            trace.out("cu", "FromTxt(" + root + "): depth=" + this.depth);
            this.checkFiles(root, 0, this.depth);
            if (CTATtoLMS.this.omitted.size() > 0) {
                String omit = "";
                omit = omit + "These files to be omitted:\r\n";
                for (String file : CTATtoLMS.this.omitted) {
                    omit = omit + file + "\r\n";
                }
                CTATtoLMS.this.warning(omit);
            }
        }

        @Override
        public boolean setup() {
            String contents = CTATtoLMS.this.inputFile(new File(CTATtoLMS.this.curDir + CTATtoLMS.HIERARCHY));
            contents = contents.replaceAll("\r\n\r\n", "\r\n");
            String[] tabs = new String[]{"\t\t\t", "\t\t", "\t"};
            int sectionNum = 1;
            boolean found = true;
            boolean began = false;
            this.depth = 0;
            for (int i = 0; i < tabs.length; ++i) {
                boolean bl = found = contents.indexOf(tabs[i]) != -1;
                if (began && !found) {
                    return false;
                }
                if (!began && !found) continue;
                this.depth = !began ? 3 - i : this.depth;
                began = true;
            }
            trace.out("cu", "setup(): depth=" + this.depth);
            String[] blocks = contents.split("\r\n");
            ArrayList<Section> curUnit = null;
            Section curSection = null;
            if (this.depth <= 1) {
                curUnit = new ArrayList<Section>();
                CTATtoLMS.this.curriculum.add(curUnit);
                CTATtoLMS.this.unitNames.add(CTATtoLMS.this.root.getName());
            }
            if (this.depth == 0) {
                curSection = new Section(CTATtoLMS.this.root.getName(), CTATtoLMS.this.platform, CTATtoLMS.this.studentInterface, false, 1);
                curUnit.add(curSection);
            }
            Integer relDepth = null;
            for (int i = 0; i < blocks.length; ++i) {
                String blockInfo = blocks[i];
                if (!blockInfo.startsWith("\t")) {
                    relDepth = this.depth;
                } else {
                    int tabIndex;
                    for (tabIndex = 0; tabIndex < tabs.length && !blockInfo.startsWith(tabs[tabIndex]); ++tabIndex) {
                    }
                    if (relDepth == 0 || relDepth - (this.depth - (3 - tabIndex)) == 1 || relDepth - (this.depth - (3 - tabIndex)) == -1) {
                        relDepth = this.depth - (3 - tabIndex);
                    } else {
                        CTATtoLMS.this.error("Parsing error, hierarchy in file incorrect");
                        return false;
                    }
                }
                trace.out("cu", "setup(): relDepth=" + relDepth + "; curUnit=" + curUnit);
                blockInfo = blockInfo.trim();
                if (relDepth == 0) {
                    if (blockInfo.indexOf("\t") != -1) {
                        curSection.addProblem(blockInfo.split("\t")[0], blockInfo.split("\t")[1], null);
                        continue;
                    }
                    if (blockInfo.contains("/")) {
                        blockInfo = blockInfo.substring(blockInfo.lastIndexOf("/") + 1);
                    }
                    if (blockInfo.contains("\\")) {
                        blockInfo = blockInfo.substring(blockInfo.lastIndexOf("\\") + 1);
                    }
                    curSection.addProblem(blockInfo, blockInfo, null);
                    continue;
                }
                if (relDepth == 1) {
                    String[] sectionInfo = blockInfo.split("\t");
                    curSection = new Section(sectionInfo, sectionNum++);
                    curUnit.add(curSection);
                    continue;
                }
                if (relDepth != 2) continue;
                curUnit = new ArrayList();
                CTATtoLMS.this.curriculum.add(curUnit);
                CTATtoLMS.this.unitNames.add(blockInfo);
                sectionNum = 1;
            }
            return true;
        }
    }

    public class ParseUtil {
        protected int getDepth(File parent) {
            trace.out("skills", "CTATtoLMS.getDepth(" + parent + ")");
            if (!parent.getName().endsWith(".brd")) {
                int maxDepth = Integer.MIN_VALUE;
                File[] files = CTATtoLMS.this.filter(parent, 0);
                for (int i = 0; i < files.length; ++i) {
                    int curDepth = this.getDepth(files[i]) + 1;
                    if (curDepth <= maxDepth) continue;
                    maxDepth = curDepth;
                }
                return maxDepth;
            }
            return 0;
        }

        protected void checkFiles(File parent, int curDepth, int depth) {
            if (curDepth >= depth - 1) {
                return;
            }
            File[] brds = CTATtoLMS.this.filter(parent, -1);
            for (int i = 0; i < brds.length; ++i) {
                CTATtoLMS.this.omitted.add(brds[i].getName());
            }
            File[] folders = CTATtoLMS.this.filter(parent, 1);
            for (int i = 0; i < folders.length; ++i) {
                this.checkFiles(folders[i], curDepth + 1, depth);
            }
        }

        protected Section getSection(File parent, String studentInterface, String platform, int sectionNum) {
            Section section = new Section(parent.getName(), studentInterface, platform, false, sectionNum);
            File[] brds = CTATtoLMS.this.filter(parent, -1);
            HashSet<String> skills = new HashSet<String>();
            for (int i = 0; i < brds.length; ++i) {
                section.addProblem(brds[i]);
                HashSet problemSkills = (HashSet)CTATtoLMS.this.problemToSkillMap.get(brds[i]);
                if (problemSkills == null) continue;
                for (String skill : problemSkills) {
                    skills.add(skill);
                }
            }
            for (String skill : skills) {
                section.addSkill(skill);
            }
            return section;
        }
    }

    public static interface Parse {
        public boolean setup();
    }
}

