/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.pact.Utilities.trace;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class XMLSupport {
    private Map<String, AttributeDescriptor> attrDescs = new TreeMap<String, AttributeDescriptor>();
    private String floatFormat = null;

    public XMLSupport(Client instance) {
        for (Method method : instance.getClass().getMethods()) {
            String attrName = XMLSupport.getMethodToPropertyName(method);
            if (attrName == null || !instance.isAttrProperty(attrName)) continue;
            String setMethodName = "set" + method.getName().substring("get".length());
            Method setMethod = null;
            try {
                setMethod = instance.getClass().getDeclaredMethod(setMethodName, String.class);
                this.attrDescs.put(attrName, new AttributeDescriptor(attrName, method, setMethod));
            }
            catch (NoSuchMethodException nsme) {
                throw new Error("getAttrDescriptor(): need to declare a setter method " + setMethodName + "(String): " + nsme);
            }
        }
        if (trace.getDebugCode("skills")) {
            trace.out("skills", "XMLSupport attrDescs: " + this.attrDescs);
        }
    }

    public static String getMethodToPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.length() < 4) {
            return null;
        }
        if (!methodName.startsWith("get") || method.getParameterTypes().length > 0) {
            return null;
        }
        String attrName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        return attrName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLSupport initialize(Client client) {
        Class<?> clazz = client.getClass();
        synchronized (clazz) {
            XMLSupport clientVal = client.getXMLSupport();
            if (clientVal != null) {
                return clientVal;
            }
            clientVal = new XMLSupport(client);
            client.setXMLSupport(clientVal);
            return clientVal;
        }
    }

    public void setAttributes(Client client, Element elt) {
        for (String attrName : this.attrDescs.keySet()) {
            AttributeDescriptor desc = null;
            try {
                desc = this.attrDescs.get(attrName);
                Object obj = desc.getMethod.invoke((Object)client, new Object[0]);
                if (this.floatFormat != null && (obj instanceof Float || obj instanceof Double)) {
                    elt.setAttribute(attrName, String.format(this.floatFormat, ((Number)obj).doubleValue()));
                    continue;
                }
                elt.setAttribute(attrName, obj.toString());
            }
            catch (NullPointerException npe) {
                trace.err("warning: field " + attrName + " is null; descriptor " + desc);
            }
            catch (Exception e) {
                String err = "error saving attribute " + attrName + ", descriptor " + desc + ": " + e;
                trace.err(err);
                e.printStackTrace();
                throw new RuntimeException(err, e);
            }
        }
    }

    public void getAttributes(Client client, Element elt) throws Exception {
        for (AttributeDescriptor desc : this.attrDescs.values()) {
            String attrVal = elt.getAttributeValue(desc.name);
            if (attrVal == null) continue;
            desc.setMethod.invoke((Object)client, attrVal);
        }
    }

    public static Document parse(String s) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        StringReader rdr = new StringReader(s);
        Document doc = builder.build((Reader)rdr);
        ((Reader)rdr).close();
        return doc;
    }

    public void setFloatFormat(String floatFormat) {
        this.floatFormat = floatFormat;
    }

    public String getFloatFormat() {
        return this.floatFormat;
    }

    class AttributeDescriptor {
        private final String name;
        private Method getMethod;
        private Method setMethod;

        public AttributeDescriptor(String attrName, Method getMethod, Method setMethod) {
            if (attrName == null || attrName.length() < 1) {
                throw new IllegalArgumentException("attrName null or empty");
            }
            this.name = attrName;
            this.getMethod = getMethod;
            this.setMethod = setMethod;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.name);
            sb.append(": ").append(this.getMethod.toString());
            sb.append(", ").append(this.setMethod.toString());
            return sb.append(';').toString();
        }
    }

    public static interface Client {
        public XMLSupport getXMLSupport();

        public void setXMLSupport(XMLSupport var1);

        public boolean isAttrProperty(String var1);
    }
}

