/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditContextEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditorContextListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.View.GraphInspector.TreeModelGroupComparator;
import edu.cmu.pact.BehaviorRecorder.View.GraphInspector.TreeModelLinkComparator;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GroupTreeModel
implements TreeModel,
GroupChangeListener,
EditorContextListener {
    HashSet<TreeModelListener> treeListeners;
    ExampleTracerGraph graph;
    GroupModel groupModel;
    GroupEditorContext editContext;
    JTree groupTree;
    Color[] colors;
    int lastColorIndex = 0;

    public GroupTreeModel(JTree groupTree, GroupEditorContext editContext) {
        this.groupTree = groupTree;
        this.treeListeners = new HashSet();
        this.editContext = editContext;
        this.groupModel = editContext.getGroupModel();
        editContext.addEditorContextListener(this);
        this.groupModel.addGroupChangeListener(this);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.treeListeners.add(listener);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof LinkGroup) {
            LinkGroup group = (LinkGroup)parent;
            LinkGroup[] sortedSubGroups = this.getSortedSubGroups(group);
            ExampleTracerLink[] sortedUniqueLinks = this.getSortedUniqueLinks(group);
            if (index - sortedSubGroups.length < 0) {
                return sortedSubGroups[index];
            }
            return sortedUniqueLinks[index - sortedSubGroups.length];
        }
        if (parent instanceof ExampleTracerLink) {
            return null;
        }
        throw new IllegalArgumentException("Tree Node not of type ExampleTracerGroup");
    }

    @Override
    public int getChildCount(Object arg0) {
        if (arg0 instanceof LinkGroup) {
            LinkGroup group = (LinkGroup)arg0;
            return this.groupModel.getGroupSubgroupCount(group) + this.groupModel.getUniqueLinks(group).size();
        }
        if (arg0 instanceof ExampleTracerLink) {
            return 0;
        }
        throw new IllegalArgumentException("Tree Node not of type ExampleTracerGroup");
    }

    @Override
    public int getIndexOfChild(Object arg0, Object arg1) {
        if (arg0 instanceof LinkGroup) {
            LinkGroup group = (LinkGroup)arg0;
            if (arg1 instanceof ExampleTracerLink) {
                ExampleTracerLink childLink = (ExampleTracerLink)arg1;
                ExampleTracerLink[] sortedUniqueLinks = this.getSortedUniqueLinks(group);
                return Arrays.binarySearch(sortedUniqueLinks, childLink, new TreeModelLinkComparator()) + this.groupModel.getGroupSubgroupCount(group);
            }
            if (arg1 instanceof LinkGroup) {
                LinkGroup childGroup = (LinkGroup)arg1;
                LinkGroup[] sortedSubGroups = this.getSortedSubGroups(group);
                return Arrays.binarySearch(sortedSubGroups, childGroup, new TreeModelGroupComparator(this.groupModel));
            }
            throw new IllegalArgumentException("Child not of type ExampleTracerGroup/Link");
        }
        if (arg0 instanceof ExampleTracerLink) {
            return -1;
        }
        System.out.println(arg0.getClass());
        throw new IllegalArgumentException("Tree Node not of type ExampleTracerGroup");
    }

    @Override
    public Object getRoot() {
        return this.groupModel.getTopLevelGroup();
    }

    @Override
    public boolean isLeaf(Object ob) {
        if (ob instanceof LinkGroup) {
            return false;
        }
        if (ob instanceof ExampleTracerLink) {
            return true;
        }
        throw new IllegalArgumentException("Tree Node not of type ExampleTracerGroup");
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.treeListeners.remove(listener);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    @Override
    public void groupChanged(GroupChangeEvent event) {
        this.notifyListeners();
    }

    private void fixTreeAfterNotify() {
        for (LinkGroup group : this.groupModel) {
            if (this.editContext.getGroupIsExpanded(group)) {
                this.groupTree.expandPath(this.getPathToGroup(group));
                continue;
            }
            this.groupTree.collapsePath(this.getPathToGroup(group));
        }
        if (this.editContext.getSelectedGroup() != null) {
            this.groupTree.setSelectionPath(this.getPathToGroup(this.editContext.getSelectedGroup()));
        }
    }

    private TreePath getPathToGroup(LinkGroup group) {
        LinkedList<LinkGroup> treePath = new LinkedList<LinkGroup>();
        do {
            treePath.addFirst(group);
        } while ((group = this.groupModel.getGroupParent(group)) != null);
        return new TreePath(treePath.toArray(new LinkGroup[0]));
    }

    private void notifyListeners() {
        for (TreeModelListener listener : this.treeListeners) {
            listener.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
        }
        this.fixTreeAfterNotify();
    }

    private LinkGroup[] getSortedSubGroups(LinkGroup group) {
        Set<LinkGroup> subGroupsSet = this.groupModel.getGroupSubgroups(group);
        LinkGroup[] subGroups = subGroupsSet.toArray(new LinkGroup[0]);
        Arrays.sort(subGroups, new TreeModelGroupComparator(this.groupModel));
        return subGroups;
    }

    private ExampleTracerLink[] getSortedUniqueLinks(LinkGroup group) {
        Set<ExampleTracerLink> uniqueLinksSet = this.groupModel.getUniqueLinks(group);
        ExampleTracerLink[] uniqueLinks = uniqueLinksSet.toArray(new ExampleTracerLink[0]);
        Arrays.sort(uniqueLinks, new TreeModelLinkComparator());
        return uniqueLinks;
    }

    @Override
    public void editorContextChanged(EditContextEvent e) {
        if (this.editContext.getSelectedGroup() == null) {
            this.groupTree.clearSelection();
        }
        if (e.getType() == 3) {
            this.notifyListeners();
        }
    }
}

