/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.FunctionTransferHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.WindowUtils;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class ExpressionMatcherPanel
extends MatcherPanel
implements ActionListener {
    JTextField inputField;
    JTextArea inputArea;
    private JTextComponent syntaxCheckText;
    private EdgeData edgeData;
    JList relationOptions;
    private JButton checkButton;
    private JButton lastButton;
    private ExpressionMatcher lastMatcher;
    private static final DateFormat fmt = new SimpleDateFormat("h:mm:ss a");

    private JTextField field(String name) {
        JTextField field = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(field);
        field.setName(name);
        field.setColumns(30);
        return field;
    }

    private void addLabelFieldBox(String labelStr, JComponent[] components) {
        JLabel label = new JLabel(labelStr);
        Box box = new Box(0);
        box.add(label);
        for (JComponent component : components) {
            box.add(component);
        }
        this.add(WindowUtils.wrapLeft(box));
        this.add(Box.createVerticalStrut(5));
    }

    private void addLabelFieldBox(String labelStr, JTextField field) {
        this.addLabelFieldBox(labelStr, new JComponent[]{field});
    }

    public ExpressionMatcherPanel(EdgeData edgeData, boolean allow, int max_students) {
        this(edgeData, allow, max_students, 0);
    }

    public ExpressionMatcherPanel(EdgeData edgeData, boolean allow, int max_students, int selectionIndex) {
        super(edgeData, allow, max_students, "<html>Enter a formula below.<br>", null);
        this.relationOptions = new JList<String>(ExpressionMatcher.RELATIONS);
        this.relationOptions.setSelectedIndex(0);
        this.relationOptions.setVisibleRowCount(1);
        this.inputField = this.field("inputField");
        this.syntaxCheckText = new JTextArea();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.syntaxCheckText);
        if (edgeData.getMatcher() != null && edgeData.getMatcher() instanceof ExpressionMatcher) {
            ExpressionMatcher m = (ExpressionMatcher)edgeData.getMatcher();
            this.actionField.setText(m.getAction());
            this.selectionField.setText(m.getSelection());
            this.inputField.setText(m.getInputExpression());
            this.relationOptions.setSelectedValue(m.getRelation(), true);
            this.lastMatcher = m;
            this.showLast();
        } else {
            this.actionField.setText(edgeData.getAction().get(0).toString());
            this.selectionField.setText(edgeData.getSelection().get(selectionIndex).toString());
            this.inputField.setText(edgeData.getInput().get(0).toString());
        }
        Box actorBox = new Box(0);
        this.checkButton = new JButton("Check");
        this.checkButton.setHorizontalAlignment(0);
        this.checkButton.addActionListener(this);
        this.lastButton = new JButton("Last Evaluation");
        this.lastButton.setHorizontalAlignment(0);
        this.lastButton.addActionListener(this);
        JPanel btnBox = new JPanel(new GridLayout(2, 1));
        btnBox.add(this.checkButton);
        btnBox.add(this.lastButton);
        this.addLabelFieldBox("Input: ", new JComponent[]{this.relationOptions, this.inputField, btnBox});
        if (allow) {
            this.add(WindowUtils.wrapLeft(actorBox));
        }
    }

    public ExpressionMatcherPanel(EdgeData edgeData, String text) {
        super(1);
        Object testRel;
        String expression;
        int endQuote;
        int relation = 0;
        int beginQuote = text.indexOf("\"");
        if (beginQuote >= 0 && (endQuote = text.lastIndexOf("\"")) >= 0) {
            expression = text.substring(beginQuote + 1, endQuote);
            testRel = text.substring(0, text.indexOf(" "));
            for (int i = 0; i < ExpressionMatcher.RELATIONS.length; ++i) {
                if (!((String)testRel).equals(ExpressionMatcher.RELATIONS[i])) continue;
                relation = i;
                break;
            }
        } else {
            expression = text;
        }
        this.edgeData = edgeData;
        this.SAIPane = new JPanel(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.anchor = 23;
        this.c.insets = new Insets(0, 0, 0, 2);
        this.c.fill = 0;
        this.c.weighty = 0.0;
        this.c.weightx = 0.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.relationOptions = new JList<String>(ExpressionMatcher.RELATIONS);
        this.relationOptions.setSelectedIndex(relation);
        this.relationOptions.setVisibleRowCount(1);
        this.relationOptions.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
        this.SAIPane.add((Component)this.relationOptions, this.c);
        this.c.insets = new Insets(0, 0, 0, 0);
        this.c.fill = 1;
        this.c.weighty = 1.0;
        this.c.weightx = 1.0;
        this.c.gridheight = 0;
        this.c.gridwidth = 0;
        this.c.gridx = 1;
        this.inputArea = new JTextArea(expression);
        testRel = JUndo.makeTextUndoable(this.inputArea);
        this.inputArea.setEditable(true);
        this.inputArea.setLineWrap(false);
        this.inputArea.setFont(new Font("Monospaced", 0, 11));
        this.inputArea.setTransferHandler(new FunctionTransferHandler(this.inputArea.getTransferHandler()));
        JScrollPane scrollInputArea = new JScrollPane(this.inputArea, 22, 32);
        if (trace.getDebugCode("editstudentinput")) {
            trace.out("editstudentinput", "EMP.inputArea border " + trace.nh(this.inputArea.getBorder()));
        }
        this.SAIPane.add((Component)scrollInputArea, this.c);
        this.add(this.SAIPane);
        this.checkButton = new JButton("Check");
        this.checkButton.setHorizontalAlignment(0);
        this.checkButton.addActionListener(this);
        this.lastButton = new JButton("Last Evaluation");
        this.lastButton.setHorizontalAlignment(0);
        this.lastButton.addActionListener(this);
    }

    public void setSyntaxCheck(JTextComponent area) {
        this.syntaxCheckText = area;
    }

    @Override
    public Matcher createMatcher() {
        Matcher m;
        ExpressionMatcher exm = new ExpressionMatcher();
        if (this.actionField == null || this.selectionField == null) {
            exm.setDefaultAction(null);
            exm.setDefaultSelection(null);
        } else {
            exm.setDefaultAction(this.actionField.getText());
            exm.setDefaultSelection(this.selectionField.getText());
        }
        exm.setInputExpression(this.inputField == null ? this.inputArea.getText() : this.inputField.getText());
        exm.setRelation((String)this.relationOptions.getSelectedValue());
        exm.setDefaultActor("Student");
        exm.setLinkTriggered(false);
        if (this.edgeData != null && (m = this.edgeData.getMatcher()) != null) {
            exm.setDefaultInput(m.getDefaultInput());
            exm.setDefaultAction(m.getDefaultAction());
            exm.setDefaultSelection(m.getDefaultSelection());
            exm.setDefaultActor(m.getDefaultActor());
            exm.setLinkTriggered(m.isLinkTriggered());
        }
        return exm;
    }

    private String beautifyErrorMessage(String msg) {
        String[] msgLines = msg.split("\n");
        StringBuffer buf = new StringBuffer();
        boolean foundERROR = false;
        for (String msgLine : msgLines) {
            String displayLine = msgLine.replaceAll(" ", "&nbsp;");
            displayLine = displayLine.replaceAll("<", "&lt;");
            if ((displayLine = displayLine.replaceAll(">", "&gt;")).startsWith("ERROR:")) {
                if (foundERROR) break;
                foundERROR = true;
                buf.append("ERROR:");
            } else {
                buf.append(displayLine);
            }
            buf.append("<br>");
        }
        return buf.toString();
    }

    private void showSyntaxCheckMessage(String msg, String colorName) {
        this.syntaxCheckText.setText(msg);
        this.syntaxCheckText.setSelectionStart(0);
        this.syntaxCheckText.setSelectionEnd(0);
        this.syntaxCheckText.repaint();
    }

    @Override
    public void showSyntaxCheckMessage(String msg, boolean correct) {
        this.showSyntaxCheckMessage(msg, correct ? "green" : "red");
    }

    public boolean checkDemonstratedValues(boolean single, boolean concat2, int vector, Vector selection, Vector action, Vector input) {
        ExpressionMatcher m = null;
        Matcher tmp = null;
        if (single) {
            m = new ExpressionMatcher(concat2, vector, "");
            m.setInputExpression(this.inputField == null ? this.inputArea.getText() : this.inputField.getText());
            m.setRelation((String)this.relationOptions.getSelectedValue());
        } else {
            m = (ExpressionMatcher)this.createMatcher();
        }
        if (this.edgeData != null) {
            tmp = this.edgeData.getMatcher();
            this.edgeData.setMatcher(m);
        }
        boolean check = m.checkExpression();
        boolean demoValues = true;
        this.showSyntaxCheckMessage(check ? "OK" : m.error(), check);
        if (check) {
            this.relationOptions.setSelectedValue(m.getRelation(), true);
            if (selection != null && action != null && input != null && concat2) {
                demoValues = m.matchConcatenation(selection, action, input);
                this.showSyntaxCheckMessage(this.syntaxCheckText.getText() + "\r\n" + (demoValues ? "Demonstrated values matched" : "Demonstrated values did not match"), demoValues);
            }
        }
        this.validate();
        if (this.edgeData != null) {
            this.edgeData.setMatcher(tmp);
        }
        return check && demoValues;
    }

    public boolean check() {
        return this.checkDemonstratedValues(false, false, -1, null, null, null);
    }

    private void showLast() {
        String msg = "This expression has not been evaluated.";
        String color = "blue";
        ExpressionMatcher m = this.lastMatcher;
        if (m != null && m.lastResult() != null) {
            String evalTime = this.lastMatcher.lastEvaluationTime() == null ? "" : fmt.format(this.lastMatcher.lastEvaluationTime());
            msg = "Last evaluation (" + evalTime + "):";
            msg = msg + "\n\nObserved input (student): " + m.lastInput();
            if (trace.getDebugCode("functions")) {
                trace.outln("functions", "relation is " + m.getRelation());
            }
            String expected = m.lastResult().toString();
            if (!m.isEqualRelation() && !m.isBooleanRelation()) {
                expected = m.getRelation() + " " + expected;
            }
            msg = msg + "\nExpected input (formula): " + expected;
            msg = msg + "\n\n" + (m.lastComparison() ? "Match!" : "No match!");
        } else if (m != null && m.lastError() != null) {
            msg = m.lastError();
            color = "red";
        }
        this.showSyntaxCheckMessage(msg, color);
    }

    public void setLastMatcher(ExpressionMatcher m) {
        this.lastMatcher = m;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src instanceof JButton && ((JButton)src).getText().equals("Last Evaluation")) {
            this.showLast();
        } else if (src == this.checkButton) {
            this.check();
        } else if (src == this.lastButton) {
            this.showLast();
        }
    }

    @Override
    public String getMatcherType() {
        return "Formula Match";
    }
}

