/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEventListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerGraph;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerInterpretation;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerPath;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExpressionMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.SolverMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ExampleTracerTracer {
    public static final String INCORRECT_ACTION = "Buggy Action";
    public static final String SUBOPTIMAL_ACTION = "Fireable Buggy Action";
    public static final String CORRECT_ACTION = "Correct Action";
    public static final String NULL_MODEL = "NO-MODEL";
    public static final String HINT = "Hint";
    public static final String NOT_A_TRANSACTION = "NotATransaction";
    private VariableTable startStateVT;
    private ArrayList<ExampleTracerInterpretation> interpretations;
    private Map<Integer, ExampleTracerLink> incorrectActionMatches;
    private ArrayList<ExampleTracerSAI> studentSAIs;
    private ExampleTracerGraph graph;
    private ExampleTracerEvent lastResult;
    private boolean isDemonstrateMode;
    private static int count = 0;
    private int instance = count++;
    private HashSet<ExampleTracerEventListener> listeners = new HashSet();
    private ExampleTracerInterpretation bestInterpretation;
    private Map<ExampleTracerLink, Boolean> matchedSelections;

    public void initialize(VariableTable startStateVariableTable) {
        if (startStateVariableTable == null) {
            this.startStateVT = null;
        } else {
            this.setStartStateVT(startStateVariableTable);
        }
        this.resetTracer();
    }

    public void resetTracer() {
        if (this.interpretations == null) {
            this.interpretations = new ArrayList();
        } else {
            this.interpretations.clear();
        }
        ExampleTracerInterpretation tempInterp = new ExampleTracerInterpretation(this.getAllPaths());
        if (this.startStateVT != null) {
            tempInterp.setVariableTable(this.startStateVT);
        }
        this.interpretations.add(tempInterp);
        this.bestInterpretation = tempInterp;
        if (this.incorrectActionMatches == null) {
            this.incorrectActionMatches = new HashMap<Integer, ExampleTracerLink>();
        } else {
            this.incorrectActionMatches.clear();
        }
        if (this.matchedSelections == null) {
            this.matchedSelections = new LinkedHashMap<ExampleTracerLink, Boolean>();
        } else {
            this.matchedSelections.clear();
        }
        if (this.studentSAIs == null) {
            this.studentSAIs = new ArrayList();
        } else {
            this.studentSAIs.clear();
        }
        for (ExampleTracerLink link : this.getGraph().getLinks()) {
            link.getMatcher().reset();
        }
    }

    public ExampleTracerTracer(ExampleTracerGraph graph) {
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "creating listener list for TracerTracer #" + this.instance);
        }
        this.graph = graph;
        this.resetTracer();
    }

    private Set<ExampleTracerPath> getAllPaths() {
        return this.graph.findAllPaths();
    }

    public ArrayList<ExampleTracerSAI> getStudentSAIs() {
        return this.studentSAIs;
    }

    ArrayList<ExampleTracerInterpretation> getInterpretationsInternal() {
        return this.interpretations;
    }

    public ArrayList<ExampleTracerInterpretation> getInterpretations() {
        return this.interpretations == null ? null : (ArrayList)this.interpretations.clone();
    }

    public void setStartStateVT(VariableTable vt) {
        this.startStateVT = (VariableTable)vt.clone();
    }

    VariableTable getStartStateVTInternal() {
        return this.startStateVT;
    }

    public VariableTable getStartStateVT() {
        return this.startStateVT == null ? null : (VariableTable)this.startStateVT.clone();
    }

    private void setInterpretations(Collection<ExampleTracerInterpretation> c) {
        this.interpretations.clear();
        if (c.size() == 0) {
            return;
        }
        this.interpretations.addAll(c);
        this.bestInterpretation = null;
    }

    public ExampleTracerInterpretation getBestInterpretation() {
        if (this.bestInterpretation == null) {
            this.bestInterpretation = this.getBestInterpretation(this.getInterpretationsInternal());
        }
        return this.bestInterpretation;
    }

    private ExampleTracerInterpretation getBestInterpretation(Iterable<ExampleTracerInterpretation> iter) {
        ExampleTracerInterpretationComparator comp = new ExampleTracerInterpretationComparator();
        ExampleTracerInterpretation bestInterp = null;
        for (ExampleTracerInterpretation interp : iter) {
            if (bestInterp == null) {
                bestInterp = interp;
                continue;
            }
            int compResult = comp.compare(interp, bestInterp);
            if (trace.getDebugCode("etcomp")) {
                trace.out("etcomp", "interps compare(" + interp + "," + bestInterp + ")=" + compResult);
            }
            if (compResult <= 0) continue;
            bestInterp = interp;
        }
        return bestInterp;
    }

    ExampleTracerGraph getGraph() {
        return this.graph;
    }

    public ExampleTracerEvent getLastResult() {
        return this.lastResult;
    }

    public ProblemEdge doHint(Vector selection, Vector action, Vector input, String actor, ExampleTracerEvent rtnResult, boolean allowHintBias) {
        ProblemEdge link = null;
        Vector previousFocus = null;
        Vector previousAction = null;
        if (trace.getDebugCode("ett")) {
            trace.out("ett", "doHint(" + selection + "," + action + "," + input + ")");
        }
        if (allowHintBias && action != null && action.size() > 1 && action.get(1).equals("PreviousFocus") && selection != null && selection.size() > 1 && selection.get(1) != null && !selection.get(1).equals("null")) {
            previousFocus = new Vector();
            previousFocus.add(selection.get(1));
            if (action.size() > 2) {
                previousAction = new Vector();
                for (int i = 2; i < action.size(); ++i) {
                    previousAction.add(action.get(i));
                }
            }
        }
        if (rtnResult != null) {
            rtnResult.setStudentSAI(previousFocus, previousAction, null, actor);
            rtnResult.setFeedback(this.getGraph().getFeedback());
            rtnResult.setHintRequest(true);
            link = this.matchForHint(rtnResult);
        }
        return link;
    }

    public ProblemNode getCurrentNode(boolean isDemonstrateMode) {
        return this.getCurrentNode(isDemonstrateMode, false);
    }

    public ProblemNode getCurrentNode(boolean isDemonstrateMode, boolean wantHint) {
        ProblemNode[] endNode;
        ExampleTracerLink bestNextLink;
        ExampleTracerLink deepest;
        if (isDemonstrateMode && (deepest = ExampleTracerPath.getDeepestLink(this.getBestInterpretation().getMatchedLinks())) != null) {
            return this.graph.getNode(deepest.getNextNode()).getProblemNode();
        }
        ExampleTracerInterpretation bestInterp = this.getBestInterpretation();
        if (bestInterp != null && bestInterp.getMatchedLinks().size() != 0 && bestInterp.getLastMatchedLink().getEdge().isDone()) {
            return this.graph.getNode(bestInterp.getLastMatchedLink().getNextNode()).getProblemNode();
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "ETT.getCurrentNode() not done node: calling getBestNextLink()");
        }
        if ((bestNextLink = this.getBestNextLink(wantHint, endNode = new ProblemNode[1], new ExampleTracerInterpretation[]{bestInterp})) == null) {
            if (endNode[0] != null) {
                return endNode[0];
            }
            if (this.graph.getStartNode() != null) {
                return this.graph.getStartNode().getProblemNode();
            }
            return null;
        }
        return this.graph.getNode(bestNextLink.getPrevNode()).getProblemNode();
    }

    ExampleTracerLink getBestNextLink(boolean wantHint, ProblemNode[] rtnLastNode, ExampleTracerInterpretation[] rtnInterp) {
        ExampleTracerInterpretation interp;
        ExampleTracerInterpretation exampleTracerInterpretation = interp = rtnInterp != null && rtnInterp[0] != null ? rtnInterp[0] : null;
        if (interp == null) {
            interp = this.getBestInterpretation();
        }
        if (rtnInterp != null) {
            rtnInterp[0] = interp;
        }
        ExampleTracerPath path = ExampleTracerPath.getBestPath(interp.getPaths());
        ExampleTracerLink highestLink = this.getHighestUntraversedLink(interp, path, wantHint, false);
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "ETT.getBestNextLink() highest untraversed link " + highestLink + "\n  in path " + path);
        }
        if (highestLink != null) {
            return highestLink;
        }
        ExampleTracerLink lastLink = null;
        Iterator<ExampleTracerLink> iterator = path.iterator();
        while (iterator.hasNext()) {
            ExampleTracerLink link;
            lastLink = link = iterator.next();
            if (interp.getTraversalCount(link) >= link.getEdge().getMaxTraversals() || wantHint && this.nHints(link, interp.getVariableTable()) <= 0 || !this.graph.observesOrderingConstraints(interp.getMatchedLinks(), link, path.getLinks(), null) || !this.doneStepOK(interp, link, path.getLinks())) continue;
            if (trace.getDebugCode("sai")) {
                trace.out("sai", "ETT.getBestNextLink() to return highest unmaxed link " + link + "\n  in path " + path);
            }
            return link;
        }
        if (rtnLastNode != null && lastLink != null) {
            rtnLastNode[0] = lastLink.getEdge().getEndProblemNode();
        }
        if (trace.getDebugCode("sai")) {
            trace.out("sai", "ETT.getBestNextLink() to return null; last link " + lastLink);
        }
        return null;
    }

    public ExampleTracerLink getHighestUntraversedLink(ExampleTracerInterpretation interp, ExampleTracerPath path, boolean wantHint, boolean countOptionalAsTraversed) {
        ExampleTracerEvent result = new ExampleTracerEvent(this);
        boolean lastLinkVisited = true;
        ArrayList<ExampleTracerLink> suggestedLinks = new ArrayList<ExampleTracerLink>();
        for (ExampleTracerLink link : path) {
            EdgeData edgeData;
            if (interp.isTraversed(link, countOptionalAsTraversed) || this.isNoOp(link)) {
                lastLinkVisited = true;
                continue;
            }
            if (lastLinkVisited) {
                ExampleTracerNode pNode = this.graph.getNode(link.getPrevNode());
                ArrayList<ExampleTracerLink> outLinks = pNode.getOutLinks();
                for (ExampleTracerLink outLink : outLinks) {
                    if (wantHint && this.nHints(outLink, interp.getVariableTable()) < 1 || interp.getTraversalCount(outLink) >= outLink.getEdge().getMaxTraversals()) continue;
                    suggestedLinks.add(outLink);
                }
            }
            lastLinkVisited = (edgeData = link.getEdge()) == null ? false : edgeData.getMinTraversals() <= interp.getTraversalCount(link);
        }
        Collections.sort(suggestedLinks, new ExampleTracerLinkComparator(interp));
        for (ExampleTracerLink suggestedLink : suggestedLinks) {
            if (this.isPathOK(suggestedLink, interp, path, this.isDemonstrateMode, result)) {
                return suggestedLink;
            }
            for (ExampleTracerPath otherPath : interp.getPaths()) {
                if (path == otherPath || !this.isPathOK(suggestedLink, interp, otherPath, this.isDemonstrateMode, result)) continue;
                return suggestedLink;
            }
        }
        return null;
    }

    private int nHints(ExampleTracerLink link, VariableTable vt) {
        return this.nHints(link.getEdge(), vt);
    }

    private int nHints(EdgeData edgeData, VariableTable vt) {
        if (edgeData == null) {
            return 0;
        }
        List<String> hints = edgeData.getAllNonEmptyHints();
        if (hints == null || hints.size() < 1) {
            return 0;
        }
        if (this.getLastResult() == null) {
            return hints.size();
        }
        ExampleTracerSAI sai = this.getLastResult().getStudentSAI();
        edgeData.interpolateHints(vt, sai.getSelectionAsString(), sai.getActionAsString(), sai.getInputAsString());
        hints = edgeData.getHints();
        return hints.size();
    }

    private boolean isNoOp(ExampleTracerLink link) {
        EdgeData edgeData = link.getEdge();
        if (edgeData == null) {
            return false;
        }
        return edgeData.getMinTraversals() < 1 && edgeData.getMaxTraversals() < 1;
    }

    public ProblemEdge traceForHint(ExampleTracerEvent result) {
        boolean eval2 = this.evaluate(result, true, false);
        if (result.getResult().equals(CORRECT_ACTION)) {
            EdgeData edgeData = result.getReportableLink().getEdge();
            return edgeData.getEdge();
        }
        return null;
    }

    ArrayList<ExampleTracerLink> findSAIMatchingLinks(ExampleTracerSAI sai, boolean hint, VariableTable vt, ExampleTracerEvent result) {
        if (trace.getDebugCode("et")) {
            trace.outNT("et", "findSAIMatchingLinks(" + sai + "," + hint + ",vt#" + vt.getInstance() + ")");
        }
        ArrayList<ExampleTracerLink> matchingLinks = new ArrayList<ExampleTracerLink>();
        for (ExampleTracerLink link : this.graph.getLinks()) {
            if (!hint) {
                boolean matched = link.matchesSAI(sai, vt);
                if (matched) {
                    matchingLinks.add(link);
                }
                if (!this.getGraph().getFeedback().hideButRequireSteps()) continue;
                this.updateMatchedSelections(sai, matched, link, vt);
                continue;
            }
            if (!link.matchesSAIforHint(sai, result, vt)) continue;
            matchingLinks.add(link);
        }
        return matchingLinks;
    }

    private void updateMatchedSelections(ExampleTracerSAI sai, boolean matched, ExampleTracerLink link, VariableTable vt) {
        Boolean newResult = matched && link.isCorrect();
        if (this.matchedSelections.containsKey(link) || link.matchesSAIforHint(sai, null, vt)) {
            this.matchedSelections.put(link, newResult);
        }
        if (trace.getDebugCode("feedback")) {
            trace.out("feedback", String.format("updateMatchedSelections(): link %3d, newResult %-5s, matchedSelections %s", link.getID(), newResult.toString(), ExampleTracerLink.listLinkIDs(this.matchedSelections.keySet())));
        }
    }

    boolean doneStepOK(ExampleTracerInterpretation interp, ExampleTracerLink newLink, Set<ExampleTracerLink> path) {
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "doneStepOK(" + interp + ", " + newLink + ", ...)");
        }
        if (newLink == null || !newLink.getEdge().isDone()) {
            return true;
        }
        if (this.getGraph().getFeedback().exitOnIncorrectDone()) {
            return true;
        }
        if (newLink.getType().equals(INCORRECT_ACTION)) {
            return true;
        }
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "doneStepOK(" + interp + ", " + newLink + ", " + path + ")");
        }
        for (ExampleTracerLink link : path) {
            if (link.getUniqueID() == newLink.getUniqueID()) continue;
            int traversalCount = interp.getTraversalCount(link);
            int minTraversals = link.getEdge().getMinTraversals();
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "doneStepOK() " + link + " traversalCount " + traversalCount);
            }
            if (this.getGraph().getFeedback() == FeedbackEnum.HIDE_BUT_COMPLETE && (traversalCount > 0 || minTraversals < 1) || traversalCount >= minTraversals) continue;
            return false;
        }
        return true;
    }

    boolean evaluate(ExampleTracerSAI sai) {
        this.lastResult = new ExampleTracerEvent(this);
        this.lastResult.setStudentSAI(sai);
        return this.evaluate(this.lastResult, false, true);
    }

    boolean evaluate(ExampleTracerEvent result, boolean isHintTrace, boolean doUpdate) {
        HashSet<ExampleTracerInterpretation> newInterps = new HashSet<ExampleTracerInterpretation>();
        ArrayList<ExampleTracerLink> saiLinkMatches = result.getPreloadedLinkMatches();
        if (trace.getDebugCode("ett")) {
            trace.out("ett", "PreloadedLinkMatches: " + saiLinkMatches);
        }
        for (ExampleTracerInterpretation interpretation : this.interpretations) {
            if (trace.getDebugCode("ett")) {
                trace.out("ett", "trying interpretation: " + interpretation);
            }
            if ((saiLinkMatches = result.getPreloadedLinkMatches()) == null) {
                saiLinkMatches = this.findSAIMatchingLinks(result.getStudentSAI(), isHintTrace, interpretation.getVariableTable(), result);
            } else {
                for (ExampleTracerLink link : saiLinkMatches) {
                    this.updateMatchedSelections(result.getStudentSAI(), true, link, interpretation.getVariableTable());
                }
            }
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "number of link matches: " + saiLinkMatches.size());
            }
            for (ExampleTracerLink link : saiLinkMatches) {
                if (trace.getDebugCode("ett")) {
                    trace.out("ett", "Using link: " + link + ", traversals " + interpretation.getTraversalCount(link));
                }
                if (!this.getGraph().getFeedback().relaxOrderConstraints() && interpretation.getTraversalCount(link) >= link.getEdge().getMaxTraversals()) continue;
                ExampleTracerInterpretation newInterp = interpretation.clone();
                if (trace.getDebugCode("ET")) {
                    trace.out("ET", "ClonedInterp: " + newInterp);
                }
                Iterator<ExampleTracerPath> iter = newInterp.getPaths().iterator();
                while (iter.hasNext()) {
                    ExampleTracerPath path = iter.next();
                    if (trace.getDebugCode("ET")) {
                        trace.out("ET", "Trying Path: " + path);
                    }
                    if (this.isPathOK(link, newInterp, path, this.isDemonstrateMode, result)) continue;
                    iter.remove();
                }
                if (newInterp.getPaths().size() <= 0) continue;
                Matcher m = link.getMatcher();
                result.setTutorSAI(new ExampleTracerSAI(m.getSelection(), m.getAction(), m.getEvaluatedInput(), m.getActor()));
                boolean solverResult = this.checkSolver(link, result.getStudentSAI(), isHintTrace, result);
                if (trace.getDebugCode("solverdebug")) {
                    trace.out("solverdebug", "solverResult " + result.getResult() + ", InterfaceActions: " + result.getInterfaceActions());
                }
                this.fixupMatcherForPreloadedLinkMatches(link, newInterp, result);
                if (!solverResult) {
                    // empty if block
                }
                newInterp.addLink(link);
                if (doUpdate) {
                    Vector replacementInput = this.replaceInput(link, result.getStudentSAI(), newInterp);
                    newInterp.updateVariableTable(result.getStudentSAI(), replacementInput, link);
                }
                newInterps.add(newInterp);
            }
        }
        if (trace.getDebugCode("et")) {
            trace.out("et", "newInterps.size() " + newInterps);
        }
        result.setNumberOfInterpretations(newInterps.size());
        Boolean doneResult = this.checkDoneStep(result, isHintTrace, doUpdate, newInterps);
        if (doneResult != null) {
            return doneResult;
        }
        if (newInterps.size() == 0) {
            result.setResult(NULL_MODEL);
            return false;
        }
        ExampleTracerInterpretation bestInterp = this.getBestInterpretation(newInterps);
        String type = null;
        type = result.isSolverResult() ? (NULL_MODEL.equalsIgnoreCase(result.getResult()) ? INCORRECT_ACTION : result.getResult()) : bestInterp.getLastMatchedLink().getType();
        if (trace.getDebugCode("et")) {
            trace.out("et", "bestInterp " + bestInterp + ", lastMatchedLinktype " + type);
        }
        return this.finishEvaluate(result, doUpdate, type, null, bestInterp, newInterps);
    }

    private boolean finishEvaluate(ExampleTracerEvent result, boolean doUpdate, String type, ExampleTracerLink link, ExampleTracerInterpretation bestInterp, Collection<ExampleTracerInterpretation> newInterps) {
        if (doUpdate) {
            this.studentSAIs.add(result.getStudentSAI());
            if (type.equals(CORRECT_ACTION) || type.equals(SUBOPTIMAL_ACTION)) {
                Iterator<ExampleTracerInterpretation> iter = newInterps.iterator();
                while (iter.hasNext()) {
                    if (!iter.next().getLastMatchedLink().getType().equals(INCORRECT_ACTION)) continue;
                    iter.remove();
                }
                if (newInterps.size() > 0) {
                    this.setInterpretations(newInterps);
                }
                if (trace.getDebugCode("et")) {
                    trace.out("et", "Update Example Tracer");
                }
                this.incorrectActionMatches.clear();
            } else {
                result.setNumberOfInterpretations(0);
                this.incorrectActionMatches.clear();
                for (ExampleTracerInterpretation interp : newInterps) {
                    this.incorrectActionMatches.put(interp.getLastMatchedLink().getUniqueID(), interp.getLastMatchedLink());
                }
            }
            if (type.equals(INCORRECT_ACTION)) {
                this.studentSAIs.remove(this.studentSAIs.size() - 1);
            }
        }
        if (!result.isSolverResult()) {
            result.setResult(type);
        }
        if (bestInterp == null) {
            result.setReportableLink(link);
        } else {
            link = bestInterp.getLastMatchedLink();
            if (trace.getDebugCode("et")) {
                trace.out("et", "updateExampleTracer: reportableLink " + link);
            }
            result.setReportableLink(link);
            result.setReportableVariableTable(bestInterp.getVariableTable());
            ExampleTracerSAI sai = result.getStudentSAI();
            link.getEdge().interpolateHints(bestInterp.getVariableTable(), sai.getSelectionAsString(), sai.getActionAsString(), sai.getInputAsString());
            result.setReportableHints(link.getEdge().getHints());
        }
        this.fireExampleTracerEvent(result);
        return !type.equals(INCORRECT_ACTION);
    }

    private Boolean checkDoneStep(ExampleTracerEvent result, boolean isHintTrace, boolean doUpdate, Collection<ExampleTracerInterpretation> newInterps) {
        if (trace.getDebugCode("feedback")) {
            trace.printStack("feedback", "checkDoneStep() hintTrace " + isHintTrace + ", sai.isDone " + result.getStudentSAI().isDone() + ", exitOnIncorrectDone " + this.getGraph().getFeedback().exitOnIncorrectDone() + ", hideButRequireSteps " + this.getGraph().getFeedback().hideButRequireSteps());
        }
        if (!result.getStudentSAI().isDone()) {
            return null;
        }
        if (this.getGraph().getFeedback().exitOnIncorrectDone()) {
            result.setDoneStepFailed(false);
            return null;
        }
        if (!isHintTrace && this.getGraph().getFeedback().hideButRequireSteps()) {
            if (trace.getDebugCode("feedback")) {
                trace.out("feedback", "checkDoneStep matchedSelections " + this.matchedSelections.keySet());
            }
            Set<ExampleTracerLink> doneLinks = this.getGraph().getDoneLinks();
            if (trace.getDebugCode("feedback")) {
                trace.out("feedback", "checkDoneStep getDoneLinks() returns " + doneLinks);
            }
            for (ExampleTracerLink doneLink : doneLinks) {
                if (!this.getGraph().pathToLinkIsSubset(doneLink, this.matchedSelections.keySet())) continue;
                result.setDoneStepFailed(false);
                return this.finishEvaluate(result, doUpdate, CORRECT_ACTION, doneLink, null, newInterps);
            }
        }
        if (newInterps.size() < 1) {
            result.setDoneStepFailed(true);
        }
        return null;
    }

    private Vector replaceInput(ExampleTracerLink link, ExampleTracerSAI sai, ExampleTracerInterpretation newInterp) {
        EdgeData edgeData = link.getEdge();
        if (edgeData == null || !edgeData.replaceInput()) {
            return null;
        }
        Vector replacementInput = edgeData.evaluateReplacement(sai.getSelectionAsVector(), sai.getActionAsVector(), sai.getInputAsVector(), newInterp.getVariableTable());
        return replacementInput;
    }

    private boolean checkSolver(ExampleTracerLink link, ExampleTracerSAI studentSAI, boolean isHintTrace, ExampleTracerEvent result) {
        Matcher m = link.getMatcher();
        if (!(m instanceof SolverMatcher)) {
            return true;
        }
        if (isHintTrace) {
            int nHints = ((SolverMatcher)m).requestHint(result);
            if (trace.getDebugCode("et")) {
                trace.out("et", "link " + link.getID() + ": getHintMessages() returns " + nHints);
            }
        } else {
            Vector<String> s = studentSAI.getSelectionAsVector();
            Vector<String> a = studentSAI.getActionAsVector();
            Vector<String> i = studentSAI.getInputAsVector();
            boolean success = ((SolverMatcher)m).doStep(s, a, i, result);
            if (trace.getDebugCode("et")) {
                trace.out("et", "link " + link.getID() + ": evaluate(" + s + "," + a + "," + i + ") returns " + result + ", InterfaceActions: " + result.getInterfaceActions());
            }
        }
        return ((SolverMatcher)m).isDone();
    }

    private void fixupMatcherForPreloadedLinkMatches(ExampleTracerLink link, ExampleTracerInterpretation interp, ExampleTracerEvent result) {
        if (result.getPreloadedLinkMatches() == null) {
            return;
        }
        if (!result.getPreloadedLinkMatches().contains(link)) {
            return;
        }
        EdgeData edgeData = link.getEdge();
        this.setInterpolateSAI(edgeData);
        Matcher m = link.getMatcher();
        ExampleTracerSAI sai = result.getStudentSAI();
        boolean mResult = m.match(sai.getSelectionAsVector(), sai.getActionAsVector(), sai.getInputAsVector(), sai.getActor(), interp.getVariableTable());
        ExampleTracerSAI tutorSAI = new ExampleTracerSAI(m.getSelection(), m.getAction(), m.getDefaultInput(), m.getActor());
        if (m instanceof VectorMatcher) {
            Matcher inputMatcher = ((VectorMatcher)m).getMatchers(2).get(0);
            if (inputMatcher instanceof ExpressionMatcher) {
                if (((ExpressionMatcher)inputMatcher).isEqualRelation()) {
                    String evaluatedInput = ((ExpressionMatcher)inputMatcher).getLastResult();
                    result.setEvaluatedInput(evaluatedInput);
                    edgeData.setStudentInput(evaluatedInput);
                    inputMatcher.setDefaultInput(((ExpressionMatcher)inputMatcher).getLastResult());
                    tutorSAI.setInput(inputMatcher.getEvaluatedInput());
                }
            } else if (inputMatcher instanceof ExactMatcher) {
                edgeData.setStudentInput(((VectorMatcher)m).getInputMatcher());
                tutorSAI.setInput(((VectorMatcher)m).getInputMatcher());
                edgeData.setStudentAction(((VectorMatcher)m).getActionMatcher());
                edgeData.setStudentSelection(((VectorMatcher)m).getSelectionMatcher());
            }
        } else if (m instanceof ExactMatcher) {
            edgeData.setStudentInput(m.getDefaultInput());
            tutorSAI.setInput(m.getDefaultInput());
            edgeData.setStudentAction(m.getDefaultAction());
            edgeData.setStudentSelection(m.getDefaultSelection());
        }
        result.setTutorSAI(tutorSAI);
    }

    private boolean isPathOK(ExampleTracerLink newLink, ExampleTracerInterpretation interp, ExampleTracerPath path, boolean isDemonstrateMode, ExampleTracerEvent result) {
        Set<ExampleTracerLink> pathLinks;
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isPathOK(" + newLink + ", " + interp + ", " + path + ", " + isDemonstrateMode + ")");
        }
        if (isDemonstrateMode) {
            ArrayList<ExampleTracerLink> allLinks = new ArrayList<ExampleTracerLink>(interp.getMatchedLinks());
            allLinks.add(newLink);
            pathLinks = path.getLinksRestricted(allLinks);
        } else {
            pathLinks = path.getLinks();
        }
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isPathOK() pathLinks: " + pathLinks);
        }
        if (isDemonstrateMode) {
            ArrayList<ExampleTracerLink> traversedLinks = new ArrayList<ExampleTracerLink>();
            for (ExampleTracerLink link : interp.getMatchedLinks()) {
                if (!this.graph.observesOrderingConstraints(traversedLinks, link, pathLinks, result) || !this.doneStepOK(interp, link, pathLinks)) {
                    return false;
                }
                traversedLinks.add(link);
            }
        }
        if (newLink.getType().equals(INCORRECT_ACTION)) {
            if (!this.graph.isIncorrectLinkOK(interp.getMatchedLinks(), newLink, pathLinks, interp)) {
                return false;
            }
        } else {
            if (!this.graph.observesOrderingConstraints(interp.getMatchedLinks(), newLink, pathLinks, result)) {
                return false;
            }
            if (!this.doneStepOK(interp, newLink, pathLinks)) {
                return false;
            }
        }
        return true;
    }

    private String linkName(ExampleTracerLink link, String s) {
        return "link" + link.getUniqueID() + "." + s;
    }

    public List<EdgeData> evaluateEdges(ExampleTracerPath path, List<ExampleTracerEvent> results) {
        this.resetTracer();
        ArrayList<EdgeData> traversedEdges = new ArrayList<EdgeData>();
        for (ExampleTracerLink link : path) {
            EdgeData data = link.getEdge();
            boolean traced = this.evaluate(data);
            ExampleTracerEvent result = this.getLastResult();
            if (trace.getDebugCode("br")) {
                trace.outln("br", "evaluateEdges edgeID(" + data + ") returns " + traced + "; result " + result);
            }
            if (results != null) {
                results.add(result);
            }
            if (!traced) continue;
            traversedEdges.add(data);
        }
        return traversedEdges;
    }

    public boolean evaluate(EdgeData edgeData) {
        return this.evaluate(edgeData.getUniqueID(), edgeData.getSelection(), edgeData.getAction(), edgeData.getInput(), edgeData.getActor());
    }

    public boolean evaluate(int linkID, Vector selection, Vector action, Vector input, String actor) {
        ExampleTracerLink link;
        this.lastResult = new ExampleTracerEvent(this);
        this.lastResult.setStudentSAI(selection, action, input, actor);
        if (linkID > 0 && (link = this.graph.getLink(linkID)) != null) {
            this.lastResult.addPreloadedLinkMatch(link);
        }
        if (trace.getDebugCode("et")) {
            trace.out("et", "ExTracerTracer(link" + linkID + ") calling evaluate(), result " + this.lastResult);
        }
        return this.evaluate(this.lastResult, false, true);
    }

    private void setInterpolateSAI(EdgeData edgeData) {
        String selection = "";
        if (edgeData.getSelection() != null) {
            selection = edgeData.getSelection().get(0).toString();
        }
        String action = null;
        if (edgeData.getAction() != null) {
            action = edgeData.getAction().get(0).toString();
        }
        String input = null;
        if (edgeData.getInput() != null) {
            input = edgeData.getInput().get(0).toString();
        }
        edgeData.setInterpolateSAI(selection, action, input);
    }

    public boolean evaluate(Vector selection, Vector action, Vector input, String actor) {
        return this.evaluate(-1, selection, action, input, actor);
    }

    public ProblemEdge matchForHint(ExampleTracerEvent result) {
        Vector<String> selection;
        Vector<String> vector = selection = result.getStudentSAI() == null ? null : result.getStudentSAI().getSelectionAsVector();
        if (selection != null && selection.size() > 0) {
            result.setWantReportableHints(true);
            ProblemEdge link = this.traceForHint(result);
            if (link != null && result.getReportableHints().size() > 0) {
                link.getEdgeData().setInterpolatedHints(result.getReportableHints());
                return link;
            }
        }
        return this.getBestNextLink(true, result);
    }

    public ProblemEdge getBestNextLink(boolean wantHint, ExampleTracerEvent result) {
        ProblemEdge link = null;
        ProblemNode[] endNode = new ProblemNode[1];
        ExampleTracerInterpretation[] interp = new ExampleTracerInterpretation[1];
        ExampleTracerLink etLink = this.getBestNextLink(wantHint, endNode, interp);
        if (etLink == null) {
            trace.err("matchForHint(): getBestNextLink returns null; endNode " + endNode[0]);
            return null;
        }
        EdgeData edgeData = etLink.getEdge();
        if (edgeData == null) {
            trace.err("matchForHint(): getBestNextLink returns etLink " + etLink + " with null EdgeData");
            return null;
        }
        link = edgeData.getEdge();
        if (etLink.getType().equals(INCORRECT_ACTION)) {
            trace.err("matchForHint(): getBestNextLink returns INCORRECT " + link);
            return null;
        }
        Matcher m = edgeData.getMatcher();
        if (m instanceof SolverMatcher) {
            ((SolverMatcher)m).requestHint(result);
        } else {
            edgeData.interpolateHints(interp[0].getVariableTable());
        }
        result.setReportableLink(etLink);
        return link;
    }

    public static int compareLinkTypes(String t1, String t2) {
        if (t1 == null) {
            return t2 == null ? 0 : 1;
        }
        if (t2 == null) {
            return -1;
        }
        if (t1.equals(t2)) {
            return 0;
        }
        if (t1.equals(CORRECT_ACTION)) {
            return -1;
        }
        if (t2.equals(CORRECT_ACTION)) {
            return 1;
        }
        if (t1.equals(SUBOPTIMAL_ACTION)) {
            return -1;
        }
        if (t2.equals(SUBOPTIMAL_ACTION)) {
            return 1;
        }
        if (t1.equals(INCORRECT_ACTION)) {
            return -1;
        }
        if (t2.equals(INCORRECT_ACTION)) {
            return 1;
        }
        return 0;
    }

    public boolean isLinkVisited(int uniqueID) {
        boolean visited = false;
        if (this.interpretations != null && this.interpretations.size() > 0) {
            ExampleTracerInterpretation interp = this.getBestInterpretation();
            visited = interp.isVisited(uniqueID);
        }
        if (!visited) {
            ExampleTracerLink linkMatch = this.incorrectActionMatches.get(new Integer(uniqueID));
            visited = linkMatch != null;
        }
        return visited;
    }

    public String toString() {
        String s = "TracerState\n";
        for (ExampleTracerInterpretation interp : this.interpretations) {
            s = s + interp.toString() + "\n";
        }
        return s;
    }

    public void setDemonstrateMode(boolean b) {
        if (this.isDemonstrateMode != b) {
            this.isDemonstrateMode = b;
        }
    }

    public boolean isDemonstrateMode() {
        return this.isDemonstrateMode;
    }

    public void extendPaths() {
        if (!this.isDemonstrateMode) {
            System.err.println("ExampleTracerTracer.extendPaths() was called when not in demonstrate mode");
            return;
        }
        for (ExampleTracerInterpretation interp : this.interpretations) {
            Set<ExampleTracerPath> paths = this.getAllPaths();
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "extendPaths(): interp " + interp + ", paths " + paths);
            }
            interp.setPaths(paths);
        }
        this.bestInterpretation = null;
    }

    public int getInterpretationCount() {
        return this.interpretations.size();
    }

    public void assignVariable(String key, Object value) {
        if (this.interpretations == null) {
            return;
        }
        for (ExampleTracerInterpretation interp : this.interpretations) {
            VariableTable vt = interp.getVariableTable();
            if (vt == null) continue;
            vt.put(key, value);
        }
    }

    public void addExampleTracerEventListener(ExampleTracerEventListener l) {
        this.listeners.add(l);
    }

    public int getInstance() {
        return this.instance;
    }

    public void fireExampleTracerEvent(ExampleTracerEvent e) {
        if (trace.getDebugCode("eti")) {
            trace.outNT("eti", "TracerTracer #" + this.instance + ": fireExampleTraceEvent()");
        }
        for (ExampleTracerEventListener listener : this.listeners) {
            listener.ExampleTracerEventOccurred(e);
        }
    }

    public class ExampleTracerLinkComparator
    implements Comparator<ExampleTracerLink> {
        private ExampleTracerInterpretation interp;

        public ExampleTracerLinkComparator(ExampleTracerInterpretation interp) {
            this.interp = interp;
        }

        @Override
        public int compare(ExampleTracerLink l1, ExampleTracerLink l2) {
            String t2;
            String t1 = l1.getType();
            int m = ExampleTracerTracer.compareLinkTypes(t1, t2 = l2.getType());
            if (m != 0) {
                return m;
            }
            int h1 = ExampleTracerTracer.this.nHints(l1, this.interp.getVariableTable());
            int h2 = ExampleTracerTracer.this.nHints(l2, this.interp.getVariableTable());
            if (h1 > 0 && h2 <= 0) {
                return -1;
            }
            if (h1 <= 0 && h2 > 0) {
                return 1;
            }
            EdgeData e1 = l1.getEdge();
            EdgeData e2 = l2.getEdge();
            if (l1.getDepth() < l2.getDepth()) {
                return -1;
            }
            if (l1.getDepth() > l2.getDepth()) {
                return 1;
            }
            int tc1 = this.interp.getTraversalCount(l1) - e1.getMinTraversals();
            int tc2 = this.interp.getTraversalCount(l2) - e2.getMinTraversals();
            if (tc1 < 0 && tc2 >= 0) {
                return -1;
            }
            if (tc1 >= 0 && tc2 < 0) {
                return 1;
            }
            if (e1.isPreferredEdge()) {
                return -1;
            }
            if (e2.isPreferredEdge()) {
                return 1;
            }
            m = Matcher.compare(l1.getMatcher(), l2.getMatcher());
            if (m != 0) {
                return m;
            }
            if (l1.getUniqueID() < l2.getUniqueID()) {
                return -1;
            }
            return 1;
        }
    }

    public class ExampleTracerInterpretationComparator
    implements Comparator {
        public int compare(Object d1, Object d2) {
            return this.compare((ExampleTracerInterpretation)d1, (ExampleTracerInterpretation)d2);
        }

        private int compare(ExampleTracerInterpretation i1, ExampleTracerInterpretation i2) {
            String i1Type = i1.getType();
            int result = ExampleTracerTracer.compareLinkTypes(i1Type, i2.getType());
            if (trace.getDebugCode("et")) {
                trace.out("et", "i1Type=" + i1Type + "; compareLinkType(" + i1 + "," + i2 + ") = " + result);
            }
            if (result != 0) {
                return result < 0 ? 1 : -1;
            }
            ExampleTracerLink w1 = i1.getLastMatchedLink();
            ExampleTracerLink w2 = i2.getLastMatchedLink();
            int m = 0;
            if (w1 != null && w2 != null) {
                m = Matcher.compare(w1.getMatcher(), w2.getMatcher());
            }
            if (trace.getDebugCode("et")) {
                trace.out("et", "compare matchers(" + w1 + "," + w2 + ") = " + m);
            }
            if (m != 0) {
                return m;
            }
            ExampleTracerPath p1 = ExampleTracerPath.getBestPath(i1.getPaths());
            ExampleTracerPath p2 = ExampleTracerPath.getBestPath(i2.getPaths());
            HashSet<ExampleTracerPath> bestPair = new HashSet<ExampleTracerPath>();
            bestPair.add(p1);
            bestPair.add(p2);
            ExampleTracerPath best = ExampleTracerPath.getBestPath(bestPair);
            if (trace.getDebugCode("et")) {
                trace.out("et", "getBestPath(" + p1 + "," + p2 + ") = " + (best == p2 ? "p2" : "p1"));
            }
            return best == p2 ? -1 : 1;
        }

        private int breakByLowerLinkID(ExampleTracerInterpretation i1, ExampleTracerInterpretation i2) {
            Iterator<ExampleTracerLink> links1 = i1.getMatchedLinks().iterator();
            Iterator<ExampleTracerLink> links2 = i2.getMatchedLinks().iterator();
            ExampleTracerLink link1 = null;
            ExampleTracerLink link2 = null;
            while (links1.hasNext() && links2.hasNext()) {
                link1 = links1.next();
                link2 = links2.next();
                if (link1.getUniqueID() == link2.getUniqueID()) continue;
            }
            if (link1.getUniqueID() < link2.getUniqueID()) {
                return -1;
            }
            return 1;
        }
    }
}

