/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerSAI;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ExampleTracerLink {
    private int uniqueID;
    private EdgeData edge;
    private int depth;
    private int prevNode;
    private int nextNode;

    public ExampleTracerLink(int uniqueID, int prevNode, int nextNode) {
        this.uniqueID = uniqueID;
        this.prevNode = prevNode;
        this.nextNode = nextNode;
    }

    ExampleTracerLink(EdgeData edge) {
        this.edge = edge;
        this.uniqueID = edge.getUniqueID();
    }

    public ExampleTracerLink(EdgeData edge, int prevNode, int nextNode) {
        this.edge = edge;
        this.prevNode = prevNode;
        this.nextNode = nextNode;
        this.uniqueID = edge.getUniqueID();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[link ");
        sb.append(this.getUniqueID());
        sb.append(" (").append(this.getPrevNode()).append('-').append(this.getNextNode());
        sb.append(") ").append(this.getType());
        if (this.edge != null && this.edge.getActionLabel() != null) {
            sb.append(" ").append(this.edge.getActionLabel().getText());
        }
        sb.append("]");
        return sb.toString();
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(int id) {
        this.uniqueID = id;
    }

    public int getPrevNode() {
        return this.prevNode;
    }

    void setPrevNode(int prevNode) {
        this.prevNode = prevNode;
    }

    public int getNextNode() {
        return this.nextNode;
    }

    void setNextNode(int nextNode) {
        this.nextNode = nextNode;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public boolean isTraversable() {
        if (this.getEdge().getMaxTraversals() < 1) {
            return false;
        }
        if (this.isCorrect()) {
            return true;
        }
        return this.isSuboptimal();
    }

    String getType() {
        return this.edge.getActionType();
    }

    public boolean isCorrect() {
        return "Correct Action".equalsIgnoreCase(this.getType());
    }

    public boolean isSuboptimal() {
        return "Fireable Buggy Action".equalsIgnoreCase(this.getType());
    }

    public boolean isRequired() {
        return this.getEdge().getMinTraversals() > 0;
    }

    Matcher getMatcher() {
        boolean caseInsensitive = this.edge.getProblemModel().isCaseInsensitive();
        Matcher m = this.edge.getMatcher();
        if (trace.getDebugCode("match")) {
            trace.out("match", "ETLink.getMatcher() matcher " + m + ", caseInsensitive " + caseInsensitive);
        }
        m.setCaseInsensitive(caseInsensitive);
        return m;
    }

    boolean matchesSAI(ExampleTracerSAI sai, VariableTable vt) {
        Matcher m = this.getMatcher();
        this.getEdge().setInterpolateSAI(sai.getSelectionAsString(), sai.getActionAsString(), sai.getInputAsString());
        boolean mResult = m.match(sai.getSelectionAsVector(), sai.getActionAsVector(), sai.getInputAsVector(), sai.getActor(), vt);
        if (trace.getDebugCode("et")) {
            trace.outNT("et", "ExampleTracerLink.matchesSAI(" + sai + ") matcher " + m + " returns " + mResult);
        }
        return mResult;
    }

    boolean matchesSAIforHint(ExampleTracerSAI sai, ExampleTracerEvent result, VariableTable vt) {
        if (!this.getMatcher().matchForHint(sai.getSelectionAsVector(), sai.getActionAsVector(), sai.getActor(), vt)) {
            return false;
        }
        if (result != null && result.getWantReportableHints()) {
            int nStaticHints;
            EdgeData edgeData = this.getEdge();
            int n = nStaticHints = edgeData == null ? 0 : edgeData.getAllHints().size();
            if (nStaticHints < 1) {
                return false;
            }
        }
        return true;
    }

    boolean matchesType(String type) {
        return this.getType().equals(type);
    }

    public EdgeData getEdge() {
        return this.edge;
    }

    public int getID() {
        return this.getEdge().getEdge().getUniqueID();
    }

    public boolean isDoneLink() {
        return this.getEdge().isDone();
    }

    public static List<Integer> listLinkIDs(Collection<ExampleTracerLink> links) {
        if (links == null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(links.size());
        for (ExampleTracerLink link : links) {
            result.add(link.getID());
        }
        return result;
    }

    public static class LinkDepthComparator
    implements Comparator<ExampleTracerLink> {
        @Override
        public int compare(ExampleTracerLink arg0, ExampleTracerLink arg1) {
            return arg0.getDepth() - arg1.getDepth();
        }
    }
}

