/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.BrdFilter;
import edu.cmu.pact.BehaviorRecorder.Dialogs.DialogUtilities;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import pact.CommWidgets.StudentInterfaceWrapper;

public class SaveFileDialog {
    private File destDir;
    public static final String BRD_OTHER_DIR_KEY = "BRD File other location";
    private BR_Controller controller;
    private boolean cancelled;
    private String problemName;

    public static boolean doDialog(BR_Controller controller, String problemNameP) {
        String dirName = SaveFileDialog.getBrdDirectoryToSuggest(controller);
        File promptDir = new File(dirName);
        if (trace.getDebugCode("br")) {
            trace.out("br", "prompted folder for " + problemNameP + " = " + promptDir);
        }
        SaveFileDialog d = new SaveFileDialog(controller, problemNameP, promptDir);
        return d.doSaveFileOtherLocation();
    }

    public static String getBrdDirectoryToSuggest(BR_Controller controller) {
        String dirName = null;
        String fullName = controller.getProblemModel().getProblemFullName();
        if (fullName != null) {
            int sep = fullName.lastIndexOf(File.separatorChar);
            if (sep < 0) {
                sep = fullName.lastIndexOf(47);
            }
            if (sep > 0) {
                dirName = fullName.substring(0, sep);
            }
        }
        if (trace.getDebugCode("save")) {
            trace.out("save", "SFD.getBrdDirectoryToSuggest() fullName " + fullName + ", brdOther " + controller.getPreferencesModel().getStringValue(BRD_OTHER_DIR_KEY) + ", projs " + SaveFileDialog.getProjectsDirectory(controller));
        }
        if (dirName == null || dirName.length() < 1) {
            dirName = controller.getPreferencesModel().getStringValue(BRD_OTHER_DIR_KEY);
        }
        if (dirName == null || dirName.length() < 1) {
            dirName = SaveFileDialog.getProjectsDirectory(controller);
        }
        return dirName;
    }

    private SaveFileDialog(BR_Controller controller, String problemName, File destDir) {
        this.problemName = problemName;
        this.destDir = destDir;
        if (trace.getDebugCode("br")) {
            trace.out("br", "SaveFileDialog(" + problemName + "): destDir " + destDir.getPath());
        }
        this.controller = controller;
        if (!destDir.exists()) {
            destDir.mkdir();
        }
    }

    public static String getProjectsDirectory(BR_Controller controller) {
        String projectsStr = controller.getPreferencesModel().getStringValue("workspace");
        if (trace.getDebugCode("br")) {
            trace.out("br", "projectsStr[pref] = " + projectsStr);
        }
        if (projectsStr == null || projectsStr.length() < 1) {
            projectsStr = SaveFileDialog.getStudentInterfaceParentDir(controller);
            if (trace.getDebugCode("br")) {
                trace.out("br", "projectsStr[studentInterface] = " + projectsStr);
            }
        }
        if (projectsStr == null || projectsStr.length() < 1) {
            projectsStr = System.getProperty("user.dir");
            if (trace.getDebugCode("br")) {
                trace.out("br", "projectsStr[user.dir] = " + projectsStr);
            }
        }
        return projectsStr;
    }

    private static String getStudentInterfaceParentDir(BR_Controller controller) {
        StudentInterfaceWrapper studentInterface;
        URL studentInterfaceURL = null;
        String studentPanelURLstr = (String)controller.getProperties().getProperty("studentInterface.url");
        try {
            if (studentPanelURLstr != null && studentPanelURLstr.length() > 0) {
                studentInterfaceURL = new URL(studentPanelURLstr);
            }
        }
        catch (MalformedURLException mue) {
            trace.err("Bad URL in System property studentInterface.url: " + mue);
            studentInterfaceURL = null;
        }
        if (studentInterfaceURL == null && (studentInterface = controller.getStudentInterface()) != null) {
            studentInterfaceURL = studentInterface.getClass().getResource("/");
        }
        if (trace.getDebugCode("br")) {
            trace.out("SFD.getStudentInterfaceParentDir() studentInterfaceURL " + studentInterfaceURL);
        }
        if (studentInterfaceURL != null) {
            File studentInterfaceFile = Utils.getFileAsResource(studentInterfaceURL);
            if (trace.getDebugCode("br")) {
                trace.out("SFD.getStudentInterfaceParentDir() studentInterfaceFile = " + studentInterfaceFile);
            }
            if (studentInterfaceFile != null) {
                return studentInterfaceFile.getAbsolutePath();
            }
        }
        return null;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private boolean doSaveFileOtherLocation() {
        int ans;
        String problemFullName;
        File chosenFile = DialogUtilities.chooseFile(this.destDir.getPath(), this.problemName, (FileFilter)new BrdFilter(), "Please set the file name", "Save", this.controller);
        if (trace.getDebugCode("inter")) {
            trace.out("inter", "doSaveFileOtherLocation() chosenFile " + chosenFile);
        }
        if (chosenFile == null) {
            return false;
        }
        String chosenFileName = chosenFile.getName();
        String chosenDir = chosenFile.getParent();
        String problemName = chosenFileName;
        if (problemName.indexOf(47) != -1 || problemName.indexOf(92) != -1 || problemName.indexOf(42) != -1) {
            String newProblemName = problemName.replace('/', '_').replace('\\', '_').replace('*', '_');
            if (JOptionPane.showConfirmDialog(this.controller.getActiveWindow(), "The filename contains invalid characters.\nWould you like to use the name " + newProblemName + "?", "Invalid filename", 2) == 0) {
                problemName = newProblemName;
            } else {
                return false;
            }
        }
        if (!problemName.endsWith(".brd")) {
            problemName = problemName + ".brd";
        }
        if ((chosenFile = new File(problemFullName = chosenDir + File.separator + problemName)).exists() && (ans = JOptionPane.showConfirmDialog(this.controller.getActiveWindow(), "The file already exists. Overwrite?", "File exists", 2)) != 0) {
            return false;
        }
        this.controller.getProblemModel().setProblemName(problemName);
        this.controller.getProblemModel().setProblemFullName(problemFullName);
        this.controller.getProblemModel().setCourseName("");
        this.controller.getProblemModel().setUnitName("");
        this.controller.getProblemModel().setSectionName("");
        String filename = this.controller.getProblemStateWriter().saveBRDFile(this.controller.getProblemModel().getProblemFullName());
        if (!Utils.isRuntime()) {
            this.controller.getServer().getDockManager().refreshGraphTitle(this.controller.getTabNumber());
        }
        String prefDir = this.controller.getPreferencesModel().getStringValue(BRD_OTHER_DIR_KEY);
        if (chosenDir != null && !chosenDir.equals(prefDir)) {
            this.controller.getPreferencesModel().setStringValue(BRD_OTHER_DIR_KEY, chosenDir);
            this.controller.getPreferencesModel().saveToDisk();
        }
        return true;
    }

    public static String getBrdFileOtherLocation(BR_Controller controller) {
        String targetDir = controller.getPreferencesModel().getStringValue(BRD_OTHER_DIR_KEY);
        String interfaceHome = (String)controller.getProperties().getProperty("studentInterface.url");
        String projectsDir = SaveFileDialog.getProjectsDirectory(controller);
        if (targetDir != null && !new File(targetDir).isAbsolute()) {
            targetDir = new File(projectsDir, targetDir).getAbsolutePath();
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "SFD.getBrdFileOtherLocation: BRD_OTHER " + targetDir + ", INTERFACE_HOME " + interfaceHome + ", getProjectsDirectory() " + projectsDir);
        }
        if (targetDir == null || !new File(targetDir).isDirectory()) {
            targetDir = interfaceHome;
        }
        if (targetDir == null || !new File(targetDir).isDirectory()) {
            targetDir = projectsDir;
        }
        if (targetDir != null) {
            return targetDir;
        }
        String defaultDir = System.getProperty("user.dir");
        if (defaultDir == null) {
            defaultDir = System.getProperty("user.home");
        }
        if (targetDir == null) {
            targetDir = defaultDir;
        }
        return targetDir;
    }
}

