/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDirectoryEntry;
import edu.cmu.hcii.ctat.CTATProblemSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CTATDirectoryTXT
extends CTATBase {
    private ArrayList<CTATProblemSet> entries = null;
    private boolean loaded = false;
    private int setIndex = 0;

    public CTATDirectoryTXT() {
        this.setClassName("CTATDirectoryTXT");
        this.debug("CTATDirectoryTXT ()");
        this.entries = new ArrayList();
    }

    public ArrayList<CTATProblemSet> getEntries() {
        return this.entries;
    }

    public CTATProblemSet getNextEntry() {
        ++this.setIndex;
        if (this.setIndex < this.entries.size()) {
            return this.entries.get(this.setIndex);
        }
        return null;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public CTATProblemSet getProblemSet(String aProblemSet) {
        this.debug("getProblemSet (" + aProblemSet + ")");
        for (int i = 0; i < this.entries.size(); ++i) {
            CTATProblemSet entry = this.entries.get(i);
            if (!entry.getDirectory().equals(aProblemSet)) continue;
            return entry;
        }
        return null;
    }

    public boolean loadDirectoryTXT(String aFile) {
        this.debug("loadDirectoryTXT ()");
        if (aFile == null || aFile.equals("")) {
            return false;
        }
        Map<String, CTATDirectoryEntry> dirTxtMap = CTATDirectoryEntry.createMapFromFile(aFile);
        HashMap<String, CTATProblemSet> dirPSMap = new HashMap<String, CTATProblemSet>();
        File directory = new File(aFile).getParentFile();
        File[] subdirs = directory.listFiles();
        if (subdirs == null) {
            return false;
        }
        for (int i = 0; i < subdirs.length; ++i) {
            String[] contents;
            if (!subdirs[i].isDirectory()) continue;
            CTATDirectoryEntry dirTxtEntry = null;
            if (dirTxtMap != null && (dirTxtEntry = dirTxtMap.get(subdirs[i].getName())) == null || (contents = subdirs[i].list()) == null) continue;
            boolean isProblemSet = false;
            for (int j = 0; j < contents.length; ++j) {
                if (!contents[j].equals("problem_set.xml")) continue;
                isProblemSet = true;
                break;
            }
            if (!isProblemSet) continue;
            CTATProblemSet entry = new CTATProblemSet();
            if (!entry.loadProblemSet(subdirs[i].toString() + "/problem_set.xml")) {
                this.debug("Error loading problem set");
                return false;
            }
            this.debug("Problem set directory: " + subdirs[i].getName());
            if (dirTxtMap != null) {
                dirPSMap.put(subdirs[i].getName(), entry);
                continue;
            }
            this.entries.add(entry);
            this.loaded = true;
        }
        if (dirTxtMap != null) {
            this.orderEntriesAccordingToMap(dirTxtMap, dirPSMap);
        }
        return true;
    }

    private void orderEntriesAccordingToMap(Map<String, CTATDirectoryEntry> dirTxtMap, Map<String, CTATProblemSet> dirPSMap) {
        for (CTATDirectoryEntry dirEntry : dirTxtMap.values()) {
            CTATProblemSet entry = dirPSMap.get(dirEntry.getDirectory());
            if (entry == null) continue;
            if (dirEntry.getName() != null && dirEntry.getName().length() > 0) {
                entry.setName(dirEntry.getName());
            }
            if (dirEntry.getDescription() != null && dirEntry.getDescription().length() > 0) {
                entry.setDescription(dirEntry.getDescription());
            }
            this.entries.add(entry);
            this.loaded = true;
        }
    }
}

