/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATDesktopFileManager;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATURLFetch;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;

public class CTATDataShop
extends CTATBase {
    private static Date lastUpload = null;

    public CTATDataShop() {
        this.setClassName("CTATDataShop");
        this.debug("CTATDataShop ()");
    }

    public boolean migrateData() {
        this.debug("migratedata ()");
        lastUpload = new Date();
        String datashopData = "";
        CTATDesktopFileManager fileManager = new CTATDesktopFileManager();
        if (!fileManager.doesFileExist(CTATLink.datashopFile)) {
            this.debug("Log file does not exist, skipping task ...");
            return false;
        }
        datashopData = fileManager.getContents(CTATLink.datashopFile);
        String[] split = datashopData.split("\\n");
        for (int i = 0; i < split.length; ++i) {
            this.debug("Sending: " + split[i]);
            CTATURLFetch dataShopStream = new CTATURLFetch();
            try {
                dataShopStream.sendData(CTATLink.datashopURL, split[i]);
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        fileManager.setContents(CTATLink.datashopFile, "");
        return true;
    }

    public static Date getLastUploadTime() {
        if (lastUpload != null) {
            return (Date)lastUpload.clone();
        }
        return null;
    }
}

