/*
 * Decompiled with CFR 0.152.
 */
package pact.EconGraph;

import java.awt.Color;
import java.util.Vector;
import pact.EconGraph.PointListener;

public class Point {
    public int x;
    public int y;
    public boolean moveable;
    public boolean isCorrect;
    public boolean useTemp = false;
    public Color color;
    public Color tempColor;
    String lineName;
    int pointNum;
    static Vector pointListeners = new Vector();
    int startX;
    int startY;
    public boolean hasBeenMoved = false;

    Point(int xv, int yv, boolean move, Color tcolor, String lineName, int pointNum) {
        this.x = xv;
        this.y = yv;
        this.startX = this.x;
        this.startY = this.y;
        this.moveable = move;
        this.color = tcolor;
        this.lineName = lineName;
        this.pointNum = pointNum;
    }

    public void setName(String newName) {
        this.lineName = newName;
    }

    public String getName() {
        return this.lineName;
    }

    Point(int xv, int yv, boolean move, Color tcolor) {
        this(xv, yv, move, tcolor, "no name", -1);
    }

    Point(int x, int y, String lineName, int lineNum) {
        this(x, y, false, Color.black, lineName, lineNum);
    }

    public Point(int xv, int yv) {
        this(xv, yv, false, Color.black);
    }

    public static void addPointListener(PointListener p) {
        pointListeners.addElement(p);
    }

    public void move(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.hasBeenMoved = true;
    }

    public boolean useTempColor() {
        return this.useTemp;
    }

    public void reset() {
        this.x = this.startX;
        this.y = this.startY;
    }

    public void saveResetState() {
        this.startX = this.x;
        this.startY = this.y;
    }

    public void updateListeners() {
        for (int i = 0; i < pointListeners.size(); ++i) {
            PointListener p = (PointListener)pointListeners.elementAt(i);
            p.updatePointListener(this.lineName, this.pointNum, this.x, this.y);
        }
    }

    public void setx(int x) {
        this.x = x;
    }

    public void sety(int y) {
        this.y = y;
    }

    int getx() {
        return this.x;
    }

    int gety() {
        return this.y;
    }

    void setMoveable(boolean move) {
        this.moveable = move;
    }

    boolean getMoveable() {
        return this.moveable;
    }

    public void setColor(Color tcolor) {
        this.color = tcolor;
    }

    public void setTempColor(Color tempC) {
        this.tempColor = tempC;
    }

    Color getColor() {
        return this.color;
    }

    public boolean isGreen() {
        return this.isCorrect;
    }

    String showLabel() {
        return "(" + this.x + "," + this.y + ")";
    }

    public String toString() {
        String s = "[pt]" + (this.moveable ? "M" : "s");
        return s + "(" + this.x + "," + this.y + ")";
    }
}

