/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets.InputMethodFramework;

import java.text.AttributedCharacterIterator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class CompositeIterator
implements AttributedCharacterIterator {
    AttributedCharacterIterator iterator1;
    AttributedCharacterIterator iterator2;
    int begin1;
    int end1;
    int begin2;
    int end2;
    int endIndex;
    int currentIndex;
    AttributedCharacterIterator currentIterator;
    int currentIteratorDelta;

    CompositeIterator(AttributedCharacterIterator iterator1, AttributedCharacterIterator iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.begin1 = iterator1.getBeginIndex();
        this.end1 = iterator1.getEndIndex();
        this.begin2 = iterator2.getBeginIndex();
        this.end2 = iterator2.getEndIndex();
        this.endIndex = this.end1 - this.begin1 + (this.end2 - this.begin2);
        this.internalSetIndex(0);
    }

    @Override
    public char first() {
        return this.internalSetIndex(0);
    }

    @Override
    public char last() {
        if (this.endIndex == 0) {
            return this.internalSetIndex(this.endIndex);
        }
        return this.internalSetIndex(this.endIndex - 1);
    }

    @Override
    public char next() {
        if (this.currentIndex < this.endIndex) {
            return this.internalSetIndex(this.currentIndex + 1);
        }
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this.currentIndex > 0) {
            return this.internalSetIndex(this.currentIndex - 1);
        }
        return '\uffff';
    }

    @Override
    public char current() {
        return this.currentIterator.setIndex(this.currentIndex + this.currentIteratorDelta);
    }

    @Override
    public char setIndex(int position) {
        if (position < 0 || position > this.endIndex) {
            throw new IllegalArgumentException("invalid index");
        }
        return this.internalSetIndex(position);
    }

    private char internalSetIndex(int position) {
        this.currentIndex = position;
        if (this.currentIndex < this.end1 - this.begin1) {
            this.currentIterator = this.iterator1;
            this.currentIteratorDelta = this.begin1;
        } else {
            this.currentIterator = this.iterator2;
            this.currentIteratorDelta = this.begin2 - (this.end1 - this.begin1);
        }
        return this.currentIterator.setIndex(this.currentIndex + this.currentIteratorDelta);
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.endIndex;
    }

    @Override
    public int getIndex() {
        return this.currentIndex;
    }

    @Override
    public int getRunStart() {
        return this.currentIterator.getRunStart() - this.currentIteratorDelta;
    }

    @Override
    public int getRunLimit() {
        return this.currentIterator.getRunLimit() - this.currentIteratorDelta;
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        return this.currentIterator.getRunStart(attribute) - this.currentIteratorDelta;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        return this.currentIterator.getRunLimit(attribute) - this.currentIteratorDelta;
    }

    public int getRunStart(Set attributes) {
        return this.currentIterator.getRunStart(attributes) - this.currentIteratorDelta;
    }

    public int getRunLimit(Set attributes) {
        return this.currentIterator.getRunLimit(attributes) - this.currentIteratorDelta;
    }

    public Map getAttributes() {
        return this.currentIterator.getAttributes();
    }

    public Set getAllAttributeKeys() {
        HashSet<AttributedCharacterIterator.Attribute> keys = new HashSet<AttributedCharacterIterator.Attribute>(this.iterator1.getAllAttributeKeys());
        keys.addAll(this.iterator2.getAllAttributeKeys());
        return keys;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.currentIterator.getAttribute(attribute);
    }

    @Override
    public Object clone() {
        try {
            CompositeIterator other = (CompositeIterator)super.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

