/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra.expression;

import edu.cmu.pact.miss.userDef.algebra.expression.AlgExp;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.ComplexTerm;
import edu.cmu.pact.miss.userDef.algebra.expression.Constant;
import edu.cmu.pact.miss.userDef.algebra.expression.ConstantFraction;
import edu.cmu.pact.miss.userDef.algebra.expression.DoubleConst;
import edu.cmu.pact.miss.userDef.algebra.expression.ExpParseException;
import edu.cmu.pact.miss.userDef.algebra.expression.IntConst;
import edu.cmu.pact.miss.userDef.algebra.expression.Polynomial;
import edu.cmu.pact.miss.userDef.algebra.expression.Variable;
import java.util.HashSet;
import java.util.Set;

public class SimpleTerm
extends AlgExp {
    protected Constant constant;
    protected Variable variable;

    public SimpleTerm(AlgExp constant, AlgExp variable) {
        this((Constant)constant, (Variable)variable);
    }

    public SimpleTerm(Constant c, Variable v) {
        this.variable = v;
        this.constant = c;
        this.isTerm = true;
        this.isSimpleTerm = true;
        this.hasVariable = true;
        this.isSimple = true;
        this.isMonomial = true;
        this.isNegative = c.isNegative();
        this.isFraction = c.isFraction();
    }

    public Constant getConstant() {
        return this.constant;
    }

    public Variable getVariable() {
        return this.variable;
    }

    @Override
    public AlgExp add(IntConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(DoubleConst c) {
        return new Polynomial(this, c);
    }

    @Override
    public AlgExp add(Variable v) {
        if (v.equals(this.variable)) {
            AlgExp newCoe = this.constant.add(AlgExp.ONE);
            if (newCoe.equals(AlgExp.ZERO)) {
                return AlgExp.ZERO;
            }
            if (newCoe.equals(AlgExp.ONE)) {
                return new Variable(v.getName());
            }
            return new SimpleTerm(newCoe, (AlgExp)v);
        }
        return new Polynomial(this, v);
    }

    @Override
    public AlgExp add(ConstantFraction f) {
        return new Polynomial(this, f);
    }

    @Override
    public AlgExp add(SimpleTerm t) {
        if (t.getVariable().equals(this.variable)) {
            AlgExp newCoe = this.constant.add(t.getConstant());
            if (newCoe.equals(AlgExp.ZERO)) {
                return AlgExp.ZERO;
            }
            if (newCoe.equals(AlgExp.ONE)) {
                return new Variable(this.variable.getName());
            }
            return new SimpleTerm(newCoe, (AlgExp)this.variable);
        }
        return new Polynomial(this, t);
    }

    @Override
    public AlgExp mul(IntConst c) {
        AlgExp result = c.mul(this.constant);
        if (result.equals(AlgExp.ZERO)) {
            return ZERO;
        }
        if (result.equals(AlgExp.ONE)) {
            return new Variable(this.variable.getName());
        }
        return new SimpleTerm(result, (AlgExp)this.variable);
    }

    @Override
    public AlgExp mul(Variable v) {
        return new ComplexTerm(this, v);
    }

    @Override
    public AlgExp mul(ConstantFraction f) {
        AlgExp result = f.mul(this.constant);
        if (result.equals(AlgExp.ZERO)) {
            return ZERO;
        }
        if (result.equals(AlgExp.ONE)) {
            return new Variable(this.variable.getName());
        }
        return new SimpleTerm(result, (AlgExp)this.variable);
    }

    @Override
    public AlgExp mul(SimpleTerm t) {
        AlgExp constantResult = t.mul(this.constant);
        if (constantResult.equals(AlgExp.ZERO)) {
            return ZERO;
        }
        if (constantResult.equals(AlgExp.ONE)) {
            return new Variable(this.variable.getName());
        }
        return new ComplexTerm(this.constant.mul(t.getConstant()), this.variable.mul(t.getVariable()));
    }

    @Override
    public AlgExp div(IntConst c) {
        AlgExp constantResult = this.constant.div(c);
        if (constantResult.equals(AlgExp.ZERO)) {
            return ZERO;
        }
        if (constantResult.equals(AlgExp.ONE)) {
            return new Variable(this.variable.getName());
        }
        return new SimpleTerm(this.constant.div(c), (AlgExp)this.variable);
    }

    @Override
    public AlgExp div(DoubleConst c) {
        AlgExp constantResult = this.constant.div(c);
        if (constantResult.equals(AlgExp.ZERO)) {
            return ZERO;
        }
        if (constantResult.equals(AlgExp.ONE)) {
            return new Variable(this.variable.getName());
        }
        return new SimpleTerm(this.constant.div(c), (AlgExp)this.variable);
    }

    @Override
    public AlgExp div(Variable v) {
        if (this.variable.equals(v)) {
            try {
                return SimpleTerm.parseExp(this.constant.toString());
            }
            catch (ExpParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.constant.mul(v.mul(this.variable));
    }

    @Override
    public AlgExp div(ConstantFraction f) {
        return this.mul(f.invert());
    }

    @Override
    public AlgExp div(SimpleTerm t) {
        if (this.equals(t)) {
            return AlgExp.ONE;
        }
        if (t.getVariable().equals(this.variable)) {
            return this.constant.div(t.getConstant());
        }
        return this.constant.div(t.getConstant()).mul(new ComplexFraction(this.variable, t.getVariable()));
    }

    @Override
    public AlgExp add(Polynomial e) {
        return e.add(this);
    }

    @Override
    public AlgExp add(ComplexTerm ct) {
        return ct.add(this);
    }

    @Override
    public AlgExp mul(Polynomial e) {
        return e.mul(this);
    }

    @Override
    public AlgExp mul(ComplexTerm ct) {
        return ct.mul(this);
    }

    @Override
    public AlgExp div(Polynomial e) {
        return this.mul(e.invert());
    }

    @Override
    public AlgExp div(ComplexTerm ct) {
        return this.mul(ct.invert());
    }

    @Override
    public AlgExp add(ComplexFraction cf) {
        return cf.add(this);
    }

    @Override
    public AlgExp mul(ComplexFraction cf) {
        return cf.mul(this);
    }

    @Override
    public AlgExp div(ComplexFraction cf) {
        return this.mul(cf.invert());
    }

    @Override
    public AlgExp invert() {
        return new ComplexFraction(AlgExp.ONE, this);
    }

    @Override
    public boolean equals(SimpleTerm t) {
        return t.getConstant().equals(this.constant) && t.getVariable().equals(this.variable);
    }

    @Override
    public boolean equals(Variable v) {
        return this.variable.equals(v) && this.constant.equals(AlgExp.ONE);
    }

    public String toString() {
        if (this.constant.equals(AlgExp.NEGONE)) {
            return "-" + this.variable;
        }
        if (this.constant.isFraction()) {
            ConstantFraction f = (ConstantFraction)this.constant;
            if (f.getNumerator().equals(AlgExp.ONE)) {
                if (f.getDenominator().isNegative()) {
                    return "-" + this.variable + "/" + f.getDenominator().negate();
                }
                return this.variable + "/" + f.getDenominator();
            }
            if (f.getNumerator().equals(AlgExp.NEGONE)) {
                return "-" + this.variable + "/" + f.getDenominator();
            }
        }
        return this.constant.toString().concat(this.variable.toString());
    }

    @Override
    public boolean equals(IntConst c) {
        return c.equals(AlgExp.ZERO) && this.constant.equals(AlgExp.ZERO);
    }

    @Override
    public boolean equals(ConstantFraction f) {
        return false;
    }

    @Override
    public boolean equals(Polynomial e) {
        return e.equals(this);
    }

    @Override
    public boolean equals(ComplexTerm ct) {
        return ct.equals(this);
    }

    @Override
    public boolean equals(ComplexFraction cf) {
        return cf.equals(this);
    }

    @Override
    public AlgExp mul(DoubleConst c) {
        return new SimpleTerm(this.constant.mul(c), (AlgExp)this.variable);
    }

    @Override
    public boolean equals(DoubleConst c) {
        return false;
    }

    @Override
    public AlgExp eval() {
        if (this.constant.isFraction) {
            int i;
            double d2;
            AlgExp newCoe = this.constant.eval();
            double d1 = this.getConstant().getVal();
            if (d1 == (d2 = (double)(i = (int)d1))) {
                if (d1 == 1.0) {
                    return new Variable(this.variable.getName());
                }
                return new SimpleTerm(new IntConst(d1), this.variable);
            }
            if (!newCoe.toString().equals(this.constant)) {
                if (newCoe.equals(AlgExp.ONE)) {
                    return new Variable(this.variable.getName());
                }
                return new SimpleTerm(newCoe, (AlgExp)this.variable);
            }
        }
        return this;
    }

    @Override
    public boolean hasVariable(String varName) {
        return this.variable.getName().equalsIgnoreCase(varName);
    }

    @Override
    public Set getAllVars() {
        HashSet<String> var = new HashSet<String>();
        var.add(this.variable.getName());
        return var;
    }

    @Override
    public AlgExp divDecimal(IntConst c) {
        new Exception().printStackTrace();
        return null;
    }
}

