/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStEdge;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStProblemGraph;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class SimStNode
extends ProblemNode {
    private SimStNode prevNode;
    private SimStNode nextNode;
    private int outDegree;
    private String name;
    private boolean doneState = false;
    private SimStProblemGraph problemGraph;
    private List<SimStNode> children;

    public SimStNode(String name, SimStProblemGraph graph) {
        this.name = name;
        this.problemGraph = graph;
        this.outDegree = 0;
        this.setPrevNode(null);
        this.setNextNode(null);
    }

    @Override
    public int getInDegree() {
        return this.getIncomingEdges().size();
    }

    @Override
    public ProblemEdge isChildNode(ProblemNode node) {
        List<ProblemEdge> outgoingEdges = this.getOutgoingEdges();
        for (int i = 0; i < outgoingEdges.size(); ++i) {
            SimStEdge ssEdge = (SimStEdge)outgoingEdges.get(i);
            if (!node.equals(ssEdge.getDest())) continue;
            return ssEdge;
        }
        return null;
    }

    @Override
    public Vector<ProblemNode> getChildren() {
        Vector<ProblemNode> children = new Vector<ProblemNode>();
        List<ProblemEdge> outgoingEdges = this.getOutgoingEdges();
        for (SimStEdge simStEdge : outgoingEdges) {
            children.add(simStEdge.getDest());
        }
        return children;
    }

    @Override
    public Vector getParents() {
        Vector<SimStNode> vec = new Vector<SimStNode>();
        Enumeration<SimStNode> parents = this.getProblemGraph().parents(this);
        while (parents.hasMoreElements()) {
            SimStNode ssNode = parents.nextElement();
            vec.add(ssNode);
        }
        return vec;
    }

    @Override
    public List<ProblemEdge> getOutgoingEdges() {
        ArrayList<ProblemEdge> list = new ArrayList<ProblemEdge>();
        Enumeration<SimStEdge> iterEdges = this.getProblemGraph().getOutgoingEdges(this);
        while (iterEdges.hasMoreElements()) {
            SimStEdge edge = iterEdges.nextElement();
            list.add(edge);
        }
        return list;
    }

    public List getIncomingEdges() {
        ArrayList<SimStEdge> list = new ArrayList<SimStEdge>();
        Enumeration<SimStEdge> iterEdges = this.getProblemGraph().getIncomingEdges(this);
        while (iterEdges.hasMoreElements()) {
            SimStEdge edge = iterEdges.nextElement();
            list.add(edge);
        }
        return list;
    }

    @Override
    public boolean isLeaf() {
        return this.getProblemGraph().isLeaf(this);
    }

    public Vector<ProblemEdge> findSolutionPath() {
        return this.findSolutionPath(new String[2]);
    }

    public Vector<ProblemEdge> findSolutionPath(String[] equation) {
        if (this.isLeaf()) {
            return new Vector<ProblemEdge>();
        }
        List<ProblemEdge> outEdges = this.getOutgoingEdges();
        ProblemEdge backupWrongAnswer = null;
        for (ProblemEdge edge : outEdges) {
            if (edge.isCorrect()) {
                SimStNode child;
                Vector<ProblemEdge> path;
                String selection = (String)edge.getEdgeData().getSelection().get(0);
                String input = (String)edge.getEdgeData().getAction().get(0);
                if (selection.equalsIgnoreCase("DONE")) {
                    Vector<ProblemEdge> path2 = new Vector<ProblemEdge>();
                    path2.add(0, edge);
                    return path2;
                }
                if (selection.contains("dorminTable")) {
                    int idx = selection.indexOf("_") - 1;
                    char c = selection.charAt(idx);
                    int col = c - 49 + 1;
                    switch (col) {
                        case 1: {
                            equation[0] = input;
                            break;
                        }
                        case 2: {
                            equation[1] = input;
                            break;
                        }
                        case 3: {
                            equation[1] = null;
                            equation[0] = null;
                        }
                    }
                }
                if ((path = (child = (SimStNode)edge.getDest()).findSolutionPath(equation)) != null) {
                    path.add(0, edge);
                    return path;
                }
                path = new Vector();
                path.add(0, edge);
                return path;
            }
            if (edge.getEdgeData().getInput().get(0).toString().equalsIgnoreCase("FALSE")) continue;
            if (backupWrongAnswer != null) {
                if (!backupWrongAnswer.getDest().isLeaf() || edge.getDest().isLeaf()) continue;
                backupWrongAnswer = edge;
                continue;
            }
            backupWrongAnswer = edge;
        }
        if (backupWrongAnswer != null) {
            SimStNode child = (SimStNode)backupWrongAnswer.getDest();
            Vector<ProblemEdge> path = child.findSolutionPath(equation);
            if (path != null) {
                path.add(0, backupWrongAnswer);
                return path;
            }
            path = new Vector();
            path.add(0, backupWrongAnswer);
            return path;
        }
        return null;
    }

    public Vector findPathToNode(SimStNode ssNode) {
        SimStNode endNode = ssNode;
        Vector pathEdges = new Vector();
        return this.findPathDepthFirst(this.getProblemGraph().getStartNode(), endNode);
    }

    private Vector findPathDepthFirst(ProblemNode startNode, ProblemNode endNode) {
        if (startNode == endNode) {
            return null;
        }
        SimStEdge edge = null;
        edge = (SimStEdge)startNode.isChildNode(endNode);
        if (edge != null) {
            Vector<SimStEdge> path = new Vector<SimStEdge>();
            path.add(0, edge);
            return path;
        }
        Vector<ProblemNode> children = startNode.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        for (int i = 0; i < children.size(); ++i) {
            SimStNode childNode = (SimStNode)children.elementAt(i);
            Vector path = this.findPathDepthFirst(childNode, endNode);
            if (path == null) continue;
            path.add(0, startNode.isChildNode(childNode));
            return path;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public SimStNode getPrevNode() {
        return this.prevNode;
    }

    public void setPrevNode(SimStNode prevNode) {
        this.prevNode = prevNode;
    }

    @Override
    public SimStNode getNextNode() {
        return this.nextNode;
    }

    public void setNextNode(SimStNode nextNode) {
        this.nextNode = nextNode;
    }

    @Override
    public int getOutDegree() {
        return this.outDegree;
    }

    public void setOutDegree(int outDegree) {
        this.outDegree = outDegree;
    }

    @Override
    public boolean isDoneState() {
        return this.doneState;
    }

    @Override
    public void setDoneState(boolean doneState) {
        this.doneState = doneState;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public SimStProblemGraph getProblemGraph() {
        return this.problemGraph;
    }
}

