/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class ProblemNameParser {
    private HashMap<String, ProblemBundle> map;
    private BufferedReader fr;
    private String brdLocation;

    public ProblemNameParser(String fileName, String brdLoc) {
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "ProblemNameParser(" + fileName + ", " + brdLoc + ")");
        }
        String string = this.brdLocation = brdLoc.endsWith("/") ? brdLoc.substring(0, brdLoc.length() - 1) : brdLoc;
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "ProblemNameParser initialization: " + this.brdLocation);
        }
        this.map = this.parseNames(fileName);
    }

    private HashMap<String, ProblemBundle> parseNames(String fileName) {
        HashMap<String, ProblemBundle> problemInfo = new HashMap<String, ProblemBundle>();
        try {
            this.fr = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            trace.err("Could not open name parser file " + fileName + ": " + e + ", cause: " + e.getCause());
        }
        int name = 0;
        int set = 0;
        int assignment = 0;
        int brd = 0;
        int swf = 0;
        try {
            String keyRow = this.fr.readLine();
            if (keyRow != null) {
                String row;
                String[] header = keyRow.split("\t");
                for (int i = 0; i < header.length; ++i) {
                    if (header[i].compareToIgnoreCase("Problem Name") == 0) {
                        name = i;
                        continue;
                    }
                    if (header[i].compareToIgnoreCase("Level (Assignment)") == 0) {
                        assignment = i;
                        continue;
                    }
                    if (header[i].compareToIgnoreCase("Level (ProblemSet)") == 0) {
                        set = i;
                        continue;
                    }
                    if (header[i].compareToIgnoreCase("BRD") == 0) {
                        brd = i;
                        continue;
                    }
                    if (header[i].compareToIgnoreCase("SWF") != 0) continue;
                    swf = i;
                }
                while ((row = this.fr.readLine()) != null) {
                    String[] values = row.split("\t");
                    String key = ProblemNameParser.makeKey(values[name], values[assignment], values[set]);
                    ProblemBundle value = new ProblemBundle(values[brd], values[swf], this.brdLocation);
                    if (trace.getDebugCode("replaybatch")) {
                        trace.out("replaybatch", String.format("PNP.parseNames %45s => %s", key, value));
                    }
                    problemInfo.put(key, value);
                }
            }
            this.fr.close();
        }
        catch (IOException e) {
            trace.err("parsefile opened, could not read: " + e + ", cause: " + e.getCause());
        }
        if (trace.getDebugCode("replay")) {
            trace.out("replay", "PNP.parseNames() keySet: " + problemInfo.keySet());
        }
        return problemInfo;
    }

    public static String makeKey(String probName, String probAssi, String probSet) {
        return probAssi + "|" + probSet + "|" + probName;
    }

    public ProblemBundle findBundle(String probName, String probAssi, String probSet) {
        return this.map.get(ProblemNameParser.makeKey(probName, probAssi, probSet));
    }

    public int size() {
        return this.map.size();
    }

    public class ProblemBundle {
        private String brdName;
        private String swfName;

        public ProblemBundle(String brd, String swf, String brdLoc) {
            this.brdName = brdLoc.replace("/", File.separator).replace("\\", File.separator) + File.separator + brd.replace("/", File.separator).replace("\\", File.separator);
            this.swfName = swf.replace("/", File.separator).replace("\\", File.separator);
        }

        public String toString() {
            return this.brdName + ", " + this.swfName;
        }

        public String getBRD() {
            return this.brdName;
        }

        public String getSWF() {
            return this.swfName;
        }
    }
}

