/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.JavascriptBridge;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.JavascriptBridge.JSToolProxy;
import edu.cmu.pact.SocketProxy.ActionHandler;
import edu.cmu.pact.SocketProxy.LogServlet;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import pact.CommWidgets.RemoteProxy;
import pact.CommWidgets.UniversalToolProxy;

public class JSProxy
implements RemoteProxy {
    private BR_Controller controller;
    private JSToolProxy tp;
    private ActionHandler actionHandler;
    private LogServlet logServlet = null;

    public JSProxy(BR_Controller controller) {
        this.controller = controller;
        this.tp = new JSToolProxy(controller);
    }

    public void receiveMessageFromInterface(String msg) {
        if (trace.getDebugCode("applet")) {
            trace.outNT("applet", "Received: " + msg);
        }
        if (LogServlet.handleLogRecord(msg, this.logServlet, null)) {
            return;
        }
        MessageObject mo = MessageObject.parse(msg);
        if (this.logServlet == null && "SetPreferences".equalsIgnoreCase(mo.getMessageType())) {
            this.setupLogServlet(mo);
        }
        this.actionHandler.enqueue(mo);
    }

    @Override
    public void start() {
        this.actionHandler = new ActionHandler(this.controller);
        new Thread(this.actionHandler).start();
    }

    @Override
    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    @Override
    public UniversalToolProxy getToolProxy() {
        return this.tp;
    }

    @Override
    public void setupLogServlet(MessageObject setPrefsMsg) {
        this.logServlet = new LogServlet(this.controller.getPreferencesModel(), setPrefsMsg, false, null);
        TSLauncherServer ls = this.controller.getLauncher().getLauncherServer();
        if (ls != null) {
            this.logServlet.setLogInfo(ls.getLogInfo(null));
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "SocketProxy.setLogServlet(" + this.logServlet + ")");
        }
        new Thread(this.logServlet).start();
    }

    public void quitActionHandler() {
        this.actionHandler.enqueue(MessageObject.makeQuitMessage());
    }

    @Override
    public void extCloseConnection(boolean preserveSession) {
    }
}

