/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProblemRuleParser
extends DefaultHandler {
    private String currentElement;
    private String currentElementData;
    private String tempRuleName;
    private String tempProductionSet;
    private RuleProduction currentProduction;
    private HashMap<String, String> vars;
    private Vector<RuleProduction> problemRules;

    public ProblemRuleParser(Vector<RuleProduction> problemRules) {
        this.problemRules = problemRules;
    }

    @Override
    public void startDocument() {
        this.currentElement = null;
        this.currentProduction = null;
        this.tempProductionSet = null;
        this.tempRuleName = null;
        this.vars = new HashMap();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("stateGraph")) {
            this.currentElement = "stateGraph";
            String version = attributes.getValue("version");
            if (!(version == null || version.equals("0.5") || version.equals("1.0") || version.equals("2.1"))) {
                throw new SAXException("Unrecognized CTAT problem file version number");
            }
        } else if (qName.equals("productionRule")) {
            this.currentElement = "productionRule";
        } else if (qName.equals("text")) {
            if (this.currentElement.equals("productionRule")) {
                this.currentElement = "productionRuleText";
                this.currentElementData = new String();
            }
        } else if (qName.equals("hintMessage")) {
            if (this.currentElement.equals("productionRule")) {
                this.currentElement = "productionRuleHintMessage";
                this.currentElementData = new String();
            }
        } else if (this.currentElement.equals("productionRule") && (qName.equals("ruleName") || qName.equals("productionSet"))) {
            this.currentElement = new String(qName);
            this.currentElementData = new String();
        }
    }

    private String insertVars(String str) {
        Pattern varPattern = Pattern.compile("%([^ ]*?)%");
        Matcher varMatcher = varPattern.matcher(str);
        while (varMatcher.find()) {
            String value = null;
            if (varMatcher.group(1) != null) {
                value = this.vars.get(varMatcher.group(1));
            }
            if (value == null) continue;
            str = varMatcher.replaceFirst(value);
            varMatcher = varPattern.matcher(str);
        }
        return str;
    }

    @Override
    public void endElement(String namespaceUri, String localName, String qName) {
        if (this.currentElement.equals("ruleName")) {
            this.tempRuleName = this.insertVars(this.currentElementData);
            if (this.tempProductionSet != null) {
                this.currentProduction = new RuleProduction(this.tempRuleName, this.tempProductionSet);
            }
            this.currentElement = "productionRule";
        } else if (this.currentElement.equals("productionSet")) {
            this.tempProductionSet = this.insertVars(this.currentElementData);
            if (this.tempRuleName != null) {
                this.currentProduction = new RuleProduction(this.tempRuleName, this.tempProductionSet);
            }
            this.currentElement = "productionRule";
        } else if (this.currentElement.equals("productionRuleHintMessage") && this.currentProduction != null) {
            this.currentProduction.addHintItem(this.currentElementData);
            this.currentElement = "productionRule";
        } else if (this.currentElement.equals("productionRuleText") && this.currentProduction != null) {
            this.currentProduction.setProductionRule(this.insertVars(this.currentElementData));
            this.currentElement = "productionRule";
        } else if (this.currentElement.equals("productionRule") && this.currentProduction != null) {
            if (!this.tempRuleName.equals("unnamed") || !this.tempProductionSet.equals("rule")) {
                this.problemRules.add(this.currentProduction);
            }
            this.currentProduction = null;
        }
        this.currentElementData = new String();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.currentElementData != null) {
            this.currentElementData = this.currentElementData + new String(ch, start, length);
        }
    }
}

