/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATProblem;
import edu.cmu.hcii.ctat.CTATProblemSet;
import edu.cmu.hcii.ctat.CTATUserData;
import edu.cmu.hcii.ctat.PositionWithinAssignment;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;

public abstract class CTATObjectTagDriver
extends CTATBase {
    private String sessionID = "undefined";
    private Boolean includeMenu = false;
    private Boolean SCORMCompliant = false;

    public CTATObjectTagDriver() {
        this.setClassName("CTATObjectTagDriver");
        this.debug("CTATObjectTagDriver ()");
        UUID uuid = UUID.randomUUID();
        this.sessionID = uuid.toString();
    }

    public void setSCORMCompliant(Boolean aValue) {
        this.SCORMCompliant = aValue;
    }

    public Boolean getSCORMCompliant() {
        return this.SCORMCompliant;
    }

    public void setIncludeMenu(Boolean aValue) {
        this.includeMenu = aValue;
    }

    public Boolean getIncludeMenu() {
        return this.includeMenu;
    }

    public void setSessionID(String anID) {
        this.sessionID = anID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String generateFlashVars(CTATProblem aProblem, CTATProblemSet aSet) {
        this.debug("generateFlashVars (" + CTATLink.allowWriting + ")");
        return this.generateFlashVars(aProblem, aSet, false);
    }

    public String generateFlashVars(String aSWF, String aBRD) {
        this.debug("generateFlashVars (String aSWF,String aBRD)");
        StringBuffer flashvars = new StringBuffer();
        flashvars.append("BehaviorRecorderMode=AuthorTimeTutoring&");
        if (!CTATLink.allowWriting) {
            flashvars.append("Logging=None&");
        } else {
            flashvars.append("Logging=ClientToService&");
        }
        flashvars.append("SessionLog=true&");
        flashvars.append("log_service_url_group=TutorShopUSB&");
        flashvars.append("log_service_url=" + CTATLink.datashopURL + "&");
        flashvars.append("user_guid=" + CTATLink.userID + "&");
        if (this.getSessionID().equals("undefined")) {
            UUID uuid = UUID.randomUUID();
            this.setSessionID(uuid.toString());
        }
        flashvars.append("session_id=" + this.getSessionID() + "&");
        flashvars.append("source_id=PACT_CTAT_FLASH&");
        flashvars.append("TutorShopDeliveryMethod=sendandload&");
        flashvars.append("lcId=" + System.currentTimeMillis() + "&");
        flashvars.append("remoteSocketURL=" + CTATLink.hostName + "&");
        flashvars.append("remoteSocketPort=" + CTATLink.tsPort + "&");
        flashvars.append("dataset_name=" + CTATLink.datasetName + "&");
        flashvars.append("dataset_level_type1=ProblemSet&");
        flashvars.append("dataset_level_name1=ProblemSet&");
        flashvars.append("problem_name=" + aBRD.replaceAll("[.][bB][rR][dD]$", "") + "&");
        flashvars.append("question_file=" + aBRD + "&");
        flashvars.append("reuse_swf=true&");
        flashvars.append("target_frame=_self&");
        flashvars.append("student_interface=" + aSWF + "&");
        if (this.getSCORMCompliant().booleanValue()) {
            flashvars.append("scorm_enabled=true&");
            flashvars.append("curriculum_service_url=http://127.0.0.1/dummy/tutorshop&");
        }
        return flashvars.toString();
    }

    public String generateFlashVars(CTATProblem aProblem, CTATProblemSet aSet, boolean isLastProblem) {
        this.debug("generateFlashVars (CTATProblem aProblem,CTATProblemSet aSet,boolean isLastProblem)");
        StringBuffer flashvars = new StringBuffer();
        flashvars.append("BehaviorRecorderMode=AuthorTimeTutoring&");
        if (!CTATLink.allowWriting) {
            flashvars.append("Logging=None&");
        } else {
            flashvars.append("Logging=ClientToService&");
        }
        flashvars.append("SessionLog=true&");
        flashvars.append("log_service_url_group=TutorShopUSB&");
        flashvars.append("log_service_url=" + CTATLink.datashopURL + "&");
        flashvars.append("user_guid=" + CTATLink.userID + "&");
        if (this.getSessionID().equals("undefined")) {
            UUID uuid = UUID.randomUUID();
            this.setSessionID(uuid.toString());
        }
        flashvars.append("session_id=" + this.getSessionID() + "&");
        flashvars.append("source_id=PACT_CTAT_FLASH&");
        flashvars.append("TutorShopDeliveryMethod=sendandload&");
        flashvars.append("lcId=" + System.currentTimeMillis() + "&");
        if (this.getIncludeMenu().booleanValue()) {
            flashvars.append("info=" + aSet.buildMenuHTML() + "&");
        }
        flashvars.append("remoteSocketURL=127.0.0.1&");
        flashvars.append("remoteSocketPort=" + CTATLink.tsPort + "&");
        if (aProblem != null) {
            flashvars.append("dataset_name=" + CTATLink.datasetName + "&");
            flashvars.append("dataset_level_type1=ProblemSet&");
            flashvars.append("dataset_level_name1=" + aProblem.problem_path + "&");
            flashvars.append("problem_name=" + aProblem.name + "&");
            String qf = null;
            if (!CTATLink.remoteHost.equals("") || !CTATLink.remoteHost.equals("local")) {
                qf = "http://localhost:" + CTATLink.wwwPort + "/" + aProblem.problem_path + "FinalBRDs/" + aProblem.problem_file;
                flashvars.append("question_file=" + qf + "&");
            } else {
                qf = CTATLink.htdocs + "/" + aProblem.problem_path + "FinalBRDs/" + aProblem.problem_file;
                flashvars.append("question_file=" + qf + "&");
            }
            this.debug("Creating question_file flashvar based on remoteHost: " + CTATLink.remoteHost + "; result " + qf);
            if (!isLastProblem) {
                flashvars.append("curriculum_service_url=http://127.0.0.1:" + CTATLink.wwwPort + "/problemselect.cgi?position=" + (aProblem.index + 1) + "&");
            } else {
                flashvars.append("curriculum_service_url=http://127.0.0.1:" + CTATLink.wwwPort + "/lastproblem.cgi?position=" + (aProblem.index + 1) + "&");
            }
            flashvars.append("reuse_swf=true&");
            flashvars.append("target_frame=_self&");
            flashvars.append("student_interface=" + "/" + aProblem.problem_path + "Flash/" + aProblem.student_interface + "&");
            try {
                flashvars.append("skills=" + URLEncoder.encode(aProblem.getSkillsXML(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            flashvars.append("question_file=" + CTATLink.htdocs + "/doesnotexist.brd&");
            flashvars.append("curriculum_service_url=http://127.0.0.1:" + CTATLink.wwwPort + "/problemselect.cgi?position=-1&");
            flashvars.append("student_interface=doesnotexist.swf&");
        }
        if (this.getSCORMCompliant().booleanValue()) {
            flashvars.append("scorm_enabled=true&");
        }
        return flashvars.toString();
    }

    public String generateFlashVars(CTATProblem aProblem, CTATProblemSet aSet, int problemNumber, String problemSetActivationStatus) {
        this.debug("generateFlashVars (CTATProblem aProblem,CTATProblemSet aSet,int problemNumber,String problemSetActivationStatus)");
        String problemSetName = aSet.getName();
        StringBuffer flashvars = new StringBuffer();
        flashvars.append("BehaviorRecorderMode=AuthorTimeTutoring&");
        if (!CTATLink.allowWriting) {
            flashvars.append("Logging=None&");
        } else {
            flashvars.append("Logging=ClientToService&");
        }
        flashvars.append("SessionLog=true&");
        flashvars.append("log_service_url_group=TutorShopUSB&");
        flashvars.append("log_service_url=" + CTATLink.datashopURL + "&");
        flashvars.append("user_guid=" + CTATLink.userID + "&");
        if (this.getSessionID().equals("undefined")) {
            UUID uuid = UUID.randomUUID();
            this.setSessionID(uuid.toString());
        }
        flashvars.append("session_id=" + this.getSessionID() + "&");
        flashvars.append("source_id=PACT_CTAT_FLASH&");
        flashvars.append("TutorShopDeliveryMethod=sendandload&");
        flashvars.append("lcId=" + System.currentTimeMillis() + "&");
        if (this.getIncludeMenu().booleanValue()) {
            flashvars.append("info=" + aSet.buildMenuHTML() + "&");
        }
        flashvars.append("remoteSocketURL=" + CTATLink.hostName + "&");
        flashvars.append("remoteSocketPort=" + CTATLink.tsPort + "&");
        if (aProblem != null) {
            flashvars.append("dataset_name=" + CTATLink.datasetName + "&");
            flashvars.append("dataset_level_type1=ProblemSet&");
            flashvars.append("dataset_level_name1=" + aProblem.problem_path + "&");
            flashvars.append("problem_name=" + aProblem.name + "&");
            flashvars.append("question_file=http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/tutors/problem_sets/" + problemSetActivationStatus + "/" + problemSetName + "/FinalBRDs/" + aProblem.problem_file + "&");
            flashvars.append("curriculum_service_url=http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/process_student_assignment/" + problemSetName + "/" + problemNumber + "&");
            flashvars.append("reuse_swf=true&");
            flashvars.append("target_frame=_self&");
            flashvars.append("student_interface=/tutors/problem_sets/" + problemSetActivationStatus + "/" + problemSetName + "/Flash/" + aProblem.student_interface + "&");
            try {
                flashvars.append("skills=" + URLEncoder.encode(aProblem.getSkillsXML(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            flashvars.append("question_file=" + CTATLink.htdocs + "/doesnotexist.brd&");
            flashvars.append("curriculum_service_url=http://127.0.0.1:" + CTATLink.wwwPort + "/problemselect.cgi?position=-1&");
            flashvars.append("student_interface=doesnotexist.swf&");
        }
        if (this.getSCORMCompliant().booleanValue()) {
            flashvars.append("scorm_enabled=true&");
        }
        return flashvars.toString();
    }

    public String generateObjectTags(String template, CTATCurriculum aCurriculum, CTATProblem aProblem, CTATProblemSet aSet, int problemNumber, String problemSetActivationStatus) {
        this.debug("generateObjectTags ()");
        String response = template;
        String problemSetName = aSet.getName();
        response = response.replace("HOST_NAME", CTATLink.hostName);
        response = response.replace("PORT_NUMBER", "" + CTATLink.wwwPort);
        response = response.replace("TS_PORT", "" + CTATLink.tsPort);
        response = response.replace("HOST_NAME", CTATLink.hostName);
        response = response.replace("PROBLEM_STATE_STATUS", CTATLink.userProgress.getProblemStateStatus(CTATLink.userID, aCurriculum.getAssignment(problemSetName), problemSetName, problemNumber));
        response = response.replace("QUESTION_FILE", "http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + "/tutors/problem_sets/" + problemSetActivationStatus + "/" + problemSetName + "/FinalBRDs/" + aProblem.problem_file);
        response = response.replace("STUDENT_INTERFACE", "/tutors/problem_sets/" + problemSetActivationStatus + "/" + problemSetName + "/Flash/" + aProblem.student_interface);
        response = response.replace("CS2NUID", CTATLink.userID);
        response = response.replace("INFO", CTATLink.showNavButtons ? this.generateNavButtons(aCurriculum, problemSetName, problemNumber) : "");
        response = response.replace("SESSION_ID", this.getSessionID());
        response = response.replace("STUDENT_ASSIGNMENT_ID", problemSetName);
        response = response.replace("PROBLEM_NUMBER", "" + problemNumber);
        response = response.replace("LOG_SERVICE_URL", CTATLink.datashopURL);
        response = !CTATLink.allowWriting ? response.replace("LOGGINGSETTING", "None") : response.replace("LOGGINGSETTING", "ClientToService");
        response = response.replace("DATASET_NAME", CTATLink.datasetName);
        response = response.replace("DATASET_LEVEL_NAME1", aCurriculum.getAssignment(problemSetName));
        response = response.replace("DATASET_LEVEL_NAME2", aSet.getName());
        response = response.replace("PROBLEM_NAME", aProblem.getName());
        response = response.replace("CLASS_NAME", aCurriculum.getAssignedClass());
        response = response.replace("SCHOOL_NAME", aCurriculum.getSchoolName());
        response = response.replace("INSTRUCTOR_NAME", aCurriculum.getInstructorName());
        response = response.replace("STUDY_CONDITION_NAME1", aCurriculum.getConditionName(problemSetName));
        CTATUserData aUser = CTATLink.userProgress.getUser(CTATLink.userID);
        boolean milestoneHtmlGenerated = false;
        boolean milestonesExist = false;
        if (aUser != null) {
            this.debug("We have a user and we have skills, adding them to page ...");
            this.debug("Skill XML: " + aUser.skillXML);
            response = response.replace("SKILLS", "" + aUser.skillXML);
            String milestoneString = aUser.getMilestoneManager().generateMilestoneHTML();
            boolean bl = milestonesExist = milestoneString != null;
            if (milestonesExist) {
                String milestonesEncoded = CTATObjectTagDriver.encodeHTML(milestoneString);
                response = response.replace("MILESTONES", milestonesEncoded);
                milestoneHtmlGenerated = true;
                this.debug("Generated html: " + response);
            }
        } else {
            this.debug("Generated html: " + response);
        }
        if (!milestonesExist) {
            this.debug("No milestones; removing data-milestones tag");
            response = response.replaceAll("data-milestones='MILESTONES'", "");
        }
        if (milestoneHtmlGenerated && aUser != null) {
            aUser.milestoneManager.markShown();
        }
        return response;
    }

    public static String createIndexFile() {
        String indexFile = "index.html";
        if (CTATLink.deployType == CTATLink.DEPLOYFLASH) {
            indexFile = "index-flash.html";
        }
        if (CTATLink.deployType == CTATLink.DEPLOYHTML5) {
            indexFile = "index-html5.html";
        }
        return indexFile;
    }

    public static String encodeHTML(String s) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>') {
                out.append("&#" + c + ";");
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private String generateNavButtons(CTATCurriculum aCurriculum, String problemSet, int problemNumber) {
        boolean currentProbsetIsActive;
        int numProblems;
        CTATProblemSet probset;
        this.debug("generateNavButtons ()");
        StringBuilder sb = new StringBuilder();
        String assignmentName = aCurriculum.getAssignment(problemSet);
        PositionWithinAssignment pwa = CTATLink.userProgress.getCurrentProblem(CTATLink.userID, assignmentName);
        String lastStartedProblemSet = pwa != null ? pwa.problemSet : problemSet;
        int lastStartedProblemPosition = pwa != null ? pwa.position : problemNumber;
        String currentProbset = null;
        try {
            currentProbset = aCurriculum.getFirstProblemSet(assignmentName);
        }
        catch (NumberFormatException e) {
            return "";
        }
        boolean visitedLastStartedProblem = false;
        while (currentProbset != null) {
            probset = aCurriculum.getProblemSet(currentProbset);
            sb.append("<div class='section'><div class='title'>" + probset.getDescription() + "</div>");
            numProblems = probset.getNumProblems();
            this.debug("Building menu for initial real problems: " + probset.initialSequence);
            currentProbsetIsActive = currentProbset.equals(problemSet);
            boolean currentProbsetIsLastStarted = currentProbset.equals(lastStartedProblemSet);
            int i = 0;
            Boolean golded = false;
            for (i = 1; i <= numProblems; ++i) {
                boolean thisIsTheActiveProblem = false;
                boolean thisIsTheLastStartedProblem = false;
                String status = "step";
                if (currentProbsetIsActive && i == problemNumber) {
                    thisIsTheActiveProblem = true;
                }
                if (currentProbsetIsLastStarted && i == lastStartedProblemPosition) {
                    thisIsTheLastStartedProblem = true;
                }
                if (this.isGuest().booleanValue()) {
                    status = "current step";
                } else if (i - 1 < probset.initialSequence) {
                    if (thisIsTheActiveProblem) {
                        status = "current step";
                    } else if (!visitedLastStartedProblem) {
                        status = "step";
                    } else {
                        this.debug("We have a normal account");
                        status = "disabled step";
                    }
                } else {
                    status = "step gold";
                }
                if (!status.equals("step gold")) {
                    probset.setCurrentIndex(i - 1);
                    sb.append("<div class='" + status + "' title='" + probset.getNextProblem().description + "'>");
                    if (this.isGuest().booleanValue()) {
                        sb.append("<a href=\"/run_student_assignment/" + currentProbset + "/" + i + "\" data-active=\"" + thisIsTheActiveProblem + "\" data-name=\"tutor-" + currentProbset + "-" + i + "\" data-src=\"\">");
                    } else if (!visitedLastStartedProblem) {
                        sb.append("<a href=\"/run_student_assignment/" + currentProbset + "/" + i + "\" data-active=\"" + thisIsTheActiveProblem + "\" data-name=\"tutor-" + currentProbset + "-" + i + "\" data-src=\"\">");
                    }
                    sb.append("<img alt=\"" + i + "\" src=\"/assets/navigation/bubble-74cdd8414c90c4906aefc4b750c957d4.png\" />");
                    sb.append("<span>" + i + "</span>");
                    if (this.isGuest().booleanValue()) {
                        sb.append("</a>");
                    } else if (!visitedLastStartedProblem) {
                        sb.append("</a>");
                    }
                    sb.append("</div>");
                    if (!thisIsTheLastStartedProblem) continue;
                    visitedLastStartedProblem = true;
                    continue;
                }
                if (golded.booleanValue()) continue;
                sb.append("<div title=\"Practice\" class=\"step gold\">");
                sb.append("<a data-practice=\"" + currentProbset + "\" href=\"#\">");
                sb.append("<img src=\"/assets/navigation/gold-bubble-61776757d61d980982ccc7adab024c58.png\" alt=\"P\" />");
                sb.append("<span>P</span>");
                sb.append("</a>");
                sb.append("</div>");
                golded = true;
            }
            sb.append("</div>");
            if ((currentProbset = aCurriculum.getNextStudentAssignment(currentProbset)) == null) continue;
            sb.append("<div class=\"separator\"><img alt=\"Small-arrow\" src=\"/assets/navigation/small-arrow-4423d4ee586332329a9d12f5a61c957c.png\" /></div>");
        }
        currentProbset = null;
        try {
            currentProbset = aCurriculum.getFirstProblemSet(assignmentName);
        }
        catch (NumberFormatException e) {
            return "";
        }
        visitedLastStartedProblem = false;
        while (currentProbset != null) {
            probset = aCurriculum.getProblemSet(currentProbset);
            sb.append("<div id=\"" + currentProbset + "\" class=\"section popup\">");
            numProblems = probset.getNumProblems();
            currentProbsetIsActive = currentProbset.equals(problemSet);
            for (int i = 1; i <= numProblems; ++i) {
                if (currentProbsetIsActive) {
                    sb.append("<div title=\"Practice Problem\" class=\"step\">");
                } else {
                    sb.append("<div title=\"Practice Problem\" class=\"disabled step\">");
                }
                sb.append("  <img src=\"/assets/navigation/bubble-74cdd8414c90c4906aefc4b750c957d4.png\" alt=\"+(i+1)+\" />");
                sb.append("  <span>" + (i + 1) + "</span>");
                sb.append("</div>");
            }
            sb.append("</div>");
            currentProbset = aCurriculum.getNextStudentAssignment(currentProbset);
        }
        this.debug("Generated problem navigation menu: " + sb.toString());
        try {
            return URLEncoder.encode(sb.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private Boolean isGuest() {
        if (CTATLink.userID.length() > 30) {
            return true;
        }
        return false;
    }

    public abstract String generateObjectTags(CTATProblem var1, CTATProblemSet var2);

    public abstract String generateObjectTags(CTATProblem var1, CTATProblemSet var2, int var3, String var4);

    public abstract String generateObjectTags(File var1, File var2);
}

