/*
 * Decompiled with CFR 0.152.
 */
package pact.CommWidgets;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.TimeLine;

public class TimeLineWidget
extends JCommWidget
implements ActionListener {
    protected TimeLine timeline = new TimeLine(0, 0, 0, 0);
    protected boolean studentMode = false;

    public TimeLineWidget() {
        this.timeline.setSize(624, 45);
        this.add(this.timeline);
    }

    public void setStudentMode(boolean b) {
        this.studentMode = b;
        if (this.studentMode) {
            this.timeline.setVisible(false);
        }
    }

    @Override
    public MessageObject getDescriptionMessage() {
        if (!this.initialize(this.getController())) {
            trace.out(5, this, "ERROR!: Can't create Comm message because can't initialize.  Returning empty comm message");
            return null;
        }
        MessageObject mo = MessageObject.create("InterfaceDescription");
        mo.setVerb("SendNoteProperty");
        mo.setProperty("WidgetType", "TimeLineWidget");
        mo.setProperty("CommName", this.commName);
        mo.setProperty("UpdateEachCycle", new Boolean(this.updateEachCycle));
        Vector deftemplates = this.createJessDeftemplates();
        Vector instances = this.createJessInstances();
        if (deftemplates != null) {
            mo.setProperty("jessDeftemplates", deftemplates);
        }
        if (instances != null) {
            mo.setProperty("jessInstances", instances);
        }
        this.serializeGraphicalProperties(mo);
        this.timeline.setVisible(false);
        return mo;
    }

    public Vector createJessDeftemplates() {
        Vector<String> deftemplates = new Vector<String>();
        String deftemplateStr1 = "(deftemplate timeline (slot name) (slot startHour) (slot startMinutes) (slot startAMPM) (slot endHour) (slot endMinutes) (slot endAMPM) (multislot intervals))";
        deftemplates.add(deftemplateStr1);
        String deftemplateStr2 = "(deftemplate interval (slot name) (slot startHour) (slot startMinutes) (slot startAMPM) (slot endHour) (slot endMinutes) (slot endAMPM))";
        deftemplates.add(deftemplateStr2);
        return deftemplates;
    }

    public Vector createJessInstances() {
        Vector<String> instances = new Vector<String>();
        String instance = "(assert (timeline (name " + this.getCommName() + ")))";
        instances.add(instance);
        return instances;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void doCorrectAction(String selection, String action, String input) {
    }

    @Override
    public void doIncorrectAction(String selection, String input) {
    }

    @Override
    public void doInterfaceAction(String selection, String action, String input) {
        if (action.equals("MakeVisible")) {
            this.timeline.setVisible(true);
        } else if (action.equalsIgnoreCase("SetVisible")) {
            this.timeline.setVisible(Boolean.parseBoolean(input));
        } else if (action.equals("SetStartTime") || action.equals("SetEndTime")) {
            String[] time = input.split("-");
            int hour = new Integer(time[0]);
            int minutes = new Integer(time[1]);
            if (time[2].equals("PM")) {
                hour += 12;
            }
            if (action.equals("SetStartTime")) {
                this.timeline.setStartTime(hour, minutes);
            } else {
                this.timeline.setEndTime(hour, minutes);
            }
        }
    }

    @Override
    public void doLISPCheckAction(String selection, String input) {
    }

    @Override
    public String getCommNameToSend() {
        return this.getCommName();
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public boolean isChangedFromResetState() {
        return false;
    }

    @Override
    public void reset(TutorController controller) {
        this.timeline.setVisible(false);
    }

    public void makeVisible() {
        this.timeline.setVisible(true);
        this.timeline.repaint();
    }

    @Override
    public boolean isVisible() {
        return this.timeline.isVisible();
    }

    public void setStartTime(int start, int end) {
        this.timeline.setStartTime(start, end);
    }

    public void setEndTime(int start, int end) {
        this.timeline.setEndTime(start, end);
    }

    public void addInterval(int startHour, int startMinutes, int endHour, int endMinutes) {
        this.timeline.addInterval(startHour, startMinutes, endHour, endMinutes);
        this.timeline.repaint();
    }

    public void timelineClear() {
        this.timeline.timelineClear();
    }

    @Override
    public void sendValue() {
    }

    public static void main(String[] args) {
        TimeLineWidget tlw = new TimeLineWidget();
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add(tlw);
        f.pack();
        f.show();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

