/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.PeerLearning.StudentAvatarDesigner;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.console.controller.MissController;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimStPLEActionListener
implements ActionListener,
ChangeListener {
    BR_Controller brController = null;
    SimStLogger logger;
    long lastTabViewStart;
    String lastTabViewed;
    private long exampleStartTime = 0L;
    private long quizStartTime = 0L;
    private String exampleTitle = "";
    private String quizTitle = "";
    int previousSliderValue;

    public SimStPLEActionListener(BR_Controller brController) {
        this.setBrController(brController);
        this.logger = new SimStLogger(this.getBrController());
        this.lastTabViewStart = Calendar.getInstance().getTimeInMillis();
        this.lastTabViewed = "";
        this.previousSliderValue = 0;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        String sourceText = "";
        if (event.getSource() instanceof JButton) {
            if (!((JButton)event.getSource()).isEnabled()) {
                if (trace.getDebugCode("ss")) {
                    trace.out("ss", "Button is not enabled!");
                }
                return;
            }
            sourceText = ((JButton)event.getSource()).getText();
        }
        if (this.brController.getMissController() != null && this.brController.getMissController().getSimSt() != null && this.brController.getMissController().getSimSt().isSsMetaTutorMode() && this.brController.getAmt() != null && !"undo".equals(event.getActionCommand())) {
            if (trace.getDebugCode("rr")) {
                trace.out("rr", "Modeltracing the student action: " + event.getActionCommand() + "  ButtonPressed  -1");
            }
            this.brController.getAmt().handleInterfaceAction(event.getActionCommand(), "ButtonPressed", "-1");
        }
        if ("next problem".equals(actionCommand)) {
            if (sourceText.equals(this.brController.getMissController().getSimStPLE().getProblemEnteredButtonString())) {
                this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Problem Entered Button Clicked", "");
            } else {
                this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Next Problem Button Clicked", "");
            }
            if (this.brController.getCurrentNode() != null && !this.brController.getCurrentNode().isDoneState()) {
                SimSt simSt = this.getMissController().getSimSt();
                int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - simSt.getSsInteractiveLearning().getProblemStartTime());
                this.logger.simStLog("SIM_STUDENT_PROBLEM", "Problem Abandoned", simSt.getProblemStepString(), "", (Object)"", problemDuration);
            } else if (this.brController.getCurrentNode() != null && this.brController.getCurrentNode().isDoneState()) {
                SimSt simSt = this.getMissController().getSimSt();
                int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - simSt.getSsInteractiveLearning().getProblemStartTime());
                this.logger.simStLog("SIM_STUDENT_PROBLEM", "Problem Completed", simSt.getProblemStepString(), "", (Object)"", problemDuration);
            }
            this.getMissController().pleNextProblem();
        } else if ("quiz".equals(actionCommand)) {
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Quiz Button Clicked", "");
            this.takeQuiz();
        } else if ("curriculum browser".equals(actionCommand)) {
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Curriculum Browser Button Clicked", "");
            this.getMissController().pleCurriculumBrowser();
        } else if ("examples".equals(actionCommand)) {
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Examples Button Clicked", "");
            this.getMissController().pleExamplesSimSt();
        } else if ("undo".equals(actionCommand)) {
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Undo Button Clicked", "");
            this.getMissController().pleUndoSimSt();
        } else if ("restart".equals(actionCommand)) {
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Restart Problem Button Clicked", "");
            this.getMissController().pleRestartProblemSimSt();
        } else if ("configure".equals(actionCommand)) {
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Avatar Configure Button Clicked", "");
            StudentAvatarDesigner.createAndShowGUI(this.getMissController().getSimStPLE().getSimStPeerTutoringPlatform(), this.getMissController().getSimSt().getUserID());
        } else {
            new Exception("Invalid action event: " + event).printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)event.getSource();
            if (this.lastTabViewed.length() == 0) {
                this.lastTabViewed = tabPane.getTitleAt(0);
            }
            int duration = (int)(Calendar.getInstance().getTimeInMillis() - this.lastTabViewStart);
            this.lastTabViewStart = Calendar.getInstance().getTimeInMillis();
            if (this.brController.getMissController() != null && this.brController.getMissController().getSimSt() != null && this.brController.getMissController().getSimSt().isSsMetaTutorMode() && this.brController.getAmt() != null) {
                String tabText = tabPane.getTitleAt(tabPane.getSelectedIndex()).replaceAll("\\s+", "");
                this.brController.getAmt().handleInterfaceAction(tabText, "TabClicked", "-1");
            }
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Left Tab", "", this.lastTabViewed, (Object)"", duration);
            if (this.lastTabViewed.equals("Examples") && this.exampleTitle.length() > 0) {
                long exampleDuration = Calendar.getInstance().getTimeInMillis() - this.exampleStartTime;
                this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Finished Example Solution View by Leaving Tab", "", this.exampleTitle, (Object)"", (int)exampleDuration);
            }
            if (this.lastTabViewed.equals("Quiz") && this.quizTitle.length() > 0) {
                long quizDuration = Calendar.getInstance().getTimeInMillis() - this.quizStartTime;
                this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Finished Quiz Solution View by Leaving Tab", "", this.quizTitle, (Object)"", (int)quizDuration);
            }
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Switched Tab", tabPane.getTitleAt(tabPane.getSelectedIndex()));
            if (trace.getDebugCode("miss")) {
                trace.out("miss", "In stateChanged and calling setUpTab");
            }
            this.getMissController().getSimStPLE().setUpTab(tabPane.getTitleAt(tabPane.getSelectedIndex()));
            this.lastTabViewed = tabPane.getTitleAt(tabPane.getSelectedIndex());
            if (this.lastTabViewed.equals("Examples") && this.exampleTitle.length() > 0) {
                this.exampleStartTime = Calendar.getInstance().getTimeInMillis();
                this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Example Solution Viewed on New Tab", this.exampleTitle);
            }
            if (this.lastTabViewed.equals("Quiz") && this.quizTitle.length() > 0) {
                this.quizStartTime = Calendar.getInstance().getTimeInMillis();
                this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Quiz Solution Viewed on New Tab", this.quizTitle);
            }
        }
        if (event.getSource() instanceof JSlider) {
            JSlider source = (JSlider)event.getSource();
            if (source.getValueIsAdjusting()) {
                return;
            }
            String skill = ((JLabel)source.getLabelTable().get(0)).getText();
            int newValue = source.getValue();
            Sai sai = new Sai(skill, "Skillometer Updated", "" + newValue);
            int change = newValue - this.previousSliderValue;
            SimSt simSt = this.getMissController().getSimSt();
            if (simSt != null) {
                if (simSt.getSkillSliderNameValuePair() == null) {
                    simSt.setSkillSliderNameValuePair(new Hashtable<String, Integer>());
                }
                Hashtable<String, Integer> skillSlider = simSt.getSkillSliderNameValuePair();
                skillSlider.put(skill, newValue);
            }
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Skillometer Updated", simSt.getProblemStepString(), "" + change, (Object)"", sai);
            this.previousSliderValue = newValue;
        }
    }

    public void exampleSwitched(String newExampleTitle) {
        if (this.exampleTitle.length() > 0) {
            long exampleDuration = Calendar.getInstance().getTimeInMillis() - this.exampleStartTime;
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Finished Example Solution View", "", this.exampleTitle, (Object)"", (int)exampleDuration);
        }
        this.exampleTitle = newExampleTitle;
        this.exampleStartTime = Calendar.getInstance().getTimeInMillis();
        this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Example Solution Viewed", newExampleTitle);
    }

    public void quizSwitched(String newQuizTitle) {
        if (this.quizTitle.length() > 0) {
            long quizDuration = Calendar.getInstance().getTimeInMillis() - this.quizStartTime;
            this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Finished Quiz Solution View", "", this.quizTitle, (Object)"", (int)quizDuration);
        }
        this.quizTitle = newQuizTitle;
        this.quizStartTime = Calendar.getInstance().getTimeInMillis();
        this.logger.simStLog("SIM_STUDENT_ACTION_LISTENER", "Quiz Solution Viewed", newQuizTitle);
    }

    public void takeQuiz() {
        this.quizTitle = "";
        this.quizStartTime = 0L;
        if (this.brController.getCurrentNode() != null && !this.brController.getCurrentNode().isDoneState()) {
            SimSt simSt = this.getMissController().getSimSt();
            int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - simSt.getSsInteractiveLearning().getProblemStartTime());
            this.logger.simStLog("SIM_STUDENT_PROBLEM", "Incomplete Problem Left to Quiz", simSt.getProblemStepString(), "", (Object)"", problemDuration);
        } else if (this.brController.getCurrentNode() != null && this.brController.getCurrentNode().isDoneState()) {
            SimSt simSt = this.getMissController().getSimSt();
            int problemDuration = (int)(Calendar.getInstance().getTimeInMillis() - simSt.getSsInteractiveLearning().getProblemStartTime());
            this.logger.simStLog("SIM_STUDENT_PROBLEM", "Problem Completed", simSt.getProblemStepString(), "", (Object)"", problemDuration);
        }
        this.getMissController().pleQuizSimSt();
    }

    public BR_Controller getBrController() {
        return this.brController;
    }

    public void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    private MissController getMissController() {
        return (MissController)this.getBrController().getMissController();
    }
}

