/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.miss.PeerLearning.SimStPLE;
import edu.cmu.pact.miss.PeerLearning.SimStPeerTutoringPlatform;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class JTabbedPaneWithCloseIcons
extends JTabbedPane
implements MouseListener,
MouseMotionListener {
    private static final int ICON_WIDTH = 16;
    private static final String path = "/edu/cmu/pact/miss/PeerLearning/img/undock.png";
    private static final long serialVersionUID = 1L;
    private MouseEvent lastMouseEvent;
    private SimStPeerTutoringPlatform simStPeerTutoringPlatform = null;
    private Component problemBankComponent = null;

    public SimStPeerTutoringPlatform getSimStPeerTutoringPlatform() {
        return this.simStPeerTutoringPlatform;
    }

    public void setSimStPeerTutoringPlatform(SimStPeerTutoringPlatform simStPeerTutoringPlatform) {
        this.simStPeerTutoringPlatform = simStPeerTutoringPlatform;
    }

    public JTabbedPaneWithCloseIcons(SimStPeerTutoringPlatform ssPlatform) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.simStPeerTutoringPlatform = ssPlatform;
    }

    public void addTab(String title, Component component, boolean flag) {
        if (flag) {
            super.addTab(title, new UnDockTabIcon(this.getClass().getResource(path)), component);
            this.repaint();
        } else {
            super.addTab(title, component);
            this.repaint();
        }
    }

    public void closeClosableTabs() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            Icon icon = this.getIconAt(i);
            if (icon == null) {
                return;
            }
            this.closeTabCommon(i);
        }
    }

    public void closeSelectedTab() {
        int i = this.getSelectedIndex();
        this.closeTabCommon(i);
    }

    private void closeTabCommon(int i) {
        Component c = this.getComponentAt(i);
        this.removeTabAt(i);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        if (tabNumber > 1) {
            return;
        }
        UnDockTabIcon icon = (UnDockTabIcon)this.getIconAt(tabNumber);
        if (icon == null) {
            return;
        }
        if (icon.isMouseOnUndock(e.getX(), e.getY())) {
            this.undock();
        }
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseMoved(e);
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        for (int tabNumber = 0; tabNumber < this.getComponentCount(); ++tabNumber) {
            UnDockTabIcon icon = (UnDockTabIcon)this.getIconAt(tabNumber);
            if (icon != null) continue;
            return;
        }
        this.lastMouseEvent = e;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMouseEvent = e;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.lastMouseEvent = e;
    }

    public void undock() {
        this.problemBankComponent = this.getSelectedComponent();
        JFrame frame = new JFrame("Problem Bank");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JTabbedPaneWithCloseIcons.this.generateProblemBankTab();
            }
        });
        frame.add(this.problemBankComponent);
        frame.pack();
        frame.setVisible(true);
        this.simStPeerTutoringPlatform.getTabPane().setSelectedIndex(0);
    }

    public void generateProblemBankTab() {
        JTabbedPaneWithCloseIcons exampleTabPane = this.getSimStPeerTutoringPlatform().getExamplePane();
        if (this.problemBankComponent == null) {
            String[] columns = new String[]{"Problem", "Attempts", "Difficulty"};
            SimStPeerTutoringPlatform simStPeerTutoringPlatform = this.getSimStPeerTutoringPlatform();
            this.getSimStPeerTutoringPlatform().getSimStPLE();
            this.problemBankComponent = simStPeerTutoringPlatform.createProblemBank(columns, SimStPLE.problemStatData);
        }
        String bankTab = "Problem Bank";
        this.problemBankComponent.setSize(400, 400);
        int tabIndex = exampleTabPane.indexOfTab(bankTab);
        if (tabIndex >= 0) {
            exampleTabPane.remove(tabIndex);
        }
        exampleTabPane.insertTab(bankTab, new UnDockTabIcon(this.getClass().getResource(path)), this.problemBankComponent, "", 1);
        exampleTabPane.setSelectedIndex(0);
    }

    private class UnDockTabIcon
    extends ImageIcon {
        private Component component;
        private int x_pos;
        private int y_pos;

        public UnDockTabIcon(URL path) {
            super(path);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            this.x_pos = x;
            this.y_pos = y;
            this.component = c;
        }

        public boolean isMouseOnUndock(int x, int y) {
            Rectangle rect = new Rectangle(this.x_pos + 2, this.y_pos + 2, 12, 12);
            return rect.contains(x, y);
        }
    }
}

