/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.AplusToBRD;

import edu.cmu.pact.miss.AplusToBRD.AplusToBRDWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;

public class AplusToBRDConverter {
    String aplusFilename;
    String studentFilename;
    String outputFilename;
    private int actionCol_aplus = -1;
    private int timeCol_aplus = -1;
    private int actionCol_stud = -1;
    private int timeCol_stud = -1;
    private int anonIDCol = 3;
    private int problemCol_aplus = -1;
    private int problemCol_stud = -1;
    private String previousAnonID = "";
    boolean switchUserFlag = false;
    private String nextTransaction_stud = "";
    String nextTransaction_apl = "";
    boolean convertOutputForBRDWritter = false;
    int outcomeCol = -1;
    int cf_resultCol = -1;
    int selectionCol = -1;
    int inputCol = -1;
    int actionCol = -1;
    int skillCol = -1;
    public static final String BRDWRITTER_HEADER = "id\tstudent_name\tproblem_name\tinterface_action\tselection\taction\tinput\tskill\toutcome\tactualOutcome\n";
    String aplusLog_name = "";
    boolean studEOF = false;
    boolean aplusEOF = false;
    Queue<String> stdQueue;
    Queue<String> aplQueue;
    public static final String CF_ACTION_HEADER = "CF (ACTION)";
    public static final String CF_TIME_HEADER = "CF (tool_event_time)";
    public static final String PROBLEM_NAME_HEADER = "Problem Name";
    public static final String SELECTION_HEADER = "Selection";
    public static final String ACTION_HEADER = "Action";
    public static final String INPUT_HEADER = "Input";
    public static final String SKILL_HEADER = "KC Category (ActualSkill)";
    public static final String CF_RESULT_HEADER = "CF (RESULT)";
    public static final String OUTCOME_HEADER = "Outcome";
    public static final String NEW_PROBLEM_ENTERED_ACTION = "New Problem Entered";
    public static final String PROBLEM_RESTARTED_ACTION = "Problem Restarted";
    public static final String STEP_UNDONE_ACTION = "Step Undone";
    public static final String STUDENT_RESPONSE = "Student Verified Correctness of Sim Student Input";
    public static final String STUDENT_DEMONSTRATION = "Hint Received";
    public static final int APLUS_LOG = 1;
    public static final int STUDENT_LOG = 2;
    public static final String RESULT_CORRECT = "Correct Action";
    public static final String RESULT_INCORRECT = "Error Action";
    public static final String OUTCOME_CORRECT = "CORRECT";
    public static final String OUTCOME_INCORRECT = "INCORRECT";
    public static final String BRD_CORRECT = "OK";
    public static final String BRD_INCORRECT = "UNTRACEABLE_ERROR";
    private static final int ACTUAL_SKILL_ID = 29;
    private static final int DEFAULT_KC_ID = 31;
    private static final int PROBLEM_KC_ID = 33;
    private static final int STEP_KC_ID = 35;
    private static final int CF_HINT_ID = 48;
    private static final int CF_HINT_TYPE = 49;
    private static final int CF_INFO = 50;
    private static final int UNIQUE_STEP_ID = 41;
    private static final int UNIQUE_STEP_CAT_ID = 42;

    private void setAplusFilename(String filename) {
        this.aplusFilename = filename;
    }

    private String getAplusFilename() {
        return this.aplusFilename;
    }

    private void setStudentFilename(String filename) {
        this.studentFilename = filename;
    }

    private String getStudentFilename() {
        return this.studentFilename;
    }

    private void setOutputFilename(String filename) {
        this.outputFilename = filename;
    }

    private String getOutputFilename() {
        return this.outputFilename;
    }

    private void setActionCol_aplus(int col) {
        this.actionCol_aplus = col;
    }

    private int getActionCol_aplus() {
        return this.actionCol_aplus;
    }

    private void setTimeCol_aplus(int col) {
        this.timeCol_aplus = col;
    }

    private int setTimeCol_aplus() {
        return this.timeCol_aplus;
    }

    private void setActionCol_stud(int col) {
        this.actionCol_stud = col;
    }

    private int getActionCol_stud() {
        return this.actionCol_stud;
    }

    private void setTimeCol_stud(int col) {
        this.timeCol_stud = col;
    }

    private int getTimeCol_stud() {
        return this.timeCol_stud;
    }

    private int getAnonIDCol() {
        return this.anonIDCol;
    }

    private void setAnonIDColr(int col) {
        this.anonIDCol = col;
    }

    private void setProblemCol_aplus(int col) {
        this.problemCol_aplus = col;
    }

    private int getProblemCol_aplus() {
        return this.problemCol_aplus;
    }

    private void setProblemCol_stud(int col) {
        this.problemCol_stud = col;
    }

    private int getProblemCol_stud() {
        return this.problemCol_stud;
    }

    private void setPreviousAnonID(String anonID) {
        this.previousAnonID = anonID;
    }

    private String getPreviousAnonID() {
        return this.previousAnonID;
    }

    void setSwitchUserFlag(boolean flag) {
        this.switchUserFlag = flag;
    }

    boolean getSwitchUserFlag() {
        return this.switchUserFlag;
    }

    private void setNextTransaction_stud(String line) {
        this.nextTransaction_stud = line;
    }

    private String getNextTransaction_stud() {
        return this.nextTransaction_stud;
    }

    private void setNextTransaction_apl(String line) {
        this.nextTransaction_apl = line;
    }

    private String getNextTransaction_apl() {
        return this.nextTransaction_apl;
    }

    public void convertOutputForBRDWritter(boolean flag) {
        this.convertOutputForBRDWritter = flag;
    }

    private boolean getConvertOutputForBRDWritter() {
        return this.convertOutputForBRDWritter;
    }

    private void setOutcomeCol(int col) {
        this.outcomeCol = col;
    }

    private int getOutcomeCol() {
        return this.outcomeCol;
    }

    private void setCFResultCol(int col) {
        this.cf_resultCol = col;
    }

    private int getCFResultCol() {
        return this.cf_resultCol;
    }

    private void setSelectionCol(int col) {
        this.selectionCol = col;
    }

    private int getSelectionCol() {
        return this.selectionCol;
    }

    private void setInputCol(int col) {
        this.inputCol = col;
    }

    private int getInputCol() {
        return this.inputCol;
    }

    private void setActionCol(int col) {
        this.actionCol = col;
    }

    private int getActionCol() {
        return this.actionCol;
    }

    private void setSkillCol(int col) {
        this.skillCol = col;
    }

    private int getSkillCol() {
        return this.skillCol;
    }

    public AplusToBRDConverter(String aplusFilename, String studentFilename, String outputFilename) {
        this.setAplusFilename(aplusFilename);
        this.setStudentFilename(studentFilename);
        this.setOutputFilename(outputFilename);
        this.stdQueue = new LinkedList<String>();
        this.aplQueue = new LinkedList<String>();
    }

    private String getNextProperTransaction_student(BufferedReader br) throws IOException {
        String line;
        String returnString = "";
        if (!this.stdQueue.isEmpty()) {
            this.setNextTransaction_stud(this.stdQueue.poll());
            return this.nextTransaction_stud;
        }
        while ((line = br.readLine()) != null) {
            if (!this.isHumanDemonstration(line) && !this.isHumanResponse(line)) continue;
            returnString = line;
            break;
        }
        if (returnString.equals("")) {
            this.studEOF = true;
            return null;
        }
        this.setNextTransaction_stud(returnString);
        return returnString;
    }

    private String codifyCorrectness(String str) {
        String returnValue = "";
        if (str.equals(RESULT_CORRECT) || str.equals(OUTCOME_CORRECT)) {
            returnValue = BRD_CORRECT;
        } else if (str.equals(RESULT_INCORRECT) || str.equals(OUTCOME_INCORRECT)) {
            returnValue = BRD_INCORRECT;
        }
        return returnValue;
    }

    private String proceedOrNot(String str, String cf_action) {
        String returnValue = "";
        returnValue = cf_action.equals(STUDENT_DEMONSTRATION) ? BRD_CORRECT : this.codifyCorrectness(str);
        return returnValue;
    }

    private String getCorrectness(String result, String outcome, String action) {
        String returnString = "";
        if (action.equals(STUDENT_RESPONSE)) {
            if (result.equals(RESULT_CORRECT) && outcome.equals(OUTCOME_CORRECT)) {
                returnString = BRD_CORRECT;
            } else if (result.equals(RESULT_CORRECT) && outcome.equals(OUTCOME_INCORRECT)) {
                returnString = BRD_INCORRECT;
            } else if (result.equals(RESULT_INCORRECT) && outcome.equals(OUTCOME_CORRECT)) {
                returnString = BRD_INCORRECT;
            } else if (result.equals(RESULT_INCORRECT) && outcome.equals(OUTCOME_INCORRECT)) {
                returnString = BRD_CORRECT;
            }
        } else {
            returnString = this.codifyCorrectness(outcome);
        }
        return returnString;
    }

    private String getNextProperTransaction_aplus(BufferedReader br) throws IOException {
        String line;
        String returnString = "";
        if (!this.aplQueue.isEmpty()) {
            this.setNextTransaction_apl(this.aplQueue.poll());
            return this.getNextTransaction_apl();
        }
        while ((line = br.readLine()) != null) {
            if (!this.isProblemStarted(line) && !this.isProblemRestarted(line) && !this.isStepUndone(line)) continue;
            returnString = line;
            break;
        }
        if (returnString.equals("")) {
            this.aplusEOF = true;
            return null;
        }
        this.setNextTransaction_apl(returnString);
        this.aplusLog_name = this.getTransactionValue(this.getNextTransaction_apl(), this.getAnonIDCol());
        return returnString;
    }

    public boolean isTransactionOldest(String aplusLine, String studentLine) throws ParseException {
        String studentTimeStamp;
        String stud_name;
        String aplus_name = this.getTransactionValue(aplusLine, this.getAnonIDCol());
        if (!aplus_name.equals(stud_name = this.getTransactionValue(studentLine, this.getAnonIDCol()))) {
            this.setSwitchUserFlag(true);
            this.stdQueue.add(studentLine);
            return true;
        }
        String aplusTimeStamp = this.getTime(aplusLine, 1);
        boolean isAplusLogOldest = AplusToBRDConverter.isOldest(aplusTimeStamp, studentTimeStamp = this.getTime(studentLine, 2));
        if (isAplusLogOldest) {
            this.stdQueue.add(studentLine);
        }
        return isAplusLogOldest;
    }

    public boolean isNewUser(String anonId) {
        return !anonId.equals(this.getPreviousAnonID());
    }

    private void extractColumnIDs(BufferedReader aplus_br, BufferedReader student_br, FileWriter fw) throws IOException {
        String line = aplus_br.readLine();
        this.setColumnID(line, 1);
        fw.write(AplusToBRDConverter.adjustLine_aplus(line, "CF(ProblemSubmitted)", "CF(ProblemSubmitted_Type)") + "\n");
        line = student_br.readLine();
        this.setColumnID(line, 2);
    }

    public boolean mergeAndPreprocessLogs() throws IOException, ParseException {
        File aplusLogs = new File(this.getAplusFilename());
        File studentLogs = new File(this.getStudentFilename());
        FileWriter fw = new FileWriter(this.getOutputFilename());
        try {
            BufferedReader aplus_br = new BufferedReader(new FileReader(aplusLogs));
            BufferedReader student_br = new BufferedReader(new FileReader(studentLogs));
            this.extractColumnIDs(aplus_br, student_br, fw);
            while (this.getNextProperTransaction_aplus(aplus_br) != null) {
                String line = this.getNextTransaction_apl();
                String anonId = this.getTransactionValue(line, this.getAnonIDCol());
                if (this.getPreviousAnonID().equals("")) {
                    System.out.println("Processing user " + anonId + " ..... ");
                    this.setPreviousAnonID(anonId);
                }
                if (this.isNewUser(anonId)) {
                    System.out.println("Processing user " + anonId + " ......");
                    this.dumpResiduals_stud(student_br, this.getPreviousAnonID(), fw);
                    this.setPreviousAnonID(anonId);
                }
                while (!this.isTransactionOldest(line, this.getNextProperTransaction_student(student_br)) && !this.getSwitchUserFlag()) {
                    this.writeToOutput(fw, this.getNextTransaction_stud(), 2);
                }
                this.writeToOutput(fw, line, 1);
                if (!this.getSwitchUserFlag()) continue;
                this.dumpResiduals_aplus(aplus_br, this.getTransactionValue(line, this.getAnonIDCol()), fw);
                this.setSwitchUserFlag(false);
            }
            if (!this.studEOF) {
                this.dumpResiduals_stud(student_br, this.getPreviousAnonID(), fw);
            }
            aplus_br.close();
            student_br.close();
            fw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void convertToBRDWriterFormat(String filename, String outputFilename) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        FileWriter fw = new FileWriter(outputFilename);
        fw.write(BRDWRITTER_HEADER);
        String line = br.readLine();
        this.setColumnID(line, 1);
        boolean i = false;
        while ((line = br.readLine()) != null) {
            String[] tokens = line.split("\t");
            String id = tokens[2];
            String student = tokens[this.getAnonIDCol()];
            String problemName = tokens[this.getProblemCol_aplus()].replace("'", "");
            String skill = tokens[this.getSkillCol()];
            String selection = tokens[this.getSelectionCol()];
            String action = tokens[this.getActionCol()];
            String input = tokens[this.getInputCol()].replace("'", "");
            String outcome = tokens[this.getOutcomeCol()];
            String result = tokens[this.getCFResultCol()];
            String cf_action = tokens[this.getActionCol_aplus()];
            String finalOutcome = this.getCorrectness(result, outcome, cf_action);
            this.writeToFile(fw, id, student, problemName, cf_action, selection, action, input, skill, this.proceedOrNot(result, cf_action), finalOutcome);
        }
        br.close();
        fw.close();
    }

    private void writeToFile(FileWriter out, String id, String student, String problem, String cf_action, String selection, String action, String input, String skill, String proceed, String actualOutcome) throws IOException {
        String log = id + "\t";
        log = log + student + "\t";
        log = log + problem + "\t";
        log = log + cf_action + "\t";
        log = log + selection + "\t";
        log = log + action + "\t";
        log = log + input + "\t";
        log = log + skill + "\t";
        log = log + proceed + "\t";
        log = log + actualOutcome + "\n";
        out.write(log);
    }

    private void writeToOutput(FileWriter fw, String line, int originLog) throws IOException {
        if (originLog == 1) {
            fw.write(AplusToBRDConverter.adjustLine_aplus(line) + " \n");
        } else if (originLog == 2) {
            fw.write(AplusToBRDConverter.adjustLine_stud(line) + " \n");
        }
    }

    private void dumpResiduals_aplus(BufferedReader br, String anonID, FileWriter fw) throws IOException {
        for (int i = 0; i < this.aplQueue.size(); ++i) {
            this.writeToOutput(fw, this.aplQueue.poll(), 1);
        }
        if (!this.aplusEOF) {
            while (this.getTransactionValue(this.getNextProperTransaction_aplus(br), this.getAnonIDCol()).equals(anonID)) {
                this.writeToOutput(fw, this.getNextTransaction_apl(), 1);
            }
            this.setPreviousAnonID(this.aplusLog_name);
            this.aplQueue.add(this.getNextTransaction_apl());
        }
    }

    private void dumpResiduals_stud(BufferedReader br, String anonID, FileWriter fw) throws IOException {
        for (int i = 0; i < this.stdQueue.size(); ++i) {
            this.writeToOutput(fw, this.stdQueue.poll(), 2);
        }
        if (!this.studEOF) {
            while (this.getTransactionValue(this.getNextProperTransaction_student(br), this.getAnonIDCol()).equals(anonID)) {
                this.writeToOutput(fw, this.getNextTransaction_stud(), 2);
            }
            this.stdQueue.add(this.getNextTransaction_stud());
        }
    }

    private void setColumnID(String line, int log) {
        String[] array = line.split("\\t");
        for (int i = 0; i < array.length; ++i) {
            if (array[i].equals(CF_ACTION_HEADER)) {
                if (log == 1) {
                    this.setActionCol_aplus(i);
                    continue;
                }
                if (log != 2) continue;
                this.setActionCol_stud(i);
                continue;
            }
            if (array[i].equals(CF_TIME_HEADER)) {
                if (log == 1) {
                    this.setTimeCol_aplus(i);
                    continue;
                }
                if (log != 2) continue;
                this.setTimeCol_stud(i);
                continue;
            }
            if (array[i].equals(PROBLEM_NAME_HEADER)) {
                if (log == 1) {
                    this.setProblemCol_aplus(i);
                    continue;
                }
                if (log != 2) continue;
                this.setProblemCol_stud(i);
                continue;
            }
            if (array[i].equals(OUTCOME_HEADER)) {
                this.setOutcomeCol(i);
                continue;
            }
            if (array[i].equals(SELECTION_HEADER)) {
                this.setSelectionCol(i);
                continue;
            }
            if (array[i].equals(CF_RESULT_HEADER)) {
                this.setCFResultCol(i);
                continue;
            }
            if (array[i].equals(SKILL_HEADER)) {
                this.setSkillCol(i);
                continue;
            }
            if (array[i].equals(ACTION_HEADER)) {
                this.setActionCol(i);
                continue;
            }
            if (!array[i].equals(INPUT_HEADER)) continue;
            this.setInputCol(i);
        }
    }

    private boolean isProblemStarted(String line) {
        String[] array = line.split("\\t");
        return array[this.getActionCol_aplus()].equals(NEW_PROBLEM_ENTERED_ACTION);
    }

    private boolean isStepUndone(String line) {
        String[] array = line.split("\\t");
        return array[this.getActionCol_aplus()].equals(STEP_UNDONE_ACTION);
    }

    private boolean isHumanDemonstration(String line) {
        String[] array = line.split("\\t");
        return array[this.getActionCol_stud()].equals(STUDENT_DEMONSTRATION);
    }

    private boolean isHumanResponse(String line) {
        String[] array = line.split("\\t");
        return array[this.getActionCol_stud()].equals(STUDENT_RESPONSE);
    }

    private boolean isProblemRestarted(String line) {
        String[] array = line.split("\\t");
        return array[this.getActionCol_aplus()].equals(PROBLEM_RESTARTED_ACTION);
    }

    private String getTime(String line, int log) {
        String[] array = line.split("\\t");
        int col = -1;
        if (log == 1) {
            col = this.setTimeCol_aplus();
        } else if (log == 2) {
            col = this.getTimeCol_stud();
        }
        return array[col];
    }

    private String getTransactionValue(String line, int col) {
        if (line == null) {
            return "noTrans";
        }
        String[] array = line.split("\\t");
        return array[col];
    }

    private static boolean isOldest(String time1, String time2) throws ParseException {
        SimpleDateFormat s1 = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss.SSS");
        Date time1Date = s1.parse(time1);
        Date time2Date = s1.parse(time2);
        return time1Date.before(time2Date);
    }

    public static String adjustLine_stud(String line) {
        String newString = "";
        String[] array = line.split("\\t");
        String[] newArray = new String[array.length + 3];
        int j = 0;
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = i != 48 && i != 49 && i != 50 ? array[j++] : "";
        }
        newString = AplusToBRDConverter.arrayToString(newArray, "\t");
        return newString;
    }

    public static String[] reOrderKC(String[] array) {
        String[] newArray = new String[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[29] = array[35];
        newArray[30] = array[36];
        newArray[31] = array[33];
        newArray[32] = array[34];
        newArray[33] = array[31];
        newArray[34] = array[32];
        newArray[35] = array[29];
        newArray[36] = array[30];
        return newArray;
    }

    public static String adjustLine_aplus(String line, String head1, String head2) {
        String newString = "";
        String[] array = line.split("\\t");
        String[] newArray = new String[array.length + 2];
        int j = 0;
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = i != 41 && i != 42 ? array[j++] : (i == 41 ? head1 : head2);
        }
        newString = AplusToBRDConverter.arrayToString(AplusToBRDConverter.reOrderKC(newArray), "\t");
        return newString;
    }

    public static String adjustLine_aplus(String line) {
        return AplusToBRDConverter.adjustLine_aplus(line, "", "");
    }

    public static String arrayToString(String[] array, String delimiter) {
        StringBuilder arTostr = new StringBuilder();
        if (array.length > 0) {
            arTostr.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                arTostr.append(delimiter);
                arTostr.append(array[i]);
            }
        }
        return arTostr.toString();
    }

    public static void main(String[] args) throws IOException, ParseException {
        AplusToBRDConverter logConverter = new AplusToBRDConverter("/Users/simstudent/Documents/workspace/Log2Brd/aplus_all_all1.txt", "/Users/simstudent/Documents/workspace/Log2Brd/student_all.txt", "/Users/simstudent/Documents/workspace/Log2Brd/output_teliki_problem1.txt");
        AplusToBRDWriter ssBRDTest = new AplusToBRDWriter();
        ssBRDTest.testFunc("/Users/simstudent/Documents/workspace/Log2Brd/outBrd.txt", "/Users/simstudent/Documents/workspace/Log2Brd/tmp");
        System.out.println("done!");
    }
}

