/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat.model;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.StartStateModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class CtatListModel
extends AbstractListModel
implements StartStateModel.Listener {
    private static final long serialVersionUID = 201403051800L;
    protected List<String> delegate = new ArrayList<String>();
    private State state = State.waiting;

    public CtatListModel(Collection<String> items) {
        if (items == null) {
            this.setState(State.waiting);
        } else {
            this.addAll(items);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(91);
        sb.append(this.getClass().getSimpleName());
        sb.append(", size ").append(this.getSize());
        sb.append(", state ").append((Object)this.state);
        sb.append(']');
        return sb.toString();
    }

    public boolean hasData() {
        return this.state == State.complete;
    }

    public boolean getCannotFill() {
        return this.state == State.cannotFill;
    }

    public String setCannotFill(boolean cannotFill) {
        State result = this.state;
        if (cannotFill) {
            this.setState(State.cannotFill);
        }
        return result.toString();
    }

    private synchronized void setState(State state) {
        this.state = state;
        if (this.hasData()) {
            this.notifyAll();
        } else {
            this.delegate.clear();
            this.delegate.add(state.toString());
        }
    }

    public void addAll(Collection<String> items) {
        this.addAll(items, true);
    }

    protected synchronized void addAll(Collection<String> items, boolean sort) {
        if (trace.getDebugCode("editstudentinput")) {
            trace.printStack("editstudentinput", "CtatListModel.addAll(" + trace.nh(items) + ") size " + items.size() + "; listenerCount " + this.listenerList.getListenerCount());
        }
        this.delegate.clear();
        this.delegate.addAll(items);
        if (sort) {
            Collections.sort(this.delegate, String.CASE_INSENSITIVE_ORDER);
        }
        this.setState(State.complete);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.delegate.get(index);
    }

    @Override
    public void startStateReceived(EventObject evt) {
        if (!(evt.getSource() instanceof StartStateModel)) {
            trace.err("CtatListModel.startStateReceived(" + evt + ") caller not StartStateModel");
            return;
        }
        StartStateModel ssm = (StartStateModel)evt.getSource();
        this.addAll(ssm.getComponentNames());
    }

    public Iterator<String> iterator() {
        return this.delegate.iterator();
    }

    static enum State {
        complete("complete"),
        waiting("... waiting ..."),
        cannotFill("<interface disconnected>");

        private final String display;

        private State(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }
    }
}

