/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.TimeZone;

public class MessageEvent
extends EventObject {
    private boolean sent;
    private String messageType;
    private String result;
    private Date timeStamp = new Date();
    private Object message;
    public static final String QUIT = "quit";
    private static final DateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");

    public MessageEvent(Object source, boolean sent, Object message) {
        this(source, sent, null, null, message);
    }

    public MessageEvent(Object source, boolean sent, String messageType, Object message) {
        this(source, sent, messageType, null, message);
    }

    public MessageEvent(Object source, boolean sent, String messageType, String result, Object message) {
        super(source);
        this.sent = sent;
        this.messageType = messageType;
        this.result = result;
        this.message = message;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append("[").append(dateFmt.format(this.timeStamp));
        sb.append(",").append(this.sent ? "sent" : "rcvd");
        sb.append(",").append(this.messageType);
        sb.append(":\n ").append(this.message);
        sb.append("]");
        return sb.toString();
    }

    public boolean getSent() {
        return this.sent;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getResult() {
        return this.result;
    }

    public Object getMessage() {
        return this.message;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getMessageAsString() {
        if (this.message == null) {
            return null;
        }
        return this.message.toString();
    }

    public boolean isQuitMsg() {
        return QUIT.equals(this.messageType);
    }

    static {
        dateFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

